/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import javax.swing.Icon;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.swing.renderer.JavaNameRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;

public class CPUJavaNameRenderer
extends JavaNameRenderer {
    private static final Icon THREAD_ICON = Icons.getIcon((String)"ProfilerIcons.Thread");
    private static final Icon THREAD_ICON_DISABLED = UIManager.getLookAndFeel().getDisabledIcon(null, THREAD_ICON);
    private static final Icon LEAF_ICON = Icons.getIcon((String)"ProfilerIcons.NodeLeaf");
    private static final Icon LEAF_ICON_DISABLED = UIManager.getLookAndFeel().getDisabledIcon(null, LEAF_ICON);
    private final Icon icon;
    private final Icon iconDisabled;

    public CPUJavaNameRenderer() {
        this("ProfilerIcons.NodeForward");
    }

    public CPUJavaNameRenderer(String iconKey) {
        this.icon = Icons.getIcon((String)iconKey);
        this.iconDisabled = UIManager.getLookAndFeel().getDisabledIcon(null, this.icon);
    }

    @Override
    public void setValue(Object value, int row) {
        if (value instanceof PrestimeCPUCCTNode) {
            PrestimeCPUCCTNode node = (PrestimeCPUCCTNode)value;
            if (node.isSelfTimeNode()) {
                this.setNormalValue(node.getNodeName());
                this.setBoldValue("");
                this.setGrayValue("");
            } else if (node.isThreadNode()) {
                this.setNormalValue("");
                this.setBoldValue(node.getNodeName());
                this.setGrayValue("");
            } else if (node.isFiltered()) {
                this.setNormalValue("");
                this.setBoldValue("");
                this.setGrayValue(node.getNodeName());
            } else {
                super.setValue(node.getNodeName(), row);
            }
            if (node.isThreadNode()) {
                this.setIcon(node.isFiltered() ? THREAD_ICON_DISABLED : THREAD_ICON);
            } else if (node.isLeaf()) {
                this.setIcon(node.isFiltered() ? LEAF_ICON_DISABLED : LEAF_ICON);
            } else {
                this.setIcon(node.isFiltered() ? this.iconDisabled : this.icon);
            }
        } else {
            super.setValue(value, row);
        }
    }
}

