/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.awt.Component;
import java.awt.Graphics;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmConstructor;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmFunctionPointerType;
import org.netbeans.modules.cnd.api.model.CsmFunctional;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeAlias;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.deep.CsmRangeForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmExpressionResolver;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.services.CsmResolveContext;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmTemplateBasedReferencedObject;
import org.netbeans.modules.cnd.completion.cplusplus.NbCsmCompletionQuery;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CompletionSupport;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletion;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionExpression;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionTokenProcessor;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmExpandedTokenProcessor;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmResultItem;
import org.netbeans.modules.cnd.completion.csm.CompletionResolver;
import org.netbeans.modules.cnd.completion.csm.CompletionResolverImpl;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.modelutil.ClassifiersAntiLoop;
import org.netbeans.modules.cnd.modelutil.CsmPaintComponent;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public abstract class CsmCompletionQuery {
    private BaseDocument baseDocument;
    private static final String NO_SUGGESTIONS = NbBundle.getMessage(CsmCompletionQuery.class, (String)"completion-no-suggestions");
    private static final String PROJECT_BEEING_PARSED = NbBundle.getMessage(CsmCompletionQuery.class, (String)"completion-project-beeing-parsed");
    private static final boolean TRACE_COMPLETION = Boolean.getBoolean("cnd.completion.trace");
    private static final boolean TRACE_MULTIPLE_VISIBE_OBJECTS = Boolean.getBoolean("cnd.trace.multiple.visible");
    private static CsmItemFactory itemFactory;
    private static final int MAX_DEPTH = 15;
    private static final ThreadLocal<Map<AntiloopClient, Set<CsmOffsetable>>> threadLocalAntiloopMap;
    Set<CsmOffsetable> antiLoop = new HashSet<CsmOffsetable>();
    private static final String TOKEN_PROCESSOR_CACHE_KEY = "TokenProcessorCache";
    private static final int FAKE_PRIORITY = 1000;

    protected BaseDocument getBaseDocument() {
        return this.baseDocument;
    }

    protected abstract CompletionResolver getCompletionResolver(CsmScope var1, boolean var2, boolean var3, boolean var4);

    protected abstract CsmFinder getFinder();

    protected abstract CompletionResolver.QueryScope getCompletionQueryScope();

    protected abstract FileReferencesContext getFileReferencesContext();

    public abstract CsmFile getCsmFile();

    private CsmProject getCsmProject() {
        CsmFile csmFile = this.getCsmFile();
        if (csmFile != null) {
            return csmFile.getProject();
        }
        return null;
    }

    public CsmCompletionResult query(JTextComponent component, int offset, boolean instantiateTypes) {
        boolean sort = false;
        return this.query(component, offset, false, sort, instantiateTypes);
    }

    public CsmCompletionResult query(JTextComponent component, int offset, boolean openingSource, boolean sort, boolean instantiateTypes) {
        BaseDocument doc = (BaseDocument)component.getDocument();
        return this.query(component, doc, offset, openingSource, sort, instantiateTypes);
    }

    public CsmCompletionResult query(JTextComponent component, int offset, boolean openingSource, boolean sort, boolean instantiateTypes, boolean tooltip) {
        BaseDocument doc = (BaseDocument)component.getDocument();
        return this.query(component, doc, offset, openingSource, sort, instantiateTypes, tooltip);
    }

    public Collection<CsmObject> queryObjects(CsmOffsetable expression, List<CsmInstantiation> instantiations) {
        QueryObjectsTask task = new QueryObjectsTask();
        this.performQueryTask(expression, instantiations, task);
        return task.getObjects();
    }

    public void queryType(CsmOffsetable expression, List<CsmInstantiation> instantiations, CsmExpressionResolver.ResolvedTypeHandler resolvedHandler) {
        QueryTypeTask task = new QueryTypeTask(resolvedHandler);
        this.performQueryTask(expression, instantiations, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performQueryTask(CsmOffsetable expression, List<CsmInstantiation> instantiations, QueryTask task) {
        if (this.enterThreadLocalAntiloop(AntiloopClient.query_type, expression)) {
            try {
                CsmCompletionTokenProcessor tp;
                CsmCacheManager.enter();
                this.baseDocument = (BaseDocument)CsmUtilities.getDocument((CsmFile)expression.getContainingFile());
                if (this.baseDocument == null) {
                    CloneableEditorSupport support = CsmUtilities.findCloneableEditorSupport((CsmFile)expression.getContainingFile());
                    if (support == null) {
                        boolean bl = false;
                        return bl;
                    }
                    this.baseDocument = (BaseDocument)support.openDocument();
                }
                int startOffset = expression.getStartOffset();
                int endOffset = expression.getEndOffset();
                long docVersion = DocumentUtilities.getDocumentVersion((Document)this.baseDocument);
                CsmFile csmFile = this.getCsmFile();
                if (csmFile == null) {
                    csmFile = CsmUtilities.getCsmFile((Document)this.baseDocument, (boolean)true, (boolean)false);
                }
                boolean processAsExpression = CsmKindUtilities.isExpression((CsmObject)expression);
                CsmScope passedScope = null;
                if (processAsExpression) {
                    passedScope = ((CsmExpression)expression).getScope();
                    tp = this.processTokensInExpression((CsmExpression)expression, task.isFindTypeTask());
                } else {
                    tp = this.processTokensInFile(csmFile, startOffset, endOffset, this.baseDocument, docVersion);
                }
                if (!this.checkErrorTokenState(tp)) {
                    try {
                        this.pushResolveContext(CsmResolveContext.create((CsmFile)csmFile, (int)startOffset));
                        CsmCompletionExpression exp = this.getResultExpression(tp, processAsExpression, task.isFindTypeTask());
                        Context ctx = this.getResolvedContext(null, (Document)this.baseDocument, true, endOffset, exp, instantiations, false, this.isInIncludeDirective(this.baseDocument, endOffset), true, task.isFindTypeTask(), passedScope);
                        task.perform(ctx);
                        if (TRACE_COMPLETION) {
                            System.err.println("expression " + exp);
                        }
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        this.popResolveContext();
                    }
                }
                if (TRACE_COMPLETION) {
                    System.err.println("Error expression " + tp.getResultExp());
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            finally {
                this.exitThreadLocalAntiloop(AntiloopClient.query_type, expression);
                CsmCacheManager.leave();
            }
        }
        return false;
    }

    public static boolean checkCondition(final Document doc, final int dot, boolean takeLock) {
        if (!takeLock) {
            return CsmCompletionQuery._checkCondition(doc, dot);
        }
        final AtomicBoolean res = new AtomicBoolean(false);
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).render(new Runnable(){

                @Override
                public void run() {
                    res.set(CsmCompletionQuery._checkCondition(doc, dot));
                }
            });
        } else {
            res.set(CsmCompletionQuery._checkCondition(doc, dot));
        }
        return res.get();
    }

    public static boolean checkCondition(final Document doc, final int dot, boolean takeLock, final int queryType) {
        if (!takeLock) {
            return CsmCompletionQuery._checkCondition(doc, dot, queryType);
        }
        final AtomicBoolean res = new AtomicBoolean(false);
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).render(new Runnable(){

                @Override
                public void run() {
                    res.set(CsmCompletionQuery._checkCondition(doc, dot, queryType));
                }
            });
        } else {
            res.set(CsmCompletionQuery._checkCondition(doc, dot, queryType));
        }
        return res.get();
    }

    private static boolean _checkCondition(Document doc, int dot) {
        return !CompletionSupport.isPreprocCompletionEnabled(doc, dot) && CompletionSupport.isCompletionEnabled(doc, dot);
    }

    private static boolean _checkCondition(Document doc, int dot, int queryType) {
        return !CompletionSupport.isPreprocCompletionEnabled(doc, dot) && CompletionSupport.isCompletionEnabled(doc, dot, queryType);
    }

    public CsmCompletionResult query(JTextComponent component, BaseDocument doc, int offset, boolean openingSource, boolean sort, boolean instantiateTypes) {
        return this.query(component, doc, offset, openingSource, sort, instantiateTypes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmCompletionResult query(JTextComponent component, BaseDocument doc, int offset, boolean openingSource, boolean sort, boolean instantiateTypes, boolean tooltip) {
        try {
            CsmCacheManager.enter();
            CsmCompletionResult csmCompletionResult = this.queryImpl(component, doc, offset, openingSource, sort, instantiateTypes, tooltip);
            return csmCompletionResult;
        }
        finally {
            CsmCacheManager.leave();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmCompletionResult queryImpl(JTextComponent component, BaseDocument doc, int offset, boolean openingSource, boolean sort, boolean instantiateTypes, boolean tooltip) {
        CsmCompletionResult ret;
        block20: {
            this.baseDocument = doc;
            ret = null;
            CompletionSupport sup = CompletionSupport.get((Document)doc);
            if (sup == null || !CsmCompletionQuery.checkCondition((Document)doc, offset, true) && !tooltip) {
                return null;
            }
            try {
                CsmFile csmFile;
                TokenProcessorCache property = (TokenProcessorCache)this.baseDocument.getProperty((Object)TOKEN_PROCESSOR_CACHE_KEY);
                long docVersion = DocumentUtilities.getDocumentVersion((Document)doc);
                CsmCompletionTokenProcessor tp = null;
                if (property != null && property.queryOffset == offset && property.docVersion == docVersion) {
                    tp = property.tp;
                }
                if ((csmFile = this.getCsmFile()) == null) {
                    csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)true, (boolean)false);
                }
                if (tp == null) {
                    int lastSepOffset = sup.getLastCommandSeparator(csmFile, offset, this.getFileReferencesContext());
                    tp = this.processTokensInFile(csmFile, lastSepOffset, offset, doc, docVersion);
                    this.baseDocument.putProperty((Object)TOKEN_PROCESSOR_CACHE_KEY, (Object)new TokenProcessorCache(offset, docVersion, tp));
                }
                sup.setLastSeparatorOffset(tp.getLastSeparatorOffset());
                if (!this.checkErrorTokenState(tp)) {
                    try {
                        this.pushResolveContext(CsmResolveContext.create((CsmFile)csmFile, (int)offset));
                        CsmCompletionExpression exp = null;
                        if (!tooltip) {
                            exp = tp.getResultExp();
                            ret = this.getResult(component, (Document)doc, openingSource, offset, exp, sort, this.isInIncludeDirective(doc, offset), instantiateTypes);
                        } else {
                            CsmVariable var;
                            CsmResultItem.VariableResultItem item;
                            List<CsmCompletionExpression> stack = tp.getStack();
                            for (int i = stack.size() - 1; i >= 0; --i) {
                                CsmCompletionExpression e = stack.get(i);
                                if (e.getExpID() == 10) {
                                    exp = e;
                                    break;
                                }
                                if (e.getExpID() != 27 || e.getParameterCount() <= 1 || e.getParameter(e.getParameterCount() - 1).getExpID() != 10) continue;
                                exp = e;
                                break;
                            }
                            exp = exp != null ? exp : tp.getResultExp();
                            ret = this.getResult(component, (Document)doc, openingSource, offset, exp, sort, this.isInIncludeDirective(doc, offset), instantiateTypes);
                            if (ret == null && exp != null && exp.getParameterCount() >= 1 && exp.getParameter(0).getExpID() == 1 && (ret = this.getResult(component, (Document)doc, openingSource, offset, exp.getParameter(0), sort, this.isInIncludeDirective(doc, offset), instantiateTypes)) != null && !ret.getItems().isEmpty() && ret.getItems().get(0) instanceof CsmResultItem.VariableResultItem && (item = (CsmResultItem.VariableResultItem)ret.getItems().get(0)).getAssociatedObject() instanceof CsmObject && CsmKindUtilities.isVariable((CsmObject)((CsmObject)item.getAssociatedObject())) && (var = (CsmVariable)item.getAssociatedObject()).getType() != null) {
                                CsmClassifier cls = var.getType().getClassifier();
                                if (CsmKindUtilities.isClass((CsmObject)(cls = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)cls, (CsmFile)this.getFinder().getCsmFile())))) {
                                    ArrayList<CsmMember> items = new ArrayList<CsmMember>();
                                    for (CsmMember member : ((CsmClass)cls).getMembers()) {
                                        if (!CsmKindUtilities.isConstructor((CsmObject)member)) continue;
                                        items.add(member);
                                    }
                                    if (!items.isEmpty()) {
                                        CsmOffsetableDeclaration context = sup.getDefinition(csmFile, offset, this.getFileReferencesContext());
                                        ret = new CsmCompletionResult(component, doc, items, cls.getName().toString(), exp, offset, 0, 0, this.isProjectBeeingParsed(openingSource), context, instantiateTypes);
                                    }
                                }
                            }
                        }
                        if (TRACE_COMPLETION) {
                            System.err.println("expression " + exp);
                        }
                        break block20;
                    }
                    finally {
                        this.popResolveContext();
                    }
                }
                if (TRACE_COMPLETION) {
                    System.err.println("Error expression " + tp.getResultExp());
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace(System.err);
            }
        }
        return ret;
    }

    private boolean enterThreadLocalAntiloop(AntiloopClient client, CsmOffsetable expression) {
        Map<AntiloopClient, Set<CsmOffsetable>> antiloopMap = threadLocalAntiloopMap.get();
        Set<CsmOffsetable> antiloopSet = antiloopMap.get((Object)client);
        if (antiloopSet == null) {
            antiloopSet = new HashSet<CsmOffsetable>(4);
            antiloopMap.put(client, antiloopSet);
        }
        if (!antiloopSet.contains(expression)) {
            antiloopSet.add(expression);
            return true;
        }
        return false;
    }

    private void exitThreadLocalAntiloop(AntiloopClient client, CsmOffsetable expression) {
        Map<AntiloopClient, Set<CsmOffsetable>> antiloopMap = threadLocalAntiloopMap.get();
        Set<CsmOffsetable> antiloopSet = antiloopMap.get((Object)client);
        assert (antiloopSet != null) : "Must be set in enter method!";
        antiloopSet.remove(expression);
    }

    private void pushResolveContext(CsmResolveContext context) {
        Stack<CsmResolveContext> contexts = (Stack<CsmResolveContext>)CsmCacheManager.get(CsmResolveContext.class);
        if (contexts == null) {
            contexts = new Stack<CsmResolveContext>();
            CsmCacheManager.put(CsmResolveContext.class, contexts);
        }
        contexts.push(context);
    }

    private CsmResolveContext popResolveContext() {
        Stack contexts = (Stack)CsmCacheManager.get(CsmResolveContext.class);
        if (contexts != null && !contexts.isEmpty()) {
            return (CsmResolveContext)contexts.pop();
        }
        return null;
    }

    private boolean checkErrorTokenState(CsmCompletionTokenProcessor tp) {
        boolean errState = false;
        CppTokenId lastValidTokenID = tp.getLastValidTokenID();
        if (lastValidTokenID != null) {
            switch (lastValidTokenID) {
                case BLOCK_COMMENT: {
                    if (tp.getLastValidTokenText() != null && tp.getLastValidTokenText().endsWith("*/")) break;
                    errState = true;
                    break;
                }
                case LINE_COMMENT: 
                case DOXYGEN_LINE_COMMENT: {
                    errState = true;
                    break;
                }
                default: {
                    errState = "preprocessor-keyword".equals(lastValidTokenID.primaryCategory()) ? true : tp.isErrorState();
                }
            }
        }
        if (!errState && tp.getResultExp() == null) {
            errState = true;
        }
        return errState;
    }

    private CsmCompletionTokenProcessor processTokensInFile(CsmFile csmFile, final int startOffset, final int endOffset, final BaseDocument doc, long docVersion) {
        CsmCompletionTokenProcessor tp = new CsmCompletionTokenProcessor(endOffset, startOffset);
        final CndTokenProcessor<Token<TokenId>> etp = CsmExpandedTokenProcessor.create(csmFile, (Document)doc, tp, endOffset);
        if (etp instanceof CsmExpandedTokenProcessor) {
            tp.setMacroCallback((CsmExpandedTokenProcessor)etp);
        }
        tp.enableLambdaSupport(CompletionSupport.areLambdasEnabled(csmFile));
        tp.enableTemplateSupport(CompletionSupport.areTemplatesEnabled(csmFile));
        doc.render(new Runnable(){

            @Override
            public void run() {
                CndTokenUtilities.processTokens((CndTokenProcessor)etp, (Document)doc, (int)startOffset, (int)endOffset);
            }
        });
        return tp;
    }

    private CsmCompletionTokenProcessor processTokensInExpression(CsmExpression expression, boolean keepWholeAst) {
        String expressionText = keepWholeAst ? CppTokenId.LPAREN.fixedText() + expression.getExpandedText().toString() + CppTokenId.RPAREN.fixedText() : expression.getExpandedText().toString();
        int exprStartOffset = expression.getStartOffset() - (keepWholeAst ? 1 : 0);
        int exprEndOffset = exprStartOffset + expressionText.length() + (keepWholeAst ? 1 : 0);
        CsmCompletionTokenProcessor tp = new CsmCompletionTokenProcessor(exprEndOffset, exprStartOffset);
        TokenHierarchy hi = TokenHierarchy.create((CharSequence)expressionText, (boolean)false, (Language)CndLexerUtilities.getLanguage((Document)this.getBaseDocument()), null, (InputAttributes)((InputAttributes)this.getBaseDocument().getProperty(InputAttributes.class)));
        List tsList = hi.embeddedTokenSequences(exprEndOffset - exprStartOffset, true);
        TokenSequence cppts = null;
        for (int i = tsList.size() - 1; i >= 0; --i) {
            TokenSequence uts;
            TokenSequence ts = (TokenSequence)tsList.get(i);
            Language lang = ts.languagePath().innerLanguage();
            if (!CndLexerUtilities.isCppLanguage((Language)lang, (boolean)false)) continue;
            cppts = uts = ts;
        }
        if (cppts != null) {
            TokenSequence cppTokenSequence = cppts;
            CsmFile csmFile = expression.getContainingFile();
            tp.enableLambdaSupport(CompletionSupport.areLambdasEnabled(csmFile));
            tp.enableTemplateSupport(CompletionSupport.areTemplatesEnabled(csmFile));
            CndTokenUtilities.processTokens((CndTokenProcessor)tp, (TokenSequence)cppTokenSequence, (int)exprStartOffset, (int)exprEndOffset, (int)exprStartOffset);
        }
        return tp;
    }

    private CsmCompletionExpression getResultExpression(CsmCompletionTokenProcessor tp, boolean processedAsExpression, boolean keepWholeAst) {
        CsmCompletionExpression resultExp;
        if (processedAsExpression && keepWholeAst && (resultExp = tp.getResultExp()) != null && resultExp.getParameterCount() == 1 && resultExp.getExpID() == 9) {
            return resultExp.getParameter(0);
        }
        return tp.getResultExp();
    }

    protected abstract boolean isProjectBeeingParsed(boolean var1);

    private CsmCompletionResult getResult(JTextComponent component, Document doc, boolean openingSource, int offset, CsmCompletionExpression exp, boolean sort, boolean inIncludeDirective, boolean instantiateTypes) {
        Context ctx = this.getResolvedContext(component, doc, openingSource, offset, exp, null, sort, inIncludeDirective, instantiateTypes, false, null);
        if (ctx != null) {
            return ctx.result;
        }
        boolean isProjectBeeingParsed = this.isProjectBeeingParsed(openingSource);
        return new CsmCompletionResult(component, this.getBaseDocument(), Collections.EMPTY_LIST, "", exp, 0, isProjectBeeingParsed, null, instantiateTypes);
    }

    private Context getResolvedContext(JTextComponent component, Document doc, boolean openingSource, int offset, CsmCompletionExpression exp, List<CsmInstantiation> instantiations, boolean sort, boolean inIncludeDirective, boolean instantiateTypes, boolean findType, CsmScope contextScope) {
        CompletionResolver resolver = this.getCompletionResolver(contextScope, openingSource, sort, inIncludeDirective);
        if (resolver != null) {
            CompletionSupport sup;
            CsmOffsetableDeclaration context;
            CsmOffsetable offsetableScope;
            if (CsmKindUtilities.isOffsetable((Object)contextScope) && (offsetableScope = (CsmOffsetable)contextScope).getEndOffset() < offset) {
                ((CompletionResolverImpl)resolver).setContextOffset((offsetableScope.getStartOffset() + offsetableScope.getEndOffset()) / 2);
            }
            if ((context = (sup = CompletionSupport.get(doc)).getDefinition(contextScope)) == null) {
                context = sup.getDefinition(this.getCsmFile(), offset, this.getFileReferencesContext());
            }
            if (!openingSource && context == null) {
                instantiateTypes = false;
            }
            Context ctx = new Context(component, sup, openingSource, offset, this.getFinder(), resolver, context, contextScope, sort, instantiateTypes, instantiations);
            ctx.setFindType(findType);
            ctx.resolveExp(exp, true);
            if (ctx.result != null) {
                ctx.result.setSimpleVariableExpression(CsmCompletionQuery.isSimpleVariableExpression(exp));
            }
            if (TRACE_COMPLETION) {
                CompletionItem[] array = ctx.result == null ? new CompletionItem[]{} : ctx.result.getItems().toArray(new CompletionItem[ctx.result.getItems().size()]);
                System.err.println("Completion Items " + array.length);
                for (int i = 0; i < array.length; ++i) {
                    CompletionItem completionItem = array[i];
                    System.err.println(completionItem.toString());
                }
            }
            return ctx;
        }
        return null;
    }

    private static String formatType(CsmType type, boolean useFullName, boolean appendDblComma, boolean appendStar) {
        CsmClassifier classifier;
        StringBuilder sb = new StringBuilder();
        if (type != null && (classifier = type.getClassifier()) != null) {
            sb.append(useFullName ? classifier.getQualifiedName() : classifier.getName());
        }
        if (appendDblComma) {
            sb.append("::");
        }
        if (appendStar) {
            sb.append('*');
        }
        return sb.toString();
    }

    static List<CsmClassifier> findNestedClassifiers(CsmFinder finder, CsmOffsetableDeclaration context, CsmClassifier classifier, String name, boolean exactMatch, boolean inspectParentClasses, boolean sort) {
        ArrayList<CsmClassifier> ret = new ArrayList<CsmClassifier>();
        if (!CsmKindUtilities.isClass((CsmObject)(classifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)classifier, (CsmFile)finder.getCsmFile())))) {
            return ret;
        }
        CsmClass cls = (CsmClass)classifier;
        List<CsmClassifier> res = finder.findNestedClassifiers(context, cls, name, exactMatch, inspectParentClasses, sort);
        if (res != null) {
            ret.addAll(res);
        }
        return ret;
    }

    static List<CsmObject> findFieldsAndMethods(CsmFinder finder, CsmOffsetableDeclaration context, CsmClassifier classifier, String name, boolean exactMatch, boolean staticOnly, boolean inspectOuterClasses, boolean inspectParentClasses, boolean scopeAccessedClassifier, boolean skipConstructors, boolean sort) {
        ArrayList<CsmObject> ret = new ArrayList<CsmObject>();
        if (CsmKindUtilities.isClass((CsmObject)(classifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)classifier, (CsmFile)finder.getCsmFile())))) {
            List<CsmField> res;
            CsmClass cls = (CsmClass)classifier;
            CsmFunction contextFunction = CsmBaseUtilities.getContextFunction((CsmOffsetableDeclaration)context);
            CsmClass contextClass = CsmBaseUtilities.getContextClass((CsmOffsetableDeclaration)context);
            if (CsmInheritanceUtilities.isAssignableFrom((CsmClass)contextClass, (CsmClass)cls)) {
                staticOnly = false;
            }
            if ((res = finder.findFields(context, cls, name, exactMatch, staticOnly, inspectOuterClasses, inspectParentClasses, scopeAccessedClassifier, sort)) != null) {
                ret.addAll(res);
            }
            if ((res = finder.findEnumerators(context, cls, name, exactMatch, inspectOuterClasses, inspectParentClasses, scopeAccessedClassifier, sort)) != null) {
                ret.addAll(res);
            }
            if (contextFunction == null && contextClass == null) {
                staticOnly = false;
                context = cls;
            }
            if ((res = finder.findMethods(context, cls, name, exactMatch, staticOnly, inspectOuterClasses, inspectParentClasses, scopeAccessedClassifier, sort)) != null) {
                if (!skipConstructors) {
                    ret.addAll(res);
                } else {
                    for (CsmField mtd : res) {
                        if (CsmKindUtilities.isConstructor((CsmObject)((CsmObject)mtd))) continue;
                        ret.add((CsmObject)mtd);
                    }
                }
            }
            return ret;
        }
        if (CsmKindUtilities.isEnum((CsmObject)classifier)) {
            for (CsmEnumerator enumerator : ((CsmEnum)classifier).getEnumerators()) {
                if (!CsmSortUtilities.matchName((CharSequence)enumerator.getName(), (CharSequence)name, (boolean)exactMatch, (boolean)exactMatch)) continue;
                ret.add((CsmObject)enumerator);
            }
            return ret;
        }
        return ret;
    }

    private static CsmClassifier getClassifier(CsmType type, CsmFile contextFile, int offset) {
        CsmClassifier cls = CsmBaseUtilities.getClassifier((CsmType)type, (CsmFile)contextFile, (int)offset, (boolean)true);
        return cls;
    }

    private static CsmFunction getOperator(CsmClassifier classifier, CsmFile contextFile, int offset, CsmFunction.OperatorKind opKind) {
        if (!CsmKindUtilities.isClass((CsmObject)classifier)) {
            return null;
        }
        CsmClass cls = (CsmClass)classifier;
        CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createNameFilter((CharSequence)("operator " + opKind.getImage()), false, true, false);
        return CsmCompletionQuery.getOperatorCheckBaseClasses(cls, contextFile, offset, filter, opKind, new ClassifiersAntiLoop());
    }

    private static CsmFunction getOperatorCheckBaseClasses(CsmClass cls, CsmFile contextFile, int offset, CsmSelect.CsmFilter filter, CsmFunction.OperatorKind opKind, ClassifiersAntiLoop antiLoop) {
        if (antiLoop.contains((CsmClassifier)cls)) {
            return null;
        }
        antiLoop.add((CsmClassifier)cls);
        Iterator it = CsmSelect.getClassMembers((CsmClass)cls, (CsmSelect.CsmFilter)filter);
        while (it.hasNext()) {
            CsmMember member = (CsmMember)it.next();
            if (!CsmKindUtilities.isOperator((CsmObject)member) || ((CsmFunction)member).getOperatorKind() != opKind) continue;
            return (CsmFunction)member;
        }
        for (CsmInheritance csmInheritance : cls.getBaseClasses()) {
            CsmFunction operatorFun;
            CsmClassifier baseClassifier = CsmCompletionQuery.getClassifier(csmInheritance.getAncestorType(), contextFile, offset);
            if (!CsmKindUtilities.isClass((CsmObject)baseClassifier) || (operatorFun = CsmCompletionQuery.getOperatorCheckBaseClasses((CsmClass)baseClassifier, contextFile, offset, filter, opKind, antiLoop)) == null) continue;
            return operatorFun;
        }
        return null;
    }

    private static CsmType getOverloadedOperatorReturnType(CsmType type, CsmFile contextFile, int offset, CsmFunction.OperatorKind operator, int level) {
        CsmFunction op;
        if (type == null || type.getArrayDepth() > 0 || CsmBaseUtilities.isPointer((CsmType)type)) {
            return null;
        }
        CsmType opType = null;
        CsmClassifier cls = CsmCompletionQuery.getClassifier(type, contextFile, offset);
        if (CsmKindUtilities.isClass((CsmObject)cls) && (op = CsmCompletionQuery.getOperator((CsmClassifier)((CsmClass)cls), contextFile, offset, operator)) != null) {
            opType = op.getReturnType();
            if (!type.equals(opType) && level > 0) {
                CsmType opType2;
                if (operator == CsmFunction.OperatorKind.ARROW && (opType2 = CsmCompletionQuery.getOverloadedOperatorReturnType(opType, contextFile, offset, operator, level - 1)) != null) {
                    opType = opType2;
                }
            } else {
                CsmFile typeFile = type.getContainingFile();
                System.err.printf("circular pointer delegation detected:%s, line %d/n", typeFile != null ? typeFile.getAbsolutePath() : type, type.getStartOffset());
                CndUtils.assertTrueInConsole((boolean)false, (String)("Infinite recursion in file " + typeFile + " type " + type));
            }
        }
        return opType;
    }

    private boolean isInIncludeDirective(BaseDocument doc, int offset) {
        return false;
    }

    private static String formatTypeList(List<CsmType> typeList, boolean methodOpen) {
        StringBuilder sb = new StringBuilder();
        if (typeList.size() > 0) {
            int cntM1 = typeList.size() - 1;
            for (int i = 0; i <= cntM1; ++i) {
                CsmType t = typeList.get(i);
                if (t != null) {
                    sb.append(t.getText());
                } else {
                    sb.append('?');
                }
                if (i >= cntM1) continue;
                sb.append(", ");
            }
            if (methodOpen) {
                sb.append(", *");
            }
        } else if (methodOpen) {
            sb.append("*");
        }
        return sb.toString();
    }

    private static boolean isSimpleVariableExpression(CsmCompletionExpression exp) {
        switch (exp.getExpID()) {
            case 32: 
            case 33: {
                if (exp.getParameterCount() <= 0) break;
                return CsmCompletionQuery.isSimpleVariableExpression(exp.getParameter(0));
            }
            case 4: 
            case 5: 
            case 15: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                return false;
            }
        }
        return true;
    }

    protected static void setCsmItemFactory(NbCsmCompletionQuery.NbCsmItemFactory factory) {
        itemFactory = factory;
    }

    public static CsmItemFactory getCsmItemFactory() {
        return itemFactory;
    }

    private static List<CsmResultItem> convertData(Collection<?> dataList, int classDisplayOffset, CsmCompletionExpression substituteExp, int substituteOffset, CsmOffsetableDeclaration contextElement, boolean instantiateTypes, CsmResultItem.SubstitutionHint hint) {
        ArrayList<CsmResultItem> ret = new ArrayList<CsmResultItem>();
        for (Object obj : dataList) {
            if (CsmCompletionQuery.isProhibitedResultItem(obj)) continue;
            CsmResultItem item = CsmCompletionQuery.createResultItem(obj, classDisplayOffset, substituteExp, contextElement, instantiateTypes);
            assert (item != null) : "why null item? object " + obj + " iof " + (obj == null ? "null" : obj.getClass()) + " in expr" + substituteExp;
            if (item == null) continue;
            item.setSubstituteOffset(substituteOffset);
            item.setHint(hint);
            ret.add(item);
        }
        return ret;
    }

    private static <T extends CsmFunctional> List<T> uninstantiateFunctionDefinitions(Collection<T> functions, CsmUtilities.Predicate<CsmFunctional> acceptor) {
        ArrayList<CsmFunctional> uninstantiated = new ArrayList<CsmFunctional>();
        for (CsmFunctional func : functions) {
            if (CsmKindUtilities.isFunctionDefinition((CsmObject)func)) {
                CsmFunctional inst = CsmCompletionQuery.tryUninstantiateFunction(func);
                if (!acceptor.check((Object)inst)) continue;
                uninstantiated.add(inst);
                continue;
            }
            uninstantiated.add(func);
        }
        return uninstantiated;
    }

    private static CsmFunctional tryUninstantiateFunction(CsmFunctional function) {
        CsmOffsetableDeclaration decl;
        while (CsmKindUtilities.isInstantiation((CsmObject)function) && CsmKindUtilities.isFunctional((CsmObject)(decl = ((CsmInstantiation)function).getTemplateDeclaration()))) {
            function = (CsmFunctional)decl;
        }
        return function;
    }

    private static boolean isProhibitedResultItem(Object obj) {
        if (obj instanceof CsmObject) {
            CsmObject csmObj = (CsmObject)obj;
            if (CsmKindUtilities.isFunctionPointerClassifier((CsmObject)csmObj)) {
                return true;
            }
            if (CsmKindUtilities.isClosureClassifier((CsmObject)csmObj)) {
                return true;
            }
        }
        return false;
    }

    private static CsmResultItem createResultItem(Object obj, int classDisplayOffset, CsmCompletionExpression substituteExp, CsmOffsetableDeclaration contextElement, boolean instantiateTypes) {
        if (CsmKindUtilities.isCsmObject((Object)obj)) {
            CsmObject csmObj = (CsmObject)obj;
            assert (!CsmKindUtilities.isMethod((CsmObject)csmObj) || CsmKindUtilities.isMethodDeclaration((CsmObject)csmObj)) : "completion result can not have method definitions " + obj;
            if (CsmKindUtilities.isNamespace((Object)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createNamespaceResultItem((CsmNamespace)csmObj, false);
            }
            if (CsmKindUtilities.isEnum((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createEnumResultItem((CsmEnum)csmObj, classDisplayOffset, false);
            }
            if (CsmKindUtilities.isEnumerator((Object)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createGlobalEnumeratorResultItem((CsmEnumerator)csmObj, classDisplayOffset, false);
            }
            if (CsmKindUtilities.isClass((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createClassResultItem((CsmClass)csmObj, classDisplayOffset, false);
            }
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createForwardClassResultItem((CsmClassForwardDeclaration)csmObj, classDisplayOffset, false);
            }
            if (CsmKindUtilities.isEnumForwardDeclaration((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createForwardEnumResultItem((CsmEnumForwardDeclaration)csmObj, classDisplayOffset, false);
            }
            if (CsmKindUtilities.isField((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createFieldResultItem((CsmField)csmObj);
            }
            if (CsmKindUtilities.isConstructor((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createConstructorResultItem((CsmConstructor)csmObj, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes);
            }
            if (CsmKindUtilities.isMethodDeclaration((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createMethodResultItem((CsmMethod)csmObj, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes);
            }
            if (CsmKindUtilities.isGlobalFunction((CsmObject)csmObj)) {
                if (CsmBaseUtilities.isFileLocalFunction((CsmFunction)((CsmFunction)csmObj))) {
                    return CsmCompletionQuery.getCsmItemFactory().createFileLocalFunctionResultItem((CsmFunction)csmObj, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes);
                }
                return CsmCompletionQuery.getCsmItemFactory().createGlobalFunctionResultItem((CsmFunction)csmObj, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes);
            }
            if (CsmKindUtilities.isGlobalVariable((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createGlobalVariableResultItem((CsmVariable)csmObj);
            }
            if (CsmKindUtilities.isFileLocalVariable((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createFileLocalVariableResultItem((CsmVariable)csmObj);
            }
            if (CsmKindUtilities.isLocalVariable((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createLocalVariableResultItem((CsmVariable)csmObj);
            }
            if (CsmKindUtilities.isMacro((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createGlobalMacroResultItem((CsmMacro)csmObj);
            }
            if (CsmKindUtilities.isTypedef((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createTypedefResultItem((CsmTypedef)csmObj, classDisplayOffset, false);
            }
            if (CsmKindUtilities.isTypeAlias((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createTypedefResultItem((CsmTypedef)((CsmTypeAlias)csmObj), classDisplayOffset, false);
            }
            if (CsmKindUtilities.isStatement((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createLabelResultItem((CsmLabel)csmObj);
            }
            if (CsmKindUtilities.isNamespaceAlias((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createNamespaceAliasResultItem((CsmNamespaceAlias)csmObj, false);
            }
            if (CsmKindUtilities.isTemplateParameter((CsmObject)csmObj)) {
                return CsmCompletionQuery.getCsmItemFactory().createTemplateParameterResultItem((CsmTemplateParameter)csmObj);
            }
            if (csmObj instanceof CsmTemplateBasedReferencedObject) {
                return new TemplateBasedReferencedObjectResultItem((CsmObject)obj);
            }
        }
        return null;
    }

    private static List<CsmResultItem> convertData(CompletionResolver.Result res, int classDisplayOffset, CsmCompletionExpression substituteExp, int substituteOffset, CsmOffsetableDeclaration contextElement, boolean instantiateTypes) {
        CsmResultItem item;
        if (res == null) {
            return Collections.emptyList();
        }
        ArrayList<CsmResultItem> out = new ArrayList<CsmResultItem>(res.size());
        CsmItemFactory factory = CsmCompletionQuery.getCsmItemFactory();
        for (CsmVariable csmVariable : res.getLocalVariables()) {
            item = factory.createLocalVariableResultItem(csmVariable);
            assert (item != null);
            out.add(item);
        }
        for (CsmTemplateParameter csmTemplateParameter : res.getTemplateparameters()) {
            item = factory.createTemplateParameterResultItem(csmTemplateParameter);
            assert (item != null);
            out.add(item);
        }
        for (CsmField csmField : res.getClassFields()) {
            item = factory.createFieldResultItem(csmField);
            assert (item != null);
            out.add(item);
        }
        for (CsmEnumerator csmEnumerator : res.getClassEnumerators()) {
            item = factory.createMemberEnumeratorResultItem(csmEnumerator, classDisplayOffset, false);
            assert (item != null);
            out.add(item);
        }
        for (CsmMethod csmMethod : res.getClassMethods()) {
            item = CsmKindUtilities.isConstructor((CsmObject)csmMethod) ? factory.createConstructorResultItem((CsmConstructor)csmMethod, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes) : factory.createMethodResultItem(csmMethod, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes);
            assert (item != null);
            out.add(item);
        }
        for (CsmClassifier csmClassifier : res.getProjectClassesifiersEnums()) {
            CsmClassForwardDeclaration fd;
            if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
                item = factory.createClassResultItem((CsmClass)csmClassifier, classDisplayOffset, false);
            } else if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmClassifier)) {
                fd = (CsmClassForwardDeclaration)csmClassifier;
                if (fd.getCsmClass() == null) continue;
                item = factory.createClassResultItem(fd.getCsmClass(), classDisplayOffset, false);
            } else if (CsmKindUtilities.isEnumForwardDeclaration((CsmObject)csmClassifier)) {
                fd = (CsmEnumForwardDeclaration)csmClassifier;
                if (fd.getCsmEnum() == null) continue;
                item = factory.createEnumResultItem(fd.getCsmEnum(), classDisplayOffset, false);
            } else if (CsmKindUtilities.isTypedef((CsmObject)csmClassifier) || CsmKindUtilities.isTypeAlias((CsmObject)csmClassifier)) {
                item = factory.createTypedefResultItem((CsmTypedef)csmClassifier, classDisplayOffset, false);
            } else {
                assert (CsmKindUtilities.isEnum((CsmObject)csmClassifier));
                item = factory.createEnumResultItem((CsmEnum)csmClassifier, classDisplayOffset, false);
            }
            assert (item != null);
            out.add(item);
        }
        for (CsmVariable csmVariable : res.getFileLocalVars()) {
            item = factory.createFileLocalVariableResultItem(csmVariable);
            assert (item != null);
            out.add(item);
        }
        for (CsmEnumerator csmEnumerator : res.getFileLocalEnumerators()) {
            item = factory.createFileLocalEnumeratorResultItem(csmEnumerator, classDisplayOffset, false);
            assert (item != null);
            out.add(item);
        }
        for (CsmMacro csmMacro : res.getFileLocalMacros()) {
            item = factory.createFileLocalMacroResultItem(csmMacro);
            assert (item != null);
            out.add(item);
        }
        for (CsmFunction csmFunction : res.getFileLocalFunctions()) {
            item = factory.createFileLocalFunctionResultItem(csmFunction, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes);
            assert (item != null);
            out.add(item);
        }
        for (CsmMacro csmMacro : res.getInFileIncludedProjectMacros()) {
            item = factory.createFileIncludedProjectMacroResultItem(csmMacro);
            assert (item != null);
            out.add(item);
        }
        for (CsmVariable csmVariable : res.getGlobalVariables()) {
            item = factory.createGlobalVariableResultItem(csmVariable);
            assert (item != null);
            out.add(item);
        }
        for (CsmEnumerator csmEnumerator : res.getGlobalEnumerators()) {
            item = factory.createGlobalEnumeratorResultItem(csmEnumerator, classDisplayOffset, false);
            assert (item != null);
            out.add(item);
        }
        for (CsmMacro csmMacro : res.getGlobalProjectMacros()) {
            item = factory.createGlobalMacroResultItem(csmMacro);
            assert (item != null);
            out.add(item);
        }
        for (CsmFunction csmFunction : res.getGlobalProjectFunctions()) {
            item = factory.createGlobalFunctionResultItem(csmFunction, substituteExp, CsmCompletionQuery.isDeclaration(substituteExp, contextElement), instantiateTypes);
            assert (item != null);
            out.add(item);
        }
        for (CsmNamespace csmNamespace : res.getGlobalProjectNamespaces()) {
            item = factory.createNamespaceResultItem(csmNamespace, false);
            assert (item != null);
            out.add(item);
        }
        for (CsmNamespaceAlias csmNamespaceAlias : res.getProjectNamespaceAliases()) {
            item = factory.createNamespaceAliasResultItem(csmNamespaceAlias, false);
            assert (item != null);
            out.add(item);
        }
        for (CsmClassifier csmClassifier : res.getLibClassifiersEnums()) {
            if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
                item = factory.createLibClassResultItem((CsmClass)csmClassifier, classDisplayOffset, false);
            } else if (CsmKindUtilities.isTypedef((CsmObject)csmClassifier) || CsmKindUtilities.isTypeAlias((CsmObject)csmClassifier)) {
                item = factory.createLibTypedefResultItem((CsmTypedef)csmClassifier, classDisplayOffset, false);
            } else {
                assert (CsmKindUtilities.isEnum((CsmObject)csmClassifier));
                item = factory.createLibEnumResultItem((CsmEnum)csmClassifier, classDisplayOffset, false);
            }
            assert (item != null);
            out.add(item);
        }
        for (CsmMacro csmMacro : res.getInFileIncludedLibMacros()) {
            item = factory.createFileIncludedLibMacroResultItem(csmMacro);
            assert (item != null);
            out.add(item);
        }
        for (CsmMacro csmMacro : res.getLibMacros()) {
            item = factory.createLibMacroResultItem(csmMacro);
            assert (item != null);
            out.add(item);
        }
        for (CsmVariable csmVariable : res.getLibVariables()) {
            item = factory.createLibGlobalVariableResultItem(csmVariable);
            assert (item != null);
            out.add(item);
        }
        for (CsmEnumerator csmEnumerator : res.getLibEnumerators()) {
            item = factory.createLibGlobalEnumeratorResultItem(csmEnumerator, classDisplayOffset, false);
            assert (item != null);
            out.add(item);
        }
        for (CsmFunction csmFunction : res.getLibFunctions()) {
            item = factory.createLibGlobalFunctionResultItem(csmFunction, substituteExp, instantiateTypes);
            assert (item != null);
            out.add(item);
        }
        for (CsmNamespace csmNamespace : res.getLibNamespaces()) {
            item = factory.createLibNamespaceResultItem(csmNamespace, false);
            assert (item != null);
            out.add(item);
        }
        for (CsmNamespaceAlias csmNamespaceAlias : res.getLibNamespaceAliases()) {
            item = factory.createLibNamespaceAliasResultItem(csmNamespaceAlias, false);
            assert (item != null);
            out.add(item);
        }
        for (CsmResultItem csmResultItem : out) {
            csmResultItem.setSubstituteOffset(substituteOffset);
        }
        return out;
    }

    private static boolean isDeclaration(CsmCompletionExpression substituteExp, CsmOffsetableDeclaration scopeElement) {
        int expId = substituteExp.getExpID();
        return scopeElement == null && (expId == 1 || expId == 27 || expId == 28);
    }

    static int getReferenceValue(CsmType type) {
        if (type.isRValueReference()) {
            return 2;
        }
        if (type.isReference()) {
            return 1;
        }
        return 0;
    }

    static {
        threadLocalAntiloopMap = new ThreadLocal<Map<AntiloopClient, Set<CsmOffsetable>>>(){

            @Override
            protected Map<AntiloopClient, Set<CsmOffsetable>> initialValue() {
                return new EnumMap<AntiloopClient, Set<CsmOffsetable>>(AntiloopClient.class);
            }
        };
    }

    private static class TemplateBasedReferencedObjectResultItem
    extends CsmResultItem {
        TemplateBasedReferencedObjectResultItem(CsmObject obj) {
            super(obj, 0);
        }

        @Override
        public String getItemText() {
            return "TemplateBasedReferencedObjectResultItem for " + this.getAssociatedObject();
        }

        @Override
        protected Component getPaintComponent(boolean isSelected) {
            return new CsmPaintComponent(){

                protected void draw(Graphics g) {
                }

                public String toString() {
                    return "fake TemplateBasedReferencedObjectResultItem paint component";
                }
            };
        }

        @Override
        public String getStringPresentation() {
            return "TemplateBasedReferencedObjectResultItem for " + this.getAssociatedObject();
        }
    }

    private static class TemplateBasedReferencedObjectImpl
    implements CsmTemplateBasedReferencedObject {
        private final CsmType lastType;
        private final CharSequence textAfterType;

        private TemplateBasedReferencedObjectImpl(CsmType lastType, CharSequence textAfterType) {
            this.lastType = lastType;
            assert (lastType != null);
            this.textAfterType = textAfterType;
            assert (textAfterType != null);
        }

        public int getNameStartOffset() {
            return 0;
        }

        public int getNameEndOffset() {
            return 0;
        }

        public CharSequence getName() {
            return NbBundle.getMessage(CsmCompletionQuery.class, (String)"completion-template-based-object", (Object)this.lastType.getCanonicalText(), (Object)this.textAfterType);
        }

        public CsmFile getContainingFile() {
            return this.lastType.getContainingFile();
        }

        public int getStartOffset() {
            return this.lastType.getStartOffset();
        }

        public int getEndOffset() {
            return this.lastType.getEndOffset();
        }

        public CsmOffsetable.Position getStartPosition() {
            return this.lastType.getStartPosition();
        }

        public CsmOffsetable.Position getEndPosition() {
            return this.lastType.getEndPosition();
        }

        public CharSequence getText() {
            return this.getName();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TemplateBasedReferencedObjectImpl other = (TemplateBasedReferencedObjectImpl)obj;
            if (!this.lastType.equals(other.lastType)) {
                return false;
            }
            return this.textAfterType.equals(other.textAfterType);
        }

        public int hashCode() {
            int hash = 5;
            hash = 71 * hash + this.lastType.hashCode();
            hash = 71 * hash + this.textAfterType.hashCode();
            return hash;
        }

        public String toString() {
            return "lastType=" + this.lastType + ", textAfterType=" + this.textAfterType;
        }
    }

    public static final class DefaultCsmItemFactory
    implements CsmItemFactory {
        @Override
        public CsmResultItem.NamespaceResultItem createNamespaceResultItem(CsmNamespace pkg, boolean displayFullNamespacePath) {
            return new CsmResultItem.NamespaceResultItem(pkg, displayFullNamespacePath, 1000);
        }

        @Override
        public CsmResultItem.NamespaceAliasResultItem createNamespaceAliasResultItem(CsmNamespaceAlias alias, boolean displayFullNamespacePath) {
            return new CsmResultItem.NamespaceAliasResultItem(alias, displayFullNamespacePath, 1000);
        }

        @Override
        public CsmResultItem.EnumeratorResultItem createMemberEnumeratorResultItem(CsmEnumerator enmtr, int enumtrDisplayOffset, boolean displayFQN) {
            return this.createGlobalEnumeratorResultItem(enmtr, enumtrDisplayOffset, displayFQN);
        }

        @Override
        public CsmResultItem.EnumeratorResultItem createFileLocalEnumeratorResultItem(CsmEnumerator enmtr, int enumtrDisplayOffset, boolean displayFQN) {
            return this.createGlobalEnumeratorResultItem(enmtr, enumtrDisplayOffset, displayFQN);
        }

        @Override
        public CsmResultItem.EnumeratorResultItem createGlobalEnumeratorResultItem(CsmEnumerator enmtr, int enumtrDisplayOffset, boolean displayFQN) {
            return new CsmResultItem.EnumeratorResultItem(enmtr, enumtrDisplayOffset, displayFQN, 1000);
        }

        @Override
        public CsmResultItem.MacroResultItem createFileLocalMacroResultItem(CsmMacro mac) {
            return this.createGlobalMacroResultItem(mac);
        }

        @Override
        public CsmResultItem.MacroResultItem createFileIncludedProjectMacroResultItem(CsmMacro mac) {
            return this.createGlobalMacroResultItem(mac);
        }

        @Override
        public CsmResultItem.ClassResultItem createClassResultItem(CsmClass cls, int classDisplayOffset, boolean displayFQN) {
            return new CsmResultItem.ClassResultItem(cls, classDisplayOffset, displayFQN, 1000);
        }

        @Override
        public CsmResultItem.ForwardClassResultItem createForwardClassResultItem(CsmClassForwardDeclaration cls, int classDisplayOffset, boolean displayFQN) {
            return new CsmResultItem.ForwardClassResultItem(cls, classDisplayOffset, displayFQN, 1000);
        }

        @Override
        public CsmResultItem.ForwardEnumResultItem createForwardEnumResultItem(CsmEnumForwardDeclaration cls, int classDisplayOffset, boolean displayFQN) {
            return new CsmResultItem.ForwardEnumResultItem(cls, classDisplayOffset, displayFQN, 1000);
        }

        @Override
        public CsmResultItem.EnumResultItem createEnumResultItem(CsmEnum enm, int enumDisplayOffset, boolean displayFQN) {
            return new CsmResultItem.EnumResultItem(enm, enumDisplayOffset, displayFQN, 1000);
        }

        @Override
        public CsmResultItem.TypedefResultItem createTypedefResultItem(CsmTypedef def, int classDisplayOffset, boolean displayFQN) {
            return new CsmResultItem.TypedefResultItem(def, classDisplayOffset, displayFQN, 1000);
        }

        @Override
        public CsmResultItem.ClassResultItem createLibClassResultItem(CsmClass cls, int classDisplayOffset, boolean displayFQN) {
            return this.createClassResultItem(cls, classDisplayOffset, displayFQN);
        }

        @Override
        public CsmResultItem.EnumResultItem createLibEnumResultItem(CsmEnum enm, int enumDisplayOffset, boolean displayFQN) {
            return this.createEnumResultItem(enm, enumDisplayOffset, displayFQN);
        }

        @Override
        public CsmResultItem.TypedefResultItem createLibTypedefResultItem(CsmTypedef def, int classDisplayOffset, boolean displayFQN) {
            return this.createTypedefResultItem(def, classDisplayOffset, displayFQN);
        }

        @Override
        public CsmResultItem.FieldResultItem createFieldResultItem(CsmField fld) {
            return new CsmResultItem.FieldResultItem(fld, 1000);
        }

        @Override
        public CsmResultItem.MethodResultItem createMethodResultItem(CsmMethod mtd, CsmCompletionExpression substituteExp, boolean isDeclaration, boolean instantiateTypes) {
            return new CsmResultItem.MethodResultItem((CsmFunction)mtd, substituteExp, 1000, isDeclaration, instantiateTypes);
        }

        @Override
        public CsmResultItem.ConstructorResultItem createConstructorResultItem(CsmConstructor ctr, CsmCompletionExpression substituteExp, boolean isDeclaration, boolean instantiateTypes) {
            return new CsmResultItem.ConstructorResultItem((CsmFunction)ctr, substituteExp, 1000, isDeclaration, instantiateTypes);
        }

        @Override
        public CsmResultItem.GlobalFunctionResultItem createGlobalFunctionResultItem(CsmFunction fun, CsmCompletionExpression substituteExp, boolean isDeclaration, boolean instantiateTypes) {
            return new CsmResultItem.GlobalFunctionResultItem(fun, substituteExp, 1000, isDeclaration, instantiateTypes);
        }

        @Override
        public CsmResultItem.GlobalVariableResultItem createGlobalVariableResultItem(CsmVariable var) {
            return new CsmResultItem.GlobalVariableResultItem(var, 1000);
        }

        @Override
        public CsmResultItem.LocalVariableResultItem createLocalVariableResultItem(CsmVariable var) {
            return new CsmResultItem.LocalVariableResultItem(var, 1000);
        }

        @Override
        public CsmResultItem.FileLocalVariableResultItem createFileLocalVariableResultItem(CsmVariable var) {
            return new CsmResultItem.FileLocalVariableResultItem(var, 1000);
        }

        @Override
        public CsmResultItem.FileLocalFunctionResultItem createFileLocalFunctionResultItem(CsmFunction fun, CsmCompletionExpression substituteExp, boolean isDeclaration, boolean instantiateTypes) {
            return new CsmResultItem.FileLocalFunctionResultItem(fun, substituteExp, 1000, isDeclaration, instantiateTypes);
        }

        @Override
        public CsmResultItem.MacroResultItem createGlobalMacroResultItem(CsmMacro mac) {
            return new CsmResultItem.MacroResultItem(mac, 1000);
        }

        @Override
        public CsmResultItem.MacroResultItem createFileIncludedLibMacroResultItem(CsmMacro mac) {
            return this.createGlobalMacroResultItem(mac);
        }

        @Override
        public CsmResultItem.MacroResultItem createLibMacroResultItem(CsmMacro mac) {
            return this.createGlobalMacroResultItem(mac);
        }

        @Override
        public CsmResultItem.GlobalVariableResultItem createLibGlobalVariableResultItem(CsmVariable var) {
            return this.createGlobalVariableResultItem(var);
        }

        @Override
        public CsmResultItem.EnumeratorResultItem createLibGlobalEnumeratorResultItem(CsmEnumerator enmtr, int enumtrDisplayOffset, boolean displayFQN) {
            return this.createGlobalEnumeratorResultItem(enmtr, enumtrDisplayOffset, displayFQN);
        }

        @Override
        public CsmResultItem.GlobalFunctionResultItem createLibGlobalFunctionResultItem(CsmFunction fun, CsmCompletionExpression substituteExp, boolean instantiateTypes) {
            return this.createGlobalFunctionResultItem(fun, substituteExp, false, instantiateTypes);
        }

        @Override
        public CsmResultItem.NamespaceResultItem createLibNamespaceResultItem(CsmNamespace pkg, boolean displayFullNamespacePath) {
            return this.createNamespaceResultItem(pkg, displayFullNamespacePath);
        }

        @Override
        public CsmResultItem.NamespaceAliasResultItem createLibNamespaceAliasResultItem(CsmNamespaceAlias alias, boolean displayFullNamespacePath) {
            return this.createNamespaceAliasResultItem(alias, displayFullNamespacePath);
        }

        @Override
        public CsmResultItem.TemplateParameterResultItem createTemplateParameterResultItem(CsmTemplateParameter par) {
            return new CsmResultItem.TemplateParameterResultItem(par, 1000);
        }

        @Override
        public CsmResultItem createLabelResultItem(CsmLabel csmStatement) {
            return new CsmResultItem.LabelResultItem(csmStatement, 1000);
        }
    }

    public static interface CsmItemFactory {
        public CsmResultItem.LocalVariableResultItem createLocalVariableResultItem(CsmVariable var1);

        public CsmResultItem createLabelResultItem(CsmLabel var1);

        public CsmResultItem.FieldResultItem createFieldResultItem(CsmField var1);

        public CsmResultItem.EnumeratorResultItem createMemberEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.MethodResultItem createMethodResultItem(CsmMethod var1, CsmCompletionExpression var2, boolean var3, boolean var4);

        public CsmResultItem.ConstructorResultItem createConstructorResultItem(CsmConstructor var1, CsmCompletionExpression var2, boolean var3, boolean var4);

        public CsmResultItem.ClassResultItem createClassResultItem(CsmClass var1, int var2, boolean var3);

        public CsmResultItem.EnumResultItem createEnumResultItem(CsmEnum var1, int var2, boolean var3);

        public CsmResultItem.TypedefResultItem createTypedefResultItem(CsmTypedef var1, int var2, boolean var3);

        public CsmResultItem.ForwardClassResultItem createForwardClassResultItem(CsmClassForwardDeclaration var1, int var2, boolean var3);

        public CsmResultItem.ForwardEnumResultItem createForwardEnumResultItem(CsmEnumForwardDeclaration var1, int var2, boolean var3);

        public CsmResultItem.FileLocalVariableResultItem createFileLocalVariableResultItem(CsmVariable var1);

        public CsmResultItem.EnumeratorResultItem createFileLocalEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.FileLocalFunctionResultItem createFileLocalFunctionResultItem(CsmFunction var1, CsmCompletionExpression var2, boolean var3, boolean var4);

        public CsmResultItem.MacroResultItem createFileLocalMacroResultItem(CsmMacro var1);

        public CsmResultItem.MacroResultItem createFileIncludedProjectMacroResultItem(CsmMacro var1);

        public CsmResultItem.TemplateParameterResultItem createTemplateParameterResultItem(CsmTemplateParameter var1);

        public CsmResultItem.GlobalVariableResultItem createGlobalVariableResultItem(CsmVariable var1);

        public CsmResultItem.EnumeratorResultItem createGlobalEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.GlobalFunctionResultItem createGlobalFunctionResultItem(CsmFunction var1, CsmCompletionExpression var2, boolean var3, boolean var4);

        public CsmResultItem.MacroResultItem createGlobalMacroResultItem(CsmMacro var1);

        public CsmResultItem.NamespaceResultItem createNamespaceResultItem(CsmNamespace var1, boolean var2);

        public CsmResultItem.NamespaceAliasResultItem createNamespaceAliasResultItem(CsmNamespaceAlias var1, boolean var2);

        public CsmResultItem.ClassResultItem createLibClassResultItem(CsmClass var1, int var2, boolean var3);

        public CsmResultItem.EnumResultItem createLibEnumResultItem(CsmEnum var1, int var2, boolean var3);

        public CsmResultItem.TypedefResultItem createLibTypedefResultItem(CsmTypedef var1, int var2, boolean var3);

        public CsmResultItem.MacroResultItem createFileIncludedLibMacroResultItem(CsmMacro var1);

        public CsmResultItem.MacroResultItem createLibMacroResultItem(CsmMacro var1);

        public CsmResultItem.GlobalVariableResultItem createLibGlobalVariableResultItem(CsmVariable var1);

        public CsmResultItem.EnumeratorResultItem createLibGlobalEnumeratorResultItem(CsmEnumerator var1, int var2, boolean var3);

        public CsmResultItem.GlobalFunctionResultItem createLibGlobalFunctionResultItem(CsmFunction var1, CsmCompletionExpression var2, boolean var3);

        public CsmResultItem.NamespaceResultItem createLibNamespaceResultItem(CsmNamespace var1, boolean var2);

        public CsmResultItem.NamespaceAliasResultItem createLibNamespaceAliasResultItem(CsmNamespaceAlias var1, boolean var2);
    }

    public static class CsmCompletionResult {
        private final int classDisplayOffset;
        private final CsmCompletionExpression substituteExp;
        private final int substituteOffset;
        private final int substituteLength;
        private final JTextComponent component;
        private BaseDocument baseDocument;
        private final List<CsmResultItem> items;
        private boolean simpleVariableExpression;

        CsmCompletionResult(JTextComponent component, BaseDocument doc, Collection<?> data, String title, CsmCompletionExpression substituteExp, int classDisplayOffset, boolean isProjectBeeingParsed, CsmOffsetableDeclaration contextElement, boolean instantiateTypes) {
            this(component, doc, data, title, substituteExp, substituteExp.getTokenOffset(0), substituteExp.getTokenLength(0), classDisplayOffset, isProjectBeeingParsed, contextElement, instantiateTypes);
        }

        CsmCompletionResult(JTextComponent component, BaseDocument doc, CompletionResolver.Result res, String title, CsmCompletionExpression substituteExp, int substituteOffset, int substituteLength, int classDisplayOffset, boolean isProjectBeeingParsed, CsmOffsetableDeclaration contextElement, boolean instantiateTypes) {
            this(component, doc, CsmCompletionQuery.convertData(res, classDisplayOffset, substituteExp, substituteOffset, contextElement, instantiateTypes), true, title, substituteExp, substituteOffset, substituteLength, classDisplayOffset, isProjectBeeingParsed);
        }

        CsmCompletionResult(JTextComponent component, BaseDocument doc, Collection<?> data, String title, CsmCompletionExpression substituteExp, int substituteOffset, int substituteLength, int classDisplayOffset, boolean isProjectBeeingParsed, CsmOffsetableDeclaration contextElement, boolean instantiateTypes) {
            this(component, doc, CsmCompletionQuery.convertData(data, classDisplayOffset, substituteExp, substituteOffset, contextElement, instantiateTypes, CsmResultItem.SubstitutionHint.NONE), true, title, substituteExp, substituteOffset, substituteLength, classDisplayOffset, isProjectBeeingParsed);
        }

        CsmCompletionResult(JTextComponent component, BaseDocument doc, Collection<?> data, CsmResultItem.SubstitutionHint hint, String title, CsmCompletionExpression substituteExp, int substituteOffset, int substituteLength, int classDisplayOffset, boolean isProjectBeeingParsed, CsmOffsetableDeclaration contextElement, boolean instantiateTypes) {
            this(component, doc, CsmCompletionQuery.convertData(data, classDisplayOffset, substituteExp, substituteOffset, contextElement, instantiateTypes, hint), true, title, substituteExp, substituteOffset, substituteLength, classDisplayOffset, isProjectBeeingParsed);
        }

        private CsmCompletionResult(JTextComponent component, BaseDocument doc, List<CsmResultItem> data, boolean updateTitle, String title, CsmCompletionExpression substituteExp, int substituteOffset, int substituteLength, int classDisplayOffset, boolean isProjectBeeingParsed) {
            this.component = component;
            this.baseDocument = doc;
            this.substituteExp = substituteExp;
            this.substituteOffset = substituteOffset;
            this.substituteLength = substituteLength;
            this.classDisplayOffset = classDisplayOffset;
            this.items = data;
        }

        public List<? extends CompletionItem> getItems() {
            return Collections.unmodifiableList(this.items);
        }

        private static String getTitle(List<?> data, String origTitle, boolean isProjectBeeingParsed) {
            if (CsmUtilities.DEBUG) {
                System.out.println("original title (resolved type) was " + origTitle);
            }
            String out = NO_SUGGESTIONS;
            if (data != null && data.size() > 0) {
                out = origTitle;
            }
            if (isProjectBeeingParsed) {
                out = MessageFormat.format(PROJECT_BEEING_PARSED, out);
            }
            return out;
        }

        protected JTextComponent getComponent() {
            return this.component;
        }

        protected int getSubstituteLength() {
            return this.substituteLength;
        }

        public int getSubstituteOffset() {
            return this.substituteOffset;
        }

        protected CsmCompletionExpression getSubstituteExp() {
            return this.substituteExp;
        }

        protected int getClassDisplayOffset() {
            return this.classDisplayOffset;
        }

        private void setSimpleVariableExpression(boolean simple) {
            this.simpleVariableExpression = simple;
        }

        public boolean isSimpleVariableExpression() {
            return this.simpleVariableExpression;
        }
    }

    class Context {
        private boolean sort;
        private JTextComponent component;
        private CompletionSupport sup;
        private boolean openingSource;
        private int endOffset;
        private boolean findType;
        private boolean staticOnly = false;
        private boolean memberPointer = false;
        private boolean scopeAccessedClassifier = false;
        private CsmNamespace lastNamespace;
        private CsmType lastType;
        private CsmCompletionResult result;
        private boolean isConstructor;
        private final CsmFinder finder;
        private final CsmFile contextFile;
        private final CsmScope contextScope;
        private CompletionResolver compResolver;
        private CsmOffsetableDeclaration contextElement;
        private final boolean instantiateTypes;
        private List<CsmInstantiation> instantiations;

        public Context(JTextComponent component, CompletionSupport sup, boolean openingSource, int endOffset, CsmFinder finder, CompletionResolver compResolver, CsmOffsetableDeclaration contextElement, CsmScope contextScope, boolean sort, boolean instantiateTypes, List<CsmInstantiation> instantiations) {
            this.component = component;
            this.sup = sup;
            this.openingSource = openingSource;
            this.endOffset = endOffset;
            this.finder = finder;
            this.contextFile = finder == null ? null : finder.getCsmFile();
            this.compResolver = compResolver;
            this.contextElement = contextElement;
            this.sort = sort;
            this.instantiateTypes = instantiateTypes;
            this.instantiations = instantiations;
            this.contextScope = contextScope;
        }

        CsmFile getContextFile() {
            return this.contextFile;
        }

        CsmScope getContextScope() {
            return this.contextScope;
        }

        CsmOffsetableDeclaration getContextElement() {
            return this.contextElement;
        }

        List<CsmInstantiation> getContextInstantiations() {
            return this.instantiations;
        }

        int getEndOffset() {
            return this.endOffset;
        }

        private int convertOffset(int pos) {
            return this.sup.doc2context(pos);
        }

        private CsmType getVariableOrClassifierType(CompletionResolver.Result res, AtomicBoolean visible, CsmCompletionExpression item) {
            CsmType resolveType = null;
            CsmObject resolveObj = null;
            ArrayList vars = new ArrayList();
            res.addResulItemsToCol(vars);
            CsmObject bestCandidate = null;
            CsmIncludeResolver ir = CsmIncludeResolver.getDefault();
            boolean onlyVisible = visible.get();
            visible.set(false);
            boolean _const = this.checkQualifier(item, CppTokenId.CONST);
            ArrayList<CsmObject> visibleObject = new ArrayList<CsmObject>();
            ArrayList<CsmObject> td = new ArrayList<CsmObject>();
            AtomicBoolean hasClassifier = new AtomicBoolean(false);
            for (CsmObject firstElem : vars) {
                if (!CsmKindUtilities.isClassifier((CsmObject)firstElem) && !CsmKindUtilities.isVariable((CsmObject)firstElem)) continue;
                if (ir.isObjectVisible(this.contextFile, firstElem)) {
                    if (!CsmKindUtilities.isClassifier((CsmObject)firstElem)) {
                        visibleObject.add(firstElem);
                        break;
                    }
                    this.fillVisibleListAndFilterTypedefs(firstElem, hasClassifier, visibleObject, td);
                    continue;
                }
                if (onlyVisible || bestCandidate != null) continue;
                bestCandidate = firstElem;
            }
            if (!visibleObject.isEmpty()) {
                resolveObj = (CsmObject)visibleObject.get(0);
                resolveType = this.getObjectType(resolveObj, _const);
                visible.set(true);
                if (TRACE_MULTIPLE_VISIBE_OBJECTS && visibleObject.size() > 1) {
                    System.err.printf("getVariableOrClassifierType: : we have several objects visible from %s [%d]%n", this.contextFile.getAbsolutePath(), this.endOffset);
                    int ind = 0;
                    for (CsmObject obj : visibleObject) {
                        System.err.printf("[%d] %s%n", ind++, obj);
                        System.err.flush();
                    }
                }
            }
            if (resolveType == null && bestCandidate != null) {
                resolveObj = bestCandidate;
                resolveType = this.getObjectType(resolveObj, _const);
            }
            return resolveType;
        }

        private CsmType getObjectType(CsmObject obj, boolean _constIfClassifier) {
            CsmType objType = CsmCompletion.getObjectType(obj, _constIfClassifier);
            if (CsmKindUtilities.isVariable((CsmObject)obj) && CsmUtilities.isAutoType((CsmType)objType)) {
                objType = this.findAutoVariableType((CsmVariable)obj, objType);
            }
            return objType;
        }

        private CsmType findAutoVariableType(CsmVariable var, CsmType varType) {
            CsmRangeForStatement forStmt;
            CsmExpression initializer;
            assert (CsmUtilities.isAutoType((CsmType)varType)) : "var must have auto type!";
            CsmType oldType = varType;
            CsmExpression initialValue = var.getInitialValue();
            if (initialValue != null) {
                varType = this.findExpressionType((CsmOffsetable)initialValue);
                if (varType != null) {
                    varType = CsmCompletion.createType(varType.getClassifier(), varType.getPointerDepth(), CsmCompletionQuery.getReferenceValue(oldType), varType.getArrayDepth(), oldType.isConst() | varType.isPointer() & varType.isConst());
                }
            } else if (CsmKindUtilities.isStatement((CsmObject)var.getScope()) && ((CsmStatement)var.getScope()).getKind().equals((Object)CsmStatement.Kind.RANGE_FOR) && (initializer = (forStmt = (CsmRangeForStatement)var.getScope()).getInitializer()) != null && initializer.getText() != null) {
                TokenHierarchy hi = TokenHierarchy.create((CharSequence)initializer.getText().toString(), (Language)CndLexerUtilities.getLanguage((Document)CsmCompletionQuery.this.getBaseDocument()));
                List tsList = hi.embeddedTokenSequences(initializer.getEndOffset(), true);
                TokenSequence cppts = null;
                for (int i = tsList.size() - 1; i >= 0; --i) {
                    TokenSequence uts;
                    TokenSequence ts = (TokenSequence)tsList.get(i);
                    Language lang = ts.languagePath().innerLanguage();
                    if (!CndLexerUtilities.isCppLanguage((Language)lang, (boolean)false)) continue;
                    cppts = uts = ts;
                }
                if (cppts != null && !CsmCompletionQuery.this.antiLoop.contains(initializer)) {
                    CsmCompletionQuery.this.antiLoop.add((CsmOffsetable)initializer);
                    final CsmCompletionTokenProcessor tp = new CsmCompletionTokenProcessor(initializer.getEndOffset(), initializer.getStartOffset());
                    tp.enableLambdaSupport(true);
                    tp.enableTemplateSupport(true);
                    final BaseDocument doc = CsmCompletionQuery.this.getBaseDocument();
                    doc.render(new Runnable(){

                        @Override
                        public void run() {
                            CndTokenUtilities.processTokens((CndTokenProcessor)tp, (Document)doc, (int)initializer.getStartOffset(), (int)initializer.getEndOffset());
                        }
                    });
                    CsmCompletionExpression exp = tp.getResultExp();
                    varType = this.resolveType(exp);
                    if (varType != null) {
                        if (varType.getArrayDepth() == 0) {
                            CsmFunction dereferenceOperator;
                            CsmClassifier cls = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)varType.getClassifier(), (CsmFile)this.contextFile);
                            List<CsmObject> decls = CsmCompletionQuery.findFieldsAndMethods(this.finder, this.contextElement, cls, "begin", true, false, false, true, false, false, false);
                            for (CsmObject csmObject : decls) {
                                if (!CsmKindUtilities.isFunction((CsmObject)csmObject)) continue;
                                varType = ((CsmFunction)csmObject).getReturnType();
                                break;
                            }
                            if ((dereferenceOperator = CsmCompletionQuery.getOperator(cls = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)varType.getClassifier(), (CsmFile)this.contextFile), this.contextFile, this.endOffset, CsmFunction.OperatorKind.POINTER)) != null) {
                                varType = dereferenceOperator.getReturnType();
                            }
                            varType = CsmCompletion.createType(varType.getClassifier(), varType.getPointerDepth(), CsmCompletionQuery.getReferenceValue(oldType), varType.getArrayDepth(), oldType.isConst() | varType.isPointer() & varType.isConst());
                        } else {
                            varType = CsmCompletion.createType(varType.getClassifier(), varType.getPointerDepth(), CsmCompletionQuery.getReferenceValue(oldType), varType.getArrayDepth() - 1, oldType.isConst() | varType.isPointer() & varType.isConst());
                        }
                    }
                }
            }
            return varType;
        }

        private CsmType findExpressionType(CsmOffsetable expression) {
            if (expression != null && !CsmCompletionQuery.this.antiLoop.contains(expression)) {
                CsmCompletionTokenProcessor tp;
                boolean processAsExpression = CsmKindUtilities.isExpression((CsmObject)expression);
                if (processAsExpression) {
                    tp = CsmCompletionQuery.this.processTokensInExpression((CsmExpression)expression, true);
                } else {
                    long docVersion = DocumentUtilities.getDocumentVersion((Document)CsmCompletionQuery.this.getBaseDocument());
                    tp = CsmCompletionQuery.this.processTokensInFile(expression.getContainingFile(), expression.getStartOffset(), expression.getEndOffset(), CsmCompletionQuery.this.getBaseDocument(), docVersion);
                }
                if (!CsmCompletionQuery.this.checkErrorTokenState(tp)) {
                    CsmCompletionQuery.this.antiLoop.add(expression);
                    CsmCompletionExpression exp = CsmCompletionQuery.this.getResultExpression(tp, processAsExpression, true);
                    return this.resolveType(exp);
                }
            }
            return null;
        }

        private void fillVisibleListAndFilterTypedefs(CsmObject elem, AtomicBoolean hasClassifier, List<CsmObject> visibleObjects, List<CsmObject> td) {
            if (CsmKindUtilities.isTypedef((CsmObject)elem) || CsmKindUtilities.isTypeAlias((CsmObject)elem)) {
                CsmTypedef curTd = (CsmTypedef)elem;
                CharSequence classifierText = curTd.getType().getClassifierText();
                if (curTd.getName().equals(classifierText)) {
                    if (!hasClassifier.get()) {
                        visibleObjects.add(elem);
                        td.add((CsmObject)curTd);
                    }
                } else {
                    visibleObjects.add(elem);
                }
            } else if (CsmKindUtilities.isEnumForwardDeclaration((CsmObject)elem) || CsmClassifierResolver.getDefault().isForwardEnum(elem)) {
                if (!hasClassifier.get()) {
                    visibleObjects.add(elem);
                    td.add(elem);
                }
            } else if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)elem) || CsmClassifierResolver.getDefault().isForwardClass(elem)) {
                if (!hasClassifier.get()) {
                    visibleObjects.add(elem);
                    td.add(elem);
                }
            } else if (CsmKindUtilities.isClassifier((CsmObject)elem)) {
                if (!td.isEmpty()) {
                    visibleObjects.removeAll(td);
                    td.clear();
                }
                hasClassifier.set(true);
                visibleObjects.add(elem);
            } else {
                visibleObjects.add(elem);
            }
        }

        private boolean resolve(int varPos, String var, boolean match) {
            varPos = this.convertOffset(varPos);
            return this.compResolver.refresh() && this.compResolver.resolve(varPos, var, match);
        }

        private void setFindType(boolean findType) {
            this.findType = findType;
        }

        protected Object clone() {
            return new Context(this.component, this.sup, this.openingSource, this.endOffset, this.finder, this.compResolver, this.contextElement, this.contextScope, this.sort, this.instantiateTypes, this.instantiations);
        }

        private CsmClassifier extractLastTypeClassifier(ExprKind expKind) {
            return this.extractTypeClassifier(this.lastType, expKind);
        }

        private CsmClassifier extractTypeClassifier(CsmType type, ExprKind expKind) {
            if (type != null) {
                CsmCompletion.SimpleClass cls = type.getArrayDepth() == 0 || expKind == ExprKind.ARROW ? CsmCompletionQuery.getClassifier(type, this.contextFile, this.endOffset) : CsmCompletion.OBJECT_CLASS_ARRAY;
                return cls;
            }
            return null;
        }

        private Collection<CsmFunction> getConstructors(CsmClass cls) {
            ArrayList<CsmFunction> out = new ArrayList<CsmFunction>();
            CsmSelect.CsmFilterBuilder filterBuilder = CsmSelect.getFilterBuilder();
            CsmSelect.CsmFilter filter = filterBuilder.createCompoundFilter(CsmSelect.FUNCTION_KIND_FILTER, filterBuilder.createNameFilter(cls.getName(), true, true, false));
            Iterator classMembers = CsmSelect.getClassMembers((CsmClass)cls, (CsmSelect.CsmFilter)filter);
            while (classMembers.hasNext()) {
                CsmMember csmMember = (CsmMember)classMembers.next();
                if (!CsmKindUtilities.isConstructor((CsmObject)csmMember)) continue;
                out.add((CsmFunction)((CsmConstructor)csmMember));
            }
            return out;
        }

        Pair<Boolean, Context> resolveExp(CsmCompletionExpression exp, boolean first, ContextCloneStrategy cloneStrategy) {
            Context ctx = cloneStrategy.cloneContext(this);
            return Pair.of((Object)ctx.resolveExp(exp, first), (Object)ctx);
        }

        CsmType resolveType(CsmCompletionExpression exp) {
            return this.resolveType(exp, true, new ContextCloneStrategy());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CsmType resolveType(CsmCompletionExpression exp, boolean first, ContextCloneStrategy cloneStrategy) {
            CsmType typ = exp.getCachedType();
            if (typ == null) {
                Context ctx = cloneStrategy.cloneContext(this);
                ctx.setFindType(true);
                CompletionResolver.QueryScope old = ctx.compResolver.setResolveScope(CompletionResolver.QueryScope.GLOBAL_QUERY);
                try {
                    if (ctx.resolveExp(exp, first)) {
                        typ = ctx.lastType;
                    }
                }
                finally {
                    exp.cacheType(typ);
                    ctx.compResolver.setResolveScope(old);
                }
            }
            return typ;
        }

        List<? extends CompletionItem> resolveObj(CsmCompletionExpression exp) {
            return this.resolveObj(exp, new ContextCloneStrategy());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<? extends CompletionItem> resolveObj(CsmCompletionExpression exp, ContextCloneStrategy cloneStrategy) {
            Context ctx = cloneStrategy.cloneContext(this);
            ctx.setFindType(false);
            CompletionResolver.QueryScope old = ctx.compResolver.setResolveScope(CompletionResolver.QueryScope.GLOBAL_QUERY);
            try {
                if (ctx.resolveExp(exp, true) && ctx.result != null && !ctx.result.getItems().isEmpty()) {
                    List<? extends CompletionItem> list = ctx.result.getItems();
                    return list;
                }
            }
            finally {
                ctx.compResolver.setResolveScope(old);
            }
            return null;
        }

        private boolean isProjectBeeingParsed() {
            return CsmCompletionQuery.this.isProjectBeeingParsed(this.openingSource);
        }

        private ExprKind extractKind(CsmCompletionExpression exp, int i, int startIdx, boolean lastDot, boolean reset) {
            ExprKind kind;
            block15: {
                block16: {
                    int tokCount;
                    block14: {
                        kind = ExprKind.NONE;
                        tokCount = exp.getTokenCount();
                        if (i != startIdx) break block14;
                        kind = ExprKind.NONE;
                        break block15;
                    }
                    if (i - 1 >= tokCount) break block16;
                    switch (exp.getTokenID(i - 1)) {
                        case ARROW: {
                            kind = ExprKind.ARROW;
                            if (reset) {
                                this.scopeAccessedClassifier = false;
                                break;
                            }
                            break block15;
                        }
                        case DOT: {
                            kind = ExprKind.DOT;
                            if (reset) {
                                this.scopeAccessedClassifier = false;
                                break;
                            }
                            break block15;
                        }
                        case SCOPE: {
                            kind = ExprKind.SCOPE;
                            if (reset) {
                                this.scopeAccessedClassifier = true;
                                break;
                            }
                            break block15;
                        }
                        default: {
                            System.err.println("unexpected token " + exp.getTokenID(i));
                            break;
                        }
                    }
                    break block15;
                }
                if (lastDot) {
                    switch (exp.getExpID()) {
                        case 25: 
                        case 26: {
                            kind = ExprKind.ARROW;
                            if (!reset) break;
                            this.scopeAccessedClassifier = false;
                            break;
                        }
                        case 4: 
                        case 5: {
                            kind = ExprKind.DOT;
                            if (!reset) break;
                            this.scopeAccessedClassifier = false;
                            break;
                        }
                        case 27: 
                        case 28: {
                            kind = ExprKind.SCOPE;
                            if (!reset) break;
                            this.scopeAccessedClassifier = true;
                            break;
                        }
                        default: {
                            System.err.println("unexpected expression" + exp);
                        }
                    }
                }
            }
            return kind;
        }

        private boolean resolveParams(CsmCompletionExpression exp, boolean lastDot, ExprKind[] lastKind) {
            CsmType opType;
            boolean ok = true;
            int parmCnt = exp.getParameterCount();
            int startIdx = 0;
            int tokCount = exp.getTokenCount();
            for (int i = tokCount - 1; 0 <= i; --i) {
                CppTokenId token = exp.getTokenID(i);
                if (token != CppTokenId.DOTMBR && token != CppTokenId.ARROWMBR) continue;
                startIdx = i + 1;
                break;
            }
            ExprKind kind = ExprKind.NONE;
            int lastInd = parmCnt - 1;
            AtomicBoolean derefOfTHIS = new AtomicBoolean(false);
            for (int i = startIdx; i < parmCnt && ok; ++i) {
                CsmType opType2;
                kind = this.extractKind(exp, i, startIdx, lastDot, true);
                ExprKind nextKind = this.extractKind(exp, i + 1, startIdx, lastDot, false);
                if (kind == ExprKind.ARROW && !derefOfTHIS.get() && i != startIdx && (i < parmCnt || lastDot || this.findType) && this.lastType != null && this.lastType.getArrayDepth() == 0 && (opType2 = CsmCompletionQuery.getOverloadedOperatorReturnType(this.lastType, this.contextFile, this.endOffset, CsmFunction.OperatorKind.ARROW, 15)) != null) {
                    this.lastType = opType2;
                }
                derefOfTHIS.set(false);
                ok = this.resolveItem(exp.getParameter(i), i == startIdx, !lastDot && i == lastInd, kind, nextKind, derefOfTHIS);
            }
            if (ok && lastDot && (kind = this.extractKind(exp, tokCount + 1, startIdx, true, true)) == ExprKind.ARROW && !derefOfTHIS.get() && this.lastType != null && this.lastType.getArrayDepth() == 0 && (opType = CsmCompletionQuery.getOverloadedOperatorReturnType(this.lastType, this.contextFile, this.endOffset, CsmFunction.OperatorKind.ARROW, 15)) != null) {
                this.lastType = opType;
            }
            lastKind[0] = kind;
            return ok;
        }

        boolean resolveExp(CsmCompletionExpression exp, boolean first) {
            boolean lastDot = false;
            boolean ok = true;
            switch (exp.getExpID()) {
                case 5: 
                case 26: {
                    lastDot = true;
                }
                case 4: 
                case 25: {
                    ExprKind[] lastParamKind = new ExprKind[]{ExprKind.NONE};
                    ok = this.resolveParams(exp, lastDot, lastParamKind);
                    if (!ok || !lastDot) break;
                    int tokenCntM1 = exp.getTokenCount() - 1;
                    int substPos = exp.getTokenOffset(tokenCntM1) + exp.getTokenLength(tokenCntM1);
                    if (this.lastType != null) {
                        List<Object> res;
                        CsmClassifier cls = this.extractLastTypeClassifier(lastParamKind[0]);
                        if (this.openingSource) {
                            res = new ArrayList<CsmClassifier>();
                            if (cls == null) {
                                cls = this.lastType.getClassifier();
                            }
                            if (cls != null && !CsmKindUtilities.isBuiltIn((CsmObject)cls)) {
                                res.add(cls);
                            }
                        } else {
                            res = CsmCompletionQuery.findFieldsAndMethods(this.finder, this.contextElement, cls, "", false, this.staticOnly && !this.memberPointer, false, true, this.scopeAccessedClassifier, true, this.sort);
                        }
                        CsmResultItem.SubstitutionHint hint = this.getSubstitutionHint(lastParamKind[0], this.lastType);
                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res, hint, CsmCompletionQuery.formatType(this.lastType, true, true, true), exp, substPos, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                        break;
                    }
                    this.result = null;
                    break;
                }
                case 28: {
                    lastDot = true;
                }
                case 27: {
                    List<Object> res;
                    this.staticOnly = true;
                    ExprKind[] lastParamKind = new ExprKind[]{ExprKind.NONE};
                    ok = this.resolveParams(exp, lastDot, lastParamKind);
                    if (!ok || !lastDot) break;
                    int tokenCntM1 = exp.getTokenCount() - 1;
                    int substPos = exp.getTokenOffset(tokenCntM1) + exp.getTokenLength(tokenCntM1);
                    if (this.lastType != null) {
                        List<Object> res2;
                        CsmClassifier cls = this.extractLastTypeClassifier(ExprKind.SCOPE);
                        if (this.openingSource) {
                            res2 = new ArrayList<CsmClassifier>();
                            if (cls == null) {
                                cls = this.lastType.getClassifier();
                            }
                            if (cls != null && !CsmKindUtilities.isBuiltIn((CsmObject)cls)) {
                                res2.add(cls);
                            }
                        } else {
                            res2 = CsmCompletionQuery.findFieldsAndMethods(this.finder, this.contextElement, cls, "", false, this.staticOnly && !this.memberPointer, false, true, this.scopeAccessedClassifier, false, this.sort);
                            List<CsmClassifier> nestedClassifiers = CsmCompletionQuery.findNestedClassifiers(this.finder, this.contextElement, cls, "", false, true, this.sort);
                            res2.addAll(nestedClassifiers);
                        }
                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res2, CsmCompletionQuery.formatType(this.lastType, true, true, true), exp, substPos, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                        break;
                    }
                    String searchPkg = (this.lastNamespace.isGlobal() ? "" : this.lastNamespace.getQualifiedName()) + "::";
                    if (this.openingSource) {
                        res = new ArrayList<CsmNamespace>();
                        res.add(this.lastNamespace);
                    } else {
                        res = this.finder.findNestedNamespaces(this.lastNamespace, "", false, false);
                        if (!this.isInNamespaceOnlyUsage(exp.getTokenOffset(0))) {
                            res.addAll(this.finder.findNamespaceElements(this.lastNamespace, "", false, false, false));
                        }
                    }
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res, searchPkg + '*', exp, substPos, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    break;
                }
                case 15: {
                    List<CsmClassifier> res = this.finder.findClasses(null, "", false, false);
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res, "*", exp, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    break;
                }
                case 35: {
                    CsmCompletionExpression item = exp.getParameter(0);
                    String name = item.getTokenText(0);
                    List<CsmLabel> res = this.finder.findLabel(this.contextElement, name, false, false);
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res, "*", exp, name.isEmpty() ? this.endOffset : item.getTokenOffset(0), name.isEmpty() ? 0 : item.getTokenLength(0), 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    break;
                }
                case 24: {
                    exp = exp.getParameter(0);
                }
                default: {
                    AtomicBoolean derefOfTHIS = new AtomicBoolean(false);
                    ok = this.resolveItem(exp, first, true, ExprKind.NONE, ExprKind.NONE, derefOfTHIS);
                }
            }
            return ok;
        }

        private CsmType getPredefinedType(CsmCompletionExpression item) {
            CsmFile containingFile = CsmCompletionQuery.this.getFinder().getCsmFile();
            int startOffset = item.getTokenOffset(0);
            int lastInd = item.getTokenCount() - 1;
            int endtOffset = item.getTokenOffset(lastInd) + item.getTokenLength(lastInd);
            return CsmCompletion.getPredefinedType(containingFile, startOffset, endtOffset, item);
        }

        /*
         * WARNING - void declaration
         */
        boolean resolveItem(CsmCompletionExpression item, boolean first, boolean last, ExprKind kind, ExprKind nextKind, AtomicBoolean derefOfThisOUT) {
            boolean cont = true;
            boolean methodOpen = false;
            boolean skipConstructors = kind != ExprKind.NONE && kind != ExprKind.SCOPE;
            block0 : switch (item.getExpID()) {
                case 0: {
                    if (first) {
                        this.lastType = this.getPredefinedType(item);
                        this.staticOnly = false;
                        break;
                    }
                    cont = false;
                    break;
                }
                case 1: {
                    switch (item.getTokenID(0)) {
                        case THIS: {
                            if (first) {
                                CsmClass cls = this.sup.getClass(CsmCompletionQuery.this.getCsmFile(), item.getTokenOffset(0));
                                if (cls == null) break block0;
                                derefOfThisOUT.set(true);
                                this.lastType = CsmCompletion.createType((CsmClassifier)cls, 1, 0, 0, false);
                                this.staticOnly = false;
                                break;
                            }
                            this.staticOnly = false;
                            break;
                        }
                        default: {
                            String var = item.getTokenText(0);
                            int varPos = item.getTokenOffset(0) + item.getTokenLength(0);
                            if (first) {
                                Collection<? extends CsmObject> res2;
                                if (last && !this.findType) {
                                    if (this.isConstructor) {
                                        this.compResolver.setResolveTypes(39322242);
                                    } else {
                                        this.compResolver.setResolveTypes(1);
                                    }
                                    if (this.resolve(varPos, var, this.openingSource)) {
                                        if (this.isConstructor && !var.isEmpty() && !this.openingSource) {
                                            Collection<? extends CsmObject> candidates = this.compResolver.getResult().addResulItemsToCol(new ArrayList());
                                            ArrayList<? extends CsmObject> res3 = new ArrayList<CsmObject>(candidates);
                                            for (CsmObject csmObject : candidates) {
                                                if (!CsmKindUtilities.isClass((CsmObject)csmObject)) continue;
                                                res3.addAll(this.getConstructors((CsmClass)csmObject));
                                            }
                                            this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res3, var + '*', item, item.getTokenOffset(0), item.getTokenLength(0), 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                            break;
                                        }
                                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), this.compResolver.getResult(), var + '*', item, item.getTokenOffset(0), item.getTokenLength(0), 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                        break;
                                    }
                                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), (CompletionResolver.Result)null, var + '*', item, item.getTokenOffset(0), item.getTokenLength(0), 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                    break;
                                }
                                if (nextKind != ExprKind.SCOPE) {
                                    if (first && !this.findType) {
                                        this.lastType = this.findExactVarType(var, varPos);
                                    }
                                    if (this.lastType == null || CsmUtilities.isAutoType((CsmType)this.lastType)) {
                                        this.compResolver.setResolveTypes(1);
                                        if (this.resolve(varPos, var, true)) {
                                            CompletionResolver.Result res4 = this.compResolver.getResult();
                                            this.lastType = this.getVariableOrClassifierType(res4, new AtomicBoolean(false), item);
                                        }
                                    }
                                }
                                if (this.lastType != null) {
                                    this.staticOnly = false;
                                    break;
                                }
                                if (var.length() == 0) {
                                    this.lastNamespace = this.finder.getCsmFile().getProject().getGlobalNamespace();
                                    break;
                                }
                                this.compResolver.setResolveTypes(37749378);
                                AtomicBoolean foundVisibleClassifier = new AtomicBoolean(false);
                                if (this.resolve(varPos, var, true)) {
                                    this.lastType = this.getVariableOrClassifierType(this.compResolver.getResult(), foundVisibleClassifier, item);
                                }
                                if (foundVisibleClassifier.get()) break block0;
                                CompletionResolver.QueryScope old = this.compResolver.setResolveScope(CompletionResolver.QueryScope.GLOBAL_QUERY);
                                this.compResolver.setResolveTypes(0x180000);
                                if (this.resolve(varPos, var, true) && !(res2 = this.compResolver.getResult().addResulItemsToCol(new ArrayList())).isEmpty()) {
                                    CsmObject csmObject = res2.iterator().next();
                                    if (CsmKindUtilities.isNamespaceAlias((CsmObject)csmObject)) {
                                        this.lastNamespace = ((CsmNamespaceAlias)csmObject).getReferencedNamespace();
                                        this.lastNamespace = CsmCompletion.getProjectNamespace(CsmCompletionQuery.this.getCsmProject(), this.lastNamespace);
                                    } else if (CsmKindUtilities.isNamespace((Object)csmObject)) {
                                        this.lastNamespace = CsmCompletion.getProjectNamespace(CsmCompletionQuery.this.getCsmProject(), (CsmNamespace)csmObject);
                                    }
                                }
                                this.compResolver.setResolveScope(old);
                                if (this.lastNamespace == null) break block0;
                                this.lastType = null;
                                break;
                            }
                            boolean needToCheckNS = true;
                            if (this.lastType != null) {
                                needToCheckNS = false;
                                if (this.findType || !last) {
                                    CsmType csmType;
                                    boolean inner = false;
                                    int ad = this.lastType.getArrayDepth();
                                    if (this.staticOnly && ad == 0 && (csmType = this.findNestedType(this.lastType, var, this.endOffset)) != null) {
                                        this.lastType = csmType;
                                        inner = true;
                                    }
                                    if (!inner) {
                                        if (ad == 0 || kind == ExprKind.ARROW) {
                                            CsmClassifier csmClassifier = CsmCompletionQuery.getClassifier(this.lastType, this.contextFile, this.endOffset);
                                            if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
                                                CsmClass clazz = (CsmClass)csmClassifier;
                                                List<CsmField> elemList = this.finder.findFields(this.contextElement, clazz, var, true, this.staticOnly, true, true, this.scopeAccessedClassifier, this.sort);
                                                if (kind == ExprKind.ARROW || kind == ExprKind.DOT) {
                                                    List<CsmClass> baseClasses = this.getBaseClasses(var, varPos, (CsmClassifier)clazz, nextKind, true);
                                                    if (elemList == null) {
                                                        elemList = baseClasses;
                                                    } else if (baseClasses != null) {
                                                        elemList.addAll(baseClasses);
                                                    }
                                                }
                                                if (elemList != null && elemList.size() > 0) {
                                                    CsmObject csmObj = (CsmObject)elemList.get(0);
                                                    this.lastType = this.getObjectType(csmObj, false);
                                                    this.staticOnly = false;
                                                } else if (kind != ExprKind.ARROW && kind != ExprKind.SCOPE) {
                                                    this.lastType = null;
                                                    cont = false;
                                                }
                                            } else {
                                                this.lastType = null;
                                                cont = false;
                                            }
                                        } else {
                                            cont = false;
                                        }
                                    }
                                } else {
                                    this.scopeAccessedClassifier = kind == ExprKind.SCOPE;
                                    CsmClassifier classifier2 = this.extractLastTypeClassifier(kind);
                                    if (classifier2 == null) {
                                        this.lastType = null;
                                        cont = false;
                                    } else {
                                        boolean inspectParentClasses = this.contextElement != null || !this.scopeAccessedClassifier || this.staticOnly;
                                        List<CsmObject> list = CsmCompletionQuery.findFieldsAndMethods(this.finder, this.contextElement, classifier2, var, this.openingSource, this.staticOnly && !this.memberPointer, false, inspectParentClasses, this.scopeAccessedClassifier, skipConstructors, this.sort);
                                        List<CsmClassifier> nestedClassifiers = CsmCompletionQuery.findNestedClassifiers(this.finder, this.contextElement, classifier2, var, this.openingSource, true, this.sort);
                                        list.addAll(nestedClassifiers);
                                        if (kind == ExprKind.ARROW || kind == ExprKind.DOT || kind == ExprKind.SCOPE) {
                                            CsmNamespace ns;
                                            List<CsmClass> baseClasses = this.finder.findBaseClasses(this.contextElement, classifier2, var, this.openingSource, this.sort);
                                            list.addAll(baseClasses);
                                            if (list.isEmpty() && (ns = this.finder.getExactNamespace(var)) != null && this.lastNamespace == null) {
                                                list.add((CsmObject)ns);
                                            }
                                            if (list.isEmpty() && !this.scopeAccessedClassifier) {
                                                CsmClassifier varCls = this.resolveClassifier(var, varPos);
                                                if (last && CsmBaseUtilities.isValid((CsmObject)varCls)) {
                                                    list.add((CsmObject)varCls);
                                                } else {
                                                    CsmType csmType = CsmCompletion.createType(varCls, 0, 0, 0, false);
                                                    baseClasses = this.getBaseClasses(csmType, classifier2, nextKind, true);
                                                    if (baseClasses != null && !baseClasses.isEmpty()) {
                                                        list.add((CsmObject)varCls);
                                                    }
                                                }
                                            }
                                        }
                                        if (list.isEmpty() && this.scopeAccessedClassifier && CsmKindUtilities.isClass((CsmObject)classifier2)) {
                                            CsmClass cls = (CsmClass)classifier2;
                                            List<CsmField> fields = this.finder.findFields(this.contextElement, cls, var, this.openingSource, false, false, inspectParentClasses, this.scopeAccessedClassifier, this.sort);
                                            list.addAll(fields);
                                        }
                                        if (list.isEmpty() && this.scopeAccessedClassifier && this.lastNamespace != null) {
                                            needToCheckNS = true;
                                        } else {
                                            CsmResultItem.SubstitutionHint hint = this.getSubstitutionHint(kind, this.lastType);
                                            this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), list, hint, CsmCompletionQuery.formatType(this.lastType, true, true, false) + var + '*', item, item.getTokenOffset(0), item.getTokenLength(0), 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                        }
                                    }
                                }
                            }
                            if (this.lastNamespace == null || !needToCheckNS) break block0;
                            String searchPkg = (this.lastNamespace.isGlobal() ? "" : this.lastNamespace.getQualifiedName() + "::") + var;
                            if (this.findType || !last) {
                                CsmNamespace csmNamespace;
                                List<CsmNamespace> res5 = this.finder.findNestedNamespaces(this.lastNamespace, var, true, true);
                                CsmNamespace csmNamespace2 = csmNamespace = res5.isEmpty() ? null : res5.get(0);
                                if (csmNamespace != null) {
                                    this.lastNamespace = CsmCompletion.getProjectNamespace(CsmCompletionQuery.this.getCsmProject(), csmNamespace);
                                    this.lastType = null;
                                    break;
                                }
                                res5 = this.finder.findNamespaceElements(this.lastNamespace, var, true, true, true);
                                CsmObject obj = res5.isEmpty() ? null : (CsmObject)res5.iterator().next();
                                this.lastType = this.getObjectType(obj, false);
                                cont = this.lastType != null;
                                this.lastNamespace = null;
                                break;
                            }
                            if (!last) break block0;
                            List<CsmNamespace> res6 = this.finder.findNestedNamespaces(this.lastNamespace, var, this.openingSource, true);
                            res6.addAll(this.finder.findNamespaceElements(this.lastNamespace, var, this.openingSource, true, false));
                            this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res6, searchPkg + '*', item, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                            break;
                        }
                    }
                    break;
                }
                case 7: {
                    CsmClassifier cls;
                    this.lastType = this.resolveType(item.getParameter(0));
                    cont = false;
                    if (this.lastType == null || (cls = CsmCompletionQuery.getClassifier(this.lastType, this.contextFile, this.endOffset)) == null) break;
                    if (item.getParameterCount() == 2) {
                        int ptrDepth = this.lastType.getPointerDepth();
                        int arrDepth = this.lastType.getArrayDepth();
                        int ref = CsmCompletionQuery.getReferenceValue(this.lastType);
                        if (arrDepth > 0) {
                            this.lastType = CsmCompletion.createType(cls, ptrDepth, ref, --arrDepth, this.lastType.isConst());
                        } else if (ptrDepth > 0) {
                            this.lastType = CsmCompletion.createType(cls, --ptrDepth, ref, arrDepth, this.lastType.isConst());
                        } else {
                            CsmFunction opArray = CsmCompletionQuery.getOperator(cls, this.contextFile, this.endOffset, CsmFunction.OperatorKind.ARRAY);
                            if (opArray != null) {
                                this.lastType = opArray.getReturnType();
                            }
                        }
                        cont = true;
                        break;
                    }
                    this.lastType = CsmCompletion.createType(cls, this.lastType.getPointerDepth(), CsmCompletionQuery.getReferenceValue(this.lastType), this.lastType.getArrayDepth() + 1, this.lastType.isConst());
                    cont = true;
                    break;
                }
                case 16: {
                    this.lastType = CsmCompletion.BOOLEAN_TYPE;
                    break;
                }
                case 17: {
                    List<CsmClass> baseClasses;
                    CsmClassifier csmClassifier;
                    boolean outsiderTypeAlias = false;
                    CsmType typ = null;
                    CsmType contextType = this.lastType;
                    if (first) {
                        typ = this.resolveType(item.getParameter(0));
                    }
                    if (typ == null && (typ = this.resolveType(item.getParameter(0), first, new ContextCloneStrategy(new ContextPropertyChanger().setStaticOnly(kind == ExprKind.SCOPE).setLastNamespace(this.lastNamespace).setLastType(this.lastType)))) == null && (kind == ExprKind.DOT || kind == ExprKind.ARROW || kind == ExprKind.SCOPE)) {
                        outsiderTypeAlias = true;
                        typ = this.resolveType(item.getParameter(0), true, new ContextCloneStrategy(new ContextPropertyChanger().setStaticOnly(true)));
                    }
                    Object object = this.lastType = typ != null ? contextType : null;
                    if (typ == null) break;
                    CsmClassifier cls = (typ = CsmUtilities.iterateTypeChain((CsmType)typ, (CsmUtilities.Predicate)new CsmUtilities.SearchTemplatePredicate())).getClassifier();
                    if (CsmKindUtilities.isSpecialization((CsmObject)cls)) {
                        Collection baseTemplateCandidates = CsmInstantiationProvider.getDefault().getBaseTemplate((CsmDeclaration)cls);
                        for (CsmOffsetableDeclaration baseTemplate : baseTemplateCandidates) {
                            if (!CsmKindUtilities.isClassifier((CsmObject)baseTemplate)) continue;
                            cls = (CsmClassifier)baseTemplate;
                            break;
                        }
                    }
                    if (cls == null || !CsmKindUtilities.isTemplate((CsmObject)cls)) break;
                    CsmObject obj = CompletionSupport.createInstantiation(this, (CsmTemplate)cls, item, Collections.<CsmType>emptyList());
                    if (CsmKindUtilities.isClassifier((CsmObject)obj)) {
                        typ = CsmCompletion.createType((CsmClassifier)obj, 0, 0, 0, false);
                    }
                    if (outsiderTypeAlias && CsmKindUtilities.isTypeAlias((CsmObject)obj) && contextType != null && CsmKindUtilities.isClass((CsmObject)(csmClassifier = CsmCompletionQuery.getClassifier(contextType, this.contextFile, this.endOffset))) && ((baseClasses = this.getBaseClasses(typ, csmClassifier, nextKind, true)) == null || baseClasses.isEmpty())) {
                        this.lastType = null;
                        typ = null;
                    }
                    if (!CsmKindUtilities.isClass((CsmObject)obj) && !CsmKindUtilities.isTypeAlias((CsmObject)obj)) break;
                    if (!last || this.findType) {
                        this.lastType = typ;
                        break;
                    }
                    CsmClassifier csmClassifier2 = (CsmClassifier)obj;
                    LinkedHashSet<CsmClassifier> classList = new LinkedHashSet<CsmClassifier>();
                    classList.add(csmClassifier2);
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), classList, csmClassifier2.getQualifiedName().toString(), item, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    break;
                }
                case 2: 
                case 18: {
                    boolean boolOperator = false;
                    CompletionResolver.Result res = null;
                    Collection mtdList = new LinkedHashSet();
                    this.compResolver.setResolveTypes(0x800828);
                    String operatorPrefix = "operator " + item.getTokenText(0);
                    if (this.resolve(item.getTokenOffset(0), operatorPrefix, false)) {
                        res = this.compResolver.getResult();
                    }
                    if (res != null) {
                        res.addResulItemsToCol(mtdList);
                    }
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res, operatorPrefix, item, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    this.lastType = null;
                    switch (item.getTokenID(0)) {
                        case EQ: 
                        case PLUSEQ: 
                        case MINUSEQ: 
                        case STAREQ: 
                        case SLASHEQ: 
                        case AMPEQ: 
                        case BAREQ: 
                        case CARETEQ: 
                        case PERCENTEQ: 
                        case LTLTEQ: 
                        case GTGTEQ: {
                            if (item.getParameterCount() <= 0) break;
                            this.lastType = this.resolveType(item.getParameter(0));
                            this.staticOnly = false;
                            break;
                        }
                        case LT: 
                        case GT: 
                        case LTEQ: 
                        case GTEQ: 
                        case EQEQ: 
                        case NOTEQ: 
                        case AMPAMP: 
                        case BARBAR: {
                            boolOperator = true;
                        }
                        case PLUS: 
                        case MINUS: {
                            if (this.findType && mtdList.isEmpty() && this.lastType == null) {
                                if (item.getParameterCount() <= 0) break;
                                this.lastType = this.resolveType(item.getParameter(0));
                                this.staticOnly = false;
                                break;
                            }
                        }
                        case LTLT: 
                        case GTGT: 
                        case STAR: 
                        case SLASH: 
                        case AMP: 
                        case BAR: 
                        case CARET: 
                        case PERCENT: {
                            CsmType typ1;
                            if (!this.findType || this.lastType != null) break;
                            if (!mtdList.isEmpty()) {
                                List<CsmType> typeList = this.getTypeList(item, 0);
                                Collection collection = CompletionSupport.filterMethods(this, mtdList = this.instantiateFunctions(mtdList, null, typeList, new CsmFunctionsAcceptor()), null, typeList, false, false);
                                if (collection.size() > 0) {
                                    mtdList = collection;
                                    this.lastType = CompletionSupport.extractFunctionType(this, mtdList, null, typeList);
                                } else if (item.getParameterCount() > 1) {
                                    CsmType type0 = this.resolveType(item.getParameter(0));
                                    CsmType type1 = this.resolveType(item.getParameter(1));
                                    if (type0 != null && type1 != null) {
                                        this.lastType = this.sup.getCommonType(type1, type0);
                                        if (this.lastType == null) {
                                            this.lastType = type0.isBuiltInBased(true) ? type1 : type0;
                                        }
                                    } else {
                                        this.lastType = type0;
                                    }
                                    this.staticOnly = false;
                                } else if (item.getParameterCount() > 0) {
                                    this.lastType = this.resolveType(item.getParameter(0));
                                    this.staticOnly = false;
                                }
                            }
                            if (this.lastType == null) {
                                switch (item.getParameterCount()) {
                                    case 2: {
                                        CsmFunction member;
                                        typ1 = this.resolveType(item.getParameter(0));
                                        if (typ1 == null || typ1.getArrayDepth() != 0) break;
                                        if (CsmCompletion.safeIsPrimitiveClass(typ1, typ1.getClassifier())) {
                                            CsmType csmType = this.resolveType(item.getParameter(1));
                                            if (csmType == null || csmType.getArrayDepth() != 0 || !CsmCompletion.safeIsPrimitiveClass(csmType, csmType.getClassifier())) break;
                                            this.lastType = this.sup.getCommonType(typ1, csmType);
                                            break;
                                        }
                                        CsmClassifier csmClassifier = this.extractTypeClassifier(typ1, ExprKind.NONE);
                                        if (!CsmKindUtilities.isClass((CsmObject)csmClassifier)) break;
                                        CsmClass cls = (CsmClass)csmClassifier;
                                        CsmFunction.OperatorKind opKind = CsmFunction.OperatorKind.getKindByImage((String)item.getTokenText(0), (boolean)true);
                                        if (opKind == CsmFunction.OperatorKind.NONE || (member = CsmCompletionQuery.getOperator((CsmClassifier)cls, this.contextFile, this.endOffset, opKind)) == null) break;
                                        this.lastType = member.getReturnType();
                                        break;
                                    }
                                    case 1: {
                                        CsmType csmType = this.resolveType(item.getParameter(0));
                                        if (csmType == null || !CsmCompletion.safeIsPrimitiveClass(csmType, csmType.getClassifier())) break;
                                        this.lastType = csmType;
                                    }
                                }
                            }
                            if (this.lastType != null || !boolOperator) break;
                            this.lastType = CsmCompletion.BOOLEAN_TYPE;
                            break;
                        }
                        case COLON: {
                            CsmType typ1;
                            switch (item.getParameterCount()) {
                                case 2: {
                                    typ1 = this.resolveType(item.getParameter(0));
                                    CsmType csmType = this.resolveType(item.getParameter(1));
                                    if (typ1 == null || csmType == null) break;
                                    this.lastType = this.sup.getCommonType(typ1, csmType);
                                    if (this.lastType != null) break;
                                    this.lastType = typ1;
                                    break;
                                }
                                case 1: {
                                    this.lastType = this.resolveType(item.getParameter(0));
                                }
                            }
                            break;
                        }
                        case QUESTION: {
                            if (item.getParameterCount() < 2) break;
                            this.lastType = this.resolveType(item.getParameter(1));
                        }
                    }
                    break;
                }
                case 3: {
                    if (item.getParameterCount() <= 0) break;
                    this.lastType = this.resolveType(item.getParameter(0));
                    this.staticOnly = false;
                    break;
                }
                case 33: {
                    if (item.getParameterCount() <= 0) break;
                    boolean hasAmp = false;
                    if (item.getTokenCount() == 1) {
                        switch (item.getTokenID(0)) {
                            case AMP: {
                                hasAmp = true;
                            }
                        }
                    }
                    this.memberPointer = hasAmp;
                    cont = this.resolveExp(item.getParameter(0), first);
                    this.memberPointer = false;
                    break;
                }
                case 32: {
                    if (item.getParameterCount() <= 0) break;
                    this.lastType = this.resolveType(item.getParameter(0));
                    this.staticOnly = false;
                    CsmFunction.OperatorKind opKind = null;
                    if (item.getTokenCount() == 1) {
                        switch (item.getTokenID(0)) {
                            case AMP: {
                                opKind = CsmFunction.OperatorKind.ADDRESS;
                                break;
                            }
                            case STAR: {
                                opKind = CsmFunction.OperatorKind.POINTER;
                            }
                        }
                    }
                    if (opKind == null) break;
                    CsmType opType = CsmCompletionQuery.getOverloadedOperatorReturnType(this.lastType, this.contextFile, this.endOffset, opKind, 15);
                    if (opType != null) {
                        this.lastType = opType;
                        break;
                    }
                    if (this.lastType == null) break;
                    CsmType lastNestedType = CsmUtilities.iterateTypeChain((CsmType)this.lastType, (CsmUtilities.Predicate)new CsmUtilities.ConstantPredicate(false));
                    int ptrDepth = lastNestedType.getPointerDepth();
                    if (ptrDepth > 0 && opKind == CsmFunction.OperatorKind.POINTER) {
                        --ptrDepth;
                    }
                    if (opKind == CsmFunction.OperatorKind.ADDRESS) {
                        ++ptrDepth;
                    }
                    this.lastType = CsmCompletion.createType(CsmCompletionQuery.getClassifier(lastNestedType, this.contextFile, this.endOffset), ptrDepth, CsmCompletionQuery.getReferenceValue(lastNestedType), lastNestedType.getArrayDepth(), lastNestedType.isConst(), lastNestedType.isTemplateBased());
                    break;
                }
                case 13: {
                    this.lastType = this.resolveType(item.getParameter(0));
                    this.staticOnly = false;
                    break;
                }
                case 31: {
                    if (item.getParameterCount() <= 0) break;
                    CsmCompletionExpression param = item.getParameter(0);
                    this.staticOnly = false;
                    this.lastType = this.resolveType(param);
                    if (this.lastType == null) break;
                    int ref = CsmCompletionQuery.getReferenceValue(this.lastType);
                    int ptrLevel = this.lastType.getPointerDepth();
                    if (item.getTokenCount() > 0) {
                        switch (item.getTokenID(0)) {
                            case AMP: {
                                ref = 1;
                                break;
                            }
                            case AMPAMP: {
                                ref = 2;
                                break;
                            }
                            case STAR: {
                                ++ptrLevel;
                                break;
                            }
                        }
                    }
                    this.lastType = CsmCompletion.createType(this.lastType.getClassifier(), ptrLevel, ref, this.lastType.getArrayDepth(), this.lastType.isConst());
                    break;
                }
                case 14: {
                    int nrTokens;
                    if (this.findType) {
                        this.lastType = item.getParameterCount() > 0 ? this.resolveType(item.getParameter(0)) : this.getPredefinedType(item);
                    }
                    if (this.findType && this.lastType != null || (nrTokens = item.getTokenCount()) < 1) break;
                    String varName = item.getTokenText(nrTokens - 1);
                    int varPos = item.getTokenOffset(nrTokens - 1);
                    if (item.getTokenID(nrTokens - 1) == CppTokenId.AUTO) {
                        CsmClassifier returnCls;
                        if (!CsmFileInfoQuery.getDefault().isCpp11OrLater(this.contextFile)) break;
                        CsmObject contextObject = CsmOffsetResolver.findObject(this.contextFile, item.getTokenOffset(0), CsmCompletionQuery.this.getFileReferencesContext());
                        if (CsmKindUtilities.isVariable((CsmObject)contextObject)) {
                            CsmType userFriendlyType;
                            CsmClassifier autoVarCls;
                            CsmVariable contextVar = (CsmVariable)contextObject;
                            if (!CsmUtilities.isAutoType((CsmType)contextVar.getType())) break;
                            CsmType csmType = this.findAutoVariableType(contextVar, contextVar.getType());
                            if (this.findType) {
                                this.lastType = csmType;
                                break;
                            }
                            if (csmType == null || !CsmBaseUtilities.isValid((CsmObject)(autoVarCls = (userFriendlyType = CsmUtilities.iterateTypeChain((CsmType)csmType, (CsmUtilities.Predicate)new CsmUtilities.SmartTypeUnrollPredicate())).getClassifier())) || CsmKindUtilities.isBuiltIn((CsmObject)autoVarCls)) break;
                            this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), Arrays.asList(autoVarCls), varName, item, varPos, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                            break;
                        }
                        if (!CsmKindUtilities.isFunction((CsmObject)contextObject)) break;
                        CsmFunction contextFunc = (CsmFunction)contextObject;
                        CsmType csmType = contextFunc.getReturnType();
                        if (this.findType) {
                            this.lastType = csmType;
                            break;
                        }
                        if (csmType == null || !CsmBaseUtilities.isValid((CsmObject)(returnCls = csmType.getClassifier()))) break;
                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), Arrays.asList(returnCls), varName, item, varPos, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                        break;
                    }
                    this.compResolver.setResolveTypes(38273090);
                    if (!this.resolve(varPos, varName, this.openingSource)) break;
                    CompletionResolver.Result res = this.compResolver.getResult();
                    if (this.findType) {
                        this.lastType = this.getVariableOrClassifierType(res, new AtomicBoolean(false), item);
                    }
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), res, varName + '*', item, varPos, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    break;
                }
                case 40: {
                    if (item.getParameterCount() > 1) {
                        this.lastType = this.resolveType(item.getParameter(1), true, new ContextCloneStrategy(new ContextPropertyChanger().setLastNamespace(this.lastNamespace).setLastType(this.lastType)));
                        break;
                    }
                    this.lastType = null;
                    break;
                }
                case 9: 
                case 48: {
                    this.lastType = this.resolveType(item.getParameter(item.getParameterCount() - 1));
                    break;
                }
                case 12: {
                    this.isConstructor = true;
                    cont = this.resolveExp(item.getParameter(0), true);
                    this.staticOnly = false;
                    break;
                }
                case 10: {
                    methodOpen = true;
                }
                case 11: {
                    List<CsmType> typeList;
                    CsmCompletionExpression mtdNameExp = item.getParameter(0);
                    CsmCompletionExpression genericNameExp = null;
                    while (mtdNameExp.getExpID() == 17) {
                        genericNameExp = mtdNameExp;
                        if (mtdNameExp.getParameterCount() <= 0) break;
                        mtdNameExp = mtdNameExp.getParameter(0);
                    }
                    String mtdName = mtdNameExp.getTokenText(0);
                    CsmCompletionExpression param = item.getParameter(0);
                    if (param.getExpID() == 11) {
                        boolean oldFindType = this.findType;
                        this.setFindType(true);
                        cont = this.resolveExp(param, true);
                        this.setFindType(oldFindType);
                    }
                    if (this.isConstructor) {
                        CsmClassifier cls = null;
                        if (first) {
                            cls = CompletionSupport.getClassFromName(CsmCompletionQuery.this.getFinder(), mtdName, true);
                        }
                        if (cls == null) {
                            cls = this.findExactClass(mtdName, mtdNameExp.getTokenOffset(0), genericNameExp);
                        }
                        if (cls != null) {
                            this.lastType = CsmCompletion.createType(cls, 1, 0, 0, false);
                        } else {
                            this.isConstructor = false;
                        }
                    }
                    if (!methodOpen || this.openingSource) {
                        Collection<CsmFunctional> mtdList = new LinkedHashSet<CsmMethod>();
                        if (first && (!this.isConstructor || this.lastType == null)) {
                            ArrayList<CsmClassifier> candidates;
                            boolean look4Constructors;
                            int n = mtdNameExp.getTokenOffset(0);
                            boolean bl = look4Constructors = this.findType || this.openingSource;
                            if (methodOpen) {
                                candidates = new ArrayList<CsmClassifier>();
                                this.compResolver.setResolveTypes(1300);
                                if (this.resolve(n, mtdName, true)) {
                                    this.compResolver.getResult().addResulItemsToCol(candidates);
                                }
                                ArrayList<CsmField> varList = new ArrayList<CsmField>();
                                for (CsmObject csmObject : candidates) {
                                    if (!CsmKindUtilities.isField((CsmObject)csmObject)) continue;
                                    varList.add((CsmField)csmObject);
                                    break;
                                }
                                if (!varList.isEmpty()) {
                                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), varList, CsmCompletionQuery.formatType(this.lastType, true, true, false) + mtdName, item, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                    return true;
                                }
                            }
                            if (look4Constructors) {
                                candidates = new ArrayList();
                                this.compResolver.setResolveTypes(192);
                                if (this.resolve(n, mtdName, true)) {
                                    this.compResolver.getResult().addResulItemsToCol(candidates);
                                }
                                if (candidates.isEmpty()) {
                                    this.compResolver.setResolveTypes(25167912);
                                    if (this.resolve(n, mtdName, true)) {
                                        this.compResolver.getResult().addResulItemsToCol(candidates);
                                    }
                                }
                                if (candidates.isEmpty() && this.instantiations != null) {
                                    this.compResolver.setResolveTypes(0x2000000);
                                    if (this.resolve(n, mtdName, true)) {
                                        ArrayList templateParams = new ArrayList();
                                        this.compResolver.getResult().addResulItemsToCol(templateParams);
                                        for (CsmObject csmObject : templateParams) {
                                            CsmType resolvedType;
                                            CsmClassifier cls;
                                            if (!CsmKindUtilities.isTemplateParameter((CsmObject)csmObject) || !CsmKindUtilities.isClass((CsmObject)(cls = (resolvedType = this.resolveTemplateParameter((CsmTemplateParameter)csmObject, this.instantiations)) != null ? resolvedType.getClassifier() : null))) continue;
                                            candidates.add(cls);
                                        }
                                    }
                                }
                                for (CsmObject csmObject : candidates) {
                                    if (CsmKindUtilities.isClass((CsmObject)csmObject)) {
                                        mtdList.addAll(this.getConstructors((CsmClass)csmObject));
                                        continue;
                                    }
                                    if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
                                        mtdList.add((CsmFunctional)((CsmFunction)csmObject));
                                        continue;
                                    }
                                    if (!CsmKindUtilities.isVariable((CsmObject)csmObject)) continue;
                                    this.updateWithVariableOperator(mtdList, (CsmVariable)csmObject);
                                }
                            }
                            this.compResolver.setResolveTypes(0x800828);
                            if (this.resolve(n, mtdName, this.openingSource)) {
                                this.compResolver.getResult().addResulItemsToCol(mtdList);
                            }
                            if (!last || this.findType) {
                                candidates = new ArrayList();
                                this.compResolver.setResolveTypes(1364);
                                if (this.resolve(n, mtdName, true)) {
                                    this.compResolver.getResult().addResulItemsToCol(candidates);
                                }
                                for (CsmObject csmObject : candidates) {
                                    if (!CsmKindUtilities.isVariable((CsmObject)csmObject)) continue;
                                    this.updateWithVariableOperator(mtdList, (CsmVariable)csmObject);
                                }
                            }
                            if (this.lastType != null && (!last || this.findType)) {
                                this.updateWithOperator(mtdList, this.lastType);
                            }
                        } else if (this.lastType != null) {
                            CsmClassifier csmClassifier = this.extractLastTypeClassifier(kind);
                            if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
                                boolean inspectParentClasses = this.contextElement != null;
                                mtdList.addAll(this.finder.findMethods(this.contextElement, (CsmClass)csmClassifier, mtdName, true, false, first, inspectParentClasses, this.scopeAccessedClassifier, this.sort));
                                if (mtdList.isEmpty() && !this.isConstructor) {
                                    CsmType previousType = this.lastType;
                                    this.lastType = null;
                                    boolean returnImmediately = true;
                                    List<CsmField> list = this.finder.findFields(this.contextElement, (CsmClass)csmClassifier, mtdName, true, false, first, true, this.scopeAccessedClassifier, this.sort);
                                    if (list != null && !list.isEmpty()) {
                                        for (CsmField csmField : list) {
                                            CsmClassifier cls;
                                            CsmType fldType = csmField.getType();
                                            if (fldType == null) continue;
                                            if (CsmKindUtilities.isFunctionPointerType((CsmObject)fldType)) {
                                                this.lastType = ((CsmFunctionPointerType)fldType).getReturnType();
                                            } else {
                                                CsmType type;
                                                cls = fldType.getClassifier();
                                                if ((CsmKindUtilities.isTypedef((CsmObject)cls) || CsmKindUtilities.isTypeAlias((CsmObject)cls)) && CsmKindUtilities.isFunctionPointerType((CsmObject)(type = ((CsmTypedef)cls).getType()))) {
                                                    this.lastType = ((CsmFunctionPointerType)type).getReturnType();
                                                }
                                            }
                                            if (this.lastType == null) {
                                                cls = CsmCompletionQuery.getClassifier(fldType, this.contextFile, this.endOffset);
                                                if (CsmKindUtilities.isFunctionPointerClassifier((CsmObject)cls)) {
                                                    this.lastType = ((CsmFunctional)cls).getReturnType();
                                                } else {
                                                    CsmFunction funCall;
                                                    CsmFunction csmFunction = funCall = cls == null ? null : CsmCompletionQuery.getOperator(cls, this.contextFile, this.endOffset, CsmFunction.OperatorKind.CAST);
                                                    if (funCall != null) {
                                                        this.lastType = funCall.getReturnType();
                                                    }
                                                }
                                            }
                                            if (this.lastType == null || !last) continue;
                                            List<CsmType> typeList2 = this.getTypeList(item, 1);
                                            String parmStr = CsmCompletionQuery.formatTypeList(typeList2, methodOpen);
                                            ArrayList<CsmField> varList = new ArrayList<CsmField>(1);
                                            varList.add(csmField);
                                            this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), varList, CsmCompletionQuery.formatType(this.lastType, true, true, false) + mtdName + '(' + parmStr + ')', item, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                        }
                                    } else if (previousType != null && (this.staticOnly || kind == ExprKind.SCOPE) && previousType.getArrayDepth() == 0) {
                                        this.lastType = this.findNestedType(previousType, mtdName, this.endOffset);
                                        boolean bl = returnImmediately = this.lastType == null;
                                    }
                                    if (returnImmediately) {
                                        return this.lastType != null;
                                    }
                                }
                            }
                        } else if (this.lastNamespace != null) {
                            boolean bl = last ? this.openingSource : true;
                            CsmNamespace curNs = this.lastNamespace;
                            this.lastNamespace = null;
                            List<CsmNamespace> res = this.finder.findNestedNamespaces(curNs, mtdName, bl, true);
                            Iterator<CsmNamespace> i$ = res.iterator();
                            if (i$.hasNext()) {
                                CsmNamespace csmNamespace = i$.next();
                                this.lastNamespace = CsmCompletion.getProjectNamespace(CsmCompletionQuery.this.getCsmProject(), csmNamespace);
                            }
                            List<CsmObject> elems = this.finder.findNamespaceElements(curNs, mtdName, bl, true, false);
                            for (CsmObject csmObject : elems) {
                                Collection<CsmFunction> constructors;
                                if (CsmKindUtilities.isFunction((CsmObject)csmObject)) {
                                    mtdList.add((CsmFunctional)((CsmFunction)csmObject));
                                    continue;
                                }
                                if (CsmKindUtilities.isTypedef((CsmObject)csmObject)) {
                                    this.lastType = ((CsmTypedef)csmObject).getType();
                                    break;
                                }
                                if (CsmKindUtilities.isTypeAlias((CsmObject)csmObject)) {
                                    CsmTypeAlias alias = (CsmTypeAlias)csmObject;
                                    alias = (CsmTypeAlias)this.tryInstantiateClassifier((CsmClassifier)alias, genericNameExp);
                                    this.lastType = alias.getType();
                                    break;
                                }
                                if (!CsmKindUtilities.isClassifier((CsmObject)csmObject)) continue;
                                CsmClassifier cls = (CsmClassifier)csmObject;
                                if (CsmKindUtilities.isClass((CsmObject)cls) && !(constructors = this.getConstructors((CsmClass)cls)).isEmpty()) {
                                    mtdList.addAll(constructors);
                                    continue;
                                }
                                cls = this.tryInstantiateClassifier(cls, genericNameExp);
                                this.lastType = CsmCompletion.createType(cls, 0, 0, 0, false);
                                break;
                            }
                            if ((this.findType || !last && !first) && mtdList.isEmpty()) {
                                return this.lastType != null || this.lastNamespace != null;
                            }
                        }
                        if (mtdList == null || mtdList.isEmpty()) {
                            if (!this.isConstructor) {
                                if (first || this.staticOnly || kind == ExprKind.SCOPE) {
                                    void var15_100;
                                    Object var15_98 = null;
                                    if (var15_98 == null) {
                                        CsmClassifier csmClassifier = this.findExactClass(mtdName, mtdNameExp.getTokenOffset(0), genericNameExp);
                                    }
                                    if (var15_100 != null) {
                                        this.lastType = CsmCompletion.createType((CsmClassifier)var15_100, 0, 0, 0, false);
                                    }
                                } else {
                                    this.lastType = null;
                                }
                                if (this.lastType == null && (!last || this.findType)) {
                                    this.lastType = this.findBuiltInFunctionReturnType(mtdName, mtdNameExp.getTokenOffset(0));
                                }
                            }
                            return this.lastType != null;
                        }
                        String string = "*";
                        typeList = this.getTypeList(item, 1);
                        Collection filtered = CompletionSupport.filterMethods(this, mtdList = this.instantiateFunctions(mtdList, genericNameExp, typeList, (CsmUtilities.Predicate<CsmFunctional>)new CsmUtilities.ConstantPredicate(true)), genericNameExp, typeList, methodOpen, true);
                        if (filtered.size() > 0) {
                            mtdList = filtered;
                            String string2 = CsmCompletionQuery.formatTypeList(typeList, methodOpen);
                        }
                        if (mtdList.size() > 0) {
                            if (last && !this.findType) {
                                void var15_103;
                                mtdList = CsmCompletionQuery.uninstantiateFunctionDefinitions(mtdList, (CsmUtilities.Predicate<CsmFunctional>)((CsmUtilities.Predicate)new CsmUtilities.ConstantPredicate(true)));
                                this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), mtdList, CsmCompletionQuery.formatType(this.lastType, true, true, false) + mtdName + '(' + (String)var15_103 + ')', item, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                                break;
                            }
                            this.lastType = CompletionSupport.extractFunctionType(this, mtdList, genericNameExp, typeList);
                            this.staticOnly = false;
                            break;
                        }
                        this.lastType = null;
                        cont = false;
                        break;
                    }
                    int varPos = this.endOffset;
                    this.compResolver.setResolveTypes(1);
                    if (!this.resolve(varPos, "", false)) break;
                    CompletionResolver.Result result = this.compResolver.getResult();
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), result, mtdName + '*', mtdNameExp, varPos, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    break;
                }
                case 53: {
                    CsmCompletionExpression lambdaFunction;
                    CsmFunctionDefinition csmFunctionDefinition;
                    if (last && !this.findType || item.getParameterCount() <= 0 || item.getParameter(0).getExpID() != 51 || (csmFunctionDefinition = this.getCsmLambda(lambdaFunction = item.getParameter(0))) == null) break;
                    List<CsmType> typeList = this.getTypeList(item, 1);
                    this.lastType = CompletionSupport.extractFunctionType(this, Arrays.asList(csmFunctionDefinition), null, typeList);
                    break;
                }
                case 51: {
                    if (!this.findType) break;
                    CsmFunctionDefinition lambda = this.getCsmLambda(item);
                    if (lambda != null) {
                        this.lastType = new CsmCompletion.CompletionClosureType(lambda, 0, false);
                        break;
                    }
                    this.lastType = null;
                    cont = false;
                }
            }
            if (this.lastType != null && this.instantiations != null && this.lastType.isTemplateBased()) {
                CsmType resolvedType;
                assert (!this.instantiations.isEmpty()) : "Instantiations must not be empty";
                CsmClassifier cls = CsmCompletionQuery.getClassifier(this.lastType, this.contextFile, this.endOffset);
                if (CsmKindUtilities.isTemplateParameter((CsmObject)cls) && (resolvedType = this.resolveTemplateParameter((CsmTemplateParameter)cls, this.instantiations)) != null) {
                    this.lastType = resolvedType;
                }
            }
            if (!this.findType) {
                CsmClassifier classifier;
                if ((this.result == null || this.result.getItems().isEmpty()) && this.lastType != null && last && (this.lastType.isTemplateBased() || CsmFileReferences.isTemplateParameterInvolved((CsmObject)this.lastType) || CsmFileReferences.hasTemplateBasedAncestors((CsmType)this.lastType))) {
                    ArrayList<TemplateBasedReferencedObjectImpl> data = new ArrayList<TemplateBasedReferencedObjectImpl>();
                    data.add(new TemplateBasedReferencedObjectImpl(this.lastType, ""));
                    this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), data, "", item, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                }
                if (last && !first && (this.result == null || this.result.getItems().isEmpty()) && this.lastType != null && CsmKindUtilities.isInstantiation((CsmObject)(classifier = CsmCompletionQuery.getClassifier(this.lastType, this.contextFile, this.endOffset)))) {
                    boolean instantiatedByTemplateParam = false;
                    CsmInstantiation inst = (CsmInstantiation)classifier;
                    Map mapping = inst.getMapping();
                    for (CsmSpecializationParameter csmSpecializationParameter : mapping.values()) {
                        CsmType type;
                        if (!CsmKindUtilities.isTypeBasedSpecalizationParameter((CsmObject)csmSpecializationParameter) || (type = ((CsmTypeBasedSpecializationParameter)csmSpecializationParameter).getType()) == null || !type.isTemplateBased()) continue;
                        instantiatedByTemplateParam = true;
                        break;
                    }
                    if (instantiatedByTemplateParam && !CsmInstantiationProvider.getDefault().getSpecializations((CsmDeclaration)classifier, this.contextFile, this.endOffset).isEmpty()) {
                        ArrayList<TemplateBasedReferencedObjectImpl> data = new ArrayList<TemplateBasedReferencedObjectImpl>();
                        data.add(new TemplateBasedReferencedObjectImpl(this.lastType, ""));
                        this.result = new CsmCompletionResult(this.component, CsmCompletionQuery.this.getBaseDocument(), data, "", item, this.endOffset, 0, 0, this.isProjectBeeingParsed(), this.contextElement, this.instantiateTypes);
                    }
                }
            }
            if (this.lastType == null && this.lastNamespace == null) {
                cont = false;
            }
            return cont;
        }

        private CsmFunctionDefinition getCsmLambda(CsmCompletionExpression lambdaFunction) {
            if (lambdaFunction != null && lambdaFunction.getExpID() == 51) {
                CsmContext context;
                int bodyStartOffset = -1;
                for (int i = 0; i < lambdaFunction.getTokenCount(); ++i) {
                    if (lambdaFunction.getTokenID(i) != CppTokenId.LBRACE) continue;
                    bodyStartOffset = lambdaFunction.getTokenOffset(i);
                }
                if (bodyStartOffset >= 0 && CsmKindUtilities.isLambda((CsmObject)(context = this.contextScope != null ? CsmOffsetResolver.findContextFromScope(this.contextFile, bodyStartOffset, this.contextScope) : CsmOffsetResolver.findContext(this.contextFile, bodyStartOffset, CsmCompletionQuery.this.getFileReferencesContext())).getLastObject())) {
                    return (CsmFunctionDefinition)context.getLastObject();
                }
            }
            return null;
        }

        private <T extends CsmFunctional> List<T> instantiateFunctions(Collection<T> functions, CsmCompletionExpression exp, List<CsmType> passedParams, CsmUtilities.Predicate<CsmFunctional> acceptor) {
            ArrayList<CsmFunctional> instantiated = new ArrayList<CsmFunctional>(functions.size());
            for (CsmFunctional func : functions) {
                CsmFunctional inst = this.tryInstantiateFunction(func, exp, passedParams);
                if (!acceptor.check((Object)inst)) continue;
                instantiated.add(inst);
            }
            return instantiated;
        }

        private CsmClassifier tryInstantiateClassifier(CsmClassifier template, CsmCompletionExpression exp) {
            CsmObject inst;
            if (exp != null && CsmKindUtilities.isTemplate((CsmObject)template) && CsmKindUtilities.isClassifier((CsmObject)(inst = CompletionSupport.createInstantiation(this, (CsmTemplate)template, exp, Collections.<CsmType>emptyList())))) {
                template = (CsmClassifier)inst;
            }
            return template;
        }

        private CsmFunctional tryInstantiateFunction(CsmFunctional func, CsmCompletionExpression exp, List<CsmType> passedParams) {
            CsmObject inst;
            if (CsmKindUtilities.isTemplate((CsmObject)func) && CsmKindUtilities.isFunctional((CsmObject)(inst = CompletionSupport.createInstantiation(this, (CsmTemplate)func, exp, passedParams)))) {
                func = (CsmFunctional)inst;
            }
            return func;
        }

        private CsmClassifier resolveClassifier(String var, int varPos) {
            this.compResolver.setResolveTypes(37749378);
            if (this.resolve(varPos, var, true)) {
                ArrayList candidates = new ArrayList();
                this.compResolver.getResult().addResulItemsToCol(candidates);
                for (CsmObject obj : candidates) {
                    if (!CsmKindUtilities.isClassifier((CsmObject)obj)) continue;
                    return (CsmClassifier)obj;
                }
            }
            return null;
        }

        private List<CsmClass> getBaseClasses(String var, int varPos, CsmClassifier clazz, ExprKind nextKind, boolean exactMatch) {
            CsmClassifier cls = this.resolveClassifier(var, varPos);
            CsmType varType = CsmCompletion.createType(cls, 0, 0, 0, false);
            return this.getBaseClasses(varType, clazz, nextKind, exactMatch);
        }

        private List<CsmClass> getBaseClasses(CsmType varType, CsmClassifier clazz, ExprKind nextKind, boolean exactMatch) {
            CsmClassifier varCls = this.extractTypeClassifier(varType, nextKind);
            List<CsmClass> baseClasses = null;
            if (varCls != null) {
                baseClasses = this.finder.findBaseClasses(this.contextElement, clazz, varCls.getName().toString(), exactMatch, this.sort);
            }
            return baseClasses;
        }

        private CsmType resolveTemplateParameter(CsmTemplateParameter param, List<CsmInstantiation> instantiations) {
            CsmInstantiationProvider ip = CsmInstantiationProvider.getDefault();
            return ip.instantiate(param, instantiations);
        }

        private void updateWithVariableOperator(Collection<CsmFunctional> mtdList, CsmVariable var) {
            CsmFunctional fun = this.lookForVariableOperator(var);
            if (fun != null) {
                mtdList.add(fun);
            }
        }

        private void updateWithOperator(Collection<CsmFunctional> mtdList, CsmType type) {
            CsmFunctional fun = this.lookForOperator(type);
            if (fun != null) {
                mtdList.add(fun);
            }
        }

        private CsmFunctional lookForVariableOperator(CsmVariable object) {
            CsmType varType = object.getType();
            if (CsmUtilities.isAutoType((CsmType)varType)) {
                varType = this.findAutoVariableType(object, varType);
            }
            return this.lookForOperator(varType);
        }

        private CsmFunctional lookForOperator(CsmType type) {
            if (type != null) {
                CsmFunction funCall;
                CsmClassifier cls = CsmCompletionQuery.getClassifier(type, this.contextFile, this.endOffset);
                if (CsmKindUtilities.isFunctionPointerClassifier((CsmObject)cls)) {
                    return (CsmFunctional)cls;
                }
                if (CsmKindUtilities.isClosureClassifier((CsmObject)cls)) {
                    return (CsmFunctional)cls;
                }
                CsmFunction csmFunction = funCall = cls == null ? null : CsmCompletionQuery.getOperator(cls, this.contextFile, this.endOffset, CsmFunction.OperatorKind.CAST);
                if (funCall != null) {
                    return funCall;
                }
            }
            return null;
        }

        private boolean checkQualifier(CsmCompletionExpression exp, CppTokenId qualifier) {
            int start = 0;
            int end = exp.getTokenCount() - 1;
            if (exp.getExpID() == 1) {
                start = 1;
                end = exp.getTokenCount();
            }
            for (int i = start; i < end; ++i) {
                if (!qualifier.equals((Object)exp.getTokenID(i))) continue;
                return true;
            }
            return false;
        }

        private CsmType findBuiltInFunctionReturnType(String mtdName, int tokenOffset) {
            CsmType out = null;
            if ("typeid".contentEquals(mtdName)) {
                List<CsmClassifier> findClasses;
                Iterator<CsmClassifier> i$;
                CsmNamespace ns;
                CsmClassifier cls = CsmCompletionQuery.this.getFinder().getExactClassifier("std::type_info");
                if (cls == null && (ns = this.findExactNamespace("std", tokenOffset)) != null && (i$ = (findClasses = CsmCompletionQuery.this.getFinder().findClasses(ns, mtdName, true, false)).iterator()).hasNext()) {
                    CsmClassifier csmClassifier;
                    cls = csmClassifier = i$.next();
                }
                if (cls != null) {
                    out = CsmCompletion.createType(cls, 0, 0, 0, false);
                }
            }
            return out;
        }

        private CsmNamespace findExactNamespace(String var, int varPos) {
            CsmNamespace ns = null;
            this.compResolver.setResolveTypes(0x180000);
            if (this.resolve(varPos, var, true)) {
                CompletionResolver.Result res = this.compResolver.getResult();
                Collection<? extends CsmObject> addResulItemsToCol = res.addResulItemsToCol(new ArrayList());
                for (CsmObject csmObject : addResulItemsToCol) {
                    if (CsmKindUtilities.isNamespace((Object)csmObject)) {
                        return (CsmNamespace)csmObject;
                    }
                    if (!CsmKindUtilities.isNamespaceAlias((CsmObject)csmObject) || (ns = ((CsmNamespaceAlias)csmObject).getReferencedNamespace()) == null) continue;
                    return ns;
                }
            }
            return ns;
        }

        private CsmClassifier findExactClass(String var, int varPos, CsmCompletionExpression genericNameExp) {
            CsmClassifier cls;
            block10: {
                CsmObject csmObject;
                CsmClassifier csmClassifier;
                cls = null;
                if (this.instantiations != null) {
                    this.compResolver.setResolveTypes(37749378);
                } else {
                    this.compResolver.setResolveTypes(4194946);
                }
                if (!this.resolve(varPos, var, true)) break block10;
                CompletionResolver.Result res = this.compResolver.getResult();
                Collection<? extends CsmObject> allItems = res.addResulItemsToCol(new ArrayList());
                ArrayList<CsmClassifier> otherClassifiers = new ArrayList<CsmClassifier>();
                ArrayList<CsmObject> visibleClassifiers = new ArrayList<CsmObject>();
                CsmIncludeResolver ir = CsmIncludeResolver.getDefault();
                ArrayList<CsmObject> td = new ArrayList<CsmObject>();
                AtomicBoolean hasClassifier = new AtomicBoolean(false);
                for (CsmObject csmObject2 : allItems) {
                    if (CsmKindUtilities.isTemplateParameter((CsmObject)csmObject2)) {
                        CsmType resolvedType = this.resolveTemplateParameter((CsmTemplateParameter)csmObject2, this.instantiations);
                        CsmClassifier resolvedCls = resolvedType != null ? resolvedType.getClassifier() : null;
                        if (!CsmKindUtilities.isClass((CsmObject)resolvedCls)) continue;
                        visibleClassifiers.add((CsmObject)resolvedCls);
                        continue;
                    }
                    if (!CsmKindUtilities.isClassifier((CsmObject)csmObject2)) continue;
                    if (ir.isObjectVisible(this.contextFile, csmObject2)) {
                        this.fillVisibleListAndFilterTypedefs(csmObject2, hasClassifier, visibleClassifiers, td);
                        continue;
                    }
                    otherClassifiers.add((CsmClassifier)csmObject2);
                }
                if (TRACE_MULTIPLE_VISIBE_OBJECTS && visibleClassifiers.size() > 1) {
                    System.err.printf("findExactClass: we have several classifiers %s visible from %s [%d]%n", var, this.contextFile.getAbsolutePath(), this.endOffset);
                    int ind = 0;
                    for (CsmObject csmClassifier2 : visibleClassifiers) {
                        System.err.printf("[%d] %s%n", ind++, csmClassifier2);
                    }
                }
                Iterator<Object> i$ = visibleClassifiers.iterator();
                while (i$.hasNext() && (cls = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)(csmClassifier = this.tryInstantiateClassifier((CsmClassifier)(csmObject = (CsmObject)i$.next()), genericNameExp)), (CsmFile)this.contextFile)) == null) {
                }
                if (cls == null) {
                    CsmClassifier csmClassifier3;
                    CsmClassifier csmClassifier4;
                    i$ = otherClassifiers.iterator();
                    while (i$.hasNext() && (cls = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)(csmClassifier4 = this.tryInstantiateClassifier(csmClassifier3 = (CsmClassifier)i$.next(), genericNameExp)), (CsmFile)this.contextFile)) == null) {
                    }
                }
            }
            return cls;
        }

        private CsmType findNestedType(CsmType baseType, String name, int endOffset) {
            CsmClass clazz;
            List<CsmClassifier> classes;
            CsmClassifier classifier;
            if (baseType != null && CsmKindUtilities.isClass((CsmObject)(classifier = CsmCompletionQuery.getClassifier(baseType, this.contextFile, endOffset))) && (classes = this.finder.findNestedClassifiers(this.contextElement, clazz = (CsmClass)classifier, name, true, true, this.sort)) != null && !classes.isEmpty()) {
                return CsmCompletion.createType(classes.get(0), 0, 0, 0, false);
            }
            return null;
        }

        private CsmType findExactVarType(String var, int varPos) {
            return this.sup.findExactVarType(this.finder.getCsmFile(), var, varPos, CsmCompletionQuery.this.getFileReferencesContext());
        }

        private List<CsmType> getTypeList(CsmCompletionExpression item, int firstChildIdx) {
            int parmCnt = item.getParameterCount();
            ArrayList<CsmType> typeList = new ArrayList<CsmType>();
            if (parmCnt > firstChildIdx) {
                for (int i = firstChildIdx; i < parmCnt; ++i) {
                    CsmCompletionExpression parm = item.getParameter(i);
                    CsmType typ = this.resolveType(parm);
                    if (parmCnt - firstChildIdx == 1 && typ != null && "void".equals(typ.getCanonicalText().toString())) continue;
                    typeList.add(typ);
                }
            }
            return typeList;
        }

        private boolean isInNamespaceOnlyUsage(final int tokenOffset) {
            final AtomicBoolean out = new AtomicBoolean(false);
            final Document document = this.sup.getDocument();
            document.render(new Runnable(){

                @Override
                public void run() {
                    TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)document, (int)tokenOffset, (boolean)true, (boolean)true);
                    if (ts != null) {
                        ts.move(tokenOffset);
                        block4: while (ts.movePrevious()) {
                            Token token = ts.token();
                            TokenId id = token.id();
                            if ("whitespace".equals(id.primaryCategory())) continue;
                            if (!(id instanceof CppTokenId)) break;
                            switch ((CppTokenId)id) {
                                case SCOPE: 
                                case EQ: 
                                case IDENTIFIER: {
                                    continue block4;
                                }
                                case NAMESPACE: {
                                    out.set(true);
                                    break;
                                }
                            }
                            break;
                        }
                    }
                }
            });
            return out.get();
        }

        private CsmResultItem.SubstitutionHint getSubstitutionHint(ExprKind kind, CsmType type) {
            CsmResultItem.SubstitutionHint hint = CsmResultItem.SubstitutionHint.NONE;
            if (this.openingSource) {
                return hint;
            }
            if (type != null) {
                if (kind == ExprKind.DOT) {
                    if ((type = CsmUtilities.iterateTypeChain((CsmType)type, (CsmUtilities.Predicate)new CsmUtilities.Predicate<CsmType>(){

                        public boolean check(CsmType value) {
                            return value.isPointer();
                        }
                    })).isPointer()) {
                        hint = CsmResultItem.SubstitutionHint.DOT_TO_ARROW;
                    }
                } else if (kind != ExprKind.ARROW || !type.isPointer()) {
                    // empty if block
                }
            }
            return hint;
        }

        private class ContextCloneStrategy {
            private final ContextPropertyChanger propertyChanger;

            public ContextCloneStrategy() {
                this.propertyChanger = null;
            }

            public ContextCloneStrategy(ContextPropertyChanger propertyChanger) {
                this.propertyChanger = propertyChanger;
            }

            Context cloneContext(Context context) {
                Context ctx = (Context)context.clone();
                if (this.propertyChanger != null) {
                    this.propertyChanger.apply(ctx);
                }
                return ctx;
            }
        }

        private class ContextPropertyChanger {
            private Boolean staticOnly;
            private Boolean findType;
            private boolean lastTypeGiven;
            private CsmType lastType;
            private boolean lastNamespaceGiven;
            private CsmNamespace lastNamespace;

            private ContextPropertyChanger() {
            }

            ContextPropertyChanger setStaticOnly(boolean staticOnly) {
                this.staticOnly = staticOnly;
                return this;
            }

            ContextPropertyChanger setFindType(boolean findType) {
                this.findType = findType;
                return this;
            }

            ContextPropertyChanger setLastType(CsmType lastType) {
                this.lastType = lastType;
                this.lastTypeGiven = true;
                return this;
            }

            ContextPropertyChanger setLastNamespace(CsmNamespace lastNamespace) {
                this.lastNamespace = lastNamespace;
                this.lastNamespaceGiven = true;
                return this;
            }

            void apply(Context ctx) {
                if (this.staticOnly != null) {
                    ctx.staticOnly = this.staticOnly;
                }
                if (this.findType != null) {
                    ctx.findType = this.findType;
                }
                if (this.lastTypeGiven) {
                    ctx.lastType = this.lastType;
                }
                if (this.lastNamespaceGiven) {
                    ctx.lastNamespace = this.lastNamespace;
                }
            }
        }

        private class CsmFunctionsAcceptor
        implements CsmUtilities.Predicate<CsmFunctional> {
            private CsmFunctionsAcceptor() {
            }

            public boolean check(CsmFunctional value) {
                return CsmKindUtilities.isFunction((CsmObject)value);
            }
        }
    }

    static enum ExprKind {
        NONE,
        SCOPE,
        ARROW,
        DOT;

    }

    private static final class TokenProcessorCache {
        private final int queryOffset;
        private final long docVersion;
        private final CsmCompletionTokenProcessor tp;

        public TokenProcessorCache(int queryOffset, long docVersion, CsmCompletionTokenProcessor tp) {
            this.queryOffset = queryOffset;
            this.docVersion = docVersion;
            this.tp = tp;
        }
    }

    static interface QueryTask {
        public AntiloopClient getAntiloopKind();

        public boolean isFindTypeTask();

        public void perform(Context var1);
    }

    static class QueryTypeTask
    implements QueryTask {
        private final CsmExpressionResolver.ResolvedTypeHandler resolvedHandler;

        public QueryTypeTask(CsmExpressionResolver.ResolvedTypeHandler resolvedHandler) {
            this.resolvedHandler = resolvedHandler;
        }

        @Override
        public void perform(Context context) {
            if (context != null) {
                CsmType type = context.lastType;
                this.resolvedHandler.process(type);
            }
        }

        @Override
        public boolean isFindTypeTask() {
            return true;
        }

        @Override
        public AntiloopClient getAntiloopKind() {
            return AntiloopClient.query_type;
        }
    }

    static class QueryObjectsTask
    implements QueryTask {
        private Collection<CsmObject> objects;

        QueryObjectsTask() {
        }

        @Override
        public void perform(Context context) {
            List<? extends CompletionItem> items;
            if (context != null && context.result != null && !(items = context.result.getItems()).isEmpty()) {
                this.objects = new ArrayList<CsmObject>(items.size());
                for (CompletionItem completionItem : items) {
                    if (!(completionItem instanceof CsmResultItem)) continue;
                    CsmResultItem csmItem = (CsmResultItem)completionItem;
                    this.objects.add((CsmObject)csmItem.getAssociatedObject());
                }
            }
        }

        @Override
        public boolean isFindTypeTask() {
            return false;
        }

        @Override
        public AntiloopClient getAntiloopKind() {
            return AntiloopClient.query_objects;
        }

        public Collection<CsmObject> getObjects() {
            return this.objects;
        }
    }

    private static enum AntiloopClient {
        query_type,
        query_objects;

    }
}

