/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus.ext;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletion;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmCompletionExpression;
import org.netbeans.modules.cnd.completion.cplusplus.ext.MacroCallback;

final class CsmCompletionTokenProcessor
implements CndTokenProcessor<Token<TokenId>> {
    private static final int NO_EXP = -1;
    private int bufferStartPos;
    private int bufferOffsetDelta;
    private List<CsmCompletionExpression> expStack = new ArrayList<CsmCompletionExpression>();
    private CppTokenId lastValidTokenID;
    private String lastValidTokenText;
    private boolean errorState = false;
    private boolean alternativeParse = false;
    private boolean inPreprocessor = false;
    private CppTokenId curTokenID;
    private int curTokenPosition;
    private String curTokenText;
    private int endScanOffset;
    private boolean supportTemplates;
    private boolean supportLambdas;
    private int nrQuestions = 0;
    private MacroCallback macroCallback = null;
    private final List<OffsetableToken> lambdaLookaheadTokens = new ArrayList<OffsetableToken>();
    private int lambdaLookaheadLevel = 0;
    private LambdaLookaheadStage lambdaLookaheadStage = null;
    private final List<OffsetableToken> tplLookaheadTokens = new ArrayList<OffsetableToken>();
    private int tplLookaheadParensLevel = 0;
    private int tplLookaheadBracketsLevel = 0;
    private int tplLookaheadBracesLevel = 0;
    private int tplLookaheadLtgtsLevel = 0;
    private int lastSeparatorOffset = -1;
    private Boolean inPP;

    CsmCompletionTokenProcessor(int endScanOffset, int lastSeparatorOffset) {
        this.endScanOffset = endScanOffset;
        this.lastSeparatorOffset = lastSeparatorOffset;
    }

    void enableTemplateSupport(boolean supportTemplates) {
        this.supportTemplates = supportTemplates;
    }

    void enableLambdaSupport(boolean supportLambdas) {
        this.supportLambdas = supportLambdas;
    }

    final List<CsmCompletionExpression> getStack() {
        return this.expStack;
    }

    final CppTokenId getLastValidTokenID() {
        return this.lastValidTokenID;
    }

    final String getLastValidTokenText() {
        return this.lastValidTokenText;
    }

    final int getCurrentOffest() {
        return this.curTokenPosition;
    }

    final boolean isErrorState() {
        return this.errorState;
    }

    final boolean isInPreprocessor() {
        return this.inPreprocessor;
    }

    final CsmCompletionExpression getResultExp() {
        CsmCompletionExpression result = this.peekExp();
        return result;
    }

    private void clearStack() {
        this.expStack.clear();
    }

    boolean isSeparatorOrOperator(CppTokenId tokenID) {
        return CndLexerUtilities.isSeparatorOrOperator((CppTokenId)tokenID);
    }

    private boolean isEqOperator(CppTokenId tokenID) {
        switch (tokenID) {
            case EQ: 
            case EQEQ: 
            case GTEQ: 
            case GTGTEQ: 
            case AMPEQ: 
            case LTEQ: 
            case LTLTEQ: 
            case PLUSEQ: 
            case NOTEQ: 
            case MINUSEQ: 
            case STAREQ: 
            case SLASHEQ: 
            case BAREQ: 
            case CARETEQ: 
            case PERCENTEQ: {
                return true;
            }
        }
        return false;
    }

    public void setMacroCallback(MacroCallback callback) {
        this.macroCallback = callback;
    }

    private boolean isMacroExpansion() {
        if (this.macroCallback != null) {
            return this.macroCallback.isMacroExpansion();
        }
        return false;
    }

    private void pushExp(CsmCompletionExpression exp) {
        this.expStack.add(exp);
    }

    private CsmCompletionExpression popExp() {
        int cnt = this.expStack.size();
        return cnt > 0 ? this.expStack.remove(cnt - 1) : null;
    }

    private CsmCompletionExpression peekExp() {
        int cnt = this.expStack.size();
        return cnt > 0 ? this.expStack.get(cnt - 1) : null;
    }

    private CsmCompletionExpression peekExp2() {
        int cnt = this.expStack.size();
        return cnt > 1 ? this.expStack.get(cnt - 2) : null;
    }

    private CsmCompletionExpression peekExp(int ind) {
        int cnt = this.expStack.size();
        return cnt >= ind && cnt > 0 ? this.expStack.get(cnt - ind) : null;
    }

    private CsmCompletionExpression createTokenExp(int id) {
        CsmCompletionExpression exp = new CsmCompletionExpression(id);
        this.addTokenTo(exp);
        return exp;
    }

    private CsmCompletionExpression createTokenExp(int id, CsmCompletionExpression oldExpression) {
        return this.createTokenExp(id, oldExpression, false);
    }

    private CsmCompletionExpression createTokenExp(int id, CsmCompletionExpression oldExpression, boolean withParams) {
        int i;
        CsmCompletionExpression exp = new CsmCompletionExpression(id);
        for (i = 0; i < oldExpression.getTokenCount(); ++i) {
            exp.addToken(oldExpression.getTokenID(i), oldExpression.getTokenOffset(i), oldExpression.getTokenText(i));
        }
        if (withParams) {
            for (i = 0; i < oldExpression.getParameterCount(); ++i) {
                exp.addParameter(oldExpression.getParameter(i));
            }
        }
        return exp;
    }

    private void addTokenTo(CsmCompletionExpression exp) {
        exp.addToken(this.curTokenID, this.curTokenPosition, this.curTokenText);
    }

    private int getValidExpID(CsmCompletionExpression exp) {
        return exp != null ? exp.getExpID() : -1;
    }

    private int tokenID2OpenExpID(CppTokenId tokenID) {
        switch (tokenID) {
            case DOT: 
            case DOTMBR: {
                return 5;
            }
            case ARROW: 
            case ARROWMBR: {
                return 26;
            }
            case SCOPE: {
                return 28;
            }
            case IF: {
                return 42;
            }
            case FOR: {
                return 41;
            }
            case SWITCH: {
                return 43;
            }
            case WHILE: {
                return 44;
            }
        }
        assert (false) : "unexpected tokenID " + tokenID;
        return 0;
    }

    private int openExpID2ExpID(int openExpID) {
        switch (openExpID) {
            case 5: {
                return 4;
            }
            case 26: {
                return 25;
            }
            case 28: {
                return 27;
            }
        }
        assert (false) : "unexpected expID" + CsmCompletionExpression.getIDName(openExpID);
        return 0;
    }

    private void setExprToTYPE(CsmCompletionExpression exp) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < exp.getTokenCount(); ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(exp.getTokenText(i));
        }
        exp.setType(buf.toString());
        exp.setExpID(14);
    }

    public boolean token(Token<TokenId> token, int tokenOffset) {
        if (!(token.id() instanceof CppTokenId)) {
            return false;
        }
        if (this.inPP == null) {
            this.inPP = token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE;
        }
        if (token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
            return this.inPP;
        }
        this.lambdaLookahead(token, tokenOffset, this.isMacroExpansion());
        return false;
    }

    private void lambdaLookahead(Token<TokenId> token, int tokenOffset, boolean macro) {
        boolean lookahead = false;
        if (this.isLambdaAmbiguity(token)) {
            this.lambdaLookaheadStage = this.tryLookaheadLambda(token, this.lambdaLookaheadStage);
            if (this.lambdaLookaheadStage == LambdaLookaheadStage.done) {
                lookahead = true;
                OffsetableToken captureLBracket = null;
                OffsetableToken captureRBracket = null;
                OffsetableToken bodyLBrace = null;
                CsmCompletionExpression lambda = new CsmCompletionExpression(51);
                for (OffsetableToken lambdaToken : this.lambdaLookaheadTokens) {
                    if (captureLBracket == null && lambdaToken.token.id() == CppTokenId.LBRACKET) {
                        captureLBracket = lambdaToken;
                        continue;
                    }
                    if (captureRBracket == null && lambdaToken.token.id() == CppTokenId.RBRACKET) {
                        captureRBracket = lambdaToken;
                        continue;
                    }
                    if (bodyLBrace != null || lambdaToken.token.id() != CppTokenId.LBRACE) continue;
                    bodyLBrace = lambdaToken;
                }
                lambda.addToken((CppTokenId)captureLBracket.token.id(), captureLBracket.offset, captureLBracket.token.text().toString());
                lambda.addToken((CppTokenId)captureRBracket.token.id(), captureRBracket.offset, captureRBracket.token.text().toString());
                lambda.addToken((CppTokenId)bodyLBrace.token.id(), bodyLBrace.offset, bodyLBrace.token.text().toString());
                lambda.addToken((CppTokenId)token.id(), tokenOffset, token.text().toString());
                this.pushExp(lambda);
                this.lambdaLookaheadStage = null;
                this.lambdaLookaheadTokens.clear();
                this.lambdaLookaheadLevel = 0;
            } else if (this.lambdaLookaheadStage != null) {
                lookahead = true;
                this.lambdaLookaheadTokens.add(new OffsetableToken(token, tokenOffset, macro, this.inPP));
            }
        }
        if (!lookahead) {
            if (this.lambdaLookaheadTokens.isEmpty()) {
                this.templateLookahead(token, tokenOffset, macro, false);
            } else {
                Boolean oldInPP = this.inPP;
                for (OffsetableToken offsetableToken : this.lambdaLookaheadTokens) {
                    this.inPP = offsetableToken.inPP;
                    this.templateLookahead(offsetableToken.token, offsetableToken.offset, offsetableToken.macro, true);
                }
                this.lambdaLookaheadStage = null;
                this.lambdaLookaheadTokens.clear();
                this.lambdaLookaheadLevel = 0;
                this.inPP = oldInPP;
                this.templateLookahead(token, tokenOffset, macro, true);
            }
        }
    }

    private boolean isLambdaAmbiguity(Token<TokenId> token) {
        if (!this.supportLambdas) {
            return false;
        }
        if (!this.lambdaLookaheadTokens.isEmpty()) {
            return true;
        }
        CppTokenId cppTokId = (CppTokenId)token.id();
        switch (cppTokId) {
            case LBRACKET: {
                CsmCompletionExpression top = this.peekExp();
                if (top != null) {
                    switch (top.getExpID()) {
                        case 2: 
                        case 8: 
                        case 10: 
                        case 52: {
                            this.lambdaLookaheadStage = LambdaLookaheadStage.capture;
                            return true;
                        }
                    }
                    break;
                }
                this.lambdaLookaheadStage = LambdaLookaheadStage.capture;
                return true;
            }
        }
        return false;
    }

    private LambdaLookaheadStage tryLookaheadLambda(Token<TokenId> token, LambdaLookaheadStage stage) {
        switch ((CppTokenId)token.id()) {
            case WHITESPACE: 
            case BLOCK_COMMENT: 
            case DOXYGEN_COMMENT: 
            case DOXYGEN_LINE_COMMENT: 
            case LINE_COMMENT: 
            case ESCAPED_LINE: 
            case ESCAPED_WHITESPACE: 
            case NEW_LINE: {
                return stage;
            }
        }
        LambdaLookaheadStage nextStage = stage;
        block3 : switch (stage) {
            case capture: {
                if (token.id() == CppTokenId.LBRACKET) {
                    ++this.lambdaLookaheadLevel;
                    if (this.lambdaLookaheadLevel <= 1) break;
                    nextStage = null;
                    break;
                }
                if (token.id() != CppTokenId.RBRACKET) break;
                --this.lambdaLookaheadLevel;
                if (this.lambdaLookaheadLevel != 0) break;
                nextStage = LambdaLookaheadStage.try_declarator_params;
                break;
            }
            case try_declarator_params: {
                if (this.lambdaLookaheadLevel == 0 && token.id() != CppTokenId.LPAREN) {
                    nextStage = this.tryLookaheadLambda(token, LambdaLookaheadStage.body);
                    break;
                }
                if (token.id() == CppTokenId.LPAREN) {
                    ++this.lambdaLookaheadLevel;
                    break;
                }
                if (token.id() != CppTokenId.RPAREN) break;
                --this.lambdaLookaheadLevel;
                if (this.lambdaLookaheadLevel != 0) break;
                nextStage = LambdaLookaheadStage.try_declarator_mutable;
                break;
            }
            case try_declarator_mutable: {
                if (token.id() == CppTokenId.MUTABLE) {
                    nextStage = LambdaLookaheadStage.try_declarator_exception;
                    break;
                }
                nextStage = this.tryLookaheadLambda(token, LambdaLookaheadStage.try_declarator_exception);
                break;
            }
            case try_declarator_exception: {
                if (token.id() == CppTokenId.THROW || token.id() == CppTokenId.NOEXCEPT) break;
                if (this.lambdaLookaheadLevel == 0 && token.id() != CppTokenId.LPAREN) {
                    nextStage = this.tryLookaheadLambda(token, LambdaLookaheadStage.try_declarator_attribute);
                    break;
                }
                if (token.id() == CppTokenId.LPAREN) {
                    ++this.lambdaLookaheadLevel;
                    break;
                }
                if (token.id() != CppTokenId.RPAREN) break;
                --this.lambdaLookaheadLevel;
                if (this.lambdaLookaheadLevel != 0) break;
                nextStage = LambdaLookaheadStage.try_declarator_attribute;
                break;
            }
            case try_declarator_attribute: {
                if (token.id() == CppTokenId.__ATTRIBUTE) {
                    nextStage = LambdaLookaheadStage.declarator_attribute_parens;
                    break;
                }
                if (token.id() == CppTokenId.__ATTRIBUTE__) {
                    nextStage = LambdaLookaheadStage.declarator_attribute_parens;
                    break;
                }
                if (token.id() == CppTokenId.LBRACKET) {
                    nextStage = this.tryLookaheadLambda(token, LambdaLookaheadStage.declarator_attribute_cpp11);
                    break;
                }
                nextStage = this.tryLookaheadLambda(token, LambdaLookaheadStage.try_declarator_trailing_type);
                break;
            }
            case declarator_attribute_parens: {
                if (this.lambdaLookaheadLevel == 0 && token.id() != CppTokenId.LPAREN) {
                    nextStage = null;
                    break;
                }
                if (token.id() == CppTokenId.LPAREN) {
                    ++this.lambdaLookaheadLevel;
                    break;
                }
                if (token.id() != CppTokenId.RPAREN) break;
                --this.lambdaLookaheadLevel;
                if (this.lambdaLookaheadLevel != 0) break;
                nextStage = LambdaLookaheadStage.try_declarator_attribute;
                break;
            }
            case declarator_attribute_cpp11: {
                if (this.lambdaLookaheadLevel == 0 && token.id() != CppTokenId.LBRACKET) {
                    nextStage = null;
                    break;
                }
                if (token.id() == CppTokenId.LBRACKET) {
                    ++this.lambdaLookaheadLevel;
                    break;
                }
                if (token.id() != CppTokenId.RBRACKET) break;
                --this.lambdaLookaheadLevel;
                if (this.lambdaLookaheadLevel != 0) break;
                nextStage = LambdaLookaheadStage.try_declarator_attribute;
                break;
            }
            case try_declarator_trailing_type: {
                if (token.id() == CppTokenId.ARROW) {
                    nextStage = LambdaLookaheadStage.declarator_trailing_type_rest;
                    break;
                }
                nextStage = this.tryLookaheadLambda(token, LambdaLookaheadStage.body);
                break;
            }
            case declarator_trailing_type_rest: {
                if (CndLexerUtilities.isType((CppTokenId)((CppTokenId)token.id()))) break;
                switch ((CppTokenId)token.id()) {
                    case SCOPE: 
                    case IDENTIFIER: 
                    case STAR: 
                    case AMP: 
                    case TYPENAME: 
                    case TEMPLATE: 
                    case STRUCT: 
                    case CLASS: 
                    case UNION: 
                    case ENUM: {
                        break block3;
                    }
                    case LBRACKET: 
                    case LPAREN: 
                    case LT: {
                        ++this.lambdaLookaheadLevel;
                        break block3;
                    }
                    case RBRACKET: 
                    case RPAREN: 
                    case GT: {
                        --this.lambdaLookaheadLevel;
                        break block3;
                    }
                }
                if (this.lambdaLookaheadLevel > 0) break;
                if (this.lambdaLookaheadLevel == 0) {
                    nextStage = this.tryLookaheadLambda(token, LambdaLookaheadStage.body);
                    break;
                }
                nextStage = null;
                break;
            }
            case body: {
                if (this.lambdaLookaheadLevel == 0 && token.id() != CppTokenId.LBRACE) {
                    nextStage = null;
                    break;
                }
                if (token.id() == CppTokenId.LBRACE) {
                    ++this.lambdaLookaheadLevel;
                    break;
                }
                if (token.id() != CppTokenId.RBRACE) break;
                --this.lambdaLookaheadLevel;
                if (this.lambdaLookaheadLevel != 0) break;
                nextStage = LambdaLookaheadStage.done;
            }
        }
        return nextStage;
    }

    private void templateLookahead(Token<TokenId> token, int tokenOffset, boolean macro, boolean mayBeInLambda) {
        boolean lookahead = false;
        if (this.isTemplateAmbiguity(token) && this.isLookaheadNeeded(token)) {
            lookahead = true;
            this.tplLookaheadTokens.add(new OffsetableToken(token, tokenOffset, this.isMacroExpansion(), this.inPP));
            switch ((CppTokenId)token.id()) {
                case LT: {
                    ++this.tplLookaheadLtgtsLevel;
                    break;
                }
                case GT: {
                    --this.tplLookaheadLtgtsLevel;
                    break;
                }
                case LPAREN: {
                    ++this.tplLookaheadParensLevel;
                    break;
                }
                case RPAREN: {
                    --this.tplLookaheadParensLevel;
                    break;
                }
                case LBRACKET: {
                    ++this.tplLookaheadBracketsLevel;
                    break;
                }
                case RBRACKET: {
                    --this.tplLookaheadBracketsLevel;
                    break;
                }
                case LBRACE: {
                    ++this.tplLookaheadBracesLevel;
                    break;
                }
                case RBRACE: {
                    --this.tplLookaheadBracesLevel;
                }
            }
        }
        if (!lookahead) {
            if (this.tplLookaheadTokens.isEmpty()) {
                this.tokenImpl(token, tokenOffset, macro, mayBeInLambda);
            } else {
                Boolean oldInPP = this.inPP;
                for (OffsetableToken offsetableToken : this.tplLookaheadTokens) {
                    this.inPP = offsetableToken.inPP;
                    this.tokenImpl(offsetableToken.token, offsetableToken.offset, offsetableToken.macro, mayBeInLambda);
                }
                this.tplLookaheadTokens.clear();
                this.inPP = oldInPP;
                this.tokenImpl(token, tokenOffset, macro, mayBeInLambda);
                this.tplLookaheadParensLevel = 0;
                this.tplLookaheadBracketsLevel = 0;
                this.tplLookaheadBracesLevel = 0;
                this.tplLookaheadLtgtsLevel = 0;
            }
        }
    }

    private boolean isLookaheadNeeded(Token<TokenId> token) {
        int tempLookaheadTokensParensLevel = this.tplLookaheadParensLevel;
        int tempLookaheadTokensBracketsLevel = this.tplLookaheadBracketsLevel;
        int tempLookaheadTokensBracesLevel = this.tplLookaheadBracesLevel;
        int tempLookaheadTokensLtgtsLevel = this.tplLookaheadLtgtsLevel;
        switch ((CppTokenId)token.id()) {
            case LT: {
                ++tempLookaheadTokensLtgtsLevel;
                break;
            }
            case GT: {
                --tempLookaheadTokensLtgtsLevel;
                break;
            }
            case LPAREN: {
                ++tempLookaheadTokensParensLevel;
                break;
            }
            case RPAREN: {
                --tempLookaheadTokensParensLevel;
                break;
            }
            case LBRACKET: {
                ++tempLookaheadTokensBracketsLevel;
                break;
            }
            case RBRACKET: {
                --tempLookaheadTokensBracketsLevel;
                break;
            }
            case LBRACE: {
                ++tempLookaheadTokensBracesLevel;
                break;
            }
            case RBRACE: {
                --tempLookaheadTokensBracesLevel;
            }
        }
        if (!this.tplLookaheadTokens.isEmpty()) {
            return tempLookaheadTokensParensLevel != 0 || tempLookaheadTokensBracketsLevel != 0 || tempLookaheadTokensBracesLevel != 0 || tempLookaheadTokensLtgtsLevel != 0;
        }
        return true;
    }

    private boolean isTemplateAmbiguity(Token<TokenId> token) {
        CsmCompletionExpression top;
        if (this.supportTemplates && (token.id() == CppTokenId.LT || !this.tplLookaheadTokens.isEmpty() && this.tplLookaheadTokens.get((int)0).token.id() == CppTokenId.LT) && (top = this.peekExp()) != null) {
            switch (top.getExpID()) {
                case 1: 
                case 4: 
                case 25: 
                case 27: 
                case 32: {
                    return true;
                }
            }
        }
        return false;
    }

    private OffsetableToken isSupportTemplates() {
        LinkedList<CppTokenId> stack = new LinkedList<CppTokenId>();
        for (OffsetableToken offsetableToken : this.tplLookaheadTokens) {
            switch ((CppTokenId)offsetableToken.token.id()) {
                case LT: {
                    stack.push(CppTokenId.LT);
                    break;
                }
                case GT: {
                    if (stack.isEmpty() || stack.pop() == CppTokenId.LT) break;
                    return offsetableToken;
                }
                case LPAREN: {
                    stack.push(CppTokenId.LPAREN);
                    break;
                }
                case RPAREN: {
                    if (stack.isEmpty() || stack.pop() == CppTokenId.LPAREN) break;
                    return offsetableToken;
                }
                case LBRACKET: {
                    stack.push(CppTokenId.LBRACKET);
                    break;
                }
                case RBRACKET: {
                    if (stack.isEmpty() || stack.pop() == CppTokenId.LBRACKET) break;
                    return offsetableToken;
                }
                case LBRACE: {
                    stack.push(CppTokenId.LBRACE);
                    break;
                }
                case RBRACE: {
                    if (stack.isEmpty() || stack.pop() == CppTokenId.LBRACE) break;
                    return offsetableToken;
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkJoin(CppTokenId tokenID) {
        boolean ret = true;
        boolean cont = true;
        block69: while (cont) {
            cont = false;
            CsmCompletionExpression top = this.peekExp();
            CsmCompletionExpression top2 = this.peekExp2();
            int top2ID = this.getValidExpID(top2);
            int topID = this.getValidExpID(top);
            switch (topID) {
                case 17: {
                    boolean stop = false;
                    switch (top2ID) {
                        case 10: {
                            switch (tokenID) {
                                case IDENTIFIER: 
                                case STAR: 
                                case AMP: 
                                case CONST: {
                                    this.popExp();
                                    CsmCompletionExpression typeExpr = new CsmCompletionExpression(14);
                                    typeExpr.addParameter(top);
                                    this.pushExp(typeExpr);
                                    stop = true;
                                }
                            }
                            break;
                        }
                    }
                    if (stop) break;
                }
                case 1: {
                    boolean stop = false;
                    block11 : switch (top2ID) {
                        case 10: {
                            switch (tokenID) {
                                case IDENTIFIER: 
                                case STAR: 
                                case AMP: 
                                case CONST: {
                                    this.setExprToTYPE(top);
                                    stop = true;
                                    break block11;
                                }
                            }
                            break;
                        }
                        case 29: {
                            switch (tokenID) {
                                case IDENTIFIER: 
                                case STAR: 
                                case AMP: 
                                case CONST: {
                                    this.popExp();
                                    this.setExprToTYPE(top2);
                                    for (int i = 0; i < top.getTokenCount(); ++i) {
                                        top2.addToken(top.getTokenID(i), top.getTokenOffset(i), top.getTokenText(i));
                                    }
                                    top = top2;
                                    stop = true;
                                }
                            }
                            break;
                        }
                    }
                    if (stop) break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 9: 
                case 11: 
                case 12: 
                case 25: 
                case 27: {
                    block21 : switch (top2ID) {
                        case 10: {
                            switch (tokenID) {
                                case IDENTIFIER: 
                                case STAR: 
                                case AMP: 
                                case CONST: {
                                    this.setExprToTYPE(top);
                                    break block21;
                                }
                            }
                            break;
                        }
                        case 3: {
                            switch (tokenID) {
                                case DOT: 
                                case DOTMBR: 
                                case ARROW: 
                                case ARROWMBR: 
                                case SCOPE: 
                                case LBRACKET: 
                                case PLUSPLUS: 
                                case MINUSMINUS: {
                                    break;
                                }
                                case LT: {
                                    if (this.supportTemplates) break;
                                }
                                case LPAREN: {
                                    if (topID != 1 || top2ID != 3 || top2.getParameterCount() != 0 || top2.getTokenCount() != 1 || top2.getTokenID(0) != CppTokenId.TILDE || top.getParameterCount() != 0 || top.getTokenCount() != 1) break;
                                    this.popExp();
                                    this.popExp();
                                    CppTokenId aCurTokenID = top.getTokenID(0);
                                    int aCurTokenPosition = top2.getTokenOffset(0);
                                    String aCurTokenText = top2.getTokenText(0) + top.getTokenText(0);
                                    CsmCompletionExpression exp = new CsmCompletionExpression(1);
                                    exp.addToken(aCurTokenID, aCurTokenPosition, aCurTokenText);
                                    this.pushExp(exp);
                                    break;
                                }
                                case WHITESPACE: 
                                case BLOCK_COMMENT: 
                                case DOXYGEN_COMMENT: 
                                case DOXYGEN_LINE_COMMENT: 
                                case LINE_COMMENT: 
                                case NEW_LINE: {
                                    break;
                                }
                                default: {
                                    if (top2.getParameterCount() != 0) break;
                                    this.popExp();
                                    top2.addParameter(top);
                                    break;
                                }
                            }
                            break;
                        }
                        case 5: 
                        case 26: 
                        case 28: {
                            if (!this.isSeparatorOrOperator(tokenID)) break;
                            switch (tokenID) {
                                case LPAREN: {
                                    break;
                                }
                                case LT: {
                                    if (this.supportTemplates) break;
                                }
                                default: {
                                    this.popExp();
                                    top2.addParameter(top);
                                    top2.setExpID(this.openExpID2ExpID(top2ID));
                                    cont = true;
                                    break;
                                }
                            }
                            break;
                        }
                        case 33: {
                            if (!this.isSeparatorOrOperator(tokenID)) break;
                            switch (tokenID) {
                                case DOT: 
                                case ARROW: 
                                case SCOPE: 
                                case LBRACKET: 
                                case LPAREN: {
                                    break block21;
                                }
                            }
                            this.popExp();
                            top2.addParameter(top);
                            top2.setExpID(32);
                            cont = true;
                            break;
                        }
                        case 13: {
                            if (!this.isSeparatorOrOperator(tokenID)) break;
                            switch (tokenID) {
                                case RPAREN: 
                                case COMMA: {
                                    CsmCompletionExpression top3 = this.peekExp(3);
                                    if (top3 != null) {
                                        switch (top3.getExpID()) {
                                            case 8: 
                                            case 10: {
                                                this.popExp();
                                                top2.addParameter(top);
                                            }
                                        }
                                        break;
                                    }
                                    break block21;
                                }
                            }
                            break;
                        }
                        case 1: 
                        case 14: 
                        case 27: 
                        case 31: {
                            if (!this.isSeparatorOrOperator(tokenID)) break;
                            switch (tokenID) {
                                case LBRACKET: 
                                case STAR: 
                                case AMP: 
                                case RPAREN: 
                                case GT: {
                                    if (topID != 2 || top.getParameterCount() != 0 || top.getTokenCount() != 1 || top.getTokenID(0) != CppTokenId.STAR && top.getTokenID(0) != CppTokenId.AMP && (!this.supportTemplates || top.getTokenID(0) != CppTokenId.AMPAMP)) break block21;
                                    this.popExp();
                                    this.popExp();
                                    CsmCompletionExpression exp = new CsmCompletionExpression(31);
                                    exp.addParameter(top2);
                                    exp.addToken(top.getTokenID(0), top.getTokenOffset(0), top.getTokenText(0));
                                    this.pushExp(exp);
                                    break block21;
                                }
                            }
                        }
                    }
                    continue block69;
                }
            }
        }
        int leftOpID = CsmCompletionExpression.getOperatorID(tokenID);
        if (leftOpID < 0) return ret;
        switch (CsmCompletionExpression.getOperatorPrecedence(leftOpID)) {
            case 0: {
                CsmCompletionExpression lastVar = null;
                CsmCompletionExpression rightOp = this.peekExp();
                int rightOpID = -1;
                rightOpID = CsmCompletionExpression.getOperatorID(rightOp);
                block57 : switch (CsmCompletionExpression.getOperatorPrecedence(rightOpID)) {
                    case 0: {
                        rightOp = null;
                        break;
                    }
                    case 1: {
                        lastVar = rightOp;
                        rightOp = this.peekExp2();
                        rightOpID = CsmCompletionExpression.getOperatorID(rightOp);
                        switch (CsmCompletionExpression.getOperatorPrecedence(rightOpID)) {
                            case 0: {
                                rightOp = null;
                                break block57;
                            }
                            case 1: {
                                return false;
                            }
                        }
                        this.popExp();
                        rightOp.addParameter(lastVar);
                        lastVar = null;
                        break;
                    }
                }
                if (rightOp == null) return ret;
                this.popExp();
                cont = true;
                ArrayList<CsmCompletionExpression> opStack = new ArrayList<CsmCompletionExpression>();
                CsmCompletionExpression leftOp = null;
                do {
                    if (leftOp == null) {
                        leftOp = this.popExp();
                        if (leftOp == null) break;
                        leftOpID = CsmCompletionExpression.getOperatorID(leftOp);
                    }
                    switch (CsmCompletionExpression.getOperatorPrecedence(leftOpID)) {
                        case 0: {
                            this.pushExp(leftOp);
                            cont = false;
                            break;
                        }
                        case 1: {
                            lastVar = leftOp;
                            leftOp = null;
                            break;
                        }
                        default: {
                            int leftOpPrec = CsmCompletionExpression.getOperatorPrecedence(leftOpID);
                            int rightOpPrec = CsmCompletionExpression.getOperatorPrecedence(rightOpID);
                            boolean rightPrec = leftOpPrec > rightOpPrec ? false : (leftOpPrec < rightOpPrec ? true : CsmCompletionExpression.isOperatorRightAssociative(rightOpID));
                            if (rightPrec) {
                                if (lastVar != null) {
                                    rightOp.addParameter(lastVar);
                                }
                                if (opStack.size() > 0) {
                                    lastVar = rightOp;
                                    rightOp = (CsmCompletionExpression)opStack.remove(opStack.size() - 1);
                                    rightOpID = CsmCompletionExpression.getOperatorID(rightOp);
                                    break;
                                }
                                leftOp.addParameter(rightOp);
                                lastVar = null;
                                rightOp = leftOp;
                                rightOpID = leftOpID;
                                leftOp = null;
                                break;
                            }
                            if (lastVar != null) {
                                leftOp.addParameter(lastVar);
                                lastVar = null;
                            }
                            opStack.add(rightOp);
                            rightOp = leftOp;
                            rightOpID = leftOpID;
                            leftOp = null;
                        }
                    }
                } while (cont);
                if (lastVar != null) {
                    rightOp.addParameter(lastVar);
                }
                for (int i = opStack.size() - 1; i >= 0; --i) {
                    CsmCompletionExpression op = (CsmCompletionExpression)opStack.get(i);
                    op.addParameter(rightOp);
                    rightOp = op;
                }
                rightOp.swapOperatorParms();
                this.pushExp(rightOp);
                return ret;
            }
        }
        return ret;
    }

    private void tokenImpl(Token<TokenId> token, int tokenOffset, boolean macro, boolean mayBeInLambda) {
        String category;
        int tokenLen = token.length();
        CppTokenId tokenID = (CppTokenId)token.id();
        if (!macro && tokenID != null && tokenID != CppTokenId.AUTO && ("keyword".equals(category = tokenID.primaryCategory()) || "keyword-directive".equals(category)) && (tokenOffset += this.bufferOffsetDelta) + tokenLen == this.endScanOffset) {
            tokenID = CppTokenId.IDENTIFIER;
        }
        if (tokenID == CppTokenId.PREPROCESSOR_IDENTIFIER || tokenID == CppTokenId.SIZEOF || tokenID == CppTokenId.TYPEID) {
            tokenID = CppTokenId.IDENTIFIER;
        }
        if (tokenID != null) {
            if (this.lastValidTokenID == CppTokenId.COLON) {
                --this.nrQuestions;
            }
            this.lastValidTokenID = tokenID;
        }
        this.curTokenID = tokenID;
        this.curTokenPosition = this.bufferStartPos + tokenOffset;
        CharSequence txt = token.text();
        if (!this.isMacroExpansion() && tokenOffset + tokenLen > this.endScanOffset) {
            assert (this.endScanOffset > tokenOffset) : "end - " + this.endScanOffset + " start - " + tokenOffset + " tokenLen - " + tokenLen + "tokenID - " + tokenID + " txt = \n" + txt;
            txt = txt.subSequence(0, this.endScanOffset - tokenOffset);
        }
        StringBuilder buf = new StringBuilder(txt);
        this.lastValidTokenText = this.curTokenText = buf.toString();
        this.errorState = false;
        this.checkJoin(tokenID);
        CsmCompletionExpression top = this.peekExp();
        int topID = this.getValidExpID(top);
        CsmCompletionExpression constExp = null;
        String kwdType = CndLexerUtilities.isType((CppTokenId)tokenID) ? this.curTokenText : null;
        block0 : switch (tokenID) {
            case PREPROCESSOR_START: 
            case PREPROCESSOR_START_ALT: {
                this.pushExp(this.createTokenExp(39));
                break;
            }
            case PREPROCESSOR_DEFINE: 
            case PREPROCESSOR_ELIF: 
            case PREPROCESSOR_ELSE: 
            case PREPROCESSOR_ENDIF: 
            case PREPROCESSOR_ERROR: 
            case PREPROCESSOR_IDENT: 
            case PREPROCESSOR_IF: 
            case PREPROCESSOR_IFDEF: 
            case PREPROCESSOR_IFNDEF: 
            case PREPROCESSOR_INCLUDE: 
            case PREPROCESSOR_INCLUDE_NEXT: 
            case PREPROCESSOR_LINE: 
            case PREPROCESSOR_PRAGMA: 
            case PREPROCESSOR_UNDEF: 
            case PREPROCESSOR_WARNING: {
                if (topID == 39) {
                    top.setExpID(38);
                    this.addTokenTo(top);
                    break;
                }
                this.errorState = true;
                break;
            }
            case STATIC_CAST: 
            case DYNAMIC_CAST: 
            case CONST_CAST: 
            case REINTERPRET_CAST: {
                this.pushExp(this.createTokenExp(37));
                break;
            }
            case TRUE: 
            case FALSE: {
                constExp = this.createTokenExp(0);
                constExp.setType(CsmCompletion.BOOLEAN_CLASS.getName().toString());
                break;
            }
            case NULL: {
                constExp = this.createTokenExp(0);
                constExp.setType("null");
                break;
            }
            case CLASS: {
                if (topID == 5 || topID == 26 || topID == 28) {
                    this.pushExp(this.createTokenExp(1));
                    break;
                }
            }
            case STRUCT: 
            case UNION: {
                this.pushExp(this.createTokenExp(36));
                break;
            }
            case GOTO: {
                this.pushExp(this.createTokenExp(34));
                break;
            }
            case NEW: {
                switch (topID) {
                    case 1: 
                    case 15: {
                        this.errorState = true;
                        break block0;
                    }
                }
                this.pushExp(this.createTokenExp(15));
                break;
            }
            case STATIC: {
                switch (topID) {
                    default: 
                }
                this.errorState = true;
                break;
            }
            case THIS: {
                this.pushExp(this.createTokenExp(1));
                break;
            }
            case CASE: {
                this.pushExp(this.createTokenExp(24));
                break;
            }
            case IF: 
            case FOR: 
            case SWITCH: 
            case WHILE: {
                if (topID == -1) {
                    this.pushExp(this.createTokenExp(this.tokenID2OpenExpID(tokenID)));
                    break;
                }
                this.errorState = true;
                break;
            }
            case IDENTIFIER: {
                switch (topID) {
                    case -1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 10: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 28: 
                    case 29: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 36: 
                    case 37: 
                    case 46: 
                    case 49: 
                    case 52: {
                        this.pushExp(this.createTokenExp(1));
                        break block0;
                    }
                    case 40: {
                        this.popExp();
                        top = this.peekExp();
                        while (this.getValidExpID(top) == 1 || this.getValidExpID(top) == 2 || this.getValidExpID(top) == 0) {
                            this.popExp();
                            top = this.peekExp();
                        }
                        this.pushExp(this.createTokenExp(1));
                        break block0;
                    }
                    case 19: {
                        top.setExpID(1);
                        this.addTokenTo(top);
                        break block0;
                    }
                    case 14: {
                        if (this.getValidExpID(this.peekExp2()) != 10) {
                            this.popExp();
                            CsmCompletionExpression var = this.createTokenExp(1);
                            for (int i = 0; i < top.getTokenCount(); ++i) {
                                var.addToken(top.getTokenID(i), top.getTokenOffset(i), top.getTokenText(i));
                            }
                            this.pushExp(var);
                            break block0;
                        }
                        this.popExp();
                        CsmCompletionExpression var = this.createTokenExp(1);
                        var.addParameter(top);
                        this.pushExp(var);
                        break block0;
                    }
                    case 1: {
                        if (this.getValidExpID(this.peekExp2()) == 10) {
                            this.addTokenTo(top);
                            break block0;
                        }
                        int cnt = this.expStack.size();
                        CsmCompletionExpression gen = null;
                        for (int i = 0; i < cnt; ++i) {
                            CsmCompletionExpression expr = this.peekExp(i + 1);
                            if (expr.getExpID() != 18) continue;
                            gen = expr;
                            break;
                        }
                        if (gen != null) {
                            this.pushExp(this.createTokenExp(1));
                            break block0;
                        }
                        this.errorState = true;
                        break block0;
                    }
                    case 31: {
                        if (this.getValidExpID(this.peekExp2()) == 10) {
                            this.popExp();
                            CsmCompletionExpression var = this.createTokenExp(1);
                            var.addParameter(top);
                            this.pushExp(var);
                            break block0;
                        }
                        this.errorState = true;
                        break block0;
                    }
                    case 39: {
                        top.setExpID(38);
                        top.addParameter(this.createTokenExp(1));
                        break block0;
                    }
                }
                this.errorState = true;
                break;
            }
            case QUESTION: {
                ++this.nrQuestions;
                CsmCompletionExpression ternary = new CsmCompletionExpression(40);
                switch (topID) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 18: 
                    case 25: 
                    case 27: 
                    case 32: 
                    case 33: 
                    case 46: 
                    case 52: {
                        this.popExp();
                        ternary.addParameter(top);
                        break;
                    }
                    default: {
                        this.errorState = true;
                    }
                }
                this.pushExp(ternary);
                break;
            }
            case STAR: 
            case AMP: 
            case AMPAMP: {
                if (tokenID != CppTokenId.AMPAMP || this.supportTemplates) {
                    boolean pointer = false;
                    switch (topID) {
                        case -1: 
                        case 6: 
                        case 8: 
                        case 10: 
                        case 13: 
                        case 18: 
                        case 33: 
                        case 46: 
                        case 52: {
                            CsmCompletionExpression opExp = this.createTokenExp(33);
                            this.pushExp(opExp);
                            pointer = true;
                            break;
                        }
                        case 14: 
                        case 17: 
                        case 28: 
                        case 31: {
                            this.popExp();
                            CsmCompletionExpression exp = this.createTokenExp(31);
                            exp.addParameter(top);
                            this.pushExp(exp);
                            pointer = true;
                            break;
                        }
                        case 2: {
                            if ((top.getTokenCount() != 1 || !this.isEqOperator(top.getTokenID(0))) && top.getTokenID(0) != CppTokenId.COLON) break;
                            CsmCompletionExpression memPtrExp = this.createTokenExp(33);
                            this.pushExp(memPtrExp);
                            pointer = true;
                        }
                    }
                    if (pointer) break;
                }
            }
            case EQ: 
            case EQEQ: 
            case GTEQ: 
            case GTGTEQ: 
            case AMPEQ: 
            case LTEQ: 
            case LTLTEQ: 
            case PLUSEQ: 
            case NOTEQ: 
            case MINUSEQ: 
            case STAREQ: 
            case SLASHEQ: 
            case BAREQ: 
            case CARETEQ: 
            case PERCENTEQ: 
            case BARBAR: 
            case LTLT: 
            case SLASH: 
            case BAR: 
            case CARET: 
            case PERCENT: 
            case COLON: {
                switch (topID) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 25: 
                    case 27: 
                    case 32: {
                        this.pushExp(this.createTokenExp(2));
                        break block0;
                    }
                    case 14: 
                    case 31: {
                        if (tokenID == CppTokenId.STAR || tokenID == CppTokenId.AMP) {
                            this.pushExp(this.createTokenExp(2));
                            break block0;
                        }
                        if (tokenID != CppTokenId.EQ) break;
                        this.pushExp(this.createTokenExp(2));
                        break block0;
                    }
                }
                this.errorState = true;
                break;
            }
            case LT: {
                boolean genericType = false;
                if (this.supportTemplates) {
                    switch (topID) {
                        case 1: 
                        case 4: 
                        case 25: 
                        case 27: 
                        case 32: {
                            this.popExp();
                            CsmCompletionExpression genExp = this.createTokenExp(18);
                            genExp.addParameter(top);
                            this.pushExp(genExp);
                            genericType = true;
                            break;
                        }
                    }
                }
                if (topID == 37) {
                    this.addTokenTo(top);
                    break;
                }
                if (this.errorState || genericType) break;
                switch (topID) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 25: 
                    case 27: 
                    case 32: {
                        this.pushExp(this.createTokenExp(2));
                        break block0;
                    }
                }
                this.errorState = true;
                break;
            }
            case GT: {
                boolean genericType = false;
                if (this.supportTemplates) {
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 3: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 11: 
                        case 14: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 25: 
                        case 27: 
                        case 31: {
                            CsmCompletionExpression param;
                            CsmCompletionExpression expr;
                            int cnt = this.expStack.size();
                            CsmCompletionExpression gen = null;
                            for (int i = 0; i < cnt && (expr = this.peekExp(i + 1)).getExpID() != 8; ++i) {
                                if (expr.getExpID() != 18) continue;
                                gen = expr;
                                break;
                            }
                            if (gen == null) break;
                            while (this.peekExp().getExpID() != 18) {
                                gen.addParameter(this.popExp());
                            }
                            gen.setExpID(17);
                            top = gen;
                            genericType = true;
                            if (gen.getParameterCount() <= 0 || (param = gen.getParameter(0)).getParameterCount() <= 0) break;
                            switch (param.getExpID()) {
                                case 32: {
                                    CsmCompletionExpression newGen = this.createTokenExp(17);
                                    newGen.addParameter(param.getParameter(0));
                                    for (int i = 1; i < gen.getParameterCount(); ++i) {
                                        newGen.addParameter(gen.getParameter(i));
                                    }
                                    top = newGen;
                                    this.popExp();
                                    this.pushExp(this.createTokenExp(33, param));
                                    this.pushExp(newGen);
                                }
                            }
                            break;
                        }
                    }
                }
                boolean conversion = false;
                if (!this.errorState && !genericType) {
                    CsmCompletionExpression top2 = this.peekExp2();
                    switch (this.getValidExpID(top2)) {
                        case 36: {
                            CsmCompletionExpression top3 = this.peekExp(3);
                            if (this.getValidExpID(top3) != 37 || !CsmCompletionExpression.isValidType(top)) break;
                            this.popExp();
                            this.popExp();
                            top3.addParameter(top);
                            top3.addParameter(top2);
                            this.addTokenTo(top3);
                            conversion = true;
                            break;
                        }
                        case 37: {
                            if (!CsmCompletionExpression.isValidType(top)) break;
                            this.popExp();
                            top2.addParameter(top);
                            this.addTokenTo(top2);
                            conversion = true;
                        }
                    }
                }
                if (this.errorState || genericType || conversion) break;
                switch (topID) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 25: 
                    case 27: 
                    case 32: {
                        this.pushExp(this.createTokenExp(2));
                        break block0;
                    }
                }
                this.errorState = true;
                break;
            }
            case GTGT: {
                boolean genericType = false;
                if (this.supportTemplates) {
                    switch (topID) {
                        case 0: 
                        case 1: 
                        case 4: 
                        case 7: 
                        case 9: 
                        case 14: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 25: 
                        case 27: {
                            int gtoIndex = this.findNextExpr(0, 18, 8);
                            int n = gtoIndex = gtoIndex >= 0 ? this.findNextExpr(gtoIndex, 18, 8) : -1;
                            if (gtoIndex < 0) break;
                            genericType = true;
                            for (int iterCount = 0; iterCount < 2; ++iterCount) {
                                CsmCompletionExpression gen = this.peekExp(this.findNextExpr(0, 18, 8));
                                while (this.peekExp().getExpID() != 18) {
                                    gen.addParameter(this.popExp());
                                }
                                gen.setExpID(17);
                                top = gen;
                                if (iterCount != 0) continue;
                                this.checkJoin(CppTokenId.GT);
                            }
                            break;
                        }
                    }
                }
                if (this.errorState || genericType) break;
                switch (topID) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 25: 
                    case 27: 
                    case 32: {
                        this.pushExp(this.createTokenExp(2));
                        break block0;
                    }
                }
                this.errorState = true;
                break;
            }
            case PLUSPLUS: 
            case MINUSMINUS: {
                switch (topID) {
                    case -1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 8: 
                    case 10: 
                    case 18: 
                    case 32: 
                    case 33: 
                    case 46: 
                    case 52: {
                        CsmCompletionExpression opExp = this.createTokenExp(3);
                        this.pushExp(opExp);
                        break block0;
                    }
                    case 1: {
                        CsmCompletionExpression opExp = this.createTokenExp(3);
                        this.popExp();
                        opExp.addParameter(top);
                        this.pushExp(opExp);
                        break block0;
                    }
                }
                this.errorState = true;
                break;
            }
            case PLUS: 
            case MINUS: {
                switch (topID) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 25: 
                    case 27: 
                    case 32: 
                    case 40: {
                        CsmCompletionExpression opExp = this.createTokenExp(2);
                        this.pushExp(opExp);
                        break block0;
                    }
                    case -1: 
                    case 2: 
                    case 6: 
                    case 8: 
                    case 10: 
                    case 13: 
                    case 18: 
                    case 33: 
                    case 46: 
                    case 52: {
                        CsmCompletionExpression opExp = this.createTokenExp(3);
                        this.pushExp(opExp);
                        break block0;
                    }
                }
                this.errorState = true;
                break;
            }
            case TILDE: 
            case NOT: {
                switch (topID) {
                    case -1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 8: 
                    case 10: 
                    case 18: 
                    case 32: 
                    case 33: 
                    case 46: 
                    case 52: {
                        CsmCompletionExpression opExp = this.createTokenExp(3);
                        this.pushExp(opExp);
                        break block0;
                    }
                    case 5: 
                    case 26: 
                    case 28: {
                        if (tokenID != CppTokenId.TILDE) break;
                        CsmCompletionExpression opExp = this.createTokenExp(3);
                        this.pushExp(opExp);
                        break block0;
                    }
                }
                this.errorState = true;
                break;
            }
            case DOT: 
            case DOTMBR: 
            case ARROW: 
            case ARROWMBR: 
            case SCOPE: {
                switch (topID) {
                    case 0: 
                    case 1: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 17: 
                    case 32: 
                    case 53: {
                        if (this.checkExpRow(49, 11) || this.checkExpRow(49, 9, 9)) {
                            this.pushExp(this.createTokenExp(50));
                            break block0;
                        }
                        this.popExp();
                        int openExpID = this.tokenID2OpenExpID(tokenID);
                        CsmCompletionExpression opExp = this.createTokenExp(openExpID);
                        if (topID == 13 && tokenID != CppTokenId.SCOPE) {
                            top.setExpID(9);
                        }
                        opExp.addParameter(top);
                        this.pushExp(opExp);
                        break block0;
                    }
                    case 4: {
                        this.addTokenTo(top);
                        top.setExpID(this.tokenID2OpenExpID(tokenID));
                        break block0;
                    }
                    case 25: {
                        this.addTokenTo(top);
                        top.setExpID(this.tokenID2OpenExpID(tokenID));
                        break block0;
                    }
                    case 27: {
                        this.addTokenTo(top);
                        top.setExpID(this.tokenID2OpenExpID(tokenID));
                        break block0;
                    }
                    case -1: 
                    case 2: 
                    case 3: 
                    case 8: 
                    case 10: 
                    case 18: 
                    case 29: 
                    case 46: 
                    case 52: {
                        CsmCompletionExpression emptyVar = CsmCompletionExpression.createEmptyVariable(this.curTokenPosition);
                        int openExpID = this.tokenID2OpenExpID(tokenID);
                        CsmCompletionExpression opExp = this.createTokenExp(openExpID);
                        opExp.addParameter(emptyVar);
                        this.pushExp(opExp);
                        break block0;
                    }
                }
                this.errorState = true;
                break;
            }
            case COMMA: {
                switch (topID) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 19: 
                    case 25: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 51: 
                    case 53: {
                        CsmCompletionExpression top2 = this.peekExp2();
                        switch (this.getValidExpID(top2)) {
                            case 10: {
                                this.popExp();
                                top2.addParameter(top);
                                this.addTokenTo(top2);
                                top = top2;
                                break block0;
                            }
                            case 21: {
                                this.popExp();
                                top2.addParameter(top);
                                this.addTokenTo(top2);
                                top = top2;
                                break block0;
                            }
                            case 8: {
                                this.popExp();
                                top2.addParameter(top);
                                this.addTokenTo(top2);
                                top = top2;
                                break block0;
                            }
                            case 52: {
                                this.popExp();
                                top2.addParameter(top);
                                this.addTokenTo(top2);
                                top = top2;
                                break block0;
                            }
                        }
                        int cnt = this.expStack.size();
                        CsmCompletionExpression gen = null;
                        for (int i = 0; i < cnt; ++i) {
                            CsmCompletionExpression expr = this.peekExp(i + 1);
                            if (expr.getExpID() != 18) continue;
                            gen = expr;
                            break;
                        }
                        if (gen != null) {
                            while (this.peekExp().getExpID() != 18) {
                                gen.addParameter(this.popExp());
                            }
                            top = gen;
                            break block0;
                        }
                        this.errorState = true;
                        break block0;
                    }
                    case 10: {
                        this.addTokenTo(top);
                        break block0;
                    }
                    case 52: {
                        this.addTokenTo(top);
                        break block0;
                    }
                }
                this.errorState = true;
                break;
            }
            case SEMICOLON: {
                this.errorState = true;
                break;
            }
            case LPAREN: {
                switch (topID) {
                    case 1: 
                    case 17: {
                        this.popExp();
                        CsmCompletionExpression top2 = this.peekExp();
                        int top2ID = this.getValidExpID(top2);
                        switch (top2ID) {
                            case 20: {
                                top2.setExpID(21);
                                top2.addParameter(top);
                                break block0;
                            }
                            case 5: 
                            case 26: 
                            case 28: {
                                CsmCompletionExpression top3 = this.peekExp2();
                                if (this.getValidExpID(top3) != 20) break;
                                top2.setExpID(this.openExpID2ExpID(top2ID));
                                top2.addParameter(top);
                                top3.setExpID(21);
                                top3.addParameter(top2);
                                this.popExp();
                                break block0;
                            }
                        }
                        CsmCompletionExpression mtdOpExp = this.createTokenExp(10);
                        mtdOpExp.addParameter(top);
                        this.pushExp(mtdOpExp);
                        break block0;
                    }
                    case 7: {
                        this.popExp();
                        CsmCompletionExpression mtdExp = this.createTokenExp(11);
                        mtdExp.addParameter(top);
                        this.pushExp(mtdExp);
                        break block0;
                    }
                    case 14: {
                        this.popExp();
                        CsmCompletionExpression convOpExp = new CsmCompletionExpression(37);
                        convOpExp.addParameter(top);
                        this.pushExp(convOpExp);
                        this.pushExp(this.createTokenExp(8));
                        break block0;
                    }
                    case 51: {
                        this.popExp();
                        CsmCompletionExpression lambdaExp = this.createTokenExp(52);
                        lambdaExp.addParameter(top);
                        this.pushExp(lambdaExp);
                        break block0;
                    }
                    case -1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 13: 
                    case 18: 
                    case 33: 
                    case 37: 
                    case 46: 
                    case 47: 
                    case 49: 
                    case 52: {
                        this.pushExp(this.createTokenExp(8));
                        break block0;
                    }
                    case 11: {
                        this.popExp();
                        CsmCompletionExpression mtdOpExp = this.createTokenExp(10);
                        mtdOpExp.addParameter(top);
                        this.pushExp(mtdOpExp);
                        break block0;
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: {
                        this.popExp();
                        this.pushExp(this.createTokenExp(46));
                        break block0;
                    }
                }
                this.errorState = true;
                break;
            }
            case RPAREN: {
                CsmCompletionExpression top2;
                boolean mtd = false;
                block144 : switch (topID) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 40: 
                    case 51: 
                    case 53: {
                        top2 = this.peekExp2();
                        block151 : switch (this.getValidExpID(top2)) {
                            case 36: {
                                CsmCompletionExpression top3 = this.peekExp(3);
                                if (this.getValidExpID(top3) == 8 && CsmCompletionExpression.isValidType(top)) {
                                    this.popExp();
                                    this.popExp();
                                    top3.addParameter(top);
                                    top3.addParameter(top2);
                                    top3.setExpID(13);
                                    this.addTokenTo(top3);
                                    break;
                                }
                                if (this.getValidExpID(top3) != 10) break block144;
                                this.popExp();
                                this.popExp();
                                top3.addParameter(top);
                                top = top3;
                                mtd = true;
                                break;
                            }
                            case 8: {
                                CsmCompletionExpression top3 = this.peekExp(3);
                                if (this.getValidExpID(top3) == 37) {
                                    int i;
                                    this.popExp();
                                    this.popExp();
                                    this.popExp();
                                    for (i = 0; i < top2.getParameterCount(); ++i) {
                                        top3.addParameter(top2.getParameter(i));
                                    }
                                    for (i = 0; i < top2.getTokenCount(); ++i) {
                                        top3.addToken(top2.getTokenID(i), top2.getTokenOffset(i), top2.getTokenText(i));
                                    }
                                    this.addTokenTo(top3);
                                    top3.addParameter(top);
                                    top3.setExpID(13);
                                    top2 = new CsmCompletionExpression(9);
                                    top2.addParameter(top3);
                                    top = top2;
                                    this.pushExp(top);
                                    break;
                                }
                                if (this.getValidExpID(top3) == 47) {
                                    this.popExp();
                                    this.popExp();
                                    this.popExp();
                                    top2.addParameter(top);
                                    top2.setExpID(48);
                                    top3.addParameter(top2);
                                    top3.setExpID(9);
                                    top = top3;
                                    this.pushExp(top);
                                    break;
                                }
                                this.popExp();
                                top2.addParameter(top);
                                if (top2.getParameterCount() == 1 && CsmCompletionExpression.isValidType(top) && this.getValidExpID(top3) != 9 && this.getValidExpID(top3) != 14) {
                                    top2.setExpID(13);
                                } else {
                                    top2.setExpID(9);
                                }
                                this.addTokenTo(top2);
                                break;
                            }
                            case 46: {
                                this.popExp();
                                this.popExp();
                                break;
                            }
                            case 18: {
                                this.popExp();
                                top2.setExpID(2);
                                top2.addParameter(top);
                                top = top2;
                                top2 = this.peekExp2();
                                if (this.getValidExpID(top2) != 10) break;
                            }
                            case 10: {
                                this.popExp();
                                top2.addParameter(top);
                                top = top2;
                                mtd = true;
                                break;
                            }
                            case 52: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(53);
                                this.addTokenTo(top2);
                                top = top2;
                                break;
                            }
                            case 13: {
                                this.popExp();
                                top2.addParameter(top);
                                top = top2;
                                top2 = this.peekExp2();
                                switch (this.getValidExpID(top2)) {
                                    case 8: {
                                        this.popExp();
                                        top2.addParameter(top);
                                        top2.setExpID(9);
                                        top = top2;
                                        break block151;
                                    }
                                    case 10: {
                                        this.popExp();
                                        top2.addParameter(top);
                                        top = top2;
                                        mtd = true;
                                    }
                                }
                                break;
                            }
                            case 33: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(32);
                                top = top2;
                                top2 = this.peekExp2();
                                switch (this.getValidExpID(top2)) {
                                    case 8: {
                                        this.popExp();
                                        top2.addParameter(top);
                                        top2.setExpID(9);
                                        top = top2;
                                        break block151;
                                    }
                                    case 10: {
                                        this.popExp();
                                        top2.addParameter(top);
                                        top = top2;
                                        mtd = true;
                                    }
                                }
                                break;
                            }
                            default: {
                                this.errorState = true;
                                break;
                            }
                        }
                        break;
                    }
                    case 10: {
                        mtd = true;
                        break;
                    }
                    case 52: {
                        this.addTokenTo(top);
                        top.setExpID(53);
                        break;
                    }
                    case 8: {
                        top2 = this.peekExp2();
                        switch (this.getValidExpID(top2)) {
                            case 37: {
                                int i;
                                this.popExp();
                                this.popExp();
                                for (i = 0; i < top.getParameterCount(); ++i) {
                                    top2.addParameter(top.getParameter(i));
                                }
                                for (i = 0; i < top.getTokenCount(); ++i) {
                                    top2.addToken(top.getTokenID(i), top.getTokenOffset(i), top.getTokenText(i));
                                }
                                this.addTokenTo(top2);
                                top2.setExpID(13);
                                top = new CsmCompletionExpression(9);
                                top.addParameter(top2);
                                this.pushExp(top);
                                break block144;
                            }
                        }
                        this.popExp();
                        break;
                    }
                    case 33: {
                        if (this.shiftedCheckExpRow(1, 49, 8)) {
                            this.popExp();
                            top.setExpID(32);
                            CsmCompletionExpression newTopExp = this.peekExp();
                            newTopExp.addParameter(top);
                            newTopExp.setExpID(9);
                            break;
                        }
                        this.errorState = true;
                        break;
                    }
                    default: {
                        this.errorState = true;
                    }
                }
                if (!mtd) break;
                this.addTokenTo(top);
                top.setExpID(11);
                top2 = this.peekExp2();
                int top2ID = this.getValidExpID(top2);
                switch (top2ID) {
                    case 5: 
                    case 26: 
                    case 28: {
                        CsmCompletionExpression top3 = this.peekExp(3);
                        if (this.getValidExpID(top3) != 15) break;
                        this.popExp();
                        top2.addParameter(top);
                        top2.setExpID(this.openExpID2ExpID(top2ID));
                        this.popExp();
                        top3.setExpID(12);
                        top3.addParameter(top2);
                        break;
                    }
                    case 15: {
                        top2.setExpID(12);
                        top2.addParameter(top);
                        this.popExp();
                    }
                }
                break;
            }
            case LBRACKET: {
                switch (topID) {
                    case 1: 
                    case 4: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 14: 
                    case 17: 
                    case 25: 
                    case 27: {
                        this.popExp();
                        CsmCompletionExpression arrExp = this.createTokenExp(6);
                        arrExp.addParameter(top);
                        this.pushExp(arrExp);
                        break block0;
                    }
                }
                this.errorState = true;
                break;
            }
            case ELLIPSIS: {
                switch (topID) {
                    case 1: 
                    case 4: 
                    case 7: 
                    case 8: 
                    case 11: 
                    case 14: 
                    case 17: {
                        CsmCompletionExpression exp = this.createTokenExp(2);
                        this.addTokenTo(exp);
                        top.addParameter(exp);
                        break block0;
                    }
                }
                this.errorState = true;
                break;
            }
            case RBRACKET: {
                switch (topID) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 9: 
                    case 11: 
                    case 13: 
                    case 16: 
                    case 25: 
                    case 27: 
                    case 32: {
                        CsmCompletionExpression top2 = this.peekExp2();
                        switch (this.getValidExpID(top2)) {
                            case 6: {
                                CsmCompletionExpression top3 = this.peekExp(3);
                                this.popExp();
                                if (this.getValidExpID(top3) == 15) {
                                    this.popExp();
                                    top3.setExpID(7);
                                    top3.addParameter(top2.getParameter(0));
                                    top3.addToken(top2.getTokenID(0), top2.getTokenOffset(0), top2.getTokenText(0));
                                    this.addTokenTo(top2);
                                    break block0;
                                }
                                top2.setExpID(7);
                                top2.addParameter(top);
                                this.addTokenTo(top2);
                                break block0;
                            }
                        }
                        this.errorState = true;
                        break block0;
                    }
                    case 6: {
                        top.setExpID(7);
                        this.addTokenTo(top);
                        break block0;
                    }
                }
                this.errorState = true;
                break;
            }
            case LBRACE: {
                CsmCompletionExpression top2;
                if (topID == 7 && this.getValidExpID(top2 = this.peekExp2()) == 15) {
                    this.popExp();
                    top2.setExpID(7);
                    top2.addParameter(top.getParameter(0));
                    top2.addToken(top.getTokenID(0), top.getTokenOffset(0), top.getTokenText(0));
                    top2.addToken(top.getTokenID(1), top.getTokenOffset(1), top.getTokenText(1));
                    break;
                }
                this.errorState = true;
                break;
            }
            case RBRACE: {
                this.errorState = true;
                break;
            }
            case NEW_LINE: {
                if (topID != 38) break;
                this.popExp();
                break;
            }
            case WHITESPACE: 
            case BLOCK_COMMENT: 
            case DOXYGEN_COMMENT: 
            case DOXYGEN_LINE_COMMENT: 
            case LINE_COMMENT: {
                break;
            }
            case CHAR_LITERAL: {
                constExp = this.createTokenExp(0);
                constExp.setType("char");
                break;
            }
            case RAW_STRING_LITERAL: 
            case STRING_LITERAL: {
                constExp = this.createTokenExp(0);
                constExp.setType(CsmCompletion.CONST_STRING_TYPE.format(true));
                break;
            }
            case NULLPTR: {
                constExp = this.createTokenExp(0);
                constExp.setType("nullptr");
                break;
            }
            case INT_LITERAL: {
                constExp = this.createTokenExp(0);
                constExp.setType("int");
                break;
            }
            case UNSIGNED_LITERAL: {
                constExp = this.createTokenExp(0);
                constExp.setType("unsigned int");
                break;
            }
            case LONG_LITERAL: {
                constExp = this.createTokenExp(0);
                constExp.setType("long");
                break;
            }
            case LONG_LONG_LITERAL: {
                constExp = this.createTokenExp(0);
                constExp.setType("long long");
                break;
            }
            case UNSIGNED_LONG_LITERAL: {
                constExp = this.createTokenExp(0);
                constExp.setType("unsigned long");
                break;
            }
            case UNSIGNED_LONG_LONG_LITERAL: {
                constExp = this.createTokenExp(0);
                constExp.setType("unsigned long long");
                break;
            }
            case FLOAT_LITERAL: {
                constExp = this.createTokenExp(0);
                constExp.setType("float");
                break;
            }
            case DOUBLE_LITERAL: {
                constExp = this.createTokenExp(0);
                constExp.setType("double");
                break;
            }
            case TYPENAME: 
            case TEMPLATE: 
            case CONST: {
                break;
            }
            case DECLTYPE: {
                this.pushExp(this.createTokenExp(47));
                break;
            }
            default: {
                this.errorState = true;
            }
        }
        if (constExp != null) {
            switch (topID) {
                case 5: 
                case 26: 
                case 28: 
                case 33: {
                    this.errorState = true;
                    break;
                }
                case -1: 
                case 2: 
                case 3: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 21: 
                case 32: 
                case 40: 
                case 46: {
                    this.pushExp(constExp);
                    this.errorState = false;
                    break;
                }
                case 18: {
                    this.pushExp(constExp);
                    this.errorState = false;
                    break;
                }
                case 0: {
                    if (CsmCompletion.CONST_STRING_TYPE.format(true).equals(top.getType()) && CsmCompletion.CONST_STRING_TYPE.format(true).equals(constExp.getType())) {
                        this.errorState = false;
                        break;
                    }
                    this.errorState = true;
                    break;
                }
                default: {
                    this.errorState = true;
                }
            }
        }
        if (kwdType != null) {
            switch (topID) {
                case -1: 
                case 8: 
                case 15: 
                case 37: 
                case 46: {
                    CsmCompletionExpression kwdExp = this.createTokenExp(14);
                    kwdExp.setType(kwdType);
                    this.pushExp(kwdExp);
                    this.errorState = false;
                    break;
                }
                case 10: 
                case 18: {
                    int expType = 14;
                    switch (tokenID) {
                        case CONST: 
                        case VOLATILE: {
                            expType = 29;
                        }
                    }
                    CsmCompletionExpression kwdExp = this.createTokenExp(expType);
                    kwdExp.setType(kwdType);
                    this.pushExp(kwdExp);
                    this.errorState = false;
                    break;
                }
                case 29: {
                    int expType = 14;
                    switch (tokenID) {
                        case CONST: 
                        case VOLATILE: {
                            expType = 29;
                        }
                    }
                    this.setExprToTYPE(top);
                    top.setExpID(expType);
                }
                case 14: {
                    CsmCompletionExpression kwdExp = top;
                    this.addTokenTo(kwdExp);
                    kwdExp.setType(kwdExp.getType() + " " + kwdType);
                    this.errorState = false;
                    break;
                }
                case 31: {
                    CsmCompletionExpression kwdExp = this.createTokenExp(14);
                    kwdExp.setType(kwdType);
                    top.addParameter(kwdExp);
                    this.errorState = false;
                    break;
                }
                default: {
                    if (tokenID == CppTokenId.CONST) break;
                    this.errorState = true;
                }
            }
        }
        if (this.errorState) {
            if (!this.alternativeParse && this.checkExp(this.peekExp2(), 10) && top.getTokenCount() > 0 && (CppTokenId.STAR == top.getTokenID(0) || CppTokenId.AMP == top.getTokenID(0)) && top.getParameterCount() > 0 && this.checkExp(top.getParameter(0), 14)) {
                CsmCompletionExpression paramExp = top.getParameter(0);
                int newExpType = -1;
                boolean withParams = false;
                if (paramExp.getTokenCount() > 0 && CppTokenId.IDENTIFIER == paramExp.getTokenID(0)) {
                    newExpType = 1;
                } else if (paramExp.getTokenCount() > 0 && CppTokenId.SCOPE == paramExp.getTokenID(0)) {
                    newExpType = 27;
                    withParams = true;
                } else if (paramExp.getTokenCount() > 1 && CppTokenId.LPAREN == paramExp.getTokenID(0) && CppTokenId.RPAREN == paramExp.getTokenID(1)) {
                    newExpType = 11;
                    withParams = true;
                }
                if (newExpType >= 0) {
                    this.popExp();
                    this.pushExp(this.createTokenExp(newExpType, paramExp, withParams));
                    this.pushExp(this.createTokenExp(2, top));
                    this.alternativeParse = true;
                    this.errorState = false;
                    this.tokenImpl(token, tokenOffset, macro, mayBeInLambda);
                    this.alternativeParse = false;
                }
            }
            if (this.errorState) {
                this.clearStack();
                if (tokenID == CppTokenId.IDENTIFIER) {
                    this.pushExp(this.createTokenExp(1));
                    this.errorState = false;
                } else if (tokenID == CppTokenId.AUTO) {
                    this.pushExp(this.createTokenExp(49));
                    this.errorState = false;
                } else if (!macro && !mayBeInLambda) {
                    this.lastSeparatorOffset = tokenOffset;
                }
            }
        }
    }

    public int getLastSeparatorOffset() {
        return this.lastSeparatorOffset;
    }

    void setLastSeparatorOffset(int lastSeparatorOffset) {
        this.lastSeparatorOffset = lastSeparatorOffset;
    }

    public void start(int startOffset, int firstTokenOffset, int lastOffset) {
        this.inPP = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void end(int offset, int lastTokenOffset) {
        if (!this.lambdaLookaheadTokens.isEmpty()) {
            Boolean oldInPP = this.inPP;
            for (OffsetableToken offsetableToken : this.lambdaLookaheadTokens) {
                this.inPP = offsetableToken.inPP;
                this.templateLookahead(offsetableToken.token, offsetableToken.offset, offsetableToken.macro, true);
            }
            this.lambdaLookaheadStage = null;
            this.lambdaLookaheadTokens.clear();
            this.lambdaLookaheadLevel = 0;
            this.inPP = oldInPP;
        }
        if (!this.tplLookaheadTokens.isEmpty()) {
            boolean oldSupportTemplates = this.supportTemplates;
            Boolean oldInPP = this.inPP;
            int lookaheadSize = this.tplLookaheadTokens.size();
            OffsetableToken disableTillToken = this.isSupportTemplates();
            this.supportTemplates = disableTillToken == null;
            for (int i = 0; i < lookaheadSize; ++i) {
                OffsetableToken currentToken = this.tplLookaheadTokens.remove(0);
                this.inPP = currentToken.inPP;
                this.tokenImpl(currentToken.token, currentToken.offset, currentToken.macro, false);
                if (currentToken != disableTillToken) continue;
                disableTillToken = this.isSupportTemplates();
                this.supportTemplates = disableTillToken == null;
            }
            this.tplLookaheadTokens.clear();
            this.supportTemplates = oldSupportTemplates;
            this.inPP = oldInPP;
        }
        if (this.lastValidTokenID != null) {
            switch (this.lastValidTokenID) {
                case COLON: {
                    if (this.nrQuestions <= 0) break;
                }
                case WHITESPACE: 
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: 
                case DOXYGEN_LINE_COMMENT: 
                case LINE_COMMENT: 
                case STAR: 
                case AMP: 
                case GT: 
                case LBRACE: 
                case RBRACE: 
                case QUESTION: 
                case SEMICOLON: {
                    if (this.getValidExpID(this.peekExp()) == 17) break;
                }
                case EQ: 
                case EQEQ: 
                case GTEQ: 
                case GTGTEQ: 
                case AMPEQ: 
                case LTEQ: 
                case LTLTEQ: 
                case PLUSEQ: 
                case NOTEQ: 
                case MINUSEQ: 
                case STAREQ: 
                case SLASHEQ: 
                case BAREQ: 
                case CARETEQ: 
                case PERCENTEQ: 
                case LT: 
                case PLUSPLUS: 
                case MINUSMINUS: 
                case AMPAMP: 
                case BARBAR: 
                case LTLT: 
                case SLASH: 
                case BAR: 
                case CARET: 
                case PERCENT: 
                case GTGT: 
                case PLUS: 
                case MINUS: 
                case NOT: {
                    this.pushExp(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                    this.errorState = false;
                    break;
                }
                default: {
                    int validExpID = this.getValidExpID(this.peekExp());
                    if (validExpID != 17 && validExpID != 46) break;
                    this.pushExp(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                    this.errorState = false;
                    break;
                }
            }
        }
        boolean reScan = true;
        block50: while (reScan) {
            reScan = false;
            CsmCompletionExpression top = this.peekExp();
            CsmCompletionExpression top2 = this.peekExp2();
            int top2ID = this.getValidExpID(top2);
            if (top != null) {
                block5 : switch (this.getValidExpID(top)) {
                    case 1: {
                        switch (top2ID) {
                            case 5: 
                            case 26: 
                            case 28: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(this.openExpID2ExpID(top2ID));
                                reScan = true;
                                break block5;
                            }
                            case 15: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(12);
                                reScan = true;
                                break block5;
                            }
                            case 34: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(35);
                                return;
                            }
                            case 20: 
                            case 21: 
                            case 24: {
                                this.popExp();
                                top2.addParameter(top);
                                return;
                            }
                            case 18: {
                                return;
                            }
                        }
                        break;
                    }
                    case 17: {
                        switch (top2ID) {
                            case 5: 
                            case 26: 
                            case 28: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(this.openExpID2ExpID(top2ID));
                                reScan = true;
                                break block5;
                            }
                            case 15: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(12);
                                reScan = true;
                                continue block50;
                            }
                        }
                        break;
                    }
                    case 10: 
                    case 11: {
                        switch (top2ID) {
                            case 5: 
                            case 26: 
                            case 28: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(this.openExpID2ExpID(top2ID));
                                reScan = true;
                                break block5;
                            }
                            case 15: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(12);
                                reScan = true;
                                continue block50;
                            }
                        }
                        break;
                    }
                    case 53: {
                        switch (top2ID) {
                            case 5: 
                            case 26: 
                            case 28: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(this.openExpID2ExpID(top2ID));
                                reScan = true;
                                continue block50;
                            }
                        }
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: {
                        switch (top2ID) {
                            case 15: {
                                this.popExp();
                                top2.addParameter(top);
                                top2.setExpID(12);
                                reScan = true;
                                break;
                            }
                            case 20: 
                            case 21: {
                                this.popExp();
                                top2.addParameter(top);
                                return;
                            }
                            case 18: {
                                return;
                            }
                            case 2: {
                                CsmCompletionExpression top4 = this.peekExp(4);
                                if (this.getValidExpID(top4) == 21) {
                                    top2.addParameter(this.peekExp(3));
                                    top2.addParameter(top);
                                    top4.addParameter(top2);
                                    this.popExp();
                                    this.popExp();
                                    this.popExp();
                                    return;
                                }
                                continue block50;
                            }
                            case 33: {
                                this.popExp();
                                top2.addParameter(top);
                                return;
                            }
                        }
                        break;
                    }
                    case 6: 
                    case 8: {
                        this.pushExp(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                        break;
                    }
                    case 39: {
                        top.addParameter(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                        break;
                    }
                    case 18: {
                        if (top.getParameterCount() > 1) break;
                    }
                    case 24: {
                        top.addParameter(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                        break;
                    }
                    case 2: {
                        if (top2ID != 1) break;
                        CsmCompletionExpression top3 = this.peekExp(3);
                        if (this.getValidExpID(top3) != 21) continue block50;
                        top.addParameter(top2);
                        top.addParameter(CsmCompletionExpression.createEmptyVariable(offset));
                        top3.addParameter(top);
                        this.popExp();
                        this.popExp();
                        break;
                    }
                    case 33: {
                        this.popExp();
                        this.pushExp(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                        break;
                    }
                    case 3: {
                        switch (top2ID) {
                            case -1: {
                                this.popExp();
                                this.pushExp(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
                                break;
                            }
                            case 5: 
                            case 26: 
                            case 28: {
                                if (top.getParameterCount() != 0 || top.getTokenCount() != 1 || top.getTokenID(0) != CppTokenId.TILDE) break;
                                top.setExpID(1);
                                reScan = true;
                            }
                        }
                        continue block50;
                    }
                }
                continue;
            }
            this.pushExp(CsmCompletionExpression.createEmptyVariable(this.bufferStartPos + this.bufferOffsetDelta + offset));
        }
        return;
    }

    public String toString() {
        int cnt = this.expStack.size();
        StringBuilder sb = new StringBuilder();
        sb.append("Stack size is ").append(cnt).append("\n");
        if (cnt > 0) {
            sb.append("Stack expressions:\n");
            for (int i = 0; i < cnt; ++i) {
                CsmCompletionExpression e = this.expStack.get(i);
                sb.append("Stack[");
                sb.append(i);
                sb.append("]: ");
                sb.append(e.toString(0));
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    public boolean isStopped() {
        return false;
    }

    private int findNextExpr(int from, int targetId, int ... restrictedIds) {
        int cnt = this.expStack.size();
        for (int i = from; i < cnt; ++i) {
            CsmCompletionExpression expr = this.peekExp(i + 1);
            for (int restricted : restrictedIds) {
                if (expr.getExpID() != restricted) continue;
                return -1;
            }
            if (expr.getExpID() != targetId) continue;
            return i + 1;
        }
        return -1;
    }

    private boolean checkExp(CsmCompletionExpression exp, int expId) {
        return exp != null && exp.getExpID() == expId;
    }

    private boolean checkExpRow(int ... ids) {
        return this.shiftedCheckExpRow(0, ids);
    }

    private boolean shiftedCheckExpRow(int skipFromTop, int ... ids) {
        if (ids != null && ids.length > 0) {
            for (int i = 1; i <= ids.length; ++i) {
                if (this.checkExp(this.peekExp(i + skipFromTop), ids[ids.length - i])) continue;
                return false;
            }
        }
        return true;
    }

    private static enum LambdaLookaheadStage {
        capture,
        try_declarator_params,
        try_declarator_mutable,
        try_declarator_exception,
        try_declarator_attribute,
        declarator_attribute_parens,
        declarator_attribute_cpp11,
        try_declarator_trailing_type,
        declarator_trailing_type_rest,
        body,
        done;

    }

    private static class OffsetableToken {
        Token<TokenId> token;
        int offset;
        boolean macro;
        Boolean inPP;

        public OffsetableToken(Token<TokenId> token, int offset, boolean macro, Boolean inPP) {
            this.token = token;
            this.offset = offset;
            this.macro = macro;
            this.inPP = inPP;
        }

        public String toString() {
            return this.token.id().toString();
        }
    }
}

