/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.completion.csm.CompletionResolver;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmDeclarationResolver;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmProjectContentResolver;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.completion.impl.xref.SymTabCache;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.filesystems.FileObject;

public class CompletionResolverImpl
implements CompletionResolver {
    private static final boolean DEBUG_SUMMARY = Boolean.getBoolean("csm.utilities.trace.summary");
    private static final boolean TRACE = Boolean.getBoolean("csm.utilities.trace");
    private static final boolean DEBUG = TRACE | DEBUG_SUMMARY;
    private int resolveTypes = 0;
    private boolean resolveContextMode = false;
    private int hideTypes = -1;
    private CsmFile file;
    private CsmContext context;
    CompletionResolver.Result result = EMPTY_RESULT;
    CsmProjectContentResolver contResolver = null;
    private boolean caseSensitive = false;
    private boolean naturalSort = false;
    private boolean sort = false;
    private static final int NOT_INITIALIZED = -1;
    private int contextOffset = -1;
    private CsmScope contextScope = null;
    private CompletionResolver.QueryScope queryScope = CompletionResolver.QueryScope.GLOBAL_QUERY;
    private boolean inIncludeDirective = false;
    private final FileReferencesContext fileReferncesContext;
    public static final boolean STAT_COMPLETION = Boolean.getBoolean("cnd.completion.stat");
    public static final boolean TIMING_COMPLETION = Boolean.getBoolean("cnd.completion.timing") || STAT_COMPLETION;
    public static final boolean USE_CACHE = true;
    private static final CompletionResolver.Result EMPTY_RESULT = new EmptyResultImpl();

    public boolean isSortNeeded() {
        return this.sort;
    }

    public void setSortNeeded(boolean sort) {
        this.sort = sort;
    }

    public void setContextOffset(int offset) {
        this.contextOffset = offset;
    }

    public void setContextScope(CsmScope scope) {
        this.contextScope = scope;
    }

    @Override
    public CompletionResolver.QueryScope setResolveScope(CompletionResolver.QueryScope queryScope) {
        CompletionResolver.QueryScope oldScope = this.queryScope;
        this.queryScope = queryScope;
        return oldScope;
    }

    public void setInIncludeDirective(boolean inIncludeDirective) {
        this.inIncludeDirective = inIncludeDirective;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isNaturalSort() {
        return this.naturalSort;
    }

    public CompletionResolverImpl(CsmFile file) {
        this(file, false, false, false, null);
    }

    public CompletionResolverImpl(CsmFile file, boolean caseSensitive, boolean sort, boolean naturalSort, FileReferencesContext fileReferncesContext) {
        this(file, 1, caseSensitive, sort, naturalSort, fileReferncesContext);
    }

    private CompletionResolverImpl(CsmFile file, int resolveTypes, boolean caseSensitive, boolean sort, boolean naturalSort, FileReferencesContext fileReferncesContext) {
        this.file = file;
        this.resolveTypes = resolveTypes;
        this.resolveContextMode = (resolveTypes & 1) == 1;
        this.caseSensitive = caseSensitive;
        this.naturalSort = naturalSort;
        this.sort = sort;
        this.fileReferncesContext = fileReferncesContext;
    }

    @Override
    public void setResolveTypes(int resolveTypes) {
        this.resolveTypes = resolveTypes;
        this.resolveContextMode = (resolveTypes & 1) == 1;
    }

    @Override
    public boolean refresh() {
        this.result = EMPTY_RESULT;
        if (this.file != null && this.file.getProject() != null && !this.file.getProject().isValid()) {
            this.file = CsmUtilities.getCsmFile((FileObject)CsmUtilities.getFileObject((CsmFile)this.file), (boolean)true, (boolean)false);
        }
        this.context = null;
        this.contResolver = null;
        if (this.file == null) {
            return false;
        }
        this.contResolver = this.createContentResolver();
        return true;
    }

    public boolean update(boolean caseSensitive, boolean naturalSort) {
        this.caseSensitive = caseSensitive;
        this.naturalSort = naturalSort;
        return this.refresh();
    }

    @Override
    public boolean resolve(int docOffset, String strPrefix, boolean match) {
        int offset;
        int n = offset = this.contextOffset == -1 ? docOffset : this.contextOffset;
        if (this.file == null) {
            return false;
        }
        this.context = this.contextScope != null ? CsmOffsetResolver.findContextFromScope(this.file, offset, this.contextScope) : CsmOffsetResolver.findContext(this.file, offset, this.fileReferncesContext);
        if (DEBUG) {
            System.out.println("context for offset " + offset + " :\n" + this.context);
        }
        this.initResolveMask(this.context, offset, strPrefix, match);
        this.hideTypes = CompletionResolverImpl.initHideMask(this.context, offset, this.resolveTypes, this.queryScope, strPrefix, match, this.inIncludeDirective);
        this.resolveContext(this.context, offset, strPrefix, match);
        return this.file != null;
    }

    @Override
    public CompletionResolver.Result getResult() {
        return this.result;
    }

    private void resolveContext(CsmContext context, int offset, String strPrefix, boolean match) {
        CsmProject prj;
        long time = 0L;
        if (TIMING_COMPLETION) {
            time = System.currentTimeMillis();
            System.err.println("Started resolving context");
        }
        CsmProject csmProject = prj = this.file != null ? this.file.getProject() : null;
        if (prj == null) {
            return;
        }
        SymTabCache.CacheEntry key = null;
        CsmFunction fun = CsmContextUtilities.getFunction(context, true);
        ResultImpl resImpl = new ResultImpl();
        boolean isLocalVariable = this.resolveLocalContext(prj, resImpl, fun, context, offset, strPrefix, match);
        if (this.isEnough(strPrefix, match)) {
            if (isLocalVariable) {
                this.result = CompletionResolverImpl.buildResult(context, resImpl);
                return;
            }
            CsmFunction cacheDecl = null;
            if (fun != null) {
                cacheDecl = fun;
            } else if (CsmKindUtilities.isVariable((CsmObject)context.getLastObject())) {
                cacheDecl = (CsmVariable)context.getLastObject();
                if (CsmKindUtilities.isParameter((CsmObject)cacheDecl)) {
                    cacheDecl = null;
                } else {
                    CsmScope scope = ((CsmVariable)cacheDecl).getScope();
                    if (CsmKindUtilities.isClass((CsmObject)scope) || CsmKindUtilities.isEnum((CsmObject)scope)) {
                        cacheDecl = scope;
                    } else if (CsmKindUtilities.isNamespace((Object)scope)) {
                        cacheDecl = scope;
                    }
                }
            }
            if (CsmBaseUtilities.isValid((CsmObject)cacheDecl) && this.fileReferncesContext != null) {
                CsmUID uid = UIDs.get((Object)cacheDecl);
                key = new SymTabCache.CacheEntry(this.resolveTypes, this.hideTypes, strPrefix, uid);
                CompletionResolver.Result res = this.fileReferncesContext.getSymTabCache().get(key);
                if (res != null) {
                    this.result = res;
                    return;
                }
                this.fileReferncesContext.getSymTabCache().setScope(uid);
            }
        }
        this.resolveContext(prj, resImpl, context, offset, strPrefix, match);
        this.result = CompletionResolverImpl.buildResult(context, resImpl);
        if (key != null) {
            this.fileReferncesContext.getSymTabCache().put(key, this.result);
        }
        if (TIMING_COMPLETION) {
            time = System.currentTimeMillis() - time;
            System.err.println("Resolving context took " + time + "ms");
        }
    }

    private boolean isEnough(String strPrefix, boolean match) {
        return match && strPrefix != null && strPrefix.length() > 0;
    }

    private boolean isEnough(String strPrefix, boolean match, Collection<?> collection) {
        if (collection != null && this.isEnough(strPrefix, match)) {
            return !collection.isEmpty();
        }
        return false;
    }

    private boolean isEnoughAfterFilterVisibileObjects(String strPrefix, boolean match, Collection<? extends CsmObject> toCheck, Collection out) {
        boolean enough = false;
        boolean foundVisible = false;
        if (this.isEnough(strPrefix, match, toCheck)) {
            assert (toCheck != null && !toCheck.isEmpty());
            ArrayList<CsmObject> visibleObjs = new ArrayList<CsmObject>();
            ArrayList<CsmObject> visibleTypedefs = new ArrayList<CsmObject>();
            ArrayList<CsmObject> visibleFwd = new ArrayList<CsmObject>();
            CsmIncludeResolver resolver = CsmIncludeResolver.getDefault();
            CsmFile startFile = this.contResolver.getStartFile();
            for (CsmObject csmObject : toCheck) {
                boolean isVisible = false;
                if (CsmKindUtilities.isOffsetable((Object)csmObject)) {
                    isVisible = resolver.isObjectVisible(((CsmOffsetable)csmObject).getContainingFile(), (CsmObject)this.file);
                }
                if (!(isVisible |= resolver.isObjectVisible(startFile, csmObject))) continue;
                foundVisible = true;
                if (CsmClassifierResolver.getDefault().isForwardClassifier(csmObject)) {
                    visibleFwd.add(csmObject);
                    continue;
                }
                if (CsmKindUtilities.isTypedefOrTypeAlias((CsmObject)csmObject)) {
                    visibleTypedefs.add(csmObject);
                    enough = true;
                    continue;
                }
                visibleObjs.add(csmObject);
                enough = true;
            }
            if (foundVisible) {
                out.addAll(visibleObjs);
                out.addAll(visibleTypedefs);
                out.addAll(visibleFwd);
            }
        }
        return enough;
    }

    private boolean resolveLocalContext(CsmProject prj, ResultImpl resImpl, CsmFunction fun, CsmContext context, int offset, String strPrefix, boolean match) {
        boolean needVars = this.needLocalVars(context, offset);
        boolean needClasses = this.needLocalClasses(context, offset);
        if (needVars || needClasses) {
            List<CsmDeclaration> decls = this.contResolver.findFunctionLocalDeclarations(context, strPrefix, match);
            resImpl.localVars = new ArrayList(decls.size());
            for (CsmDeclaration elem : decls) {
                if (needVars && CsmKindUtilities.isVariable((CsmObject)elem)) {
                    resImpl.localVars.add((CsmVariable)elem);
                    if (this.isEnough(strPrefix, match)) {
                        return true;
                    }
                }
                if (needClasses && CsmKindUtilities.isClassifier((CsmObject)elem)) {
                    if (resImpl.classesEnumsTypedefs == null) {
                        resImpl.classesEnumsTypedefs = new ArrayList();
                    }
                    resImpl.classesEnumsTypedefs.add((CsmClassifier)elem);
                    if (this.isEnough(strPrefix, match)) {
                        return true;
                    }
                }
                if (needVars && CsmKindUtilities.isEnumerator((Object)elem)) {
                    if (resImpl.fileLocalEnumerators == null) {
                        resImpl.fileLocalEnumerators = new ArrayList();
                    }
                    resImpl.fileLocalEnumerators.add((CsmEnumerator)elem);
                    if (this.isEnough(strPrefix, match)) {
                        return true;
                    }
                }
                if (!needVars || !CsmKindUtilities.isFunction((CsmObject)elem)) continue;
                if (resImpl.fileLocalFunctions == null) {
                    resImpl.fileLocalFunctions = new ArrayList();
                }
                resImpl.fileLocalFunctions.add((CsmFunction)elem);
                if (!this.isEnough(strPrefix, match)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkNamespaceDeclarations() {
        switch (this.file.getFileType()) {
            case SOURCE_C_FILE: 
            case SOURCE_FORTRAN_FILE: {
                return false;
            }
        }
        return true;
    }

    private boolean resolveContext(CsmProject prj, ResultImpl resImpl, CsmContext context, int offset, String strPrefix, boolean match) {
        CsmFunction fun = CsmContextUtilities.getFunction(context, true);
        if (this.needLocalVars(context, offset)) {
            boolean staticContext;
            if (resImpl.fileLocalEnumerators == null) {
                resImpl.fileLocalEnumerators = new ArrayList();
            }
            resImpl.fileLocalEnumerators.addAll(this.contResolver.getFileLocalEnumerators(context, strPrefix, match));
            if (this.isEnough(strPrefix, match, resImpl.fileLocalEnumerators)) {
                return true;
            }
            boolean bl = staticContext = fun == null ? true : CsmBaseUtilities.isStaticContext((CsmFunction)fun);
            if (this.needClassElements(context, offset)) {
                boolean inspectOuterClasses = true;
                CsmFunction contextDeclaration = fun;
                CsmClass clazz = fun == null ? null : CsmBaseUtilities.getFunctionClass((CsmFunction)fun);
                CsmClass csmClass = clazz = clazz != null ? clazz : CsmContextUtilities.getClass(context, false, true);
                if (clazz == null && (clazz = CsmBaseUtilities.getFunctionClassByQualifiedName((CsmFunction)fun)) != null) {
                    Iterator classMembers;
                    CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createNameFilter(fun.getName(), true, this.caseSensitive, false);
                    Iterator it = classMembers = CsmSelect.getClassMembers((CsmClass)clazz, (CsmSelect.CsmFilter)filter);
                    while (it.hasNext()) {
                        CsmMember member = (CsmMember)it.next();
                        if (!CsmKindUtilities.isVariable((CsmObject)member)) continue;
                        contextDeclaration = member;
                        staticContext = member.isStatic();
                    }
                }
                if (clazz != null) {
                    if (this.resolveCurrentClassInsideType(clazz, resImpl, context, offset, strPrefix, match)) {
                        return true;
                    }
                    if (this.needClassFields(context, offset)) {
                        resImpl.classFields = this.contResolver.getFields(clazz, (CsmOffsetableDeclaration)contextDeclaration, strPrefix, staticContext, match, true, inspectOuterClasses, false);
                        if (this.isEnough(strPrefix, match, resImpl.classFields)) {
                            return true;
                        }
                    }
                    if (this.needClassEnumerators(context, offset)) {
                        resImpl.classEnumerators = this.contResolver.getEnumerators(clazz, (CsmOffsetableDeclaration)contextDeclaration, strPrefix, match, true, inspectOuterClasses, false);
                        if (this.isEnough(strPrefix, match, resImpl.classEnumerators)) {
                            return true;
                        }
                    }
                    if (this.needClassMethods(context, offset)) {
                        resImpl.classMethods = this.contResolver.getMethods(clazz, (CsmOffsetableDeclaration)contextDeclaration, strPrefix, staticContext, match, true, inspectOuterClasses, false);
                        if (this.isEnough(strPrefix, match, resImpl.classMethods)) {
                            return true;
                        }
                    }
                    if (this.needNestedClassifiers(context, offset)) {
                        resImpl.classesEnumsTypedefs = this.contResolver.getNestedClassifiers(clazz, (CsmOffsetableDeclaration)contextDeclaration, strPrefix, match, this.needClasses(context, offset), inspectOuterClasses, this.resolveContextMode);
                        if (this.isEnough(strPrefix, match, resImpl.classesEnumsTypedefs)) {
                            return true;
                        }
                    }
                }
            }
        } else if (this.needClassElements(context, offset)) {
            CsmClass clazz = fun == null ? null : CsmBaseUtilities.getFunctionClass((CsmFunction)fun);
            CsmClass csmClass = clazz = clazz != null ? clazz : CsmContextUtilities.getClass(context, false, true);
            if (clazz != null) {
                int phase;
                boolean staticContext = false;
                if (this.resolveCurrentClassInsideType(clazz, resImpl, context, offset, strPrefix, match)) {
                    return true;
                }
                CsmFunction contextDeclaration = fun != null ? fun : clazz;
                int n = phase = match ? 0 : 1;
                while (phase < 2) {
                    boolean inspectOuterAndParentClasses;
                    boolean bl = inspectOuterAndParentClasses = phase == 1;
                    if (this.needClassMethods(context, offset)) {
                        resImpl.classMethods = this.contResolver.getMethods(clazz, (CsmOffsetableDeclaration)contextDeclaration, strPrefix, staticContext, match, inspectOuterAndParentClasses, inspectOuterAndParentClasses, false);
                        if (this.isEnough(strPrefix, match, resImpl.classMethods)) {
                            return true;
                        }
                    }
                    if (this.needClassFields(context, offset)) {
                        resImpl.classFields = this.contResolver.getFields(clazz, (CsmOffsetableDeclaration)contextDeclaration, strPrefix, staticContext, match, inspectOuterAndParentClasses, inspectOuterAndParentClasses, false);
                        if (this.isEnough(strPrefix, match, resImpl.classFields)) {
                            return true;
                        }
                    }
                    if (this.needClassEnumerators(context, offset)) {
                        resImpl.classEnumerators = this.contResolver.getEnumerators(clazz, (CsmOffsetableDeclaration)contextDeclaration, strPrefix, match, inspectOuterAndParentClasses, inspectOuterAndParentClasses, false);
                        if (this.isEnough(strPrefix, match, resImpl.classEnumerators)) {
                            return true;
                        }
                    }
                    if (this.needNestedClassifiers(context, offset)) {
                        resImpl.classesEnumsTypedefs = this.contResolver.getNestedClassifiers(clazz, (CsmOffsetableDeclaration)contextDeclaration, strPrefix, match, inspectOuterAndParentClasses, inspectOuterAndParentClasses, this.resolveContextMode);
                        if (this.isEnough(strPrefix, match, resImpl.classesEnumsTypedefs)) {
                            return true;
                        }
                    }
                    ++phase;
                }
            }
        }
        if (this.needTemplateParameters(context, offset)) {
            resImpl.templateParameters = this.getTemplateParameters(context, strPrefix, match, offset);
            if (this.isEnough(strPrefix, match, resImpl.templateParameters)) {
                return true;
            }
        }
        if (this.needClasses(context, offset) || this.needContextClasses(context, offset)) {
            if (resImpl.classesEnumsTypedefs == null) {
                resImpl.classesEnumsTypedefs = new LinkedHashSet();
            } else {
                resImpl.classesEnumsTypedefs = new LinkedHashSet(resImpl.classesEnumsTypedefs);
            }
            Collection<CsmClassifier> classesEnums = this.getClassesEnums(context, prj, strPrefix, match, offset, !this.needClasses(context, offset));
            ArrayList visibleClassesEnums = new ArrayList();
            if (this.isEnoughAfterFilterVisibileObjects(strPrefix, match, classesEnums, visibleClassesEnums)) {
                resImpl.classesEnumsTypedefs.addAll(visibleClassesEnums);
                return true;
            }
            resImpl.classesEnumsTypedefs.addAll(classesEnums);
        }
        if (this.needFileLocalMacros(context, offset)) {
            resImpl.fileLocalMacros = this.contResolver.getFileLocalMacros(context, strPrefix, match);
            if (this.isEnough(strPrefix, match, resImpl.fileLocalMacros)) {
                return true;
            }
        }
        if (this.needFileLocalFunctions(context, offset)) {
            if (resImpl.fileLocalFunctions == null) {
                resImpl.fileLocalFunctions = new ArrayList();
            }
            resImpl.fileLocalFunctions.addAll(this.getFileLocalFunctions(context, strPrefix, match));
            if (this.isEnough(strPrefix, match, resImpl.fileLocalFunctions)) {
                return true;
            }
        }
        if (this.needFileLocalVars(context, offset)) {
            if (this.fileReferncesContext != null && !this.fileReferncesContext.isCleaned()) {
                this.fileReferncesContext.advance(offset);
            }
            resImpl.fileLocalVars = this.contResolver.getFileLocalVariables(context, this.fileReferncesContext, strPrefix, match, this.queryScope == CompletionResolver.QueryScope.LOCAL_QUERY || this.queryScope == CompletionResolver.QueryScope.GLOBAL_QUERY);
            if (this.isEnough(strPrefix, match, resImpl.fileLocalVars)) {
                return true;
            }
            if (resImpl.fileLocalEnumerators == null) {
                resImpl.fileLocalEnumerators = this.contResolver.getFileLocalEnumerators(context, strPrefix, match);
                if (this.isEnough(strPrefix, match, resImpl.fileLocalEnumerators)) {
                    return true;
                }
            }
        }
        if (this.needFileIncludedMacros(context, offset)) {
            if (this.fileReferncesContext != null && !this.fileReferncesContext.isCleaned()) {
                this.fileReferncesContext.advance(offset);
                CsmMacro macro = this.fileReferncesContext.findIncludedMacro(strPrefix);
                if (macro != null) {
                    resImpl.fileProjectMacros = new ArrayList(1);
                    resImpl.fileProjectMacros.add(macro);
                }
                if (this.isEnough(strPrefix, match, resImpl.fileProjectMacros)) {
                    return true;
                }
            } else {
                resImpl.fileProjectMacros = this.contResolver.getFileIncludedProjectMacros(context, strPrefix, match);
            }
        }
        if (this.needFileIncludedLibMacros(context, offset)) {
            if (this.fileReferncesContext != null && !this.fileReferncesContext.isCleaned()) {
                this.fileReferncesContext.advance(offset);
                CsmMacro macro = this.fileReferncesContext.findIncludedMacro(strPrefix);
                if (macro != null) {
                    resImpl.fileLibMacros = new ArrayList(1);
                    resImpl.fileLibMacros.add(macro);
                }
            } else {
                resImpl.fileLibMacros = this.contResolver.getFileIncludeLibMacros(context, strPrefix, match);
            }
            if (this.isEnough(strPrefix, match, resImpl.fileLibMacros)) {
                return true;
            }
        }
        if (this.needGlobalMacros(context, offset)) {
            resImpl.globProjectMacros = this.contResolver.getProjectMacros(context, strPrefix, match);
            if (this.isEnough(strPrefix, match, resImpl.globProjectMacros)) {
                return true;
            }
        }
        if (this.needGlobalLibMacros(context, offset)) {
            resImpl.globLibMacros = this.contResolver.getLibMacros(context, strPrefix, match);
            if (this.isEnough(strPrefix, match, resImpl.globLibMacros)) {
                return true;
            }
        }
        if (this.needGlobalVariables(context, offset)) {
            resImpl.globVars = this.getGlobalVariables(context, prj, strPrefix, match, offset);
            if (this.isEnough(strPrefix, match, resImpl.globVars)) {
                return true;
            }
        }
        if (this.needGlobalEnumerators(context, offset)) {
            resImpl.globEnumerators = this.getGlobalEnumerators(context, prj, strPrefix, match, offset);
            if (this.isEnough(strPrefix, match, resImpl.globEnumerators)) {
                return true;
            }
        }
        if (this.needGlobalFunctions(context, offset)) {
            resImpl.globFuns = this.getGlobalFunctions(context, prj, strPrefix, match, offset);
            if (this.isEnough(strPrefix, match, resImpl.globFuns)) {
                return true;
            }
        }
        if (this.needGlobalNamespaces(context, offset)) {
            resImpl.projectNsAliases = this.getProjectNamespaceAliases(context, prj, strPrefix, match, offset);
            if (this.isEnough(strPrefix, match, resImpl.projectNsAliases)) {
                return true;
            }
            resImpl.globProjectNSs = this.getGlobalNamespaces(context, prj, strPrefix, match, offset);
            if (this.isEnough(strPrefix, match, resImpl.globProjectNSs)) {
                return true;
            }
        }
        if (this.needLibClasses(context, offset)) {
            ArrayList visibleClassesEnums;
            Collection<CsmClassifier> libClassesEnums;
            if (resImpl.libClasses == null) {
                resImpl.libClasses = new ArrayList();
            }
            if (this.isEnoughAfterFilterVisibileObjects(strPrefix, match, libClassesEnums = this.getLibClassesEnums(prj, strPrefix, match), visibleClassesEnums = new ArrayList())) {
                resImpl.classesEnumsTypedefs.clear();
                resImpl.libClasses.addAll(visibleClassesEnums);
                return true;
            }
            resImpl.libClasses.addAll(libClassesEnums);
        }
        if (this.needLibVariables(context, offset)) {
            resImpl.libVars = this.getLibVariables(prj, strPrefix, match);
            if (this.isEnough(strPrefix, match, resImpl.libVars)) {
                return true;
            }
        }
        if (this.needLibEnumerators(context, offset)) {
            resImpl.libEnumerators = this.getLibEnumerators(prj, strPrefix, match);
            if (this.isEnough(strPrefix, match, resImpl.libEnumerators)) {
                return true;
            }
        }
        if (this.needLibFunctions(context, offset)) {
            resImpl.libFuns = this.getLibFunctions(prj, strPrefix, match);
            if (this.isEnough(strPrefix, match, resImpl.libFuns)) {
                return true;
            }
        }
        if (this.needLibNamespaces(context, offset)) {
            resImpl.libNSs = this.getLibNamespaces(prj, strPrefix, match);
            if (this.isEnough(strPrefix, match, resImpl.libNSs)) {
                return true;
            }
        }
        return false;
    }

    private boolean resolveCurrentClassInsideType(CsmClass clazz, ResultImpl resImpl, CsmContext context, int offset, String strPrefix, boolean match) {
        if (this.needClasses(context, offset) && CsmContextUtilities.isInType(context, offset) && CsmSortUtilities.matchName((CharSequence)clazz.getName(), (CharSequence)strPrefix, (boolean)match, (boolean)this.caseSensitive)) {
            if (resImpl.classesEnumsTypedefs == null) {
                resImpl.classesEnumsTypedefs = new LinkedHashSet();
            }
            resImpl.classesEnumsTypedefs.add(clazz);
            if (this.isEnough(strPrefix, match, resImpl.classesEnumsTypedefs)) {
                return true;
            }
        }
        return false;
    }

    private static int initHideMask(CsmContext context, int offset, int resolveTypes, CompletionResolver.QueryScope queryScope, String strPrefix, boolean match, boolean inIncludeDirective) {
        int hideTypes;
        int n = hideTypes = inIncludeDirective ? 507904 : -1;
        if ((resolveTypes & 1) == 1 && strPrefix.length() == 0) {
            hideTypes &= 0xFFEAE1FF;
            if (!CsmKindUtilities.isFile((CsmObject)context.getLastScope())) {
                hideTypes &= 0xFFFDFFFF;
            }
        }
        if (queryScope == CompletionResolver.QueryScope.LOCAL_QUERY || queryScope == CompletionResolver.QueryScope.SMART_QUERY) {
            hideTypes &= 0xFFEAE1FF;
            hideTypes &= 0xFFFDFFFF;
            hideTypes &= 0xFFFF7FFF;
            hideTypes &= 0xFFF7FFFF;
            hideTypes &= 0xFFFFFFFD;
            hideTypes &= 0xFFFFFFFB;
            hideTypes &= 0xFFFFFFF7;
            hideTypes &= 0xFFFFDFFF;
        }
        if (queryScope == CompletionResolver.QueryScope.LOCAL_QUERY) {
            hideTypes &= 0xFFFFFFEF;
            hideTypes &= 0xFFFFFFDF;
            hideTypes &= 0xFFBFFFFF;
            hideTypes &= 0xFFDFFFFF;
        }
        if (match) {
            hideTypes |= 2;
            hideTypes |= 0x200;
        }
        if (CsmContextUtilities.isInSimpleType(context, offset)) {
            hideTypes &= 0xFFFFFFEF;
            hideTypes &= 0xFFFFFFDF;
            hideTypes &= 0xFFDFFFFF;
        }
        if (CsmContextUtilities.isInForwardDeclaration(context, offset)) {
            hideTypes &= 0xFFFFFFEF;
            hideTypes &= 0xFFFFFFDF;
        }
        return hideTypes;
    }

    private static CompletionResolver.Result buildResult(CsmContext context, ResultImpl out) {
        int fullSize = 0;
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.localVars, "Local variables");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.classFields, "Class fields");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.classEnumerators, "Class enumerators");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.classMethods, "Class methods");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.classesEnumsTypedefs, "Classes/Enums/Typedefs");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.fileLocalVars, "File Local Variables");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.fileLocalEnumerators, "File Local Enumerators");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.fileLocalMacros, "File Local Macros");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.fileLocalFunctions, "File Local Functions");
        }
        CompletionResolverImpl.remove(out.fileProjectMacros, out.fileLocalMacros);
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.fileProjectMacros, "File Included Project Macros");
        }
        CompletionResolverImpl.remove(out.globVars, out.fileLocalVars);
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.globVars, "Global variables");
        }
        CompletionResolverImpl.remove(out.globEnumerators, out.fileLocalEnumerators);
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.globEnumerators, "Global enumerators");
        }
        CompletionResolverImpl.remove(out.globProjectMacros, out.fileProjectMacros);
        CompletionResolverImpl.remove(out.globProjectMacros, out.fileLocalMacros);
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.globProjectMacros, "Global Project Macros");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.globFuns, "Global Project functions");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.globProjectNSs, "Global Project Namespaces");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.projectNsAliases, "Project Namespace Aliases");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.libClasses, "Library classes");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.fileLibMacros, "File Included Library Macros");
        }
        CompletionResolverImpl.remove(out.globLibMacros, out.fileLibMacros);
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.globLibMacros, "Global Library Macros");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.libVars, "Global Library variables");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.libEnumerators, "Global Library enumerators");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.libFuns, "Global Library functions");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.libNSs, "Global Library Namespaces");
        }
        if (DEBUG || STAT_COMPLETION) {
            fullSize += CompletionResolverImpl.trace(out.libNsAliases, "Global Library Namespace Aliases");
        }
        if (DEBUG || STAT_COMPLETION) {
            CompletionResolverImpl.trace(null, "There are " + fullSize + " resovled elements");
        }
        return out;
    }

    private static <T> Collection<T> remove(Collection<T> dest, Collection<T> removeItems) {
        CsmUtilities.removeAll(dest, removeItems);
        return dest;
    }

    protected CsmProjectContentResolver createContentResolver() {
        CsmProject filePrj;
        CsmFile contextFile = this.file;
        CsmProject startProject = filePrj = contextFile.getProject();
        CsmFile startProjectFile = this.file;
        ArrayList<CsmProject> libs = new ArrayList<CsmProject>();
        boolean replaceProject = startProject.isArtificial();
        for (CsmCompilationUnit cu : CsmFileInfoQuery.getDefault().getCompilationUnits(this.file, this.contextOffset)) {
            CsmFile startFile = cu.getStartFile();
            CsmProject prj = startFile == null ? null : startFile.getProject();
            if (prj == null) continue;
            startProject = replaceProject ? prj : startProject;
            startProjectFile = startFile;
            break;
        }
        libs.addAll(startProject.getLibraries());
        CsmProjectContentResolver resolver = new CsmProjectContentResolver(startProjectFile, filePrj, this.isCaseSensitive(), this.isSortNeeded(), this.isNaturalSort(), libs);
        return resolver;
    }

    private static Collection merge(Collection orig, Collection newList) {
        return CsmUtilities.merge((Collection)orig, (Collection)newList);
    }

    private Collection<CsmTemplateParameter> getTemplateParameters(CsmContext context, String strPrefix, boolean match, int offset) {
        CsmClass clazz;
        ArrayList<CsmTemplateParameter> templateParameters = null;
        CsmFunction fun = CsmContextUtilities.getFunction(context, false);
        ArrayList<CsmTemplate> analyzeTemplates = new ArrayList<CsmTemplate>();
        if (fun == null && context.getLastObject() != null) {
            CsmObject obj = context.getLastObject();
            if (CsmKindUtilities.isFunction((CsmObject)obj)) {
                fun = (CsmFunction)obj;
            } else {
                obj = CsmDeclarationResolver.findInnerFileObject(this.file, offset, context, this.fileReferncesContext);
                if (CsmKindUtilities.isFunction((CsmObject)obj)) {
                    fun = (CsmFunction)obj;
                } else if ((CsmKindUtilities.isClassForwardDeclaration((CsmObject)obj) || CsmKindUtilities.isEnumForwardDeclaration((CsmObject)obj)) && CsmKindUtilities.isTemplate((CsmObject)obj)) {
                    analyzeTemplates.add((CsmTemplate)obj);
                }
            }
            if (CsmKindUtilities.isTemplate((CsmObject)obj) && obj != fun) {
                analyzeTemplates.add((CsmTemplate)obj);
            }
        }
        if (CsmKindUtilities.isTemplate((CsmObject)fun)) {
            analyzeTemplates.add((CsmTemplate)fun);
        }
        CsmClass funClass = fun == null ? null : CsmBaseUtilities.getFunctionClass((CsmFunction)fun);
        CsmClass contextClass = CsmContextUtilities.getClass(context, false, false);
        CsmClass csmClass = clazz = funClass != null ? funClass : contextClass;
        if (clazz == null && CsmKindUtilities.isClassForwardDeclaration((CsmObject)context.getLastScope())) {
            clazz = (CsmClassForwardDeclaration)context.getLastScope();
        }
        if (clazz != null) {
            if (CsmKindUtilities.isTemplate((CsmObject)clazz) && !analyzeTemplates.contains((CsmTemplate)clazz)) {
                analyzeTemplates.add((CsmTemplate)clazz);
            }
            CsmScope scope = clazz.getScope();
            while (CsmKindUtilities.isClass((CsmObject)scope)) {
                if (CsmKindUtilities.isTemplate((CsmObject)scope)) {
                    analyzeTemplates.add((CsmTemplate)scope);
                }
                scope = ((CsmClass)scope).getScope();
            }
        }
        if (!analyzeTemplates.isEmpty()) {
            templateParameters = new ArrayList<CsmTemplateParameter>();
            for (CsmTemplate csmTemplate : analyzeTemplates) {
                this.getTemplateParameters(csmTemplate, strPrefix, match, templateParameters);
            }
        }
        return templateParameters;
    }

    private void getTemplateParameters(CsmTemplate template, String strPrefix, boolean match, Collection<CsmTemplateParameter> out) {
        for (CsmTemplateParameter elem : template.getTemplateParameters()) {
            if (CsmSortUtilities.matchName((CharSequence)elem.getName(), (CharSequence)strPrefix, (boolean)match, (boolean)this.caseSensitive)) {
                out.add(elem);
            }
            if (!CsmKindUtilities.isTemplate((CsmObject)elem)) continue;
            this.getTemplateParameters((CsmTemplate)elem, strPrefix, match, out);
        }
    }

    private Collection<CsmClassifier> getClassesEnums(CsmContext context, CsmProject prj, String strPrefix, boolean match, int offset, boolean contextOnly) {
        if (prj == null) {
            return null;
        }
        Collection<CsmNamespace> namespaces = this.getNamespacesToSearch(context, this.file, offset, strPrefix.length() == 0, contextOnly);
        LinkedHashSet<CsmClassifier> out = new LinkedHashSet<CsmClassifier>(1024);
        for (CsmNamespace ns : namespaces) {
            List<CsmClassifier> res = this.contResolver.getNamespaceClassesEnums(ns, strPrefix, match, false);
            out.addAll(res);
        }
        CsmDeclaration.Kind[] kinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION, CsmDeclaration.Kind.ENUM_FORWARD_DECLARATION, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF, CsmDeclaration.Kind.TYPEALIAS};
        if (!contextOnly && this.checkNamespaceDeclarations()) {
            Collection<CsmDeclaration> usedDecls = this.getUsedDeclarations(this.file, offset, strPrefix, match, kinds);
            out.addAll(usedDecls);
        }
        if (out.isEmpty() && match) {
            out.addAll(prj.findClassifiers((CharSequence)strPrefix));
        }
        return out;
    }

    private Collection<CsmVariable> getGlobalVariables(CsmContext context, CsmProject prj, String strPrefix, boolean match, int offset) {
        Collection<CsmNamespace> namespaces = this.getNamespacesToSearch(context, this.file, offset, strPrefix.length() == 0, false);
        LinkedHashSet<CsmVariable> out = new LinkedHashSet<CsmVariable>(1024);
        for (CsmNamespace ns : namespaces) {
            List<CsmVariable> res = this.contResolver.getNamespaceVariables(ns, strPrefix, match, false);
            out.addAll(res);
        }
        CsmDeclaration.Kind[] kinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE};
        if (this.checkNamespaceDeclarations()) {
            Collection<CsmDeclaration> usedDecls = this.getUsedDeclarations(this.file, offset, strPrefix, match, kinds);
            out.addAll(usedDecls);
        }
        return out;
    }

    private Collection<CsmEnumerator> getGlobalEnumerators(CsmContext context, CsmProject prj, String strPrefix, boolean match, int offset) {
        CsmEnumerator hotSpotEnum;
        if (this.isEnough(strPrefix, match) && this.fileReferncesContext != null && !this.fileReferncesContext.isCleaned() && (hotSpotEnum = this.fileReferncesContext.getHotSpotEnum(strPrefix)) != null) {
            return Collections.singleton(hotSpotEnum);
        }
        Collection<CsmNamespace> namespaces = this.getNamespacesToSearch(context, this.file, offset, strPrefix.length() == 0, false);
        LinkedHashSet<CsmEnumerator> out = new LinkedHashSet<CsmEnumerator>(1024);
        for (CsmNamespace ns : namespaces) {
            List<CsmEnumerator> res = this.contResolver.getNamespaceEnumerators(ns, strPrefix, match, false);
            out.addAll(res);
        }
        if (this.isEnough(strPrefix, match, out) && this.fileReferncesContext != null && !this.fileReferncesContext.isCleaned()) {
            this.fileReferncesContext.putHotSpotEnum(out);
        }
        return out;
    }

    private Collection<CsmFunction> getGlobalFunctions(CsmContext context, CsmProject prj, String strPrefix, boolean match, int offset) {
        Collection<CsmNamespace> namespaces = this.getNamespacesToSearch(context, this.file, offset, strPrefix.length() == 0, false);
        LinkedHashSet<CsmFunction> out = new LinkedHashSet<CsmFunction>(1024);
        for (CsmNamespace ns : namespaces) {
            List<CsmFunction> res = this.contResolver.getNamespaceFunctions(ns, strPrefix, match, false);
            out.addAll(res);
        }
        CsmDeclaration.Kind[] kinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION};
        if (this.checkNamespaceDeclarations()) {
            Collection<CsmDeclaration> usedDecls = this.getUsedDeclarations(this.file, offset, strPrefix, match, kinds);
            out.addAll(usedDecls);
        }
        return out;
    }

    private Collection<CsmFunction> getFileLocalFunctions(CsmContext context, String strPrefix, boolean match) {
        List<CsmFunction> res = this.contResolver.getFileLocalFunctions(context, strPrefix, match, this.queryScope == CompletionResolver.QueryScope.LOCAL_QUERY);
        return res;
    }

    private Collection<CsmNamespace> getGlobalNamespaces(CsmContext context, CsmProject prj, String strPrefix, boolean match, int offset) {
        Collection<CsmNamespace> namespaces = this.getNamespacesToSearch(context, this.file, offset, strPrefix.length() == 0, false);
        LinkedHashSet<CsmNamespace> out = new LinkedHashSet<CsmNamespace>(1024);
        for (CsmNamespace ns : namespaces) {
            List<CsmNamespace> res = this.contResolver.getNestedNamespaces(ns, strPrefix, match, false);
            out.addAll(res);
        }
        return out;
    }

    private Collection<CsmNamespaceAlias> getProjectNamespaceAliases(CsmContext context, CsmProject prj, String strPrefix, boolean match, int offset) {
        if (!this.checkNamespaceDeclarations()) {
            return Collections.emptyList();
        }
        CsmProject inProject = strPrefix.length() == 0 ? prj : null;
        Collection aliases = CsmUsingResolver.getDefault().findNamespaceAliases(this.file, offset, inProject);
        LinkedHashSet<CsmNamespaceAlias> out = new LinkedHashSet();
        if (strPrefix.length() > 0) {
            out = this.filterDeclarations(aliases, strPrefix, match, new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_ALIAS});
        } else {
            out.addAll(aliases);
        }
        Collection<CsmNamespace> namespaces = this.getNamespacesToSearch(context, this.file, offset, strPrefix.length() == 0, false);
        for (CsmNamespace ns : namespaces) {
            List<CsmNamespaceAlias> aliases2 = this.contResolver.getNamespaceAliases(ns, strPrefix, match, match);
            for (CsmNamespaceAlias alias : aliases2) {
                if (!alias.getContainingFile().equals(this.file) || alias.getEndOffset() >= offset) continue;
                out.add(alias);
            }
        }
        return out;
    }

    private Collection<CsmClassifier> getLibClassesEnums(CsmProject prj, String strPrefix, boolean match) {
        return this.contResolver.getLibClassesEnums(strPrefix, match);
    }

    private Collection<CsmVariable> getLibVariables(CsmProject prj, String strPrefix, boolean match) {
        return this.contResolver.getLibVariables(strPrefix, match);
    }

    private Collection<CsmEnumerator> getLibEnumerators(CsmProject prj, String strPrefix, boolean match) {
        Collection<CsmEnumerator> res = null;
        if (this.fileReferncesContext != null && match) {
            res = this.fileReferncesContext.getLibEnumerators(strPrefix);
        }
        if (res == null) {
            res = this.contResolver.getLibEnumerators(strPrefix, match, true);
            if (this.fileReferncesContext != null && match) {
                this.fileReferncesContext.putLibEnumerators(strPrefix, res);
            }
        }
        return res;
    }

    private Collection<CsmFunction> getLibFunctions(CsmProject prj, String strPrefix, boolean match) {
        return this.contResolver.getLibFunctions(strPrefix, match);
    }

    private Collection<CsmNamespace> getLibNamespaces(CsmProject prj, String strPrefix, boolean match) {
        return this.contResolver.getLibNamespaces(strPrefix, match);
    }

    private boolean needLocalClasses(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x80) == 128;
    }

    private boolean needClasses(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 2) == 2;
    }

    private boolean needContextClasses(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x1000000) == 0x1000000;
    }

    private void updateResolveTypesInFunction(int offset, CsmContext context, boolean match) {
        this.resolveTypes |= 0x80;
        boolean isInType = CsmContextUtilities.isInSimpleType(context, offset);
        if (!isInType) {
            this.resolveTypes |= 0x100;
            this.resolveTypes |= 0x40;
            this.resolveTypes |= 4;
            this.resolveTypes |= 0x2000;
            this.resolveTypes |= 0x10;
            this.resolveTypes |= 0x200000;
            this.resolveTypes |= 0x1000;
        }
        if (CsmContextUtilities.isInFunctionBodyOrInitializerListOrCastOperatorType(context, offset)) {
            if (!isInType || !match) {
                this.resolveTypes |= 0x400;
                this.resolveTypes |= 8;
                this.resolveTypes |= 0x800000;
                this.resolveTypes |= 0x800;
                this.resolveTypes |= 0x20;
            }
            if (!match) {
                this.resolveTypes |= 0x100;
                this.resolveTypes |= 0x40;
                this.resolveTypes |= 4;
                this.resolveTypes |= 0x10;
                this.resolveTypes |= 0x200000;
            }
        }
    }

    private boolean needFileLocalVars(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x100) == 256;
    }

    private boolean needLocalVars(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x40) == 64;
    }

    private boolean needGlobalVariables(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 4) == 4;
    }

    private boolean needGlobalEnumerators(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x2000) == 8192;
    }

    private boolean needGlobalFunctions(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 8) == 8;
    }

    private boolean needGlobalNamespaces(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x80000) == 524288;
    }

    private boolean needFunctionVars(CsmContext context, int offset) {
        return this.needLocalVars(context, offset);
    }

    private boolean needLibClasses(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x200) == 512;
    }

    private boolean needLibVariables(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x400) == 1024;
    }

    private boolean needLibEnumerators(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x1000) == 4096;
    }

    private boolean needLibFunctions(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x800) == 2048;
    }

    private boolean needLibNamespaces(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x100000) == 0x100000;
    }

    private boolean needFileLocalMacros(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x4000) == 16384;
    }

    private boolean needFileLocalFunctions(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x800000) == 0x800000;
    }

    private boolean needFileIncludedMacros(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x8000) == 32768;
    }

    private boolean needFileIncludedLibMacros(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x10000) == 65536;
    }

    private boolean needGlobalMacros(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x20000) == 131072;
    }

    private boolean needGlobalLibMacros(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x40000) == 262144;
    }

    private boolean needClassMethods(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x20) == 32;
    }

    private boolean needClassFields(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x10) == 16;
    }

    private boolean needClassEnumerators(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x200000) == 0x200000;
    }

    private boolean needNestedClassifiers(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x400000) == 0x400000;
    }

    private boolean needClassElements(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x20) == 32 || (this.hideTypes & this.resolveTypes & 0x10) == 16 || (this.hideTypes & this.resolveTypes & 0x400000) == 0x400000 || (this.hideTypes & this.resolveTypes & 0x200000) == 0x200000;
    }

    private boolean needTemplateParameters(CsmContext context, int offset) {
        return (this.hideTypes & this.resolveTypes & 0x2000000) == 0x2000000;
    }

    private static int trace(Collection<? extends CsmObject> list, String msg) {
        System.err.println("\t" + msg + " [size - " + (list == null ? "null" : Integer.valueOf(list.size())) + "]");
        if (list == null) {
            return 0;
        }
        if (TRACE) {
            int i = 0;
            for (CsmObject csmObject : list) {
                System.err.println("\t\t[" + i + "]" + CsmUtilities.getCsmName((CsmObject)csmObject));
                ++i;
            }
        }
        return list.size();
    }

    private static <T> Collection<T> maskNull(Collection<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    private static <T> Collection appendResult(Collection<T> dest, ResultImpl result) {
        assert (dest != null);
        CompletionResolverImpl.merge(dest, result.localVars);
        CompletionResolverImpl.merge(dest, result.classFields);
        CompletionResolverImpl.merge(dest, result.classEnumerators);
        CompletionResolverImpl.merge(dest, result.classMethods);
        CompletionResolverImpl.merge(dest, result.classesEnumsTypedefs);
        CompletionResolverImpl.merge(dest, result.fileLocalVars);
        CompletionResolverImpl.merge(dest, result.fileLocalEnumerators);
        CompletionResolverImpl.merge(dest, result.fileLocalMacros);
        CompletionResolverImpl.merge(dest, result.fileLocalFunctions);
        CompletionResolverImpl.merge(dest, result.fileProjectMacros);
        CompletionResolverImpl.merge(dest, result.globVars);
        CompletionResolverImpl.merge(dest, result.globEnumerators);
        CompletionResolverImpl.merge(dest, result.globProjectMacros);
        CompletionResolverImpl.merge(dest, result.globFuns);
        CompletionResolverImpl.merge(dest, result.globProjectNSs);
        CompletionResolverImpl.merge(dest, result.projectNsAliases);
        CompletionResolverImpl.merge(dest, result.libClasses);
        CompletionResolverImpl.merge(dest, result.fileLibMacros);
        CompletionResolverImpl.merge(dest, result.globLibMacros);
        CompletionResolverImpl.merge(dest, result.libVars);
        CompletionResolverImpl.merge(dest, result.libEnumerators);
        CompletionResolverImpl.merge(dest, result.libFuns);
        CompletionResolverImpl.merge(dest, result.libNSs);
        CompletionResolverImpl.merge(dest, result.libNsAliases);
        CompletionResolverImpl.merge(dest, result.templateParameters);
        return dest;
    }

    private void initResolveMask(CsmContext context, int offset, String strPrefix, boolean match) {
        if ((this.resolveTypes & 1) == 1) {
            this.resolveTypes = strPrefix.length() == 0 ? (this.resolveTypes |= 0x8000) : (this.fileReferncesContext == null ? (this.resolveTypes |= 0x60000) : (this.resolveTypes |= 0x18000));
            this.resolveTypes |= 0x1000000;
            this.resolveTypes |= 2;
            this.resolveTypes |= 0x2000000;
            this.resolveTypes |= 0x80000;
            this.resolveTypes |= 0x200;
            this.resolveTypes |= 0x100000;
            this.resolveTypes |= 0x400000;
            this.resolveTypes |= 0x804100;
            this.resolveTypes |= 4;
            this.resolveTypes |= 0x2000;
            assert (context != null);
            boolean resolveGlobalContext = false;
            if (CsmContextUtilities.isInFunction(context, offset)) {
                this.updateResolveTypesInFunction(offset, context, match);
            } else if (this.isInFunctionPointerType(context, offset)) {
                this.updateResolveTypesInFunction(offset, context, match);
            } else if (CsmContextUtilities.getClass(context, false, true) != null) {
                this.resolveTypes |= 0x10;
                this.resolveTypes |= 0x20;
                this.resolveTypes |= 0x200000;
            } else if (CsmContextUtilities.isInFunctionInstantiation(context, offset)) {
                this.updateResolveTypesInFunction(offset, context, match);
            } else {
                resolveGlobalContext = true;
            }
            if (resolveGlobalContext || match && CsmContextUtilities.isInInitializerList(context, offset)) {
                this.resolveTypes |= 8;
                this.resolveTypes |= 0x80000;
                this.resolveTypes |= 0x200;
                this.resolveTypes |= 0x400;
                this.resolveTypes |= 0x1000;
                this.resolveTypes |= 0x800;
                this.resolveTypes |= 0x100000;
            }
        }
    }

    private boolean isInFunctionPointerType(CsmContext context, int offset) {
        CsmTypedef typedef;
        CsmType type;
        if (CsmKindUtilities.isFunctionPointerType((CsmObject)context.getLastScope())) {
            return CsmOffsetUtilities.isInObject((CsmObject)context.getLastScope(), offset);
        }
        if (CsmKindUtilities.isTypedefOrTypeAlias((CsmObject)context.getLastObject()) && CsmKindUtilities.isFunctionPointerType((CsmObject)(type = (typedef = (CsmTypedef)context.getLastObject()).getType()))) {
            return CsmOffsetUtilities.isInObject((CsmObject)type, offset);
        }
        return false;
    }

    private Collection<CsmDeclaration> getUsedDeclarations(CsmFile file, int offset, String prefix, boolean match, CsmDeclaration.Kind[] kinds) {
        CsmProject prj = file.getProject();
        CsmProject inProject = prefix.length() == 0 ? prj : null;
        Collection usedDecls = CsmUsingResolver.getDefault().findUsedDeclarations(file, offset, inProject);
        Collection<CsmDeclaration> out = this.filterDeclarations(usedDecls, prefix, match, kinds);
        return out;
    }

    private Collection<CsmDeclaration> filterDeclarations(Collection<CsmDeclaration> orig, String prefix, boolean match, CsmDeclaration.Kind[] kinds) {
        LinkedHashSet<CsmDeclaration> out = new LinkedHashSet<CsmDeclaration>(orig.size());
        this.contResolver.filterDeclarations(orig.iterator(), out, kinds, prefix, match, false);
        return out;
    }

    private Collection<CsmNamespace> getNamespacesToSearch(CsmContext context, CsmFile file, int offset, boolean onlyInProject, boolean contextOnly) {
        CsmProject prj = file.getProject();
        CsmProject inProject = onlyInProject || contextOnly ? prj : null;
        Collection<CsmNamespace> namespaces = new ArrayList<CsmNamespace>();
        List<CsmNamespace> contextNSs = this.getContextNamespaces(context);
        namespaces.addAll(contextNSs);
        namespaces = this.filterNamespaces(namespaces, inProject);
        if (!contextOnly && this.checkNamespaceDeclarations()) {
            namespaces.addAll(CsmUsingResolver.getDefault().findVisibleNamespaces(file, offset, inProject));
        }
        if (prj != null) {
            CsmNamespace globNS = prj.getGlobalNamespace();
            namespaces.add(globNS);
        }
        return namespaces;
    }

    private List<CsmNamespace> getContextNamespaces(CsmContext context) {
        ArrayList<CsmNamespace> out = new ArrayList<CsmNamespace>();
        for (CsmNamespace ns = CsmContextUtilities.getNamespace(context); ns != null && !ns.isGlobal(); ns = ns.getParent()) {
            out.add(ns);
        }
        return out;
    }

    private Collection<CsmNamespace> filterNamespaces(Collection<CsmNamespace> orig, CsmProject prj) {
        LinkedHashSet<CsmNamespace> out = new LinkedHashSet<CsmNamespace>(orig.size());
        for (CsmNamespace ns : orig) {
            if (ns == null || prj != null && ns.getProject() != prj) continue;
            out.add(ns);
        }
        return out;
    }

    private static final class EmptyResultImpl
    implements CompletionResolver.Result {
        private EmptyResultImpl() {
        }

        @Override
        public Collection<CsmVariable> getLocalVariables() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmField> getClassFields() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmEnumerator> getClassEnumerators() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmMethod> getClassMethods() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmClassifier> getProjectClassesifiersEnums() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmVariable> getFileLocalVars() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmEnumerator> getFileLocalEnumerators() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmMacro> getFileLocalMacros() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmFunction> getFileLocalFunctions() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmMacro> getInFileIncludedProjectMacros() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmVariable> getGlobalVariables() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmEnumerator> getGlobalEnumerators() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmMacro> getGlobalProjectMacros() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmFunction> getGlobalProjectFunctions() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmNamespace> getGlobalProjectNamespaces() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmClassifier> getLibClassifiersEnums() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmMacro> getInFileIncludedLibMacros() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmMacro> getLibMacros() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmVariable> getLibVariables() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmEnumerator> getLibEnumerators() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmFunction> getLibFunctions() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmNamespace> getLibNamespaces() {
            return Collections.emptyList();
        }

        @Override
        public Collection<? extends CsmObject> addResulItemsToCol(Collection<? extends CsmObject> orig) {
            return orig;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Collection<CsmNamespaceAlias> getProjectNamespaceAliases() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmNamespaceAlias> getLibNamespaceAliases() {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmTemplateParameter> getTemplateparameters() {
            return Collections.emptyList();
        }

        public String toString() {
            return "<Empty Result>";
        }
    }

    private static final class ResultImpl
    implements CompletionResolver.Result {
        private Collection<CsmVariable> localVars;
        private Collection<CsmField> classFields;
        private Collection<CsmEnumerator> classEnumerators;
        private Collection<CsmMethod> classMethods;
        private Collection<CsmClassifier> classesEnumsTypedefs;
        private Collection<CsmVariable> fileLocalVars;
        private Collection<CsmEnumerator> fileLocalEnumerators;
        private Collection<CsmMacro> fileLocalMacros;
        private Collection<CsmFunction> fileLocalFunctions;
        private Collection<CsmMacro> fileProjectMacros;
        private Collection<CsmVariable> globVars;
        private Collection<CsmEnumerator> globEnumerators;
        private Collection<CsmMacro> globProjectMacros;
        private Collection<CsmFunction> globFuns;
        private Collection<CsmNamespace> globProjectNSs;
        private Collection<CsmNamespaceAlias> projectNsAliases;
        private Collection<CsmClassifier> libClasses;
        private Collection<CsmMacro> fileLibMacros;
        private Collection<CsmMacro> globLibMacros;
        private Collection<CsmVariable> libVars;
        private Collection<CsmEnumerator> libEnumerators;
        private Collection<CsmFunction> libFuns;
        private Collection<CsmNamespace> libNSs;
        private Collection<CsmNamespaceAlias> libNsAliases;
        private Collection<CsmTemplateParameter> templateParameters;
        int size = -1;

        private ResultImpl() {
        }

        @Override
        public Collection<CsmVariable> getLocalVariables() {
            return CompletionResolverImpl.maskNull(this.localVars);
        }

        @Override
        public Collection<CsmField> getClassFields() {
            return CompletionResolverImpl.maskNull(this.classFields);
        }

        @Override
        public Collection<CsmEnumerator> getClassEnumerators() {
            return CompletionResolverImpl.maskNull(this.classEnumerators);
        }

        @Override
        public Collection<CsmMethod> getClassMethods() {
            return CompletionResolverImpl.maskNull(this.classMethods);
        }

        @Override
        public Collection<CsmClassifier> getProjectClassesifiersEnums() {
            return CompletionResolverImpl.maskNull(this.classesEnumsTypedefs);
        }

        @Override
        public Collection<CsmVariable> getFileLocalVars() {
            return CompletionResolverImpl.maskNull(this.fileLocalVars);
        }

        @Override
        public Collection<CsmEnumerator> getFileLocalEnumerators() {
            return CompletionResolverImpl.maskNull(this.fileLocalEnumerators);
        }

        @Override
        public Collection<CsmMacro> getFileLocalMacros() {
            return CompletionResolverImpl.maskNull(this.fileLocalMacros);
        }

        @Override
        public Collection<CsmFunction> getFileLocalFunctions() {
            return CompletionResolverImpl.maskNull(this.fileLocalFunctions);
        }

        @Override
        public Collection<CsmMacro> getInFileIncludedProjectMacros() {
            return CompletionResolverImpl.maskNull(this.fileProjectMacros);
        }

        @Override
        public Collection<CsmVariable> getGlobalVariables() {
            return CompletionResolverImpl.maskNull(this.globVars);
        }

        @Override
        public Collection<CsmEnumerator> getGlobalEnumerators() {
            return CompletionResolverImpl.maskNull(this.globEnumerators);
        }

        @Override
        public Collection<CsmMacro> getGlobalProjectMacros() {
            return CompletionResolverImpl.maskNull(this.globProjectMacros);
        }

        @Override
        public Collection<CsmFunction> getGlobalProjectFunctions() {
            return CompletionResolverImpl.maskNull(this.globFuns);
        }

        @Override
        public Collection<CsmNamespace> getGlobalProjectNamespaces() {
            return CompletionResolverImpl.maskNull(this.globProjectNSs);
        }

        @Override
        public Collection<CsmNamespaceAlias> getProjectNamespaceAliases() {
            return CompletionResolverImpl.maskNull(this.projectNsAliases);
        }

        @Override
        public Collection<CsmClassifier> getLibClassifiersEnums() {
            return CompletionResolverImpl.maskNull(this.libClasses);
        }

        @Override
        public Collection<CsmMacro> getInFileIncludedLibMacros() {
            return CompletionResolverImpl.maskNull(this.fileLibMacros);
        }

        @Override
        public Collection<CsmMacro> getLibMacros() {
            return CompletionResolverImpl.maskNull(this.globLibMacros);
        }

        @Override
        public Collection<CsmVariable> getLibVariables() {
            return CompletionResolverImpl.maskNull(this.libVars);
        }

        @Override
        public Collection<CsmEnumerator> getLibEnumerators() {
            return CompletionResolverImpl.maskNull(this.libEnumerators);
        }

        @Override
        public Collection<CsmFunction> getLibFunctions() {
            return CompletionResolverImpl.maskNull(this.libFuns);
        }

        @Override
        public Collection<CsmNamespace> getLibNamespaces() {
            return CompletionResolverImpl.maskNull(this.libNSs);
        }

        @Override
        public Collection<CsmNamespaceAlias> getLibNamespaceAliases() {
            return CompletionResolverImpl.maskNull(this.libNsAliases);
        }

        @Override
        public Collection<CsmTemplateParameter> getTemplateparameters() {
            return CompletionResolverImpl.maskNull(this.templateParameters);
        }

        @Override
        public Collection<? extends CsmObject> addResulItemsToCol(Collection<? extends CsmObject> orig) {
            assert (orig != null);
            return CompletionResolverImpl.appendResult(orig, this);
        }

        @Override
        public int size() {
            if (this.size == -1) {
                this.size = 0;
                this.size += this.getLocalVariables().size();
                this.size += this.getClassFields().size();
                this.size += this.getClassEnumerators().size();
                this.size += this.getClassMethods().size();
                this.size += this.getProjectClassesifiersEnums().size();
                this.size += this.getFileLocalVars().size();
                this.size += this.getFileLocalEnumerators().size();
                this.size += this.getFileLocalMacros().size();
                this.size += this.getFileLocalFunctions().size();
                this.size += this.getInFileIncludedProjectMacros().size();
                this.size += this.getGlobalVariables().size();
                this.size += this.getGlobalEnumerators().size();
                this.size += this.getGlobalProjectMacros().size();
                this.size += this.getGlobalProjectFunctions().size();
                this.size += this.getGlobalProjectNamespaces().size();
                this.size += this.getLibClassifiersEnums().size();
                this.size += this.getInFileIncludedLibMacros().size();
                this.size += this.getLibMacros().size();
                this.size += this.getLibVariables().size();
                this.size += this.getLibEnumerators().size();
                this.size += this.getLibFunctions().size();
                this.size += this.getLibNamespaces().size();
                this.size += this.getTemplateparameters().size();
            }
            return this.size;
        }

        public String toString() {
            ArrayList coll = new ArrayList();
            this.addResulItemsToCol(coll);
            return ((Object)coll).toString();
        }
    }
}

