/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.completion.impl.xref.ReferenceImpl;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.support.Interrupter;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;

public class ReferenceResolverImpl
extends CsmReferenceResolver {
    public boolean isKindOf(CsmReference ref, Set<CsmReferenceKind> kinds) {
        if (kinds.equals(CsmReferenceKind.ALL) || kinds.contains(ref.getKind())) {
            return true;
        }
        CsmFile file = ref.getContainingFile();
        int offset = ref.getStartOffset();
        if (kinds.contains(CsmReferenceKind.IN_DEAD_BLOCK) && ReferenceResolverImpl.isIn(CsmFileInfoQuery.getDefault().getUnusedCodeBlocks(file, Interrupter.DUMMY), offset)) {
            return true;
        }
        if (kinds.contains(CsmReferenceKind.IN_PREPROCESSOR_DIRECTIVE)) {
            if (ReferenceResolverImpl.isIn(file.getIncludes(), offset)) {
                return true;
            }
            if (ReferenceResolverImpl.isIn(file.getMacros(), offset)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isIn(Collection<? extends CsmOffsetable> collection, int offset) {
        for (CsmOffsetable csmOffsetable : collection) {
            if (csmOffsetable.getStartOffset() > offset || csmOffsetable.getEndOffset() < offset) continue;
            return true;
        }
        return false;
    }

    public CsmReference findReference(CsmFile file, Document doc, int offset) {
        assert (file != null);
        if (doc == null) {
            doc = CsmReferenceRepository.getDocument((CsmFile)file);
        }
        if (!(doc instanceof BaseDocument)) {
            return null;
        }
        ReferenceImpl ref = ReferencesSupport.createReferenceImpl(file, (BaseDocument)doc, offset);
        return ref;
    }

    public CsmReference findReference(Node activatedNode) {
        JEditorPane pane;
        assert (activatedNode != null) : "activatedNode must be not null";
        EditorCookie cookie = (EditorCookie)activatedNode.getCookie(EditorCookie.class);
        if (cookie != null && (pane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)cookie)) != null) {
            int offset = pane.getSelectionEnd();
            StyledDocument doc = CsmUtilities.openDocument((EditorCookie)cookie);
            return this.findReferenceInDoc(doc, offset);
        }
        return null;
    }

    public CsmReference findReference(Document doc, int offset) {
        return this.findReferenceInDoc(doc, offset);
    }

    private CsmReference findReferenceInDoc(Document doc, int offset) {
        CsmFile file;
        if (doc instanceof BaseDocument && (file = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false)) != null) {
            return ReferencesSupport.createReferenceImpl(file, (BaseDocument)doc, offset);
        }
        return null;
    }

    public CsmReferenceResolver.Scope fastCheckScope(CsmReference ref) {
        return ReferencesSupport.fastCheckScope(ref);
    }

    public Collection<CsmReference> getReferences(CsmFile file) {
        return Collections.emptyList();
    }
}

