/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceRepository;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.openide.text.NbDocument;

public class ReferencesCache {
    static CsmObject UNRESOLVED = new CsmObject(){

        public String toString() {
            return "FAKE REFERENCE";
        }
    };
    private static final int MAX_CACHE_SIZE = 10;
    private final Object cacheLock = new CacheLock();
    private LinkedHashMap<CsmFile, Map<TokenItem<TokenId>, CacheEntry>> cache = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmObject getReferencedObject(CsmFile file, TokenItem<TokenId> token, long callTimeVersion) {
        Object object = this.cacheLock;
        synchronized (object) {
            CacheEntry cacheEntry;
            Map<TokenItem<TokenId>, CacheEntry> entry = this.cache.get(file);
            CsmObject out = null;
            if (entry != null && (cacheEntry = entry.get(token)) != null) {
                out = cacheEntry.csmObject;
                if (out == UNRESOLVED) {
                    long storedVersion = cacheEntry.fileVersion;
                    long fileVersion = CsmFileInfoQuery.getDefault().getFileVersion(file);
                    if (fileVersion != storedVersion) {
                        entry.put(token, null);
                        out = null;
                    }
                } else if (!CsmBaseUtilities.isValid((CsmObject)out)) {
                    entry.put(token, null);
                    out = null;
                }
            }
            return out;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putReferencedObject(CsmFile file, TokenItem<TokenId> token, CsmObject object, long fileVersionOnStartResolving) {
        Object object2 = this.cacheLock;
        synchronized (object2) {
            CacheEntry cacheEntry;
            Map<TokenItem<TokenId>, CacheEntry> entry = this.cache.get(file);
            if (entry == null) {
                if (this.cache.size() > 10) {
                    Map.Entry<CsmFile, Map<TokenItem<TokenId>, CacheEntry>> next = this.cache.entrySet().iterator().next();
                    this.cache.remove(next.getKey());
                }
                entry = new HashMap<TokenItem<TokenId>, CacheEntry>();
                this.cache.put(file, entry);
            }
            if ((cacheEntry = entry.get(token)) == null) {
                cacheEntry = new CacheEntry(fileVersionOnStartResolving, object);
                entry.put(token, cacheEntry);
            } else {
                long currentFileVersion;
                if (object == UNRESOLVED && fileVersionOnStartResolving != (currentFileVersion = CsmFileInfoQuery.getDefault().getFileVersion(file))) {
                    return;
                }
                if (cacheEntry.fileVersion < fileVersionOnStartResolving) {
                    cacheEntry = new CacheEntry(fileVersionOnStartResolving, object);
                    entry.put(token, cacheEntry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearFileReferences(CsmFile file) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (file == null) {
                Iterator<Map.Entry<CsmFile, Map<TokenItem<TokenId>, CacheEntry>>> it = this.cache.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<CsmFile, Map<TokenItem<TokenId>, CacheEntry>> entry = it.next();
                    CsmFile aFile = entry.getKey();
                    if (CsmFileInfoQuery.getDefault().isDocumentBasedFile(aFile)) {
                        this.clearUnresolved(aFile);
                        continue;
                    }
                    it.remove();
                }
            } else if (CsmFileInfoQuery.getDefault().isDocumentBasedFile(file)) {
                this.clearUnresolved(file);
            } else {
                this.cache.remove(file);
            }
        }
    }

    private void clearUnresolved(CsmFile file) {
        Map<TokenItem<TokenId>, CacheEntry> entry = this.cache.get(file);
        if (entry != null) {
            Iterator<Map.Entry<TokenItem<TokenId>, CacheEntry>> it = entry.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<TokenItem<TokenId>, CacheEntry> next = it.next();
                CacheEntry value = next.getValue();
                if (value != null && value.csmObject != UNRESOLVED) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpInfo(PrintWriter printOut) {
        Object object = this.cacheLock;
        synchronized (object) {
            printOut.printf("cache of size %d%n", this.cache.size());
            for (Map.Entry<CsmFile, Map<TokenItem<TokenId>, CacheEntry>> entry : this.cache.entrySet()) {
                CsmFile file = entry.getKey();
                printOut.printf("-----------------------%n", new Object[0]);
                printOut.printf("file %s version=%d, class=%s%n", file.getAbsolutePath(), CsmFileInfoQuery.getDefault().getFileVersion(file), file.getClass().getName());
                TreeMap<TokenItem<TokenId>, CacheEntry> unresolved = new TreeMap<TokenItem<TokenId>, CacheEntry>();
                TreeMap<TokenItem<TokenId>, CacheEntry> invalid = new TreeMap<TokenItem<TokenId>, CacheEntry>();
                for (Map.Entry<TokenItem<TokenId>, CacheEntry> entry2 : entry.getValue().entrySet()) {
                    CacheEntry value = entry2.getValue();
                    if (value == null) continue;
                    CsmObject csmObject = value.csmObject;
                    if (csmObject == UNRESOLVED) {
                        unresolved.put(entry2.getKey(), value);
                        continue;
                    }
                    if (CsmBaseUtilities.isValid((CsmObject)csmObject)) continue;
                    invalid.put(entry2.getKey(), value);
                }
                if (unresolved.isEmpty()) {
                    printOut.printf("no UNRESOLVED %n", new Object[0]);
                } else {
                    for (Map.Entry<Object, CacheEntry> entry3 : unresolved.entrySet()) {
                        printOut.printf("UNRESOLVED [%s] version=%d%n", this.getPosition((TokenItem<TokenId>)((TokenItem)entry3.getKey()), file), entry3.getValue().fileVersion);
                        CsmObject checkAgain = ReferencesSupport.findDeclaration(file, (Document)CsmReferenceRepository.getDocument((CsmFile)file), (TokenItem<TokenId>)((TokenItem)entry3.getKey()), ((TokenItem)entry3.getKey()).offset());
                        if (checkAgain == null) continue;
                        printOut.printf("\t ERROR: resolved as [%s]%n", checkAgain);
                    }
                }
                if (invalid.isEmpty()) {
                    printOut.printf("no INVALID %n", new Object[0]);
                    continue;
                }
                for (Map.Entry<Object, CacheEntry> entry4 : invalid.entrySet()) {
                    CsmObject csmObject = entry4.getValue().csmObject;
                    printOut.printf("INVALID [%s] version=%d %s%n", this.getPosition((TokenItem<TokenId>)((TokenItem)entry4.getKey()), file), entry4.getValue().fileVersion, csmObject);
                    CsmObject checkAgain = ReferencesSupport.findDeclaration(file, (Document)CsmReferenceRepository.getDocument((CsmFile)file), (TokenItem<TokenId>)((TokenItem)entry4.getKey()), ((TokenItem)entry4.getKey()).offset());
                    if (checkAgain == csmObject) continue;
                    printOut.printf("\t ERROR: invalid resolved as [%s]%n", checkAgain);
                }
            }
            printOut.printf("-----------------------%n", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPosition(TokenItem<TokenId> offset, CsmFile file) {
        BaseDocument document = CsmReferenceRepository.getDocument((CsmFile)file);
        StringBuilder out = new StringBuilder();
        out.append("offset=").append(offset.offset());
        if (document instanceof StyledDocument) {
            TokenItem jumpToken;
            int line = NbDocument.findLineNumber((StyledDocument)((StyledDocument)document), (int)offset.offset()) + 1;
            out.append(", line=").append(line);
            int col = NbDocument.findLineColumn((StyledDocument)((StyledDocument)document), (int)offset.offset()) + 1;
            out.append(", column=").append(col);
            document.readLock();
            try {
                jumpToken = CndTokenUtilities.getTokenCheckPrev((Document)document, (int)offset.offset());
            }
            finally {
                document.readUnlock();
            }
            out.append(", tok=").append(jumpToken);
        }
        return out.toString();
    }

    private static final class CacheEntry {
        private final long fileVersion;
        private final CsmObject csmObject;

        public CacheEntry(long fileVersion, CsmObject csmObject) {
            this.fileVersion = fileVersion;
            this.csmObject = csmObject;
        }
    }

    private static final class CacheLock {
        private CacheLock() {
        }
    }
}

