/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.completion.csm.CompletionResolver;

public final class SymTabCache {
    private final Map<CacheEntry, CompletionResolver.Result> cache = new HashMap<CacheEntry, CompletionResolver.Result>();

    SymTabCache() {
    }

    private Map<CacheEntry, CompletionResolver.Result> getCache() {
        return this.cache;
    }

    public CompletionResolver.Result get(CacheEntry key) {
        return this.getCache().get(key);
    }

    public void clear() {
        this.getCache().clear();
    }

    public CompletionResolver.Result put(CacheEntry key, CompletionResolver.Result value) {
        return this.getCache().put(key, value);
    }

    public void setScope(CsmUID uid) {
        CacheEntry entry;
        Iterator<CacheEntry> it = this.getCache().keySet().iterator();
        if (it.hasNext() && !(entry = it.next()).getScope().equals(uid)) {
            this.getCache().clear();
        }
    }

    public static final class CacheEntry {
        private final int resolve;
        private final int hide;
        private final String name;
        private final CsmUID scope;

        public CacheEntry(int resolve, int hide, String name, CsmUID scope) {
            this.resolve = resolve;
            this.hide = hide;
            this.name = name;
            this.scope = scope;
        }

        public CsmUID getScope() {
            return this.scope;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheEntry)) {
                return false;
            }
            CacheEntry o = (CacheEntry)obj;
            return this.resolve == o.resolve && this.hide == o.hide && this.name.equals(o.name) && this.scope.equals(o.scope);
        }

        public int hashCode() {
            return this.resolve + 17 * (this.hide + 17 * (this.name.hashCode() + 17 * this.scope.hashCode()));
        }
    }
}

