/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.templates;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateInsertRequest;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateParameter;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessor;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateProcessorFactory;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmDeclarationResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.NbBundle;

public class CppCodeTemplateProcessor
implements CodeTemplateProcessor {
    public static final String ARRAY = "array";
    public static final String ITERABLE = "iterable";
    public static final String TYPE = "type";
    public static final String CAST = "cast";
    public static final String ITERABLE_ELEMENT_TYPE = "iterableElementType";
    public static final String NEW_VAR_NAME = "newVarName";
    public static final String RIGHT_SIDE_TYPE = "rightSideType";
    private final CodeTemplateInsertRequest request;
    private CsmClass enclClass = null;
    private List<CsmVariable> locals = null;
    private static final String[] iterableTypes = new String[]{"list", "map", "vector"};

    private CppCodeTemplateProcessor(CodeTemplateInsertRequest request) {
        this.request = request;
        for (CodeTemplateParameter param : request.getMasterParameters()) {
            if (!"selection".equals(param.getName())) continue;
            this.initParsing();
            return;
        }
    }

    public void updateDefaultValues() {
        for (Object p : this.request.getMasterParameters()) {
            CodeTemplateParameter param = (CodeTemplateParameter)p;
            String value = this.getProposedValue(param);
            if (value == null || value.equals(param.getValue())) continue;
            param.setValue(value);
        }
    }

    public void parameterValueChanged(CodeTemplateParameter masterParameter, boolean typingChange) {
        if (typingChange) {
            for (Object p : this.request.getMasterParameters()) {
                String value;
                CodeTemplateParameter param = (CodeTemplateParameter)p;
                if (param.isUserModified() || (value = this.getProposedValue(param)) == null || value.equals(param.getValue())) continue;
                param.setValue(value);
            }
        }
    }

    public void release() {
    }

    private void initParsing() {
        JTextComponent c = this.request.getComponent();
        final int offset = c.getSelectionStart();
        final Document doc = c.getDocument();
        final AtomicBoolean cancel = new AtomicBoolean();
        ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (cancel.get()) {
                    return;
                }
                CppCodeTemplateProcessor.this.locals = new ArrayList();
                CsmFile file = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
                CsmContext context = new CsmContext(file, offset);
                CsmObject lastObj = CsmDeclarationResolver.findInnerFileObject(file, offset, context, null);
                for (CsmDeclaration var : CsmContextUtilities.findFunctionLocalVariables(context)) {
                    if (!CsmKindUtilities.isVariable((CsmObject)var)) continue;
                    CppCodeTemplateProcessor.this.locals.add((CsmVariable)var);
                }
                CsmContextUtilities.isInFunctionBody(context, offset);
                for (CsmDeclaration var : CsmContextUtilities.findFileLocalVariables(context)) {
                    if (!CsmKindUtilities.isVariable((CsmObject)var)) continue;
                    CppCodeTemplateProcessor.this.locals.add((CsmVariable)var);
                }
                CsmNamespace namespace = CsmContextUtilities.getNamespace(context);
                if (namespace != null) {
                    for (CsmDeclaration var : namespace.getDeclarations()) {
                        if (!CsmKindUtilities.isVariable((CsmObject)var)) continue;
                        CppCodeTemplateProcessor.this.locals.add((CsmVariable)var);
                    }
                }
                CppCodeTemplateProcessor.this.enclClass = CsmContextUtilities.getClass(context, true, false);
                if (CppCodeTemplateProcessor.this.enclClass != null) {
                    for (CsmDeclaration var : CppCodeTemplateProcessor.this.enclClass.getMembers()) {
                        if (!CsmKindUtilities.isVariable((CsmObject)var)) continue;
                        CppCodeTemplateProcessor.this.locals.add((CsmVariable)var);
                    }
                }
            }
        }, (String)NbBundle.getMessage(CppCodeTemplateProcessor.class, (String)"CPP-init"), (AtomicBoolean)cancel, (boolean)false);
    }

    private String getProposedValue(CodeTemplateParameter param) {
        String name = null;
        for (Map.Entry entry : param.getHints().entrySet()) {
            if (ARRAY.equals(entry.getKey())) {
                for (CsmVariable var : this.locals) {
                    if (!this.isArray(var)) continue;
                    return var.getName().toString();
                }
                continue;
            }
            if (!ITERABLE.equals(entry.getKey())) continue;
            for (CsmVariable var : this.locals) {
                if (!this.isIterable(var)) continue;
                return var.getName().toString();
            }
        }
        return name;
    }

    private boolean isIterable(CsmVariable var) {
        CsmType type = var.getType();
        if (type != null) {
            CharSequence text = type.getText();
            for (String s : iterableTypes) {
                if (!CharSequenceUtils.startsWith((CharSequence)text, (CharSequence)s) && !CharSequenceUtils.startsWith((CharSequence)text, (CharSequence)("std::" + s))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isArray(CsmVariable var) {
        CsmType type = var.getType();
        return type != null && type.getArrayDepth() == 1;
    }

    public static final class Factory
    implements CodeTemplateProcessorFactory {
        public CodeTemplateProcessor createProcessor(CodeTemplateInsertRequest request) {
            return new CppCodeTemplateProcessor(request);
        }
    }
}

