/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.action;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.Action;
import org.netbeans.modules.dlight.sendto.action.DynamicMenu;
import org.netbeans.modules.dlight.sendto.action.FutureAction;
import org.netbeans.modules.dlight.sendto.api.Configuration;
import org.openide.util.Lookup;

public class MenuUpdator {
    private static final ExecutorService rp = Executors.newSingleThreadExecutor();
    private static MenuUpdator lastCreated = null;
    private static final Object factoryLock = new Object();
    private final DynamicMenu menu;
    private final ConcurrentLinkedQueue<Future<Void>> tasks = new ConcurrentLinkedQueue();

    private MenuUpdator(DynamicMenu menu) {
        this.menu = menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void start(DynamicMenu menu, Lookup actionContext, List<Configuration> configs) {
        Object object = factoryLock;
        synchronized (object) {
            if (lastCreated != null) {
                lastCreated.cancel();
            }
            lastCreated = new MenuUpdator(menu);
            for (Configuration cfg : configs) {
                FutureAction action = cfg.getHandler().createActionFor(actionContext, cfg);
                if (action == null) continue;
                lastCreated.add(action);
            }
        }
    }

    private void add(final FutureAction faction) {
        this.tasks.add(rp.submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                try {
                    MenuUpdator.this.menu.addValidatingItem();
                    Action action = faction.getAction();
                    if (action != null) {
                        MenuUpdator.this.menu.addDynamicItem(action);
                    }
                }
                finally {
                    MenuUpdator.this.menu.removeValidatingItem();
                }
                return null;
            }
        }));
    }

    private void cancel() {
        for (Future<Void> task : this.tasks) {
            task.cancel(false);
        }
    }
}

