/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.WorkingCopyAttributesCache;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.notifications.NotificationsManager;
import org.netbeans.modules.subversion.ui.status.StatusAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnSearchHistorySupport;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.FileUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

class FilesystemHandler
extends VCSInterceptor {
    private final FileStatusCache cache;
    private final Set<File> movedFiles = new HashSet<File>();
    private final Set<File> copiedFiles = new HashSet<File>();
    private final Set<File> internalyDeletedFiles = new HashSet<File>();
    private final Set<File> toLockFiles = Collections.synchronizedSet(new HashSet());
    private final Map<File, Boolean> readOnlyFiles = Collections.synchronizedMap(new LinkedHashMap<File, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<File, Boolean> eldest) {
            return this.size() > 100;
        }
    });
    private static final RequestProcessor RP = new RequestProcessor("Subversion FileSystemHandler", 1, false, false);
    private final Set<File> invalidMetadata = new HashSet<File>(5);
    private static final int STATUS_VCS_MODIFIED_ATTRIBUTE = 86228;

    public FilesystemHandler(Subversion svn) {
        this.cache = svn.getStatusCache();
    }

    public boolean beforeDelete(File file) {
        Subversion.LOG.log(Level.FINE, "beforeDelete {0}", file);
        if (!SvnClientFactory.isClientAvailable()) {
            Subversion.LOG.fine(" skipping delete due to missing client");
            return false;
        }
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return true;
        }
        return this.isVersioned(file.getParentFile());
    }

    public void doDelete(File file) throws IOException {
        Subversion.LOG.log(Level.FINE, "doDelete {0}", file);
        if (!SvnUtils.isPartOfSubversionMetadata(file)) {
            try {
                SvnClient client = Subversion.getInstance().getClient(false);
                try {
                    client.remove(new File[]{file}, true);
                    return;
                }
                catch (SVNClientException ex) {
                    try {
                        if (this.isVersioned(file.getParentFile())) {
                            client.remove(new File[]{file}, true);
                        }
                        this.internalyDeletedFiles.add(file);
                    }
                    catch (SVNClientException e) {
                        if (!WorkingCopyAttributesCache.getInstance().isSuppressed(e)) {
                            SvnClientExceptionHandler.notifyException((Exception)((Object)e), false, false);
                        }
                        IOException ex2 = new IOException();
                        Exceptions.attachLocalizedMessage((Throwable)ex2, (String)NbBundle.getMessage(FilesystemHandler.class, (String)"MSG_DeleteFailed", (Object[])new Object[]{file, e.getLocalizedMessage()}));
                        ex2.getCause().initCause(e);
                        throw ex2;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.internalyDeletedFiles.add(file);
            }
        }
    }

    public void afterDelete(final File file) {
        Subversion.LOG.log(Level.FINE, "afterDelete {0}", file);
        if (file == null || SvnUtils.isPartOfSubversionMetadata(file)) {
            return;
        }
        if (this.internalyDeletedFiles.remove(file)) {
            this.cache.refreshAsync(file);
            return;
        }
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block6: {
                    try {
                        File parent = file.getParentFile();
                        if (parent == null || parent.exists()) break block6;
                    }
                    catch (Throwable throwable) {
                        FilesystemHandler.this.cache.refreshAsync(file);
                        throw throwable;
                    }
                    FilesystemHandler.this.cache.refreshAsync(file);
                    return;
                }
                try {
                    SvnClient client = Subversion.getInstance().getClient(false);
                    if (FilesystemHandler.this.shallRemove(client, file)) {
                        client.remove(new File[]{file}, true);
                    }
                }
                catch (SVNClientException e) {
                    Subversion.LOG.log(Level.FINER, null, e);
                }
                FilesystemHandler.this.cache.refreshAsync(file);
            }
        });
    }

    private void moveFolderToDifferentRepository(File from, File to) throws IOException, SVNClientException {
        File[] files;
        assert (from.isDirectory());
        assert (to.getParentFile().exists());
        if (!to.exists()) {
            if (to.mkdir()) {
                this.cache.refreshAsync(to);
            } else {
                Subversion.LOG.log(Level.WARNING, "{0}: Cannot create folder {1}", new Object[]{FilesystemHandler.class.getName(), to});
            }
        }
        for (File file : files = from.listFiles()) {
            if (SvnUtils.isAdministrative(file)) continue;
            this.svnMoveImplementation(file, new File(to, file.getName()));
        }
    }

    private void copyFolderToDifferentRepository(File from, File to) throws IOException, SVNClientException {
        File[] files;
        assert (from.isDirectory());
        assert (to.getParentFile().exists());
        if (!to.exists()) {
            if (to.mkdir()) {
                this.cache.refreshAsync(to);
            } else {
                Subversion.LOG.log(Level.WARNING, "{0}: Cannot create folder {1}", new Object[]{FilesystemHandler.class.getName(), to});
            }
        }
        for (File file : files = from.listFiles()) {
            if (SvnUtils.isAdministrative(file)) continue;
            this.svnCopyImplementation(file, new File(to, file.getName()));
        }
    }

    private boolean shallRemove(SvnClient client, File file) throws SVNClientException {
        boolean retval = true;
        if (!"true".equals(System.getProperty("org.netbeans.modules.subversion.deleteMissingFiles", "false"))) {
            Subversion.LOG.log(Level.FINE, "File {0} deleted externally, metadata not repaired (org.netbeans.modules.subversion.deleteMissingFiles=false by default)", new String[]{file.getAbsolutePath()});
            retval = false;
        } else {
            String existingFilename;
            ISVNStatus status = FilesystemHandler.getStatus(client, file);
            if (!SVNStatusKind.MISSING.equals((Object)status.getTextStatus())) {
                Subversion.LOG.fine(" shallRemove: skipping delete due to correct metadata");
                retval = false;
            } else if ((Utilities.isMac() || Utilities.isWindows()) && (existingFilename = FileUtils.getExistingFilenameInParent((File)file)) != null) {
                retval = false;
            }
        }
        return retval;
    }

    public boolean beforeMove(File from, File to) {
        Subversion.LOG.log(Level.FINE, "beforeMove {0} -> {1}", new Object[]{from, to});
        if (!SvnClientFactory.isClientAvailable()) {
            Subversion.LOG.fine(" skipping move due to missing client");
            return false;
        }
        File destDir = to.getParentFile();
        if (from != null && destDir != null && (this.isVersioned(from) || this.isVersioned(to))) {
            return SvnUtils.isManaged(to);
        }
        return false;
    }

    public void doMove(File from, File to) throws IOException {
        Subversion.LOG.log(Level.FINE, "doMove {0} -> {1}", new Object[]{from, to});
        this.svnMoveImplementation(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterMove(File from, File to) {
        File[] files;
        Subversion.LOG.log(Level.FINE, "afterMove {0} -> {1}", new Object[]{from, to});
        Set<File> set = this.movedFiles;
        synchronized (set) {
            this.movedFiles.add(from);
            files = this.movedFiles.toArray(new File[this.movedFiles.size()]);
            this.movedFiles.clear();
        }
        this.cache.refreshAsync(true, to);
        this.cache.refreshAsync(files);
        File parent = to.getParentFile();
        if (parent != null && from.equals(to)) {
            Subversion.LOG.log(Level.WARNING, "Wrong (identity) rename event for {0}", from.getAbsolutePath());
        }
    }

    public boolean beforeCopy(File from, File to) {
        Subversion.LOG.log(Level.FINE, "beforeCopy {0} -> {1}", new Object[]{from, to});
        if (!SvnClientFactory.isClientAvailable()) {
            Subversion.LOG.fine(" skipping copy due to missing client");
            return false;
        }
        File destDir = to.getParentFile();
        if (from != null && destDir != null && (this.isVersioned(from) || this.isVersioned(to))) {
            if (from.isDirectory()) {
                return true;
            }
            return SvnUtils.isManaged(to);
        }
        return false;
    }

    public void doCopy(File from, File to) throws IOException {
        Subversion.LOG.log(Level.FINE, "doCopy {0} -> {1}", new Object[]{from, to});
        this.svnCopyImplementation(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCopy(File from, File to) {
        File[] files;
        Subversion.LOG.log(Level.FINE, "afterCopy {0} -> {1}", new Object[]{from, to});
        Set<File> set = this.copiedFiles;
        synchronized (set) {
            this.copiedFiles.add(from);
            files = this.copiedFiles.toArray(new File[this.copiedFiles.size()]);
            this.copiedFiles.clear();
        }
        this.cache.refreshAsync(true, to);
        this.cache.refreshAsync(files);
        File parent = to.getParentFile();
        if (parent != null && from.equals(to)) {
            Subversion.LOG.log(Level.WARNING, "Wrong (identity) rename event for {0}", from.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void svnCopyImplementation(File from, File to) throws IOException {
        try {
            SvnClient client = Subversion.getInstance().getClient(false);
            this.removeInvalidMetadata();
            File parent = to.isDirectory() ? to : to.getParentFile();
            boolean parentManaged = false;
            boolean parentIgnored = false;
            if (parent != null && (parentManaged = SvnUtils.isManaged(parent)) && !this.isVersioned(parent)) {
                parentIgnored = !this.addDirectories(parent);
            }
            int retryCounter = 6;
            while (true) {
                try {
                    ISVNStatus toStatus = FilesystemHandler.getStatus(client, to);
                    ISVNStatus status = FilesystemHandler.getStatus(client, from);
                    List<File> srcChildren = null;
                    try {
                        srcChildren = SvnUtils.listManagedRecursively(from);
                        if (parentIgnored) {
                            if (!this.copyFile(from, to)) {
                                Subversion.LOG.log(Level.INFO, "Cannot copy file {0} to {1}", new Object[]{from, to});
                            }
                        } else if (status != null && (status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED) || status.getTextStatus().equals((Object)SVNStatusKind.IGNORED))) {
                            this.revertDeleted(client, toStatus, to, true);
                            if (!this.copyFile(from, to)) {
                                Subversion.LOG.log(Level.INFO, "Cannot copy file {0} to {1}", new Object[]{from, to});
                            }
                        } else {
                            SVNUrl repositoryTarget;
                            SVNUrl repositorySource = SvnUtils.getRepositoryRootUrl(from);
                            SVNUrl sVNUrl = repositoryTarget = parentManaged ? SvnUtils.getRepositoryRootUrl(parent) : null;
                            if (parentManaged && repositorySource.equals((Object)repositoryTarget)) {
                                client.copy(from, to);
                            } else if (from.isDirectory()) {
                                this.copyFolderToDifferentRepository(from, to);
                            } else if (this.copyFile(from, to)) {
                                Subversion.LOG.log(Level.FINE, FilesystemHandler.class.getName() + ": copying between different repositories {0} to {1}", new Object[]{from, to});
                            } else {
                                Subversion.LOG.log(Level.WARNING, FilesystemHandler.class.getName() + ": cannot copy {0} to {1}", new Object[]{from, to});
                            }
                        }
                    }
                    finally {
                        Set<File> set = this.copiedFiles;
                        synchronized (set) {
                            if (srcChildren != null) {
                                this.copiedFiles.addAll(srcChildren);
                            }
                        }
                    }
                }
                catch (SVNClientException e) {
                    if (e.getMessage().endsWith("' locked") && retryCounter > 0) {
                        try {
                            Thread.sleep(107L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                        --retryCounter;
                        continue;
                    }
                    if (!WorkingCopyAttributesCache.getInstance().isSuppressed(e)) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)e), false, false);
                    }
                    IOException ex = new IOException();
                    Exceptions.attachLocalizedMessage((Throwable)ex, (String)NbBundle.getMessage(FilesystemHandler.class, (String)"MSG_MoveFailed", (Object[])new Object[]{from, to, e.getLocalizedMessage()}));
                    ex.getCause().initCause(e);
                    throw ex;
                }
                break;
            }
        }
        catch (SVNClientException e) {
            if (!WorkingCopyAttributesCache.getInstance().isSuppressed(e)) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)e), false, false);
            }
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)ex, (String)("Subversion failed to move " + from.getAbsolutePath() + " to: " + to.getAbsolutePath() + "\n" + e.getLocalizedMessage()));
            ex.getCause().initCause(e);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeCreate(File file, boolean isDirectory) {
        block10: {
            Subversion.LOG.log(Level.FINE, "beforeCreate {0}", file);
            if (!SvnClientFactory.isClientAvailable()) {
                Subversion.LOG.fine(" skipping create due to missing client");
                return false;
            }
            if (SvnUtils.isPartOfSubversionMetadata(file)) {
                Set<File> set = this.invalidMetadata;
                synchronized (set) {
                    File p = file;
                    while (!SvnUtils.isAdministrative(p.getName())) {
                        p = p.getParentFile();
                        assert (p != null) : "file " + file + " doesn't have a .svn parent";
                    }
                    this.invalidMetadata.add(p);
                }
                return false;
            }
            if (!file.exists()) {
                try {
                    SvnClient client = Subversion.getInstance().getClient(false);
                    this.revertDeleted(client, file, true);
                }
                catch (SVNClientException ex) {
                    if (WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) break block10;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
            }
        }
        return false;
    }

    public void doCreate(File file, boolean isDirectory) throws IOException {
    }

    public void afterCreate(final File file) {
        Subversion.LOG.log(Level.FINE, "afterCreate {0}", file);
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return;
        }
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block32: {
                    int status;
                    block31: {
                        if (file == null) {
                            return;
                        }
                        status = FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN).getStatus();
                        if ((status & 0xFFFFFFFE) == 0) {
                            return;
                        }
                        if (!file.isDirectory()) break block31;
                        FilesystemHandler.this.cache.directoryContentChanged(file);
                        break block32;
                    }
                    if ((status & 0x100) != 0 && file.exists()) {
                        File temporary;
                        block28: {
                            temporary = FileUtils.generateTemporaryFile((File)file.getParentFile(), (String)file.getName());
                            SvnClient client = Subversion.getInstance().getClient(false);
                            if (file.renameTo(temporary)) {
                                client.revert(file, false);
                                file.delete();
                            } else {
                                Subversion.LOG.log(Level.WARNING, "FileSystemHandler.afterCreate: cannot rename {0} to {1}", new Object[]{file, temporary});
                                client.addFile(file);
                            }
                            if (!temporary.exists()) break block28;
                            try {
                                if (!temporary.renameTo(file)) {
                                    Subversion.LOG.log(Level.WARNING, "FileSystemHandler.afterCreate: cannot rename {0} back to {1}, {1} exists={2}", new Object[]{temporary, file, file.exists()});
                                    FileUtils.copyFile((File)temporary, (File)file);
                                }
                            }
                            catch (IOException ex) {
                                Subversion.LOG.log(Level.INFO, "FileSystemHandler.afterCreate: cannot copy {0} back to {1}", new Object[]{temporary, file});
                            }
                            finally {
                                temporary.delete();
                            }
                        }
                        FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN).getStatus();
                        break block32;
                        catch (SVNClientException ex) {
                            block29: {
                                try {
                                    Subversion.LOG.log(Level.INFO, null, ex);
                                    if (!temporary.exists()) break block29;
                                }
                                catch (Throwable throwable) {
                                    if (temporary.exists()) {
                                        try {
                                            if (!temporary.renameTo(file)) {
                                                Subversion.LOG.log(Level.WARNING, "FileSystemHandler.afterCreate: cannot rename {0} back to {1}, {1} exists={2}", new Object[]{temporary, file, file.exists()});
                                                FileUtils.copyFile((File)temporary, (File)file);
                                            }
                                        }
                                        catch (IOException ex2) {
                                            Subversion.LOG.log(Level.INFO, "FileSystemHandler.afterCreate: cannot copy {0} back to {1}", new Object[]{temporary, file});
                                        }
                                        finally {
                                            temporary.delete();
                                        }
                                    }
                                    FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN).getStatus();
                                    throw throwable;
                                }
                                try {
                                    if (!temporary.renameTo(file)) {
                                        Subversion.LOG.log(Level.WARNING, "FileSystemHandler.afterCreate: cannot rename {0} back to {1}, {1} exists={2}", new Object[]{temporary, file, file.exists()});
                                        FileUtils.copyFile((File)temporary, (File)file);
                                    }
                                }
                                catch (IOException ex3) {
                                    Subversion.LOG.log(Level.INFO, "FileSystemHandler.afterCreate: cannot copy {0} back to {1}", new Object[]{temporary, file});
                                }
                                finally {
                                    temporary.delete();
                                }
                            }
                            FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN).getStatus();
                        }
                    }
                }
            }
        });
    }

    public void afterChange(final File file) {
        if (!SvnClientFactory.isClientAvailable()) {
            Subversion.LOG.fine(" skipping afterChange due to missing client");
            return;
        }
        Subversion.LOG.log(Level.FINE, "afterChange {0}", file);
        RP.post(new Runnable(){

            @Override
            public void run() {
                if ((FilesystemHandler.this.cache.getStatus(file).getStatus() & 0xFFFFFFFE) != 0) {
                    FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
            }
        });
    }

    public Object getAttribute(final File file, String attrName) {
        if ("ProvidedExtensions.RemoteLocation".equals(attrName)) {
            return this.getRemoteRepository(file);
        }
        if ("ProvidedExtensions.Refresh".equals(attrName)) {
            return new Runnable(){

                @Override
                public void run() {
                    if (!SvnClientFactory.isClientAvailable()) {
                        Subversion.LOG.fine(" skipping ProvidedExtensions.Refresh due to missing client");
                        return;
                    }
                    if (!SvnUtils.isManaged(file)) {
                        return;
                    }
                    try {
                        SvnClient client = Subversion.getInstance().getClient(file);
                        if (client != null) {
                            Subversion.getInstance().getStatusCache().refreshCached(new Context(file));
                            StatusAction.executeStatus(file, client, null, false);
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                        return;
                    }
                }
            };
        }
        if ("ProvidedExtensions.SearchHistorySupport".equals(attrName)) {
            return new SvnSearchHistorySupport(file);
        }
        if ("ProvidedExtensions.VCSIsModified".equals(attrName)) {
            if (file == null) {
                return null;
            }
            if (!SvnClientFactory.isClientAvailable()) {
                Subversion.LOG.fine(" skipping ProvidedExtensions.VCSIsModified due to missing client");
                return null;
            }
            if (!SvnUtils.isManaged(file)) {
                return null;
            }
            try {
                SvnClient client = Subversion.getInstance().getClient(file);
                if (client != null) {
                    Context ctx = new Context(file);
                    Subversion.getInstance().getStatusCache().refreshCached(ctx);
                    StatusAction.executeStatus(file, client, null, false);
                    return this.cache.containsFiles(ctx, 86228, true);
                }
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
            return null;
        }
        return super.getAttribute(file, attrName);
    }

    public void beforeEdit(File file) {
        if (this.cache.ready()) {
            NotificationsManager.getInstance().scheduleFor(file);
        }
        this.ensureLocked(file);
    }

    public long refreshRecursively(File dir, long lastTimeStamp, List<? super File> children) {
        long retval = -1L;
        if (SvnUtils.isAdministrative(dir.getName())) {
            retval = 0L;
        }
        return retval;
    }

    public boolean isMutable(File file) {
        boolean mutable;
        boolean bl = mutable = SvnUtils.isPartOfSubversionMetadata(file) || super.isMutable(file);
        if (!mutable && SvnModuleConfig.getDefault().isAutoLock() && !this.readOnlyFiles.containsKey(file)) {
            this.toLockFiles.add(file);
            return true;
        }
        return mutable;
    }

    private String getRemoteRepository(File file) {
        if (file == null) {
            return null;
        }
        SVNUrl url = null;
        try {
            url = SvnUtils.getRepositoryRootUrl(file);
        }
        catch (SVNClientException ex) {
            Subversion.LOG.log(Level.FINE, "No repository root url found for managed file : [" + file + "]", ex);
            try {
                url = SvnUtils.getRepositoryUrl(file);
            }
            catch (SVNClientException ex1) {
                Subversion.LOG.log(Level.FINE, "No repository url found for managed file : [" + file + "]", ex1);
            }
        }
        return url != null ? SvnUtils.decodeToString(url) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInvalidMetadata() {
        Set<File> set = this.invalidMetadata;
        synchronized (set) {
            for (File file : this.invalidMetadata) {
                Utils.deleteRecursively((File)file);
            }
            this.invalidMetadata.clear();
        }
    }

    private boolean hasMetadata(File file) {
        return new File(file, SvnUtils.SVN_ENTRIES_DIR).canRead();
    }

    private boolean isVersioned(File file) {
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return false;
        }
        if (!file.isFile() && this.hasMetadata(file) || file.isFile() && this.hasMetadata(file.getParentFile())) {
            return true;
        }
        try {
            SVNStatusKind statusKind = SvnUtils.getSingleStatus(Subversion.getInstance().getClient(false), file).getTextStatus();
            return statusKind != SVNStatusKind.UNVERSIONED && statusKind != SVNStatusKind.IGNORED;
        }
        catch (SVNClientException ex) {
            return false;
        }
    }

    private static List<File> getDeletedParents(File file, SvnClient client) throws SVNClientException {
        ArrayList<File> ret = new ArrayList<File>();
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            ISVNStatus status = FilesystemHandler.getStatus(client, parent);
            if (status == null || !status.getTextStatus().equals((Object)SVNStatusKind.DELETED)) {
                return ret;
            }
            ret.add(parent);
        }
        return ret;
    }

    private void revertDeleted(SvnClient client, File file, boolean checkParents) {
        block2: {
            try {
                ISVNStatus status = FilesystemHandler.getStatus(client, file);
                this.revertDeleted(client, status, file, checkParents);
            }
            catch (SVNClientException ex) {
                if (WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) break block2;
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
        }
    }

    private void revertDeleted(SvnClient client, ISVNStatus status, File file, boolean checkParents) {
        block6: {
            try {
                if (this.equals(status, SVNStatusKind.DELETED)) {
                    if (checkParents) {
                        List<File> deletedParents = FilesystemHandler.getDeletedParents(file, client);
                        for (File parent : deletedParents) {
                            client.revert(parent, false);
                        }
                        if (!deletedParents.isEmpty()) {
                            Subversion.getInstance().getStatusCache().refreshAsync(deletedParents.toArray(new File[deletedParents.size()]));
                        }
                    }
                    client.revert(file, false);
                    this.internalyDeletedFiles.add(file);
                    file.delete();
                }
            }
            catch (SVNClientException ex) {
                if (WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) break block6;
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void svnMoveImplementation(File from, File to) throws IOException {
        try {
            boolean force = true;
            SvnClient client = Subversion.getInstance().getClient(false);
            this.removeInvalidMetadata();
            File parent = to.isDirectory() ? to : to.getParentFile();
            boolean parentIgnored = false;
            if (parent != null) {
                assert (SvnUtils.isManaged(parent)) : "Cannot move " + from.getAbsolutePath() + " to " + to.getAbsolutePath() + ", " + parent.getAbsolutePath() + " is not managed";
                if (!this.isVersioned(parent)) {
                    parentIgnored = !this.addDirectories(parent);
                }
            }
            int retryCounter = 6;
            while (true) {
                try {
                    ISVNStatus toStatus = FilesystemHandler.getStatus(client, to);
                    ISVNStatus status = FilesystemHandler.getStatus(client, from);
                    List<File> srcChildren = null;
                    SVNUrl url = status != null && status.isCopied() ? this.getCopiedUrl(client, from) : null;
                    SVNUrl toUrl = toStatus != null ? toStatus.getUrl() : null;
                    try {
                        srcChildren = SvnUtils.listManagedRecursively(from);
                        boolean moved = true;
                        if (status != null && (status.getTextStatus().equals((Object)SVNStatusKind.ADDED) || status.getTextStatus().equals((Object)SVNStatusKind.REPLACED)) && (!status.isCopied() || url != null && url.equals((Object)toUrl))) {
                            File temp = from;
                            if (Utilities.isWindows() && from.equals(to) || Utilities.isMac() && from.getPath().equalsIgnoreCase(to.getPath())) {
                                Subversion.LOG.log(Level.FINE, "svnMoveImplementation: magic workaround for filename case change {0} -> {1}", new Object[]{from, to});
                                temp = FileUtils.generateTemporaryFile((File)from.getParentFile(), (String)from.getName());
                                Subversion.LOG.log(Level.FINE, "svnMoveImplementation: magic workaround, step 1: {0} -> {1}", new Object[]{from, temp});
                                client.move(from, temp, force);
                            }
                            this.revertDeleted(client, toStatus, to, true);
                            moved = temp.renameTo(to);
                            if (moved) {
                                if (status.getTextStatus().equals((Object)SVNStatusKind.ADDED)) {
                                    client.revert(temp, true);
                                } else {
                                    client.remove(new File[]{temp}, true);
                                }
                            }
                        } else if (status != null && (status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED) || status.getTextStatus().equals((Object)SVNStatusKind.IGNORED))) {
                            this.revertDeleted(client, toStatus, to, true);
                            moved = from.renameTo(to);
                        } else if (parentIgnored) {
                            moved = from.renameTo(to);
                            client.remove(new File[]{from}, true);
                        } else {
                            SVNUrl repositoryTarget;
                            SVNUrl repositorySource = SvnUtils.getRepositoryRootUrl(from);
                            if (repositorySource.equals((Object)(repositoryTarget = SvnUtils.getRepositoryRootUrl(parent)))) {
                                try {
                                    client.move(from, to, force);
                                }
                                catch (SVNClientException ex) {
                                    if (Utilities.isWindows() && from.equals(to) || Utilities.isMac() && from.getPath().equalsIgnoreCase(to.getPath())) {
                                        Subversion.LOG.log(Level.FINE, "svnMoveImplementation: magic workaround for filename case change {0} -> {1}", new Object[]{from, to});
                                        File temp = FileUtils.generateTemporaryFile((File)to.getParentFile(), (String)from.getName());
                                        Subversion.LOG.log(Level.FINE, "svnMoveImplementation: magic workaround, step 1: {0} -> {1}", new Object[]{from, temp});
                                        client.move(from, temp, force);
                                        Subversion.LOG.log(Level.FINE, "svnMoveImplementation: magic workaround, step 2: {0} -> {1}", new Object[]{temp, to});
                                        client.move(temp, to, force);
                                        Subversion.LOG.log(Level.FINE, "svnMoveImplementation: magic workaround completed");
                                    }
                                    throw ex;
                                }
                            } else {
                                boolean remove = false;
                                if (from.isDirectory()) {
                                    this.moveFolderToDifferentRepository(from, to);
                                    remove = true;
                                } else if (from.renameTo(to)) {
                                    remove = true;
                                } else {
                                    Subversion.LOG.log(Level.WARNING, FilesystemHandler.class.getName() + ": cannot rename {0} to {1}", new Object[]{from, to});
                                }
                                if (remove) {
                                    client.remove(new File[]{from}, force);
                                    Subversion.LOG.log(Level.FINE, FilesystemHandler.class.getName() + ": moving between different repositories {0} to {1}", new Object[]{from, to});
                                }
                            }
                        }
                        if (!moved) {
                            Subversion.LOG.log(Level.INFO, "Cannot rename file {0} to {1}", new Object[]{from, to});
                        }
                    }
                    finally {
                        Set<File> set = this.movedFiles;
                        synchronized (set) {
                            if (srcChildren != null) {
                                this.movedFiles.addAll(srcChildren);
                            }
                        }
                    }
                }
                catch (SVNClientException e) {
                    if (e.getMessage().endsWith("' locked") && retryCounter > 0) {
                        try {
                            Thread.sleep(107L);
                        }
                        catch (InterruptedException ex) {
                            // empty catch block
                        }
                        --retryCounter;
                        continue;
                    }
                    if (!WorkingCopyAttributesCache.getInstance().isSuppressed(e)) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)e), false, false);
                    }
                    IOException ex = new IOException();
                    Exceptions.attachLocalizedMessage((Throwable)ex, (String)NbBundle.getMessage(FilesystemHandler.class, (String)"MSG_MoveFailed", (Object[])new Object[]{from, to, e.getLocalizedMessage()}));
                    ex.getCause().initCause(e);
                    throw ex;
                }
                break;
            }
        }
        catch (SVNClientException e) {
            if (!WorkingCopyAttributesCache.getInstance().isSuppressed(e)) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)e), false, false);
            }
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)ex, (String)("Subversion failed to move " + from.getAbsolutePath() + " to: " + to.getAbsolutePath() + "\n" + e.getLocalizedMessage()));
            ex.getCause().initCause(e);
            throw ex;
        }
    }

    private boolean addDirectories(File dir) throws SVNClientException {
        SvnClient client = Subversion.getInstance().getClient(false);
        ISVNStatus s = FilesystemHandler.getStatus(client, dir);
        if (s.getTextStatus().equals((Object)SVNStatusKind.IGNORED)) {
            return false;
        }
        File parent = dir.getParentFile();
        if (parent != null) {
            if (SvnUtils.isManaged(parent) && !this.isVersioned(parent) && !this.addDirectories(parent)) {
                return false;
            }
            client.addDirectory(dir, false);
            this.cache.refreshAsync(dir);
            return true;
        }
        throw new SVNClientException("Reached FS root, but it's still not Subversion versioned!");
    }

    private static ISVNStatus getStatus(SvnClient client, File file) throws SVNClientException {
        return SvnUtils.getSingleStatus(client, file);
    }

    private boolean equals(ISVNStatus status, SVNStatusKind kind) {
        return status != null && status.getTextStatus().equals((Object)kind);
    }

    private boolean copyFile(File from, File to) {
        try {
            FileUtils.copyFile((File)from, (File)to);
        }
        catch (IOException ex) {
            SvnClientExceptionHandler.notifyException(ex, false, false);
            return false;
        }
        return true;
    }

    private void ensureLocked(final File file) {
        if (this.toLockFiles.contains(file)) {
            Runnable outsideAWT = new Runnable(){

                @Override
                public void run() {
                    boolean readOnly = true;
                    try {
                        SVNUrl url;
                        ISVNStatus status;
                        SvnClient client = Subversion.getInstance().getClient(false);
                        boolean hasPropSet = false;
                        for (ISVNProperty prop : client.getProperties(file)) {
                            if (!"svn:needs-lock".equals(prop.getName())) continue;
                            hasPropSet = true;
                            break;
                        }
                        if (hasPropSet && (status = SvnUtils.getSingleStatus(client, file)) != null && status.getTextStatus() != SVNStatusKind.ADDED && (url = SvnUtils.getRepositoryRootUrl(file)) != null) {
                            client = Subversion.getInstance().getClient(url);
                            if (status.getLockOwner() != null) {
                                client.unlock(new File[]{file}, false);
                            }
                            client.lock(new File[]{file}, "", false);
                            readOnly = false;
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                        readOnly = true;
                    }
                    if (readOnly) {
                        FilesystemHandler.this.readOnlyFiles.put(file, Boolean.TRUE);
                    }
                    FilesystemHandler.this.toLockFiles.remove(file);
                }
            };
            if (EventQueue.isDispatchThread()) {
                Subversion.getInstance().getRequestProcessor().post(outsideAWT);
            } else {
                outsideAWT.run();
            }
        }
    }

    private SVNUrl getCopiedUrl(SvnClient client, File f) {
        block3: {
            try {
                ISVNInfo info = SvnUtils.getInfoFromWorkingCopy(client, f);
                if (info != null) {
                    return info.getCopyUrl();
                }
            }
            catch (SVNClientException e) {
                if (WorkingCopyAttributesCache.getInstance().isSuppressed(e)) break block3;
                Subversion.LOG.log(Level.INFO, null, e);
            }
        }
        return null;
    }
}

