/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.svnclientadapter.SvnClientAdapterFactory;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.JhlClientCallback;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientDescriptor;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientInvocationHandler;
import org.netbeans.modules.subversion.client.SvnKitClientCallback;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.client.cli.CommandlineClient;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SvnClientFactory {
    private static SvnClientFactory instance;
    private static ClientAdapterFactory factory;
    private static SVNClientException exception;
    private static boolean javahlCrash;
    private static final int JAVAHL_INIT_NOCRASH = 1;
    private static final int JAVAHL_INIT_STOP_REPORTING = 2;
    private static final Logger LOG;
    public static final String FACTORY_TYPE_COMMANDLINE = "commandline";
    public static final String FACTORY_TYPE_JAVAHL = "javahl";
    public static final String FACTORY_TYPE_SVNKIT = "svnkit";
    public static final String DEFAULT_FACTORY = "javahl";
    private static boolean cli16Version;

    private SvnClientFactory() {
    }

    public static synchronized SvnClientFactory getInstance() {
        SvnClientFactory.init();
        return instance;
    }

    public static synchronized void init() {
        if (instance == null) {
            SvnClientFactory fac = new SvnClientFactory();
            fac.setup();
            instance = fac;
        }
    }

    public static synchronized void resetClient() {
        instance = null;
        SvnConfigFiles.getInstance().reset();
    }

    public static boolean isCLI() {
        if (!SvnClientFactory.isClientAvailable()) {
            return false;
        }
        assert (factory != null);
        return factory.connectionType() == ConnectionType.cli;
    }

    public static boolean isCLIOldFormat() {
        return cli16Version;
    }

    public static boolean isJavaHl() {
        if (!SvnClientFactory.isClientAvailable()) {
            return false;
        }
        assert (factory != null);
        return factory.connectionType() == ConnectionType.javahl;
    }

    public static boolean isSvnKit() {
        if (!SvnClientFactory.isClientAvailable()) {
            return false;
        }
        assert (factory != null);
        return factory.connectionType() == ConnectionType.svnkit;
    }

    public SvnClient createSvnClient() throws SVNClientException {
        if (exception != null) {
            throw exception;
        }
        return factory.createSvnClient();
    }

    public SvnClient createSvnClient(SVNUrl repositoryUrl, SvnProgressSupport support, String username, char[] password, int handledExceptions) throws SVNClientException {
        if (exception != null) {
            throw exception;
        }
        try {
            return factory.createSvnClient(repositoryUrl, support, username, password, handledExceptions);
        }
        catch (Error err) {
            throw new SVNClientException((Throwable)err);
        }
    }

    static void switchToCLI() {
        LOG.log(Level.INFO, "Switching forcefully to a commandline client");
        SvnModuleConfig.getDefault().setPreferredFactoryType(FACTORY_TYPE_COMMANDLINE);
        SvnModuleConfig.getDefault().setForceCommnandlineClient(true);
        SvnClientFactory.resetClient();
    }

    private void setup() {
        block9: {
            try {
                exception = null;
                SvnConfigFiles.getInstance();
                String factoryType = this.getDefaultFactoryType(false);
                if (factoryType.trim().equals("javahl")) {
                    if (this.setupJavaHl()) {
                        return;
                    }
                    LOG.log(Level.INFO, "JavaHL not available. Falling back on SvnKit.");
                    if (this.setupSvnKit()) {
                        return;
                    }
                    LOG.log(Level.INFO, "SvnKit not available. Falling back on commandline.");
                    this.setupCommandline();
                    break block9;
                }
                if (factoryType.trim().equals(FACTORY_TYPE_SVNKIT)) {
                    if (this.setupSvnKit()) {
                        return;
                    }
                    LOG.log(Level.INFO, "SvnKit not available. Falling back on javahl.");
                    if (this.setupJavaHl()) {
                        return;
                    }
                    LOG.log(Level.INFO, "JavaHL not available. Falling back on comandline.");
                    this.setupCommandline();
                    break block9;
                }
                if (factoryType.trim().equals(FACTORY_TYPE_COMMANDLINE)) {
                    this.setupCommandline();
                    break block9;
                }
                throw new SVNClientException("Unknown factory: " + factoryType);
            }
            catch (SVNClientException e) {
                exception = e;
            }
        }
    }

    public static void checkClientAvailable() throws SVNClientException {
        SvnClientFactory.init();
        if (exception != null) {
            throw exception;
        }
    }

    public static boolean isClientAvailable() {
        SvnClientFactory.init();
        return exception == null;
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public static boolean wasJavahlCrash() {
        SvnClientFactory.init();
        if (javahlCrash) {
            javahlCrash = false;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setupJavaHl() {
        SvnClientAdapterFactory f;
        String jhlInitFile = Places.getUserDirectory().getAbsolutePath() + "/config/svn/jhlinit";
        File initFile = new File(jhlInitFile);
        if (this.checkJavahlCrash(initFile)) {
            return false;
        }
        try {
            if (!initFile.exists()) {
                initFile.createNewFile();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        try {
            f = SvnClientAdapterFactory.getInstance((SvnClientAdapterFactory.Client)SvnClientAdapterFactory.Client.JAVAHL);
            if (f == null) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.writeJavahlInitFlag(initFile, 1);
        }
        factory = new ClientAdapterFactory(){

            @Override
            protected ISVNClientAdapter createAdapter() {
                return f.createClient();
            }

            @Override
            protected SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter adapter, SvnClientDescriptor desc, SvnProgressSupport support, int handledExceptions) {
                return new SvnClientInvocationHandler(adapter, desc, support, handledExceptions, ConnectionType.javahl);
            }

            @Override
            protected ISVNPromptUserPassword createCallback(SVNUrl repositoryUrl, int handledExceptions) {
                return new JhlClientCallback(repositoryUrl, handledExceptions);
            }

            @Override
            protected ConnectionType connectionType() {
                return ConnectionType.javahl;
            }
        };
        LOG.info("running on javahl");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkJavahlCrash(File initFile) {
        if (!initFile.exists()) {
            LOG.fine("trying to init javahl first time.");
            return false;
        }
        FileReader r = null;
        try {
            r = new FileReader(initFile);
            int i = r.read();
            try {
                r.close();
                r = null;
            }
            catch (IOException e) {
                // empty catch block
            }
            switch (i) {
                case -1: {
                    this.writeJavahlInitFlag(initFile, 2);
                    javahlCrash = true;
                    LOG.log(Level.WARNING, "It appears that subversion java bindings initialization caused trouble in a previous Netbeans session. Please report.");
                    boolean bl = true;
                    return bl;
                }
                case 2: {
                    LOG.fine("won't init javahl due to problem in a previous try.");
                    boolean bl = true;
                    return bl;
                }
                case 1: {
                    LOG.fine("will try init javahl.");
                    boolean bl = false;
                    return bl;
                }
            }
            return false;
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
            return false;
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJavahlInitFlag(File initFile, int flag) {
        FileWriter w = null;
        try {
            w = new FileWriter(initFile);
            w.write(flag);
            w.flush();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, null, ex);
        }
        finally {
            try {
                if (w != null) {
                    w.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    private boolean setupSvnKit() {
        final SvnClientAdapterFactory f = SvnClientAdapterFactory.getInstance((SvnClientAdapterFactory.Client)SvnClientAdapterFactory.Client.SVNKIT);
        if (f == null) {
            return false;
        }
        factory = new ClientAdapterFactory(){

            @Override
            protected ISVNClientAdapter createAdapter() {
                return f.createClient();
            }

            @Override
            protected SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter adapter, SvnClientDescriptor desc, SvnProgressSupport support, int handledExceptions) {
                return new SvnClientInvocationHandler(adapter, desc, support, handledExceptions, ConnectionType.svnkit);
            }

            @Override
            protected ISVNPromptUserPassword createCallback(SVNUrl repositoryUrl, int handledExceptions) {
                return new SvnKitClientCallback(repositoryUrl, handledExceptions);
            }

            @Override
            protected ConnectionType connectionType() {
                return ConnectionType.svnkit;
            }

            @Override
            protected void setupAdapter(ISVNClientAdapter adapter, String username, char[] password, ISVNPromptUserPassword callback) {
                if (callback != null) {
                    adapter.addPasswordCallback(callback);
                }
                try {
                    File configDir = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath()));
                    adapter.setConfigDirectory(configDir);
                }
                catch (SVNClientException ex) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
                adapter.setUsername(username);
                adapter.setPassword(password == null ? "" : new String(password));
            }
        };
        LOG.fine("Setting svnkit prop: svnkit.http.methods=Basic");
        System.setProperty("svnkit.http.methods", "Basic");
        LOG.info("svnClientAdapter running on svnkit");
        return true;
    }

    public void setupCommandline() {
        if (!this.checkCLIExecutable()) {
            return;
        }
        factory = new ClientAdapterFactory(){

            @Override
            protected ISVNClientAdapter createAdapter() {
                return new CommandlineClient();
            }

            @Override
            protected SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter adapter, SvnClientDescriptor desc, SvnProgressSupport support, int handledExceptions) {
                return new SvnClientInvocationHandler(adapter, desc, support, handledExceptions, ConnectionType.cli);
            }

            @Override
            protected ISVNPromptUserPassword createCallback(SVNUrl repositoryUrl, int handledExceptions) {
                return null;
            }

            @Override
            protected ConnectionType connectionType() {
                return ConnectionType.cli;
            }
        };
        LOG.info("running on commandline");
    }

    private boolean checkCLIExecutable() {
        exception = null;
        SVNClientException ex = null;
        try {
            this.checkVersion();
        }
        catch (SVNClientException e) {
            ex = e;
        }
        if (ex == null) {
            LOG.fine("svn client returns correct version");
            return true;
        }
        String execPath = SvnModuleConfig.getDefault().getExecutableBinaryPath();
        if (execPath != null && !execPath.trim().equals("")) {
            exception = ex;
            LOG.log(Level.WARNING, "executable binary path set to {0} yet client not available.", new Object[]{execPath});
            return false;
        }
        if (Utilities.isUnix()) {
            LOG.fine("svn client isn't set on path yet. Will check known locations...");
            String[] locations = new String[]{"/usr/local/bin/", "/usr/bin/"};
            String name = "svn";
            for (String loc : locations) {
                File file = new File(loc, name);
                LOG.log(Level.FINE, "checking existence of {0}", new Object[]{file.getAbsolutePath()});
                if (!file.exists()) continue;
                SvnModuleConfig.getDefault().setExecutableBinaryPath(loc);
                try {
                    this.checkVersion();
                }
                catch (SVNClientException e) {
                    ex = e;
                    continue;
                }
                LOG.log(Level.INFO, "found svn executable binary. Setting executable binary path to {0}", new Object[]{loc});
                return true;
            }
        }
        exception = ex;
        return false;
    }

    private void checkVersion() throws SVNClientException {
        CommandlineClient cc = new CommandlineClient();
        try {
            this.setConfigDir(cc);
            cli16Version = cc.checkSupportedVersion();
        }
        catch (SVNClientException e) {
            LOG.log(Level.FINE, "checking version", e);
            throw e;
        }
    }

    private void setConfigDir(ISVNClientAdapter client) {
        if (client != null) {
            File configDir = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath()));
            try {
                client.setConfigDirectory(configDir);
            }
            catch (SVNClientException ex) {
                LOG.log(Level.INFO, null, ex);
            }
        }
    }

    private String getDefaultFactoryType(boolean forcedCommandlineFallbackEnabled) {
        SvnModuleConfig config = SvnModuleConfig.getDefault();
        String factoryType = config.getGlobalSvnFactory();
        if (forcedCommandlineFallbackEnabled && (factoryType == null || factoryType.trim().isEmpty()) && config.isForcedCommandlineClient()) {
            factoryType = FACTORY_TYPE_COMMANDLINE;
            LOG.log(Level.INFO, "setup: using commandline as the client - saved in preferences");
        } else {
            config.setForceCommnandlineClient(false);
        }
        if (factoryType == null || factoryType.trim().isEmpty()) {
            factoryType = config.getPreferredFactoryType("javahl");
        }
        return factoryType;
    }

    static {
        exception = null;
        javahlCrash = false;
        LOG = Logger.getLogger("org.netbeans.modules.subversion.client.SvnClientFactory");
    }

    private abstract class ClientAdapterFactory {
        private ClientAdapterFactory() {
        }

        protected abstract ISVNClientAdapter createAdapter();

        protected abstract SvnClientInvocationHandler getInvocationHandler(ISVNClientAdapter var1, SvnClientDescriptor var2, SvnProgressSupport var3, int var4);

        protected abstract ISVNPromptUserPassword createCallback(SVNUrl var1, int var2);

        protected abstract ConnectionType connectionType();

        SvnClient createSvnClient() {
            SvnClientInvocationHandler handler = this.getInvocationHandler(this.createAdapter(), this.createDescriptor(null), null, -1);
            SvnClient client = this.createSvnClient(handler);
            SvnClientFactory.this.setConfigDir(client);
            return client;
        }

        public SvnClient createSvnClient(SVNUrl repositoryUrl, SvnProgressSupport support, String username, char[] password, int handledExceptions) {
            ISVNClientAdapter adapter = this.createAdapter();
            SvnClientInvocationHandler handler = this.getInvocationHandler(adapter, this.createDescriptor(repositoryUrl), support, handledExceptions);
            this.setupAdapter(adapter, username, password, this.createCallback(repositoryUrl, handledExceptions));
            return this.createSvnClient(handler);
        }

        private SvnClientDescriptor createDescriptor(final SVNUrl repositoryUrl) {
            return new SvnClientDescriptor(){

                @Override
                public SVNUrl getSvnUrl() {
                    return repositoryUrl;
                }
            };
        }

        private SvnClient createSvnClient(SvnClientInvocationHandler handler) {
            Class<?> proxyClass = Proxy.getProxyClass(SvnClient.class.getClassLoader(), SvnClient.class);
            Subversion.getInstance().cleanupFilesystem();
            try {
                Constructor<?> c = proxyClass.getConstructor(InvocationHandler.class);
                return (SvnClient)c.newInstance(handler);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, null, e);
                return null;
            }
        }

        protected void setupAdapter(ISVNClientAdapter adapter, String username, char[] password, ISVNPromptUserPassword callback) {
            adapter.setUsername(username);
            if (callback != null) {
                adapter.addPasswordCallback(callback);
            } else {
                adapter.setPassword(password == null ? "" : new String(password));
            }
            try {
                File configDir = FileUtil.normalizeFile((File)new File(SvnConfigFiles.getNBConfigPath()));
                adapter.setConfigDirectory(configDir);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
        }
    }

    public static enum ConnectionType {
        javahl,
        cli,
        svnkit;

    }
}

