/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.history.Bundle;
import org.netbeans.modules.subversion.ui.history.SummaryView;
import org.netbeans.modules.subversion.ui.update.RevertModifications;
import org.netbeans.modules.subversion.ui.update.RevertModificationsAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

final class RepositoryRevision {
    private ISVNLogMessage message;
    private SVNUrl repositoryRootUrl;
    private final List<Event> events = new ArrayList<Event>(5);
    private List<Event> fakeRootEvents;
    private boolean eventsInitialized;
    private Search currentSearch;
    private final PropertyChangeSupport support;
    public static final String PROP_EVENTS_CHANGED = "eventsChanged";
    private final File[] selectionRoots;
    private final Map<String, File> pathToRoot;
    private final Map<String, SVNRevision> pegRevisions;

    public RepositoryRevision(ISVNLogMessage message, SVNUrl rootUrl, File[] selectionRoots, Map<String, File> pathToRoot, Map<String, SVNRevision> pegRevisions) {
        this.message = message;
        this.repositoryRootUrl = rootUrl;
        this.selectionRoots = selectionRoots;
        this.support = new PropertyChangeSupport(this);
        this.pathToRoot = pathToRoot;
        this.pegRevisions = pegRevisions;
        this.initFakeRootEvent();
    }

    public SVNUrl getRepositoryRootUrl() {
        return this.repositoryRootUrl;
    }

    List<Event> getDummyEvents() {
        return this.fakeRootEvents;
    }

    List<Event> getEvents() {
        return this.events;
    }

    public ISVNLogMessage getLog() {
        return this.message;
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(this.getLog().getRevision().getNumber());
        text.append("\t");
        text.append(this.getLog().getDate());
        text.append("\t");
        text.append(this.getLog().getAuthor());
        text.append("\n");
        text.append(this.getLog().getMessage());
        return text.toString();
    }

    public void sort(Comparator<Event> comparator) {
        if (this.events == null) {
            return;
        }
        Collections.sort(this.events, comparator);
    }

    boolean expandEvents() {
        Search s = this.currentSearch;
        if (s == null && !this.eventsInitialized) {
            this.currentSearch = new Search();
            this.currentSearch.start(Subversion.getInstance().getRequestProcessor(this.repositoryRootUrl), this.repositoryRootUrl, null);
            return true;
        }
        return !this.eventsInitialized;
    }

    void cancelExpand() {
        Search s = this.currentSearch;
        if (s != null) {
            s.cancel();
            this.currentSearch = null;
        }
    }

    boolean isEventsInitialized() {
        return this.eventsInitialized;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(propertyName, listener);
    }

    Action[] getActions() {
        ArrayList<1> actions = new ArrayList<1>();
        actions.add(new AbstractAction(NbBundle.getMessage(RepositoryRevision.class, (String)"CTL_SummaryView_RollbackChange")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SvnProgressSupport support = new SvnProgressSupport(){

                    @Override
                    public void perform() {
                        RevertModifications.RevisionInterval revisionInterval = new RevertModifications.RevisionInterval((SVNRevision)RepositoryRevision.this.getLog().getRevision());
                        Context ctx = new Context(RepositoryRevision.this.selectionRoots);
                        RevertModificationsAction.performRevert(revisionInterval, false, false, ctx, this);
                    }
                };
                support.start(Subversion.getInstance().getRequestProcessor(RepositoryRevision.this.repositoryRootUrl), RepositoryRevision.this.repositoryRootUrl, NbBundle.getMessage(SummaryView.class, (String)"MSG_Revert_Progress"));
            }
        });
        return actions.toArray(new Action[actions.size()]);
    }

    public void initFakeRootEvent() {
        this.fakeRootEvents = new LinkedList<Event>();
        for (final File selectionRoot : this.selectionRoots) {
            Event e = new Event(new ISVNLogMessageChangePath(){
                private String path;

                public String getPath() {
                    if (this.path == null) {
                        try {
                            this.path = SvnUtils.getRelativePath(selectionRoot);
                            if (!this.path.startsWith("/")) {
                                this.path = "/" + this.path;
                            }
                        }
                        catch (SVNClientException ex) {
                            Subversion.LOG.log(Level.INFO, selectionRoot.getAbsolutePath(), ex);
                            this.path = "/";
                        }
                    }
                    return this.path;
                }

                public SVNRevision.Number getCopySrcRevision() {
                    return null;
                }

                public String getCopySrcPath() {
                    return null;
                }

                public char getAction() {
                    return '?';
                }
            }, true, null);
            e.setFile(selectionRoot);
            this.fakeRootEvents.add(e);
        }
    }

    private File computeFile(String path) {
        for (String s : this.pathToRoot.keySet()) {
            if (!path.startsWith(s)) continue;
            return new File(this.pathToRoot.get(s), path.substring(s.length()));
        }
        return null;
    }

    private class Search
    extends SvnProgressSupport {
        private Search() {
        }

        @Override
        protected void perform() {
            block8: {
                try {
                    SvnClient client = Subversion.getInstance().getClient(RepositoryRevision.this.repositoryRootUrl, (SvnProgressSupport)this);
                    ISVNLogMessage[] messages = new ISVNLogMessage[]{};
                    if (RepositoryRevision.this.pegRevisions == null) {
                        messages = client.getLogMessages(RepositoryRevision.this.repositoryRootUrl, (SVNRevision)RepositoryRevision.this.message.getRevision(), (SVNRevision)RepositoryRevision.this.message.getRevision());
                    } else {
                        for (File f : RepositoryRevision.this.selectionRoots) {
                            String p = SvnUtils.getRelativePath(f);
                            if (p != null && p.startsWith("/")) {
                                p = p.substring(1, p.length());
                            }
                            if ((messages = client.getLogMessages(RepositoryRevision.this.repositoryRootUrl.appendPath(p), (SVNRevision)RepositoryRevision.this.pegRevisions.get(p), (SVNRevision)RepositoryRevision.this.message.getRevision(), (SVNRevision)RepositoryRevision.this.message.getRevision(), false, true, 0L)).length > 0) break;
                        }
                    }
                    if (messages.length > 0) {
                        final ISVNLogMessage msg = messages[0];
                        final List<Event> logEvents = this.prepareEvents(msg);
                        if (!this.isCanceled()) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (!Search.this.isCanceled()) {
                                        RepositoryRevision.this.message = msg;
                                        RepositoryRevision.this.events.clear();
                                        RepositoryRevision.this.fakeRootEvents.clear();
                                        RepositoryRevision.this.events.addAll(logEvents);
                                        RepositoryRevision.this.eventsInitialized = true;
                                        RepositoryRevision.this.currentSearch = null;
                                        RepositoryRevision.this.support.firePropertyChange(RepositoryRevision.PROP_EVENTS_CHANGED, null, new ArrayList(RepositoryRevision.this.events));
                                    }
                                }
                            });
                        }
                    }
                }
                catch (SVNClientException e) {
                    if (SvnClientExceptionHandler.handleLogException(RepositoryRevision.this.repositoryRootUrl, (SVNRevision)RepositoryRevision.this.message.getRevision(), e)) break block8;
                    this.annotate(e);
                }
            }
        }

        @Override
        protected void finnishProgress() {
        }

        @Override
        protected void startProgress() {
        }

        @Override
        protected ProgressHandle getProgressHandle() {
            return null;
        }

        private List<Event> prepareEvents(ISVNLogMessage message) {
            ISVNLogMessageChangePath[] paths = message.getChangedPaths();
            if (paths == null) {
                return Collections.emptyList();
            }
            ArrayList<Event> events = new ArrayList<Event>(paths.length);
            HashSet<String> removedPaths = new HashSet<String>(paths.length);
            for (ISVNLogMessageChangePath path : paths) {
                if (path.getAction() != 'D') continue;
                removedPaths.add(path.getPath());
            }
            for (ISVNLogMessageChangePath path : paths) {
                boolean underRoots = false;
                File f = RepositoryRevision.this.computeFile(path.getPath());
                if (f != null) {
                    File selectionRoot;
                    File[] arr$ = RepositoryRevision.this.selectionRoots;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && !(underRoots = VersioningSupport.isFlat((File)(selectionRoot = arr$[i$])) ? selectionRoot.equals(f) || selectionRoot.equals(f.getParentFile()) : Utils.isAncestorOrEqual((File)selectionRoot, (File)f)); ++i$) {
                    }
                }
                String action = Character.toString(path.getAction());
                if (path.getAction() == 'A' && path.getCopySrcPath() != null) {
                    action = removedPaths.contains(path.getCopySrcPath()) ? "R" : "C";
                }
                Event event = new Event(path, underRoots, action);
                event.setFile(f);
                if (path.getCopySrcPath() != null) {
                    event.setOriginalFile(RepositoryRevision.this.computeFile(path.getCopySrcPath()));
                }
                events.add(event);
            }
            Collections.sort(events, new EventFullNameComparator());
            return events;
        }
    }

    public static class EventBaseNameComparator
    implements Comparator<Event> {
        @Override
        public int compare(Event e1, Event e2) {
            if (e1 == null || e2 == null || e1.getName() == null || e2.getName() == null) {
                return 0;
            }
            return e1.getName().compareTo(e2.getName());
        }
    }

    public static class EventFullNameComparator
    implements Comparator<Event> {
        @Override
        public int compare(Event e1, Event e2) {
            if (e1 == null || e2 == null || e1.getChangedPath() == null || e2.getChangedPath() == null) {
                return 0;
            }
            return e1.getChangedPath().getPath().compareTo(e2.getChangedPath().getPath());
        }
    }

    public class Event {
        private File file;
        private ISVNLogMessageChangePath changedPath;
        private String name;
        private String path;
        private boolean underRoots;
        private File originalFile;
        private final String originalPath;
        private final String action;
        private final String originalName;
        private ArrayList<Action> actions;

        public Event(ISVNLogMessageChangePath changedPath, boolean underRoots, String displayAction) {
            this.changedPath = changedPath;
            this.name = changedPath.getPath().substring(changedPath.getPath().lastIndexOf(47) + 1);
            this.path = changedPath.getPath().substring(0, changedPath.getPath().lastIndexOf(47));
            this.originalPath = changedPath.getCopySrcPath();
            this.originalName = this.originalPath == null ? null : this.originalPath.substring(this.originalPath.lastIndexOf(47) + 1);
            this.underRoots = underRoots;
            this.action = displayAction == null ? Character.toString(changedPath.getAction()) : displayAction;
        }

        public RepositoryRevision getLogInfoHeader() {
            return RepositoryRevision.this;
        }

        public ISVNLogMessageChangePath getChangedPath() {
            return this.changedPath;
        }

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public File getOriginalFile() {
            return this.originalFile;
        }

        public void setOriginalFile(File originalFile) {
            this.originalFile = originalFile;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.path;
        }

        public String toString() {
            return this.changedPath.getPath();
        }

        boolean isUnderRoots() {
            return this.underRoots;
        }

        String getOriginalPath() {
            return this.originalPath;
        }

        String getOriginalName() {
            return this.originalName;
        }

        String getAction() {
            return this.action;
        }

        Action[] getActions() {
            if (this.actions == null) {
                boolean viewEnabled;
                this.actions = new ArrayList();
                boolean rollbackToEnabled = this.getFile() != null && this.getChangedPath().getAction() != 'D';
                boolean rollbackChangeEnabled = this.getFile() != null && (this.getChangedPath().getAction() != 'D' || !this.getFile().exists());
                boolean bl = viewEnabled = rollbackToEnabled && !this.getFile().isDirectory();
                if (rollbackChangeEnabled) {
                    this.actions.add(new AbstractAction(NbBundle.getMessage(RepositoryRevision.class, (String)"CTL_SummaryView_RollbackChange")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Event.this.revert();
                        }
                    });
                }
                if (rollbackToEnabled) {
                    this.actions.add(new AbstractAction(NbBundle.getMessage(RepositoryRevision.class, (String)"CTL_SummaryView_RollbackToShort")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

                                @Override
                                public void run() {
                                    Event.this.rollback();
                                }
                            });
                        }
                    });
                }
                if (viewEnabled) {
                    this.actions.add(new AbstractAction(NbBundle.getMessage(RepositoryRevision.class, (String)"CTL_SummaryView_View")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

                                @Override
                                public void run() {
                                    Event.this.viewFile(false);
                                }
                            });
                        }
                    });
                    this.actions.add(new AbstractAction(NbBundle.getMessage(RepositoryRevision.class, (String)"CTL_SummaryView_ShowAnnotations")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

                                @Override
                                public void run() {
                                    Event.this.viewFile(true);
                                }
                            });
                        }
                    });
                    this.actions.add(new AbstractAction(Bundle.CTL_Action_ViewCurrent_name()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

                                @Override
                                public void run() {
                                    Utils.openFile((File)FileUtil.normalizeFile((File)Event.this.getFile()));
                                }
                            });
                        }
                    });
                }
            }
            return this.actions.toArray(new Action[this.actions.size()]);
        }

        void viewFile(boolean showAnnotations) {
            File originFile = this.getFile();
            SVNRevision.Number rev = this.getLogInfoHeader().getLog().getRevision();
            SVNUrl repoUrl = this.getLogInfoHeader().getRepositoryRootUrl();
            SVNUrl fileUrl = repoUrl.appendPath(this.getChangedPath().getPath());
            SvnUtils.openInRevision(originFile, repoUrl, fileUrl, (SVNRevision)rev, (SVNRevision)rev, showAnnotations);
        }

        void rollback() {
            SvnProgressSupport support = new SvnProgressSupport(){

                @Override
                public void perform() {
                    File file = Event.this.getFile();
                    boolean wasDeleted = Event.this.getChangedPath().getAction() == 'D';
                    SVNUrl repoUrl = Event.this.getLogInfoHeader().getRepositoryRootUrl();
                    SVNUrl fileUrl = repoUrl.appendPath(Event.this.getChangedPath().getPath());
                    SVNRevision.Number revision = Event.this.getLogInfoHeader().getLog().getRevision();
                    SvnUtils.rollback(file, repoUrl, fileUrl, (SVNRevision)revision, wasDeleted, this.getLogger());
                }
            };
            support.start(Subversion.getInstance().getRequestProcessor(RepositoryRevision.this.repositoryRootUrl), RepositoryRevision.this.repositoryRootUrl, NbBundle.getMessage(RepositoryRevision.class, (String)"MSG_Rollback_Progress"));
        }

        void revert() {
            SvnProgressSupport support = new SvnProgressSupport(){

                @Override
                public void perform() {
                    RevertModifications.RevisionInterval revisionInterval = new RevertModifications.RevisionInterval((SVNRevision)Event.this.getLogInfoHeader().getLog().getRevision());
                    Context ctx = new Context(Event.this.getFile());
                    RevertModificationsAction.performRevert(revisionInterval, false, false, ctx, this);
                }
            };
            support.start(Subversion.getInstance().getRequestProcessor(RepositoryRevision.this.repositoryRootUrl), RepositoryRevision.this.repositoryRootUrl, NbBundle.getMessage(SummaryView.class, (String)"MSG_Revert_Progress"));
        }
    }
}

