/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.error;

import java.util.MissingResourceException;
import org.netbeans.modules.cnd.analysis.api.AnalyzerResponse;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.syntaxerr.AbstractCodeAudit;
import org.netbeans.modules.cnd.api.model.syntaxerr.AuditPreferences;
import org.netbeans.modules.cnd.api.model.syntaxerr.CodeAuditFactory;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorProvider;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmTemplateBasedReferencedObject;
import org.netbeans.modules.cnd.highlight.hints.ErrorInfoImpl;
import org.openide.util.NbBundle;

public final class IdentifierErrorProvider
extends AbstractCodeAudit {
    private static final boolean SHOW_TIMES = Boolean.getBoolean("cnd.identifier.error.provider.times");
    private static final int MAX_ERROR_LIMIT;
    private static final int UNRESOLVED = 1;
    private static final int UNRESOLVED_BUILT_IN = 2;
    private static final int UNRESOLVED_TEMPLATE = 3;
    private static final int UNRESOLVED_FORWARD = 4;
    private final int kind;
    private final String message;

    private IdentifierErrorProvider(String id, String name, String description, String defaultSeverity, boolean defaultEnabled, AuditPreferences preferences, int kind, String message) {
        super(id, name, description, defaultSeverity, defaultEnabled, preferences);
        this.kind = kind;
        this.message = message;
    }

    public boolean isSupportedEvent(CsmErrorProvider.EditorEvent kind) {
        return kind == CsmErrorProvider.EditorEvent.DocumentBased || kind == CsmErrorProvider.EditorEvent.FileBased;
    }

    public void doGetErrors(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
        if (!CsmErrorProvider.disableAsLibraryHeaderFile((CsmFile)request.getFile()) && request.getFile().isParsed()) {
            long start = System.currentTimeMillis();
            Thread currentThread = Thread.currentThread();
            CsmFile file = request.getFile();
            currentThread.setName("Provider " + this.getName() + " prosess " + file.getAbsolutePath());
            if (SHOW_TIMES) {
                System.err.println("#@# Error Highlighting update() have started for file " + file.getAbsolutePath());
            }
            CsmFileReferences.getDefault().accept((CsmScope)request.getFile(), request.getDocument(), (CsmFileReferences.Visitor)new ReferenceVisitor(request, response), CsmReferenceKind.ANY_REFERENCE_IN_ACTIVE_CODE);
            if (SHOW_TIMES) {
                System.err.println("#@# Error Highlighting update() done in " + (System.currentTimeMillis() - start) + "ms for file " + request.getFile().getAbsolutePath());
            }
        }
    }

    static {
        String limit = System.getProperty("cnd.highlighting.error.limit");
        int userInput = 100;
        if (limit != null) {
            try {
                userInput = Integer.parseInt(limit);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MAX_ERROR_LIMIT = userInput;
    }

    public static final class UnresolvedForwardFactory
    implements CodeAuditFactory {
        public AbstractCodeAudit create(AuditPreferences preferences) {
            String name = NbBundle.getMessage(IdentifierErrorProvider.class, (String)"IdentifierErrorProvider.unresolvedForward.name");
            String description = NbBundle.getMessage(IdentifierErrorProvider.class, (String)"IdentifierErrorProvider.unresolvedForward.description");
            String message = "IdentifierErrorProvider.unresolvedForward.message";
            return new IdentifierErrorProvider(name, name, description, "warning", true, preferences, 4, message);
        }
    }

    public static final class UnresolvedTemplateFactory
    implements CodeAuditFactory {
        public AbstractCodeAudit create(AuditPreferences preferences) {
            String name = NbBundle.getMessage(IdentifierErrorProvider.class, (String)"IdentifierErrorProvider.unresolvedTemplate.name");
            String description = NbBundle.getMessage(IdentifierErrorProvider.class, (String)"IdentifierErrorProvider.unresolvedTemplate.description");
            String message = "IdentifierErrorProvider.unresolvedTemplate.message";
            return new IdentifierErrorProvider(name, name, description, "warning", true, preferences, 3, message);
        }
    }

    public static final class UnresolvedBuildInFactory
    implements CodeAuditFactory {
        public AbstractCodeAudit create(AuditPreferences preferences) {
            String name = NbBundle.getMessage(IdentifierErrorProvider.class, (String)"IdentifierErrorProvider.unresolvedBuiltIn.name");
            String description = NbBundle.getMessage(IdentifierErrorProvider.class, (String)"IdentifierErrorProvider.unresolvedBuiltIn.description");
            String message = "IdentifierErrorProvider.unresolvedBuiltIn.message";
            return new IdentifierErrorProvider(name, name, description, "warning", false, preferences, 2, message);
        }
    }

    public static final class UnresolvedFactory
    implements CodeAuditFactory {
        public AbstractCodeAudit create(AuditPreferences preferences) {
            String name = NbBundle.getMessage(IdentifierErrorProvider.class, (String)"IdentifierErrorProvider.unresolved.name");
            String description = NbBundle.getMessage(IdentifierErrorProvider.class, (String)"IdentifierErrorProvider.unresolved.description");
            String message = "IdentifierErrorProvider.unresolved.message";
            return new IdentifierErrorProvider(name, name, description, "error", true, preferences, 1, message);
        }
    }

    private class ReferenceVisitor
    implements CsmFileReferences.Visitor {
        private final CsmErrorProvider.Request request;
        private final CsmErrorProvider.Response response;
        private int foundError = 0;

        public ReferenceVisitor(CsmErrorProvider.Request request, CsmErrorProvider.Response response) {
            this.request = request;
            this.response = response;
        }

        public void visit(CsmReferenceContext context) {
            if (MAX_ERROR_LIMIT >= 0 && this.foundError >= MAX_ERROR_LIMIT) {
                return;
            }
            if (!this.request.isCancelled()) {
                CsmReference ref = context.getReference();
                CsmObject referencedObject = ref.getReferencedObject();
                if (referencedObject == null) {
                    if (CsmFileReferences.isAfterUnresolved((CsmReferenceContext)context)) {
                        return;
                    }
                    if (CsmFileReferences.isMacroBased((CsmReferenceContext)context)) {
                        return;
                    }
                    int whatKind = 1;
                    if (CsmFileReferences.isBuiltInBased((CsmReference)ref)) {
                        whatKind = 2;
                    } else if (CsmFileReferences.isTemplateBased((CsmReferenceContext)context)) {
                        whatKind = 3;
                    } else if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)ref.getOwner())) {
                        whatKind = 4;
                    } else if (CsmKindUtilities.isEnumForwardDeclaration((CsmObject)ref.getOwner())) {
                        whatKind = 4;
                    }
                    if (whatKind == IdentifierErrorProvider.this.kind) {
                        this.addMessage(ref);
                    }
                } else if (referencedObject instanceof CsmTemplateBasedReferencedObject) {
                    if (CsmFileReferences.isAfterUnresolved((CsmReferenceContext)context)) {
                        return;
                    }
                    if (CsmFileReferences.isBuiltInBased((CsmReference)ref) || CsmFileReferences.isMacroBased((CsmReferenceContext)context)) {
                        return;
                    }
                    if (IdentifierErrorProvider.this.kind == 3) {
                        this.addMessage(ref);
                    }
                } else if (IdentifierErrorProvider.this.kind == 4 && CsmClassifierResolver.getDefault().isForwardClassifier(referencedObject)) {
                    this.addMessage(ref);
                }
            }
        }

        private void addMessage(CsmReference ref) throws MissingResourceException {
            ++this.foundError;
            if (this.response instanceof AnalyzerResponse) {
                String decoratedText = IdentifierErrorProvider.this.getID() + "\n" + NbBundle.getMessage(IdentifierErrorProvider.class, (String)IdentifierErrorProvider.this.message, (Object)ref.getText().toString());
                ((AnalyzerResponse)this.response).addError(AnalyzerResponse.AnalyzerSeverity.DetectedError, null, this.request.getFile().getFileObject(), (CsmErrorInfo)new ErrorInfoImpl("CodeAssistance", IdentifierErrorProvider.this.getID(), decoratedText, AbstractCodeAudit.toSeverity((String)IdentifierErrorProvider.this.minimalSeverity()), ref.getStartOffset(), ref.getEndOffset()));
            } else {
                String decoratedText = NbBundle.getMessage(IdentifierErrorProvider.class, (String)IdentifierErrorProvider.this.message, (Object)ref.getText().toString());
                this.response.addError((CsmErrorInfo)new ErrorInfoImpl("CodeAssistance", IdentifierErrorProvider.this.getID(), decoratedText, AbstractCodeAudit.toSeverity((String)IdentifierErrorProvider.this.minimalSeverity()), ref.getStartOffset(), ref.getEndOffset()));
            }
        }

        public boolean cancelled() {
            return this.request.isCancelled();
        }
    }
}

