/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.highlight.semantic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.highlight.semantic.ReferenceCollector;
import org.netbeans.modules.cnd.support.Interrupter;

public class ModelUtils {
    public static final int HIGHLIGHT_DELAY = ModelUtils.getInt("cnd.reparce.delay", 500);
    public static final int RESCHEDULE_HIGHLIGHT_DELAY = ModelUtils.getInt("cnd.reschedule.task.delay", 500);
    public static final int OCCURRENCES_DELAY = ModelUtils.getInt("cnd.reparce.delay", 300);
    public static final int RESCHEDULE_OCCURRENCES_DELAY = ModelUtils.getInt("cnd.reschedule.task.delay", 300);
    public static final int SEMANTIC_DELAY = ModelUtils.getInt("cnd.reparce.delay", 500);
    public static final int RESCHEDULE_SEMANTIC_DELAY = ModelUtils.getInt("cnd.reschedule.task.delay", 500);

    private ModelUtils() {
    }

    private static int getInt(String name, int result) {
        String text = System.getProperty(name);
        if (text != null) {
            try {
                result = Integer.parseInt(text);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    static List<CsmReference> collect(final CsmFile csmFile, Document doc, final ReferenceCollector collector, final Interrupter interrupter) {
        CsmFileReferences.getDefault().accept((CsmScope)csmFile, doc, new CsmFileReferences.Visitor(){

            public void visit(CsmReferenceContext context) {
                collector.visit(context.getReference(), csmFile);
            }

            public boolean cancelled() {
                return interrupter.cancelled();
            }
        });
        return collector.getReferences();
    }

    static List<CsmOffsetable> getInactiveCodeBlocks(CsmFile file, Document doc, Interrupter interrupter) {
        return CsmFileInfoQuery.getDefault().getUnusedCodeBlocks(file, interrupter);
    }

    static List<CsmReference> getMacroBlocks(CsmFile file, Document doc, Interrupter interrupter) {
        return CsmFileInfoQuery.getDefault().getMacroUsages(file, interrupter);
    }

    private static class ReferenceCounter {
        private CsmReference reference;
        private int count;

        public ReferenceCounter(CsmReference reference) {
            this.reference = reference;
            this.count = 1;
        }

        public CsmReference getFirstReference() {
            return this.reference;
        }

        public int getCount() {
            return this.count;
        }

        public void increment() {
            ++this.count;
            this.reference = null;
        }
    }

    static class UnusedVariableCollector
    implements ReferenceCollector {
        private final Map<CsmVariable, ReferenceCounter> counters = new LinkedHashMap<CsmVariable, ReferenceCounter>();
        private Set<CsmParameter> parameters;
        private final Interrupter interrupter;

        public UnusedVariableCollector(Interrupter interrupter) {
            this.interrupter = interrupter;
        }

        public String getEntityName() {
            return "unused-variables";
        }

        @Override
        public void visit(CsmReference ref, CsmFile file) {
            CsmObject obj;
            if (!this.cancelled() && this.isWanted(obj = ref.getReferencedObject(), file)) {
                CsmVariable var = (CsmVariable)obj;
                ReferenceCounter counter = this.counters.get(var);
                if (counter == null) {
                    counter = new ReferenceCounter(ref);
                    this.counters.put(var, counter);
                } else {
                    counter.increment();
                }
            }
        }

        @Override
        public List<CsmReference> getReferences() {
            ArrayList<CsmReference> result = new ArrayList<CsmReference>();
            for (ReferenceCounter counter : this.counters.values()) {
                if (counter.getCount() != 1) continue;
                result.add(counter.getFirstReference());
            }
            return result;
        }

        private boolean isWanted(CsmObject obj, CsmFile file) {
            if (!CsmKindUtilities.isLocalVariable((CsmObject)obj)) {
                return false;
            }
            CsmVariable var = (CsmVariable)obj;
            if (!var.getContainingFile().equals(file)) {
                return false;
            }
            if (CsmKindUtilities.isParameter((CsmObject)obj)) {
                CsmParameter prm = (CsmParameter)var;
                Set<CsmParameter> set = this.getFunctionDefinitionParameters(file);
                return set.contains(prm);
            }
            return true;
        }

        private Set<CsmParameter> getFunctionDefinitionParameters(CsmFile file) {
            if (this.parameters == null) {
                this.parameters = new HashSet<CsmParameter>();
                CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION});
                Iterator i = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter);
                while (i.hasNext()) {
                    CsmFunctionDefinition fundef = (CsmFunctionDefinition)i.next();
                    this.parameters.addAll(fundef.getParameters());
                }
            }
            return this.parameters;
        }

        @Override
        public boolean cancelled() {
            return this.interrupter.cancelled();
        }
    }

    static class FunctionReferenceCollector
    extends AbstractReferenceCollector {
        private final Interrupter interrupter;

        public FunctionReferenceCollector(Interrupter interrupter) {
            this.interrupter = interrupter;
        }

        public String getEntityName() {
            return "functions-names";
        }

        @Override
        public void visit(CsmReference ref, CsmFile file) {
            if (!this.cancelled() && this.isWanted(ref, file)) {
                this.list.add(ref);
            }
        }

        private boolean isWanted(CsmReference ref, CsmFile file) {
            CsmObject csmObject = ref.getReferencedObject();
            return CsmKindUtilities.isFunction((CsmObject)csmObject);
        }

        @Override
        public boolean cancelled() {
            return this.interrupter.cancelled();
        }
    }

    static class TypedefReferenceCollector
    extends AbstractReferenceCollector {
        private final Interrupter interrupter;

        public TypedefReferenceCollector(Interrupter interrupter) {
            this.interrupter = interrupter;
        }

        public String getEntityName() {
            return "typedefs";
        }

        @Override
        public void visit(CsmReference ref, CsmFile file) {
            CsmObject obj;
            if (!this.cancelled() && CsmKindUtilities.isTypedef((CsmObject)(obj = ref.getReferencedObject()))) {
                this.list.add(ref);
            }
        }

        @Override
        public boolean cancelled() {
            return this.interrupter.cancelled();
        }
    }

    static class FieldReferenceCollector
    extends AbstractReferenceCollector {
        private final Interrupter interrupter;

        public FieldReferenceCollector(Interrupter interrupter) {
            this.interrupter = interrupter;
        }

        public String getEntityName() {
            return "class-fields";
        }

        @Override
        public void visit(CsmReference ref, CsmFile file) {
            CsmObject obj;
            if (!this.cancelled() && CsmKindUtilities.isField((CsmObject)(obj = ref.getReferencedObject()))) {
                this.list.add(ref);
            }
        }

        @Override
        public boolean cancelled() {
            return this.interrupter.cancelled();
        }
    }

    private static abstract class AbstractReferenceCollector
    implements ReferenceCollector {
        protected final List<CsmReference> list = new ArrayList<CsmReference>();

        @Override
        public List<CsmReference> getReferences() {
            return this.list;
        }
    }
}

