/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.lang.model.element.Element;
import javax.swing.AbstractAction;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class OpenAction
extends AbstractAction {
    private ElementHandle<? extends Element> elementHandle;
    private FileObject fileObject;
    private String displayName;

    public OpenAction(ElementHandle<? extends Element> elementHandle, FileObject fileObject, String displayName) {
        this.elementHandle = elementHandle;
        this.fileObject = fileObject;
        this.displayName = displayName;
        this.putValue("Name", NbBundle.getMessage(OpenAction.class, (String)"LBL_Goto"));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (null == this.fileObject) {
            Toolkit.getDefaultToolkit().beep();
            if (null != this.displayName) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OpenAction.class, (String)"MSG_NoSource", (Object)this.displayName));
            }
        } else {
            FileObject src;
            FileObject file = this.fileObject;
            if (OpenAction.isClassFile(file) && (src = OpenAction.findSource(file, this.elementHandle)) != null) {
                file = src;
            }
            ElementOpen.open((FileObject)file, this.elementHandle);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private static boolean isClassFile(@NonNull FileObject file) {
        return "application/x-class-file".equals(file.getMIMEType(new String[]{"application/x-class-file"})) || "class".equals(file.getExt());
    }

    @CheckForNull
    private static FileObject findSource(@NonNull FileObject file, @NonNull ElementHandle<?> elementHandle) {
        String id;
        ClassPath cp;
        FileObject owner = null;
        String[] arr$ = new String[]{"classpath/execute", "classpath/compile", "classpath/boot"};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && ((cp = ClassPath.getClassPath((FileObject)file, (String)(id = arr$[i$]))) == null || (owner = cp.findOwnerRoot(file)) == null); ++i$) {
        }
        return owner == null ? owner : SourceUtils.getFile(elementHandle, (ClasspathInfo)ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{owner}), (ClassPath)ClassPath.EMPTY, (ClassPath)ClassPath.EMPTY));
    }
}

