/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute.cmd;

import java.io.File;
import java.io.IOException;
import org.apache.maven.execution.ExecutionEvent;
import org.json.simple.JSONObject;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.execute.cmd.ExecutionEventObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class ExecProject
extends ExecutionEventObject {
    public final ExecutionEventObject.GAV gav;
    @NullAllowed
    public final File currentProjectLocation;

    public ExecProject(ExecutionEventObject.GAV currentProject, File currentProjectLocation, ExecutionEvent.Type type) {
        super(type);
        this.gav = currentProject;
        this.currentProjectLocation = currentProjectLocation;
    }

    @CheckForNull
    public Project findProject() {
        FileObject fo;
        if (this.currentProjectLocation != null && (fo = FileUtil.toFileObject((File)this.currentProjectLocation)) != null) {
            try {
                return ProjectManager.getDefault().findProject(fo);
            }
            catch (IOException ex) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public static ExecutionEventObject create(JSONObject obj, ExecutionEvent.Type t) {
        JSONObject prj = (JSONObject)obj.get((Object)"prj");
        String id = (String)prj.get((Object)"id");
        String[] ids = id.split(":");
        ExecutionEventObject.GAV prjGav = new ExecutionEventObject.GAV(ids[0], ids[1], ids[2]);
        File prjFile = null;
        String file = (String)prj.get((Object)"file");
        if (file != null) {
            prjFile = FileUtil.normalizeFile((File)new File(file));
        }
        return new ExecProject(prjGav, prjFile, t);
    }
}

