/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.debug.CndDiagnosticProvider;
import org.netbeans.modules.cnd.modelui.actions.ProjectActionBase;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class CodeModelDiagnosticAction
extends ProjectActionBase {
    private static final Logger LOG = Logger.getLogger("CodeModelDiagnosticAction");
    private JPanel panel;
    private final List<ProviderAction> providerActions = new ArrayList<ProviderAction>();

    public CodeModelDiagnosticAction() {
        super(true);
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_CodeModelDiagnostic");
    }

    @Override
    protected boolean isEnabledEx(Node[] activatedNodes, Collection<CsmProject> projects) {
        if (super.isEnabledEx(activatedNodes, projects)) {
            return true;
        }
        for (Node node : activatedNodes) {
            if (node.getLookup().lookup(NativeFileItemSet.class) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void performAction(Collection<CsmProject> csmProjects) {
        Node[] activatedNodes = this.getActivatedNodes();
        ArrayList<Object> lookupObjects = new ArrayList<Object>();
        JTextComponent lastFocusedComponent = EditorRegistry.lastFocusedComponent();
        Document doc = null;
        if (lastFocusedComponent != null) {
            lookupObjects.add(lastFocusedComponent);
            doc = lastFocusedComponent.getDocument();
        }
        ArrayList<CsmFile> files = new ArrayList<CsmFile>();
        if (activatedNodes != null) {
            lookupObjects.addAll(Arrays.asList(activatedNodes));
            for (Node node : activatedNodes) {
                DataObject dob = (DataObject)node.getLookup().lookup(DataObject.class);
                if (dob == null) continue;
                lookupObjects.add(dob);
                CsmFile[] csmFiles = CsmUtilities.getCsmFiles((DataObject)dob, (boolean)false, (boolean)false);
                if (csmFiles == null) continue;
                files.addAll(Arrays.asList(csmFiles));
            }
        }
        if (doc != null) {
            lookupObjects.add(doc);
            if (files.isEmpty()) {
                DataObject dob;
                CsmFile csmFile = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false);
                if (csmFile != null) {
                    files.add(csmFile);
                }
                if ((dob = NbEditorUtilities.getDataObject((Document)doc)) != null && !lookupObjects.contains(dob)) {
                    lookupObjects.add(dob);
                }
            }
        }
        lookupObjects.addAll(csmProjects);
        lookupObjects.addAll(files);
        LOG.log(Level.INFO, "perform actions on {0}\n nodes={1}\n", new Object[]{csmProjects, activatedNodes});
        if (!lookupObjects.isEmpty()) {
            JPanel pnl = this.createPanel();
            DialogDescriptor descr = new DialogDescriptor((Object)pnl, "C/C++ Diagnostics");
            NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)descr));
            if (descr.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            Lookup context = Lookups.fixed((Object[])lookupObjects.toArray(new Object[lookupObjects.size()]));
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null) {
                tmpDir = "/var/tmp";
            }
            try {
                File tmpFile;
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ss");
                String date = df.format(new Date());
                try {
                    File file = new File(tmpDir, "cnd_diagnostics_" + date + ".txt");
                    file.delete();
                    file.createNewFile();
                    tmpFile = file;
                }
                catch (IOException e) {
                    tmpFile = File.createTempFile("cnd_diagnostics_", ".txt", new File(tmpDir));
                }
                PrintWriter pw = new PrintWriter(tmpFile);
                String taskName = "Cnd Diagnostics - " + tmpFile.getName();
                InputOutput io = IOProvider.getDefault().getIO(taskName, false);
                io.select();
                OutputWriter out = io.getOut();
                OutputWriter err = io.getErr();
                err.printf("dumping cnd diagnostics into %s%n", new Object[]{tmpFile});
                int i = 0;
                for (CsmFile csmFile : files) {
                    pw.printf("file [%d] [version=%d] [%s] of class %s%n", i++, CsmFileInfoQuery.getDefault().getFileVersion(csmFile), csmFile.getAbsolutePath(), csmFile.getClass().getName());
                }
                if (doc != null) {
                    DataObject dob = NbEditorUtilities.getDataObject((Document)doc);
                    boolean modified = false;
                    if (dob != null) {
                        modified = dob.isModified();
                    }
                    pw.printf("document version=%d timestamp=%s caret=[%d-%d]. Is modified? %s%n", DocumentUtilities.getDocumentVersion((Document)doc), DocumentUtilities.getDocumentTimestamp((Document)doc), lastFocusedComponent.getSelectionStart(), lastFocusedComponent.getSelectionEnd(), modified);
                }
                for (ProviderAction enabledProvider : this.providerActions) {
                    if (!enabledProvider.isSelected()) continue;
                    pw.printf("**********************%ndiagnostics of %s%n", enabledProvider.getProvider().getDisplayName());
                    enabledProvider.getProvider().dumpInfo(context, pw);
                }
                pw.close();
                try {
                    String line;
                    FileInputStream stream = new FileInputStream(tmpFile);
                    BufferedReader das = new BufferedReader(new InputStreamReader(stream));
                    while ((line = das.readLine()) != null) {
                        out.println(line);
                    }
                    err.printf("Cnd diagnostics is saved in %s%n", new Object[]{tmpFile});
                    das.close();
                }
                catch (IOException e) {
                    err.printf("Can not display file content %s,%ndue to %s%n", new Object[]{tmpFile, e.getMessage()});
                }
                err.close();
                out.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private JPanel createPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            Collection providers = Lookup.getDefault().lookupAll(CndDiagnosticProvider.class);
            this.panel.setPreferredSize(new Dimension(250, 32 * providers.size()));
            for (CndDiagnosticProvider prov : providers) {
                ++gridBagConstraints.gridy;
                ProviderAction providerAction = new ProviderAction(prov);
                this.providerActions.add(providerAction);
                JCheckBox cb = new JCheckBox(providerAction);
                cb.setSelected(providerAction.isSelected());
                this.panel.add((Component)cb, gridBagConstraints);
            }
        }
        return this.panel;
    }

    private static final class ProviderAction
    extends AbstractAction {
        private final CndDiagnosticProvider provider;
        private boolean selected;

        ProviderAction(CndDiagnosticProvider provider) {
            super(provider.getDisplayName());
            this.provider = provider;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.selected = !this.selected;
        }

        boolean isSelected() {
            return this.selected;
        }

        public CndDiagnosticProvider getProvider() {
            return this.provider;
        }
    }
}

