/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remotefs.versioning.util.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.Keymap;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.remotefs.versioning.hooks.VCSHook;
import org.netbeans.modules.remotefs.versioning.hooks.VCSHookContext;
import org.netbeans.modules.remotefs.versioning.util.common.Bundle;
import org.netbeans.modules.remotefs.versioning.util.common.CollapsiblePanel;
import org.netbeans.modules.remotefs.versioning.util.common.VCSCommitDiffProvider;
import org.netbeans.modules.remotefs.versioning.util.common.VCSCommitFilter;
import org.netbeans.modules.remotefs.versioning.util.common.VCSCommitTable;
import org.netbeans.modules.remotefs.versioning.util.common.VCSFileNode;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.diff.SaveBeforeClosingDiffConfirmation;
import org.netbeans.modules.versioning.diff.SaveBeforeCommitConfirmation;
import org.netbeans.modules.versioning.util.AutoResizingPanel;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.modules.versioning.util.VerticallyNonResizingPanel;
import org.netbeans.modules.versioning.util.common.VCSCommitPanelModifier;
import org.netbeans.modules.versioning.util.common.VCSCommitParameters;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.TabbedPaneFactory;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallbackSystemAction;

public abstract class VCSCommitPanel<F extends VCSFileNode>
extends AutoResizingPanel
implements PreferenceChangeListener,
TableModelListener,
ChangeListener,
PropertyChangeListener {
    public static final String PROP_COMMIT_EXCLUSIONS = "commitExclusions";
    static final Object EVENT_SETTINGS_CHANGED = new Object();
    private final AutoResizingPanel basePanel = new AutoResizingPanel();
    final JPanel progressPanel = new JPanel();
    private final JLabel errorLabel = new JLabel();
    private final JPanel parametersPane1 = new JPanel();
    private final JButton commitButton = new JButton();
    private final JButton cancelButton = new JButton();
    private VCSCommitTable commitTable;
    private JTabbedPane tabbedPane;
    private final Preferences preferences;
    private final VCSCommitParameters parameters;
    private final Map<String, VCSCommitFilter> filters = new LinkedHashMap<String, VCSCommitFilter>();
    private final VCSCommitDiffProvider diffProvider;
    private final VCSCommitPanelModifier modifier;
    private static final String ERROR_COLOR;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    public VCSCommitPanel(VCSCommitTable table, VCSCommitParameters parameters, Preferences preferences, Collection<? extends VCSHook> hooks, VCSHookContext hooksContext, List<VCSCommitFilter> filters, VCSCommitDiffProvider diffProvider) {
        this.parameters = parameters;
        this.commitTable = table;
        this.diffProvider = diffProvider;
        this.modifier = table.getCommitModifier();
        parameters.addChangeListener((ChangeListener)this);
        boolean selected = false;
        for (VCSCommitFilter f : filters) {
            assert (f.isSelected() && !selected || !f.isSelected());
            selected = f.isSelected();
            this.filters.put(f.getID(), f);
        }
        if (hooks == null) {
            hooks = Collections.emptyList();
        }
        this.initComponents(hooks, hooksContext);
        this.commitTable.setCommitPanel(this);
        this.preferences = preferences;
    }

    public VCSCommitTable<F> getCommitTable() {
        return this.commitTable;
    }

    public VCSCommitFilter getSelectedFilter() {
        for (VCSCommitFilter f : this.filters.values()) {
            if (!f.isSelected()) continue;
            return f;
        }
        assert (false) : "no filter selected";
        return null;
    }

    private JPanel getProgressPanel() {
        return this.progressPanel;
    }

    public void setErrorLabel(String htmlErrorLabel) {
        this.errorLabel.setText("<html><font color=\"" + ERROR_COLOR + "\">" + htmlErrorLabel + "</font></html>");
        this.errorLabel.setVisible(!htmlErrorLabel.isEmpty());
    }

    public void addNotify() {
        super.addNotify();
        this.preferences.addPreferenceChangeListener(this);
        this.commitTable.getTableModel().addTableModelListener(this);
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
    }

    public VCSCommitParameters getParameters() {
        return this.parameters;
    }

    public void removeNotify() {
        this.commitTable.getTableModel().removeTableModelListener(this);
        this.preferences.removePreferenceChangeListener(this);
        super.removeNotify();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith(PROP_COMMIT_EXCLUSIONS)) {
            Runnable inAWT = new Runnable(){

                @Override
                public void run() {
                    VCSCommitPanel.this.commitTable.dataChanged();
                    VCSCommitPanel.this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
                }
            };
            if (EventQueue.isDispatchThread()) {
                inAWT.run();
            } else {
                EventQueue.invokeLater(inAWT);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
    }

    protected abstract void computeNodes();

    protected boolean isCommitButtonEnabled() {
        return this.commitButton.isEnabled();
    }

    protected void enableCommitButton(boolean enabled) {
        this.commitButton.setEnabled(enabled);
    }

    protected void stopProgress() {
        JPanel p = this.getProgressPanel();
        p.removeAll();
        p.setVisible(false);
    }

    protected void setupProgress(String message, JComponent progressComponent) {
        JPanel p = this.getProgressPanel();
        p.setLayout(new BoxLayout(p, 0));
        JLabel l = new JLabel(message);
        p.add(l);
        p.add(VCSCommitPanel.makeHorizontalStrut(l, progressComponent, LayoutStyle.ComponentPlacement.RELATED, p));
        p.add(progressComponent);
    }

    protected void showProgress() {
        JPanel p = this.getProgressPanel();
        p.setVisible(true);
    }

    private void initComponents(Collection<? extends VCSHook> hooks, VCSHookContext hooksContext) {
        Mnemonics.setLocalizedText((AbstractButton)this.commitButton, (String)this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.COMMIT_BUTTON_LABEL));
        this.commitButton.getAccessibleContext().setAccessibleName(this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.COMMIT_BUTTON_ACCESSIBLE_NAME));
        this.commitButton.getAccessibleContext().setAccessibleDescription(this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.COMMIT_BUTTON_ACCESSIBLE_DESCRIPTION));
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)NbBundle.getMessage(VCSCommitPanel.class, (String)"CTL_Commit_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VCSCommitPanel.class, (String)"ACSN_Commit_Action_Cancel"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VCSCommitPanel.class, (String)"ACSD_Commit_Action_Cancel"));
        this.getAccessibleContext().setAccessibleName(this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.PANEL_ACCESSIBLE_NAME));
        this.getAccessibleContext().setAccessibleDescription(this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.PANEL_ACCESSIBLE_DESCRIPTION));
        this.basePanel.setBorder(BorderFactory.createEmptyBorder(10, this.getContainerGap(7), 0, this.getContainerGap(3)));
        this.basePanel.setLayout((LayoutManager)new BoxLayout((Container)this.basePanel, 1));
        this.parametersPane1.setLayout(new BorderLayout());
        this.parametersPane1.add(this.parameters.getPanel());
        this.parametersPane1.setAlignmentX(0.0f);
        this.basePanel.add((Component)this.parametersPane1);
        CollapsiblePanel.FilesPanel filesPanel = new CollapsiblePanel.FilesPanel(this, this.filters, this.parameters.getPanel().getPreferredSize().height);
        this.basePanel.add(VCSCommitPanel.makeVerticalStrut(this.parametersPane1, filesPanel, LayoutStyle.ComponentPlacement.RELATED, (JPanel)((Object)this)));
        this.basePanel.add((Component)filesPanel);
        int hooksWidth = -1;
        if (!hooks.isEmpty()) {
            CollapsiblePanel.HookPanel hooksPanel = new CollapsiblePanel.HookPanel(this, hooks, hooksContext);
            hooksPanel.setAlignmentX(0.0f);
            this.basePanel.add((Component)hooksPanel);
            this.basePanel.add(VCSCommitPanel.makeVerticalStrut(hooksPanel, this.errorLabel, LayoutStyle.ComponentPlacement.RELATED, (JPanel)((Object)this)));
            hooksWidth = hooksPanel.getPreferedWidth();
        } else {
            this.basePanel.add(VCSCommitPanel.makeVerticalStrut(filesPanel, this.errorLabel, LayoutStyle.ComponentPlacement.RELATED, (JPanel)((Object)this)));
        }
        VerticallyNonResizingPanel bottomPanel = new VerticallyNonResizingPanel();
        bottomPanel.setLayout(new BoxLayout((Container)bottomPanel, 1));
        bottomPanel.add(this.progressPanel);
        bottomPanel.add(this.errorLabel);
        this.errorLabel.setAlignmentY(0.5f);
        this.errorLabel.setText("");
        this.errorLabel.setVisible(false);
        this.errorLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/versioning/util/resources/error.gif", (boolean)false));
        this.progressPanel.setAlignmentY(0.0f);
        bottomPanel.setAlignmentX(0.0f);
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, this.getContainerGap(7), 0, this.getContainerGap(3)));
        this.basePanel.add((Component)bottomPanel);
        int baseWidth = this.basePanel.getPreferredSize().width;
        int baseHeight = this.basePanel.getPreferredSize().height;
        int parametersWidth = this.parametersPane1.getPreferredSize().width;
        if (baseWidth < parametersWidth) {
            baseWidth = parametersWidth;
        }
        if (baseWidth < hooksWidth) {
            baseWidth = hooksWidth;
        }
        this.basePanel.setPreferredSize(new Dimension(baseWidth, baseHeight));
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add((Component)this.basePanel);
    }

    static Component makeVerticalStrut(JComponent compA, JComponent compB, LayoutStyle.ComponentPlacement relatedUnrelated, JPanel parent) {
        int height = LayoutStyle.getInstance().getPreferredGap(compA, compB, relatedUnrelated, 5, parent);
        return Box.createVerticalStrut(height);
    }

    static Component makeHorizontalStrut(JComponent compA, JComponent compB, LayoutStyle.ComponentPlacement relatedUnrelated, JPanel parent) {
        int width = LayoutStyle.getInstance().getPreferredGap(compA, compB, relatedUnrelated, 7, parent);
        return Box.createHorizontalStrut(width);
    }

    int getContainerGap(int direction) {
        return LayoutStyle.getInstance().getContainerGap((JComponent)((Object)this), direction, null);
    }

    public void addVersioningListener(VersioningListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeVersioningListener(VersioningListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.tabbedPane && this.tabbedPane.getSelectedComponent() == this.basePanel) {
            if (this.diffProvider != null) {
                this.commitTable.setModifiedFiles(this.diffProvider.getModifiedFiles());
            }
        } else if (e.getSource() == this.parameters || e.getSource() == this.commitTable) {
            this.valuesChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void valuesChanged() {
        boolean commitable;
        String errroMsg;
        block4: {
            block3: {
                errroMsg = null;
                commitable = true;
                try {
                    commitable = this.parameters.isCommitable();
                    if (commitable) break block3;
                    errroMsg = this.parameters.getErrorMessage();
                }
                catch (Throwable throwable) {
                    this.commitButton.setEnabled(commitable);
                    this.setErrorLabel(errroMsg != null ? errroMsg : "");
                    throw throwable;
                }
                this.commitButton.setEnabled(commitable);
                this.setErrorLabel(errroMsg != null ? errroMsg : "");
                return;
            }
            errroMsg = this.commitTable.getErrorMessage();
            if (commitable &= this.commitTable.containsCommitable()) break block4;
            this.commitButton.setEnabled(commitable);
            this.setErrorLabel(errroMsg != null ? errroMsg : "");
            return;
        }
        this.commitButton.setEnabled(commitable);
        this.setErrorLabel(errroMsg != null ? errroMsg : "");
    }

    void openDiff(F[] nodes, List<F> allNodes) {
        if (this.diffProvider == null) {
            return;
        }
        boolean newDiff = false;
        VCSFileNode[] nodeArray = allNodes.toArray((VCSFileNode[])Array.newInstance(nodes.getClass().getComponentType(), allNodes.size()));
        JComponent component = this.diffProvider.getDiffComponent(nodeArray);
        if (component == null) {
            for (F node : nodes) {
                this.initializeCommitPane();
                VCSFileProxy file = ((VCSFileNode)node).getFile();
                component = this.diffProvider.getDiffComponent(file);
                if (component == null) continue;
                if (this.tabbedPane.indexOfComponent(component) == -1) {
                    this.tabbedPane.addTab(file.getName(), component);
                }
                this.tabbedPane.setSelectedComponent(component);
                this.tabbedPane.requestFocusInWindow();
                newDiff = true;
            }
        } else {
            this.initializeCommitPane();
            if (nodes.length > 0) {
                this.diffProvider.selectFile(((VCSFileNode)nodes[0]).getFile());
            }
            if (this.tabbedPane.indexOfComponent(component) == -1) {
                int existingTab = this.tabbedPane.indexOfTab(Bundle.VCSCommitPanel_DiffTab_name());
                if (existingTab != -1) {
                    this.tabbedPane.remove(existingTab);
                }
                this.tabbedPane.addTab(Bundle.VCSCommitPanel_DiffTab_name(), component);
            }
            this.tabbedPane.setSelectedComponent(component);
            this.tabbedPane.requestFocusInWindow();
            newDiff = true;
        }
        if (newDiff) {
            this.revalidate();
            this.repaint();
        }
    }

    private void initializeCommitPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = TabbedPaneFactory.createCloseButtonTabbedPane();
            this.tabbedPane.addPropertyChangeListener(this);
            this.tabbedPane.addTab(this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.TABS_MAIN_NAME), (Component)this.basePanel);
            this.tabbedPane.setPreferredSize(this.basePanel.getPreferredSize());
            this.add(this.tabbedPane);
            this.tabbedPane.addChangeListener(this);
        }
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean ret = super.processKeyBinding(ks, e, condition, pressed);
        if (1 == condition && !ret && !e.isConsumed()) {
            Action action;
            Keymap km = (Keymap)Lookup.getDefault().lookup(Keymap.class);
            Action action2 = action = km != null ? km.getAction(ks) : null;
            if (action == null) {
                return false;
            }
            if (action instanceof CallbackSystemAction) {
                Action a;
                CallbackSystemAction csAction = (CallbackSystemAction)action;
                if (this.tabbedPane != null && (a = this.tabbedPane.getActionMap().get(csAction.getActionMapKey())) != null) {
                    a.actionPerformed(new ActionEvent(this, 1001, Utilities.keyToString((KeyStroke)ks)));
                    return true;
                }
            }
            return false;
        }
        return ret;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("close".equals(evt.getPropertyName())) {
            JComponent comp = (JComponent)evt.getNewValue();
            this.removeTab(comp);
        }
    }

    private void removeTab(JComponent comp) {
        if (this.basePanel != comp && this.tabbedPane != null && this.tabbedPane.getTabCount() > 1) {
            this.tabbedPane.remove(comp);
            this.revalidate();
        }
    }

    boolean canCommit() {
        boolean result = true;
        if (this.tabbedPane != null && this.tabbedPane.getSelectedComponent() != this.basePanel) {
            NotifyDescriptor nd = new NotifyDescriptor((Object)this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.MESSAGE_FINISHING_FROM_DIFF), this.modifier.getMessage(VCSCommitPanelModifier.BundleMessage.MESSAGE_FINISHING_FROM_DIFF_TITLE), 0, 3, null, NotifyDescriptor.YES_OPTION);
            result = NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify(nd);
        }
        return result;
    }

    public boolean open(VCSContext context, HelpCtx helpCtx) {
        String contentTitle = VCSFileProxySupport.getContextDisplayName(context);
        return this.open(context, helpCtx, NbBundle.getMessage(VCSCommitPanel.class, (String)"CTL_CommitDialog_Title", (Object)contentTitle));
    }

    public boolean open(VCSContext context, HelpCtx helpCtx, String title) {
        final DialogDescriptor dd = new DialogDescriptor((Object)this, title, true, new Object[]{this.commitButton, this.cancelButton}, (Object)this.commitButton, 0, helpCtx, null);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dd.setClosingOptions(new Object[]{VCSCommitPanel.this.commitButton, VCSCommitPanel.this.cancelButton});
                SaveCookie[] saveCookies = VCSCommitPanel.this.diffProvider.getSaveCookies();
                if (VCSCommitPanel.this.cancelButton == e.getSource()) {
                    if (saveCookies.length > 0) {
                        if (SaveBeforeClosingDiffConfirmation.allSaved((SaveCookie[])saveCookies) || !VCSCommitPanel.this.isShowing()) {
                            EditorCookie[] editorCookies;
                            for (EditorCookie cookie : editorCookies = VCSCommitPanel.this.diffProvider.getEditorCookies()) {
                                cookie.open();
                            }
                        } else {
                            dd.setClosingOptions(new Object[0]);
                        }
                    }
                    dd.setValue((Object)VCSCommitPanel.this.cancelButton);
                } else if (VCSCommitPanel.this.commitButton == e.getSource()) {
                    if (saveCookies.length > 0 && !SaveBeforeCommitConfirmation.allSaved((SaveCookie[])saveCookies)) {
                        dd.setClosingOptions(new Object[0]);
                    } else if (!VCSCommitPanel.this.canCommit()) {
                        dd.setClosingOptions(new Object[0]);
                    }
                    dd.setValue((Object)VCSCommitPanel.this.commitButton);
                }
            }
        };
        dd.setButtonListener(al);
        VCSCommitTable<F> table = this.getCommitTable();
        this.computeNodes();
        this.addVersioningListener(new VersioningListener(){

            public void versioningEvent(VersioningEvent event) {
                VCSCommitPanel.this.valuesChanged();
            }
        });
        table.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                VCSCommitPanel.this.valuesChanged();
            }
        });
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        DialogBoundsPreserver windowListener = new DialogBoundsPreserver(this.preferences, this.getClass().getName());
        dialog.addWindowListener((WindowListener)windowListener);
        dialog.pack();
        windowListener.windowOpened(new WindowEvent(dialog, 200));
        dialog.setVisible(true);
        if (dd.getValue() == DialogDescriptor.CLOSED_OPTION) {
            al.actionPerformed(new ActionEvent(this.cancelButton, 1001, null));
        }
        return dd.getValue() == this.commitButton;
    }

    VCSCommitPanelModifier getModifier() {
        return this.modifier;
    }

    private static String getColorString(Color c) {
        return "#" + VCSCommitPanel.getHex(c.getRed()) + VCSCommitPanel.getHex(c.getGreen()) + VCSCommitPanel.getHex(c.getBlue());
    }

    private static String getHex(int i) {
        String hex = Integer.toHexString(i & 0xFF);
        if (hex.length() == 1) {
            hex = "0" + hex;
        }
        return hex;
    }

    static {
        Color c = UIManager.getColor("nb.errorForeground");
        ERROR_COLOR = c == null ? "#990000" : VCSCommitPanel.getColorString(c);
    }
}

