/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.metro.model.ui;

import com.sun.xml.ws.runtime.config.MetroConfig;
import com.sun.xml.ws.runtime.config.ObjectFactory;
import com.sun.xml.ws.runtime.config.TubeFactoryConfig;
import com.sun.xml.ws.runtime.config.TubeFactoryList;
import com.sun.xml.ws.runtime.config.TubelineDefinition;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.xml.namespace.QName;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.jaxwsruntimemodel.JavaWsdlMapper;
import org.netbeans.modules.websvc.metro.model.MetroConfigLoader;
import org.netbeans.modules.websvc.metro.model.ui.TubesConfigPanel;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class TubesEditor
implements WSEditor {
    private static final Logger logger = Logger.getLogger(TubesEditor.class.getName());
    private JAXWSLightSupport jaxWsSupport;
    private JaxWsService jaxWsService;
    private Project project;
    private ObjectFactory objFactory = new ObjectFactory();
    private String ref = null;
    private MetroConfigLoader cfgLoader = new MetroConfigLoader();
    private MetroConfig cfg = null;
    private List<TubeFactoryConfig> cfgList = null;
    private TubesConfigPanel panel = null;
    private boolean isClient = false;

    public TubesEditor(Project project) {
        this.project = project;
    }

    public TubesEditor(JAXWSLightSupport supp, JaxWsService jaxWsService, Project p) {
        this.project = p;
        this.jaxWsService = jaxWsService;
        this.jaxWsSupport = supp;
    }

    public String getTitle() {
        return NbBundle.getMessage(TubesEditor.class, (String)"TUBES_EDITOR_TITLE");
    }

    public JComponent createWSEditorComponent(Node node) {
        if (this.project == null) {
            return new JPanel();
        }
        if (this.jaxWsService == null) {
            Client client = (Client)node.getLookup().lookup(Client.class);
            Service service = (Service)node.getLookup().lookup(Service.class);
            boolean bl = this.isClient = client != null;
            if (this.isClient) {
                JAXWSClientSupport wscs = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.project.getProjectDirectory());
                if (wscs != null) {
                    FileObject wsdlFolder = wscs.getLocalWsdlFolderForClient(client.getName(), false);
                    FileObject wsdl = wsdlFolder != null ? wsdlFolder.getFileObject(client.getLocalWsdlFile()) : null;
                    this.ref = this.getServiceRef(TubesEditor.getModelFromFO(wsdl, false));
                    this.cfg = this.cfgLoader.loadMetroConfig(this.project);
                    if (this.cfg == null) {
                        this.cfg = this.cfgLoader.loadDefaultMetroConfig(this.project);
                        if (this.cfg == null) {
                            this.cfg = this.cfgLoader.createFreshMetroConfig();
                        }
                    }
                    boolean overrideDefaults = this.cfgLoader.getTubeline(this.cfg, this.ref) != null;
                    TubelineDefinition tDef = this.cfgLoader.createTubeline(this.cfg, this.ref, client.getName() + "Tubeline");
                    TubeFactoryList factoryList = tDef.getClientSide();
                    if (factoryList == null) {
                        factoryList = this.objFactory.createTubeFactoryList();
                        tDef.setClientSide(factoryList);
                    }
                    this.cfgList = factoryList.getTubeFactoryConfigs();
                    try {
                        this.panel = new TubesConfigPanel(this.project, factoryList, true, overrideDefaults);
                        return this.panel;
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, null, e);
                    }
                }
            } else if (service != null) {
                JAXWSSupport wss = JAXWSSupport.getJAXWSSupport((FileObject)this.project.getProjectDirectory());
                String serviceName = service.getServiceName();
                if (wss.isFromWSDL(service.getName())) {
                    FileObject wsdlFolder = wss.getLocalWsdlFolderForService(service.getName(), false);
                    FileObject wsdl = wsdlFolder != null ? wsdlFolder.getFileObject(service.getLocalWsdlFile()) : null;
                    WSDLModel wsdlModel = TubesEditor.getModelFromFO(wsdl, false);
                    String namespace = wsdlModel.getDefinitions().getTargetNamespace();
                    String portName = service.getPortName();
                    this.ref = namespace + "#(" + serviceName + "/" + portName + ")";
                } else {
                    FileObject implClass = (FileObject)node.getLookup().lookup(FileObject.class);
                    String namespace = JavaWsdlMapper.getNamespace((String)JavaWsdlMapper.getPackageFromClass((String)service.getImplementationClass()));
                    QName portQName = JavaWsdlMapper.getPortName((FileObject)implClass, (String)namespace);
                    QName serviceQName = JavaWsdlMapper.getServiceName((FileObject)implClass);
                    serviceName = serviceQName.getLocalPart();
                    this.ref = namespace + "#(" + serviceName + "/" + portQName.getLocalPart() + ")";
                }
                this.cfg = this.cfgLoader.loadMetroConfig(this.project);
                if (this.cfg == null) {
                    this.cfg = this.cfgLoader.loadDefaultMetroConfig(this.project);
                    if (this.cfg == null) {
                        this.cfg = this.cfgLoader.createFreshMetroConfig();
                    }
                }
                boolean overrideDefaults = this.cfgLoader.getTubeline(this.cfg, this.ref) != null;
                TubelineDefinition tDef = this.cfgLoader.createTubeline(this.cfg, this.ref, serviceName + "Tubeline");
                TubeFactoryList factoryList = tDef.getEndpointSide();
                if (factoryList == null) {
                    factoryList = this.objFactory.createTubeFactoryList();
                    tDef.setEndpointSide(factoryList);
                }
                this.cfgList = factoryList.getTubeFactoryConfigs();
                try {
                    this.panel = new TubesConfigPanel(this.project, factoryList, false, overrideDefaults);
                    return this.panel;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, null, e);
                }
            }
        } else if (!this.jaxWsService.isServiceProvider()) {
            FileObject wsdlFolder = this.jaxWsSupport.getWsdlFolder(false);
            FileObject wsdl = wsdlFolder != null ? wsdlFolder.getFileObject(this.jaxWsService.getLocalWsdl()) : null;
            WSDLModel model = TubesEditor.getModelFromFO(wsdl, false);
            this.ref = this.getServiceRef(model);
            String serviceName = null;
            Collection services = model.getDefinitions().getServices();
            Iterator i$ = services.iterator();
            if (i$.hasNext()) {
                org.netbeans.modules.xml.wsdl.model.Service s = (org.netbeans.modules.xml.wsdl.model.Service)i$.next();
                serviceName = s.getName();
            }
            this.cfg = this.cfgLoader.loadMetroConfig(this.project);
            if (this.cfg == null) {
                this.cfg = this.cfgLoader.loadDefaultMetroConfig(this.project);
                if (this.cfg == null) {
                    this.cfg = this.cfgLoader.createFreshMetroConfig();
                }
            }
            boolean overrideDefaults = this.cfgLoader.getTubeline(this.cfg, this.ref) != null;
            TubelineDefinition tDef = this.cfgLoader.createTubeline(this.cfg, this.ref, serviceName + "Tubeline");
            TubeFactoryList factoryList = tDef.getClientSide();
            if (factoryList == null) {
                factoryList = this.objFactory.createTubeFactoryList();
                tDef.setClientSide(factoryList);
            }
            this.cfgList = factoryList.getTubeFactoryConfigs();
            try {
                this.panel = new TubesConfigPanel(this.project, factoryList, true, overrideDefaults);
                return this.panel;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, null, e);
            }
        } else {
            String serviceName = this.jaxWsService.getServiceName();
            if (this.jaxWsService.getLocalWsdl() != null) {
                FileObject wsdlFolder = this.jaxWsSupport.getWsdlFolder(false);
                FileObject wsdl = wsdlFolder != null ? wsdlFolder.getFileObject(this.jaxWsService.getLocalWsdl()) : null;
                WSDLModel wsdlModel = TubesEditor.getModelFromFO(wsdl, false);
                String namespace = wsdlModel.getDefinitions().getTargetNamespace();
                String portName = this.jaxWsService.getPortName();
                this.ref = namespace + "#(" + serviceName + "/" + portName + ")";
            } else {
                FileObject implClass = (FileObject)node.getLookup().lookup(FileObject.class);
                String namespace = JavaWsdlMapper.getNamespace((String)JavaWsdlMapper.getPackageFromClass((String)this.jaxWsService.getImplementationClass()));
                QName portQName = JavaWsdlMapper.getPortName((FileObject)implClass, (String)namespace);
                QName serviceQName = JavaWsdlMapper.getServiceName((FileObject)implClass);
                serviceName = serviceQName.getLocalPart();
                this.ref = namespace + "#(" + serviceName + "/" + portQName.getLocalPart() + ")";
            }
            this.cfg = this.cfgLoader.loadMetroConfig(this.project);
            if (this.cfg == null) {
                this.cfg = this.cfgLoader.loadDefaultMetroConfig(this.project);
                if (this.cfg == null) {
                    this.cfg = this.cfgLoader.createFreshMetroConfig();
                }
            }
            boolean overrideDefaults = this.cfgLoader.getTubeline(this.cfg, this.ref) != null;
            TubelineDefinition tDef = this.cfgLoader.createTubeline(this.cfg, this.ref, serviceName + "Tubeline");
            TubeFactoryList factoryList = tDef.getEndpointSide();
            if (factoryList == null) {
                factoryList = this.objFactory.createTubeFactoryList();
                tDef.setEndpointSide(factoryList);
            }
            this.cfgList = factoryList.getTubeFactoryConfigs();
            try {
                this.panel = new TubesConfigPanel(this.project, factoryList, false, overrideDefaults);
                return this.panel;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, null, e);
            }
        }
        return new JPanel();
    }

    private String getServiceRef(WSDLModel model) {
        Definitions def = model.getDefinitions();
        String namespace = def.getTargetNamespace();
        String serviceName = null;
        String portName = null;
        Collection services = def.getServices();
        Iterator i$ = services.iterator();
        if (i$.hasNext()) {
            org.netbeans.modules.xml.wsdl.model.Service s = (org.netbeans.modules.xml.wsdl.model.Service)i$.next();
            serviceName = s.getName();
            Collection ports = s.getPorts();
            Iterator i$2 = ports.iterator();
            if (i$2.hasNext()) {
                Port p = (Port)i$2.next();
                portName = p.getName();
            }
        }
        return namespace + "#(" + serviceName + "/" + portName + ")";
    }

    private static WSDLModel getModelFromFO(FileObject wsdlFO, boolean editable) {
        WSDLModel model = null;
        ModelSource ms = Utilities.getModelSource((FileObject)wsdlFO, (boolean)editable);
        try {
            model = WSDLModelFactory.getDefault().getModel(ms);
            if (model != null) {
                model.sync();
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, null, ex);
        }
        return model;
    }

    public void save(Node node) {
        if (node == null) {
            return;
        }
        try {
            if (this.panel != null && this.panel.isChanged()) {
                if (this.panel.isOverride()) {
                    this.cfgList.clear();
                    this.cfgList.addAll(this.cfgLoader.createTubeFactoryConfigList(this.panel.getTubeList()));
                } else {
                    this.cfgLoader.removeTubelineReference(this.cfg, this.ref);
                }
                this.cfgLoader.saveMetroConfig(this.cfg, this.project);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
        }
    }

    public void cancel(Node node) {
    }

    public String getDescription() {
        return NbBundle.getMessage(TubesEditor.class, (String)"TUBES_CONFIG_DESC");
    }
}

