/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.codegen.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathExpressionException;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.ClientStubModel;
import org.netbeans.modules.websvc.rest.codegen.model.Method;
import org.netbeans.modules.websvc.rest.codegen.model.Resource;
import org.netbeans.modules.websvc.rest.codegen.model.ResourceModel;
import org.netbeans.modules.websvc.rest.codegen.model.RestEntity;
import org.netbeans.modules.websvc.rest.codegen.model.State;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WadlModeler
extends ResourceModel {
    private FileObject fileObject;
    private String baseUrl;

    public WadlModeler(FileObject fo) {
        this.fileObject = fo;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public State validate() {
        InputStream is = null;
        try {
            is = this.fileObject.getInputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(is);
            Element app = doc.getDocumentElement();
            if (app == null) {
                State state = State.APP_MISSING;
                return state;
            }
            List<Node> resourcesList = this.getChildNodes(app, "resources");
            if (resourcesList == null || resourcesList.size() == 0) {
                State ex = State.RESOURCES_MISSING;
                return ex;
            }
            Node resources = resourcesList.get(0);
            String base = this.getAttributeValue(resources, "base");
            if (base == null || base.trim().equals("")) {
                State state = State.BASE_URL_NULL;
                return state;
            }
            List<Node> resourceNodes = this.getChildNodes(resources, "resource");
            if (resourceNodes.isEmpty()) {
                State state = State.EMPTY_RESOURCES;
                return state;
            }
        }
        catch (Exception ex) {
            State state = State.INVALID;
            return state;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
        return State.VALID;
    }

    @Override
    public void build() throws IOException {
        State state = this.validate();
        if (state != State.VALID) {
            throw new IOException(NbBundle.getMessage(AbstractPanel.class, (String)("MSG_" + state.value())));
        }
        InputStream is = null;
        try {
            is = this.fileObject.getInputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(is);
            Element app = doc.getDocumentElement();
            Node resources = this.getChildNodes(app, "resources").get(0);
            this.baseUrl = this.getAttributeValue(resources, "base");
            List<Node> resourceNodes = this.getChildNodes(resources, "resource");
            for (Node node : resourceNodes) {
                Resource resource = this.createResource(doc, node, null);
                this.addResource(resource);
                Collection<Method> methods = this.buildResource(resource, doc, node);
                for (Method method : methods) {
                    resource.addMethod(method);
                }
            }
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private Resource createResource(Document doc, Node node, Resource parent) throws IOException {
        try {
            String path = this.getAttributeValue(node, "path");
            String name = this.findResourceNameFromPath(path);
            if (name != null && name.length() > 0) {
                name = name.substring(0, 1).toUpperCase() + name.substring(1);
            }
            String parentPath = "";
            if (parent != null) {
                name = null;
            }
            if (parent != null && parent.getName() == null) {
                parentPath = parent.getPath();
                if (!parentPath.endsWith("/")) {
                    parentPath = parentPath + "/";
                }
                path = parentPath + path;
            }
            Resource resource = new Resource(name, path);
            return resource;
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private String findResourceNameFromPath(String path) {
        String name = path.replaceAll("/", "");
        name = name.replace("{", "");
        name = name.replace("}", "");
        return ClientStubModel.normalizeName(name);
    }

    private Collection<Method> buildResource(Resource resource, Document doc, Node n) throws IOException {
        try {
            LinkedList<Method> result = new LinkedList<Method>();
            NodeList methods = RestUtils.getNodeList(n, "method");
            if (methods != null && methods.getLength() > 0) {
                for (int j = 0; j < methods.getLength(); ++j) {
                    Method restMethod = null;
                    Node method = methods.item(j);
                    String methodName = this.getAttributeValue(method, "id");
                    String httpMethod = this.getAttributeValue(method, "name");
                    if (httpMethod == null) {
                        httpMethod = this.getAttributeValue(method, "href");
                        if (httpMethod == null) {
                            throw new IOException("Method do not have name or href attribute for resource: " + resource.getName());
                        }
                        String ref = httpMethod;
                        if (ref.startsWith("#")) {
                            ref = ref.substring(1);
                        }
                        method = this.findMethodNodeByRef(doc, ref);
                        httpMethod = this.getAttributeValue(method, "name");
                        if (methodName == null) {
                            methodName = this.getAttributeValue(method, "id");
                        }
                        restMethod = this.createMethod(resource, methodName, httpMethod, method);
                    } else {
                        restMethod = this.createMethod(resource, methodName, httpMethod, method);
                    }
                    result.add(restMethod);
                }
            }
            NodeList resources = RestUtils.getNodeList(n, "resource");
            for (int i = 0; i < resources.getLength(); ++i) {
                Node item = resources.item(i);
                if (item.getChildNodes().getLength() <= 0) continue;
                Resource subResource = this.createResource(doc, item, resource);
                Collection<Method> resourceMethods = this.buildResource(subResource, doc, item);
                result.addAll(resourceMethods);
            }
            return result;
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage());
        }
    }

    private List<Node> getChildNodes(Node n, String name) {
        ArrayList<Node> childNodes = new ArrayList<Node>();
        NodeList childs = n.getChildNodes();
        if (childs != null) {
            for (int i = 0; i < childs.getLength(); ++i) {
                Node child = childs.item(i);
                String cName = child.getNodeName();
                if (cName.indexOf(":") != -1) {
                    cName = cName.substring(cName.indexOf(":") + 1);
                }
                if (!cName.equals(name) || child.getNamespaceURI() != null && !child.getNamespaceURI().equals(n.getNamespaceURI())) continue;
                childNodes.add(child);
            }
        }
        return childNodes;
    }

    private String getAttributeValue(Node attr, String name) {
        NamedNodeMap mAttrList = attr.getAttributes();
        Attr refAttr = (Attr)mAttrList.getNamedItem(name);
        if (refAttr != null) {
            return refAttr.getNodeValue();
        }
        return null;
    }

    private Node findMethodNodeByRef(Node doc, String ref) throws XPathExpressionException {
        Node method = null;
        NodeList methods = RestUtils.getNodeList(doc, "//application/method");
        if (methods != null && methods.getLength() > 0) {
            for (int j = 0; j < methods.getLength(); ++j) {
                String mName;
                method = methods.item(j);
                NamedNodeMap mAttrList = method.getAttributes();
                Attr idAttr = (Attr)mAttrList.getNamedItem("id");
                if (idAttr == null || !(mName = idAttr.getNodeValue()).equals(ref)) continue;
                return method;
            }
        }
        return method;
    }

    private Method createMethod(Resource resource, String methodName, String httpMethod, Node method) throws XPathExpressionException {
        if (methodName != null) {
            Method restMethod = new Method(methodName.toLowerCase());
            restMethod.setType(Constants.HttpMethodType.valueOf(httpMethod));
            NodeList requests = RestUtils.getNodeList(method, "request");
            boolean isVoid = true;
            if (requests != null && requests.getLength() > 0) {
                List<String> mimes = this.getMimes(requests.item(0));
                restMethod.setRequestMimes(mimes);
                isVoid = mimes.isEmpty();
            }
            restMethod.setParamType(new RestEntity(isVoid));
            isVoid = true;
            NodeList responses = RestUtils.getNodeList(method, "response");
            if (responses != null && responses.getLength() > 0) {
                List<String> mimes = this.getMimes(responses.item(0));
                restMethod.setResponseMimes(mimes);
                isVoid = mimes.isEmpty();
            }
            restMethod.setReturnType(new RestEntity(isVoid));
            if (resource.getName() == null) {
                restMethod.setPath(resource.getPath());
            }
            return restMethod;
        }
        return null;
    }

    private List<String> getMimes(Node node) throws XPathExpressionException {
        NodeList representation = RestUtils.getNodeList(node, "representation");
        LinkedList<String> mimes = new LinkedList<String>();
        if (representation != null && representation.getLength() > 0) {
            for (int l = 0; l < representation.getLength(); ++l) {
                Node rep = representation.item(l);
                String media = null;
                Attr mediaAttr = (Attr)rep.getAttributes().getNamedItem("mediaType");
                if (mediaAttr != null) {
                    media = mediaAttr.getNodeValue();
                }
                if (media == null) continue;
                mimes.add(media);
            }
        }
        return mimes;
    }
}

