/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver;

import org.clang.driver.Action;
import org.clang.driver.CrashReportInfo;
import org.clang.driver.Job;
import org.clang.driver.Tool;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.option.ArgStringList;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_string_ostream;
import org.llvm.support.sys.WindowsEncodingMethod;
import org.llvm.support.sys.sys;

public class Command
extends Job
implements Destructors.ClassWithDestructor {
    private Action Source;
    private Tool Creator;
    private char.ptr Executable;
    private ArgStringList Arguments;
    private char.ptr ResponseFile;
    private ArgStringList InputFileList;
    private std.string ResponseFileFlag;

    private void buildArgvForResponseFile(SmallVectorImpl<char.ptr> Out) {
    }

    private void writeResponseFile(raw_ostream OS) {
    }

    public Command(Action _Source, Tool _Creator, char.ptr _Executable, ArgStringList _Arguments) {
        super(Job.JobClass.CommandClass);
        this.Source = _Source;
        this.Creator = _Creator;
        this.Executable = Native.$tryClone((char.ptr)_Executable);
        this.Arguments = new ArgStringList((SmallVector)_Arguments);
        this.ResponseFile = null;
        this.InputFileList = new ArgStringList();
        this.ResponseFileFlag = new std.string();
    }

    @Override
    public void Print(raw_ostream OS, char.ptr Terminator, boolean Quote, CrashReportInfo CrashInfo) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int Execute(StringRef[] Redirects, std.string ErrMsg, bool.ptr ExecutionFailed) {
        SmallVector Argv = null;
        std.string RespContents = null;
        raw_string_ostream SS = null;
        try {
            Argv = new SmallVector(128, null);
            if (this.ResponseFile == null) {
                Argv.push_back((Object)this.Executable);
                long e = this.Arguments.size();
                for (long i = 0L; i != e; ++i) {
                    Argv.push_back(this.Arguments.$at(i));
                }
                Argv.push_back(null);
                int i = sys.ExecuteAndWait((StringRef)new StringRef(this.Executable), (type.ptr)Argv.data(), null, (type.ptr)NativePointer.create_type$ptr((Object[])Redirects), (long)0L, (long)0L, (std.string)ErrMsg, (bool.ptr)ExecutionFailed);
                return i;
            }
            RespContents = new std.string();
            SS = new raw_string_ostream(RespContents);
            this.writeResponseFile((raw_ostream)SS);
            this.buildArgvForResponseFile((SmallVectorImpl<char.ptr>)Argv);
            Argv.push_back(null);
            SS.flush();
            std_errors.error_code EC = sys.writeFileWithEncoding((StringRef)new StringRef(this.ResponseFile), (StringRef)new StringRef(RespContents), (WindowsEncodingMethod)this.Creator.getResponseFileEncoding());
            if (EC.$boolean()) {
                if (ErrMsg != null) {
                    ErrMsg.$assign(EC.message());
                }
                if (ExecutionFailed != null) {
                    ExecutionFailed.$set(true);
                }
                int n = -1;
                return n;
            }
            int n = sys.ExecuteAndWait((StringRef)new StringRef(this.Executable), (type.ptr)Argv.data(), null, (type.ptr)NativePointer.create_type$ptr((Object[])Redirects), (long)0L, (long)0L, (std.string)ErrMsg, (bool.ptr)ExecutionFailed);
            return n;
        }
        finally {
            if (SS != null) {
                SS.$destroy();
            }
            if (RespContents != null) {
                RespContents.$destroy();
            }
            if (Argv != null) {
                Argv.$destroy();
            }
        }
    }

    public Action getSource() {
        return this.Source;
    }

    public Tool getCreator() {
        return this.Creator;
    }

    public void setResponseFile(char.ptr FileName) {
    }

    public void setInputFileList(ArgStringList List2) {
        this.InputFileList.$assign((SmallVectorImpl)std.move((Object)List2));
    }

    public char.ptr getExecutable() {
        return this.Executable;
    }

    public ArgStringList getArguments() {
        return this.Arguments;
    }

    public static boolean classof(Job J) {
        return J.getKind() == Job.JobClass.CommandClass || J.getKind() == Job.JobClass.FallbackCommandClass;
    }

    public Command(Command $Prm0) {
        super($Prm0);
        this.Source = $Prm0.Source;
        this.Creator = $Prm0.Creator;
        this.Executable = Native.$tryClone((char.ptr)$Prm0.Executable);
        this.Arguments = new ArgStringList((SmallVector)$Prm0.Arguments);
        this.ResponseFile = Native.$tryClone((char.ptr)$Prm0.ResponseFile);
        this.InputFileList = new ArgStringList((SmallVector)$Prm0.InputFileList);
        this.ResponseFileFlag = new std.string($Prm0.ResponseFileFlag);
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    public String toString() {
        return "Source=" + this.Source + ", Creator=" + this.Creator + ", Executable=" + this.Executable + ", Arguments=" + this.Arguments + ", ResponseFile=" + this.ResponseFile + ", InputFileList=" + this.InputFileList + ", ResponseFileFlag=" + this.ResponseFileFlag + super.toString();
    }
}

