/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.impl;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.ObjCRuntime;
import org.clang.basic.VersionTuple;
import org.clang.driver.Action;
import org.clang.driver.Driver;
import org.clang.driver.DriverGlobals;
import org.clang.driver.Multilib;
import org.clang.driver.MultilibSet;
import org.clang.driver.NativeCallback;
import org.clang.driver.SanitizerArgs;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.DetectedMultilibs;
import org.clang.driver.impl.Distro;
import org.clang.driver.impl.MSVCToolChainStatics;
import org.clang.driver.impl.ToolChainsStatics;
import org.clang.driver.options;
import org.clang.driver.tools.impl.CrossWindows;
import org.clang.driver.tools.impl.XCore;
import org.clang.driver.tools.impl.arm;
import org.clang.driver.tools.impl.bitrig;
import org.clang.driver.tools.impl.darwin;
import org.clang.driver.tools.impl.dragonfly;
import org.clang.driver.tools.impl.freebsd;
import org.clang.driver.tools.impl.gcc;
import org.clang.driver.tools.impl.gnutools;
import org.clang.driver.tools.impl.hexagon;
import org.clang.driver.tools.impl.minix;
import org.clang.driver.tools.impl.mips;
import org.clang.driver.tools.impl.netbsd;
import org.clang.driver.tools.impl.openbsd;
import org.clang.driver.tools.impl.solaris;
import org.clang.driver.tools.impl.visualstudio;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.java.std_ptr;
import org.clank.support.CollectionUtils;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.convert_iterator;
import org.llvm.adt.Optional;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorImplChar;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.DerivedArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.option.OptTable;
import org.llvm.option.Option;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;
import org.llvm.support.raw_string_ostream;
import org.llvm.support.sys.Process;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;
import org.llvm.support.sys.sys;

public final class toolchains {

    public static class XCore
    extends ToolChain
    implements Destructors.ClassWithDestructor {
        public XCore(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
        }

        @Override
        protected Tool buildAssembler() {
            return new XCore.Assemble(this);
        }

        @Override
        protected Tool buildLinker() {
            return new XCore.Link(this);
        }

        @Override
        public boolean isPICDefault() {
            return false;
        }

        @Override
        public boolean isPIEDefault() {
            return false;
        }

        @Override
        public boolean isPICDefaultForced() {
            return false;
        }

        @Override
        public boolean SupportsProfiling() {
            return false;
        }

        @Override
        public boolean hasBlocksRuntime() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void AddClangSystemIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
            if (DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdinc.getValue())) || DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlibinc.getValue()))) {
                return;
            }
            char.ptr cl_include_dir = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"XCC_C_INCLUDE_PATH")));
            if (cl_include_dir != null) {
                SmallVector Dirs = null;
                try {
                    Dirs = new SmallVector(4, (Object)new StringRef());
                    byte[] EnvPathSeparatorStr = NativePointer.new$char((int)2, (byte[])new byte[]{NativePointer.$((char)sys.EnvPathSeparator), NativePointer.$((char)'\u0000')});
                    new StringRef(cl_include_dir).split((SmallVectorImpl)Dirs, new StringRef((Object)EnvPathSeparatorStr));
                    ArrayRef DirVec = new ArrayRef((SmallVectorImpl)Dirs);
                    XCore.addSystemIncludes(DriverArgs, (SmallVector<char.ptr>)CC1Args, (ArrayRef<StringRef>)new ArrayRef(DirVec));
                }
                finally {
                    if (Dirs != null) {
                        Dirs.$destroy();
                    }
                }
            }
        }

        @Override
        public void addClangTargetOptions(ArgList DriverArgs, ArgStringList CC1Args) {
            CC1Args.push_back((Object)NativePointer.$((String)"-nostdsysteminc"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
            if (DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdinc.getValue())) || DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlibinc.getValue())) || DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdincxx.getValue()))) {
                return;
            }
            char.ptr cl_include_dir = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"XCC_CPLUS_INCLUDE_PATH")));
            if (cl_include_dir != null) {
                SmallVector Dirs = null;
                try {
                    Dirs = new SmallVector(4, (Object)new StringRef());
                    byte[] EnvPathSeparatorStr = NativePointer.new$char((int)2, (byte[])new byte[]{NativePointer.$((char)sys.EnvPathSeparator), NativePointer.$((char)'\u0000')});
                    new StringRef(cl_include_dir).split((SmallVectorImpl)Dirs, new StringRef((Object)EnvPathSeparatorStr));
                    ArrayRef DirVec = new ArrayRef((SmallVectorImpl)Dirs);
                    XCore.addSystemIncludes(DriverArgs, (SmallVector<char.ptr>)CC1Args, (ArrayRef<StringRef>)new ArrayRef(DirVec));
                }
                finally {
                    if (Dirs != null) {
                        Dirs.$destroy();
                    }
                }
            }
        }

        @Override
        public void AddCXXStdlibLibArgs(ArgList Args, ArgStringList CmdArgs) {
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        public String toString() {
            return "" + super.toString();
        }
    }

    public static class CrossWindowsToolChain
    extends Generic_GCC
    implements Destructors.ClassWithDestructor {
        public CrossWindowsToolChain(Driver D, Triple T, ArgList Args) {
            super(D, T, Args);
            if (this.GetCXXStdlibType(Args) == ToolChain.CXXStdlibType.CST_Libstdcxx) {
                std.string SysRoot = D.SysRoot;
                this.getFilePaths().push_back((Object)std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/usr/lib")));
                this.getFilePaths().push_back((Object)std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/usr/lib/gcc")));
            }
        }

        @Override
        public boolean IsIntegratedAssemblerDefault() {
            return true;
        }

        @Override
        public boolean IsUnwindTablesDefault() {
            return this.getArch() == Triple.ArchType.x86_64;
        }

        @Override
        public boolean isPICDefault() {
            return this.getArch() == Triple.ArchType.x86_64;
        }

        @Override
        public boolean isPIEDefault() {
            return this.getArch() == Triple.ArchType.x86_64;
        }

        @Override
        public boolean isPICDefaultForced() {
            return this.getArch() == Triple.ArchType.x86_64;
        }

        @Override
        public long GetDefaultStackProtectorLevel(boolean KernelOrKext) {
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void AddClangSystemIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
            Driver D = this.getDriver();
            std.string SysRoot = D.SysRoot;
            if (DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlibinc.getValue()))) {
                return;
            }
            CrossWindowsToolChain.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/usr/local/include"))));
            if (!DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nobuiltininc.getValue()))) {
                SmallString ResourceDir = null;
                try {
                    ResourceDir = new SmallString(new StringRef(D.ResourceDir), 128);
                    path.append((SmallString)ResourceDir, (Twine)new Twine(NativePointer.$((String)"include")));
                    CrossWindowsToolChain.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(ResourceDir.str()));
                }
                finally {
                    if (ResourceDir != null) {
                        ResourceDir.$destroy();
                    }
                }
            }
            CrossWindowsToolChain.addExternCSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/usr/include"))));
        }

        @Override
        public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
            Triple Triple2 = this.getTriple();
            std.string SysRoot = this.getDriver().SysRoot;
            if (DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlibinc.getValue())) || DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdincxx.getValue()))) {
                return;
            }
            switch (this.GetCXXStdlibType(DriverArgs)) {
                case CST_Libcxx: {
                    CrossWindowsToolChain.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/c++/v1"))));
                    break;
                }
                case CST_Libstdcxx: {
                    CrossWindowsToolChain.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/c++"))));
                    CrossWindowsToolChain.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str((std.string)std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/c++/")), (std.string)Triple2.str())));
                    CrossWindowsToolChain.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/c++/backwards"))));
                }
            }
        }

        @Override
        public void AddCXXStdlibLibArgs(ArgList DriverArgs, ArgStringList CC1Args) {
            switch (this.GetCXXStdlibType(DriverArgs)) {
                case CST_Libcxx: {
                    CC1Args.push_back((Object)NativePointer.$((String)"-lc++"));
                    break;
                }
                case CST_Libstdcxx: {
                    CC1Args.push_back((Object)NativePointer.$((String)"-lstdc++"));
                    CC1Args.push_back((Object)NativePointer.$((String)"-lmingw32"));
                    CC1Args.push_back((Object)NativePointer.$((String)"-lmingwex"));
                    CC1Args.push_back((Object)NativePointer.$((String)"-lgcc"));
                    CC1Args.push_back((Object)NativePointer.$((String)"-lmoldname"));
                    CC1Args.push_back((Object)NativePointer.$((String)"-lmingw32"));
                }
            }
        }

        @Override
        protected Tool buildLinker() {
            return new CrossWindows.Link(this);
        }

        @Override
        protected Tool buildAssembler() {
            return new CrossWindows.Assemble(this);
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class MSVCToolChain
    extends ToolChain
    implements Destructors.ClassWithDestructor {
        public MSVCToolChain(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
            this.getProgramPaths().push_back((Object)new std.string(this.getDriver().getInstalledDir()));
            if (std.$noteq_T_str((char.iterator)this.getDriver().getInstalledDir(), (std.string)this.getDriver().Dir)) {
                this.getProgramPaths().push_back((Object)this.getDriver().Dir);
            }
        }

        @Override
        public boolean IsIntegratedAssemblerDefault() {
            return true;
        }

        @Override
        public boolean IsUnwindTablesDefault() {
            return this.getArch() == Triple.ArchType.x86_64;
        }

        @Override
        public boolean isPICDefault() {
            return this.getArch() == Triple.ArchType.x86_64;
        }

        @Override
        public boolean isPIEDefault() {
            return false;
        }

        @Override
        public boolean isPICDefaultForced() {
            return this.getArch() == Triple.ArchType.x86_64;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void AddClangSystemIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
            Object[] objectArray;
            block33: {
                std.string VSDir = null;
                if (DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdinc.getValue()))) {
                    return;
                }
                if (!DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nobuiltininc.getValue()))) {
                    SmallString P = null;
                    try {
                        P = new SmallString(new StringRef(this.getDriver().ResourceDir), 128);
                        path.append((SmallString)P, (Twine)new Twine(NativePointer.$((String)"include")));
                        MSVCToolChain.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(P.str()));
                    }
                    finally {
                        if (P != null) {
                            P.$destroy();
                        }
                    }
                }
                if (DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlibinc.getValue()))) {
                    return;
                }
                char.ptr cl_include_dir = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"INCLUDE")));
                if (cl_include_dir != null) {
                    SmallVector Dirs = null;
                    try {
                        Dirs = new SmallVector(8, (Object)new StringRef());
                        new StringRef(cl_include_dir).split((SmallVectorImpl)Dirs, new StringRef(NativePointer.$((String)";")), -1, false);
                        for (StringRef Dir : Dirs) {
                            MSVCToolChain.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(Dir));
                        }
                        if (!Dirs.empty()) {
                            return;
                        }
                    }
                    finally {
                        if (Dirs != null) {
                            Dirs.$destroy();
                        }
                    }
                }
                if (this.getVisualStudioInstallDir(VSDir = new std.string())) {
                    std.string WindowsSDKDir = null;
                    try {
                        this.AddSystemIncludeWithSubfolder(DriverArgs, CC1Args, VSDir, NativePointer.$((String)"VC\\include"));
                        WindowsSDKDir = new std.string();
                        int.ref major = NativePointer.create_int$ref();
                        int.ref minor = NativePointer.create_int$ref();
                        if (this.getWindowsSDKDir(WindowsSDKDir, major, minor)) {
                            if (major.$deref() >= 8) {
                                this.AddSystemIncludeWithSubfolder(DriverArgs, CC1Args, WindowsSDKDir, NativePointer.$((String)"include\\shared"));
                                this.AddSystemIncludeWithSubfolder(DriverArgs, CC1Args, WindowsSDKDir, NativePointer.$((String)"include\\um"));
                                this.AddSystemIncludeWithSubfolder(DriverArgs, CC1Args, WindowsSDKDir, NativePointer.$((String)"include\\winrt"));
                            } else {
                                this.AddSystemIncludeWithSubfolder(DriverArgs, CC1Args, WindowsSDKDir, NativePointer.$((String)"include"));
                            }
                        } else {
                            MSVCToolChain.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(VSDir));
                        }
                        return;
                    }
                    finally {
                        if (WindowsSDKDir != null) {
                            WindowsSDKDir.$destroy();
                        }
                    }
                }
                objectArray = new StringRef[]{new StringRef((CharSequence)"C:/Program Files/Microsoft Visual Studio 10.0/VC/include"), new StringRef((CharSequence)"C:/Program Files/Microsoft Visual Studio 9.0/VC/include"), new StringRef((CharSequence)"C:/Program Files/Microsoft Visual Studio 9.0/VC/PlatformSDK/Include"), new StringRef((CharSequence)"C:/Program Files/Microsoft Visual Studio 8/VC/include"), new StringRef((CharSequence)"C:/Program Files/Microsoft Visual Studio 8/VC/PlatformSDK/Include")};
                break block33;
                finally {
                    if (VSDir != null) {
                        VSDir.$destroy();
                    }
                }
            }
            Object[] Paths = objectArray;
            MSVCToolChain.addSystemIncludes(DriverArgs, (SmallVector<char.ptr>)CC1Args, (ArrayRef<StringRef>)new ArrayRef(Paths));
        }

        @Override
        public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getWindowsSDKDir(std.string path2, int.ref major, int.ref minor) {
            std.string sdkVersion = null;
            try {
                sdkVersion = new std.string();
                boolean hasSDKDir = MSVCToolChainStatics.getSystemRegistryString(NativePointer.$((String)"SOFTWARE\\Microsoft\\Microsoft SDKs\\Windows\\$VERSION"), NativePointer.$((String)"InstallationFolder"), path2, sdkVersion);
                if (!sdkVersion.empty()) {
                    std.sscanf((char.ptr)sdkVersion.c_str(), (char.ptr)NativePointer.$((String)"v%d.%d"), (Object[])new Object[]{major.deref$ptr(), minor.deref$ptr()});
                }
                boolean bl = hasSDKDir && !path2.empty();
                return bl;
            }
            finally {
                if (sdkVersion != null) {
                    sdkVersion.$destroy();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getWindowsSDKLibraryPath(std.string path2) {
            std.string sdkPath = null;
            SmallString libPath = null;
            try {
                block28: {
                    block27: {
                        sdkPath = new std.string();
                        int.ref sdkMajor = NativePointer.create_int$ref((int)0);
                        int.ref sdkMinor = NativePointer.create_int$ref((int)0);
                        path2.clear();
                        if (!this.getWindowsSDKDir(sdkPath, sdkMajor, sdkMinor)) {
                            boolean bl = false;
                            return bl;
                        }
                        libPath = new SmallString(new StringRef(sdkPath), 128);
                        path.append((SmallString)libPath, (Twine)new Twine(NativePointer.$((String)"Lib")));
                        if (sdkMajor.$deref() > 7) break block27;
                        switch (this.getArch()) {
                            case x86: {
                                break block28;
                            }
                            case x86_64: {
                                path.append((SmallString)libPath, (Twine)new Twine(NativePointer.$((String)"x64")));
                                break block28;
                            }
                            case arm: {
                                boolean bl = false;
                                return bl;
                            }
                            default: {
                                boolean bl = false;
                                return bl;
                            }
                        }
                    }
                    char.ptr[] tests = new char.ptr[]{NativePointer.$((String)"winv6.3"), NativePointer.$((String)"win8"), NativePointer.$((String)"win7")};
                    boolean found = false;
                    for (char.ptr test : tests) {
                        SmallString testPath = null;
                        try {
                            testPath = new SmallString(libPath);
                            path.append((SmallString)testPath, (Twine)new Twine(test));
                            if (!fs.exists((Twine)new Twine(testPath.c_str()))) continue;
                            libPath.$assign((SmallVectorImplChar)testPath);
                            found = true;
                            break;
                        }
                        finally {
                            if (testPath != null) {
                                testPath.$destroy();
                            }
                        }
                    }
                    if (!found) {
                        boolean bl = false;
                        return bl;
                    }
                    path.append((SmallString)libPath, (Twine)new Twine(NativePointer.$((String)"um")));
                    switch (this.getArch()) {
                        case x86: {
                            path.append((SmallString)libPath, (Twine)new Twine(NativePointer.$((String)"x86")));
                            break;
                        }
                        case x86_64: {
                            path.append((SmallString)libPath, (Twine)new Twine(NativePointer.$((String)"x64")));
                            break;
                        }
                        case arm: {
                            path.append((SmallString)libPath, (Twine)new Twine(NativePointer.$((String)"arm")));
                            break;
                        }
                        default: {
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
                path2.$assign(libPath.str().$basic_string());
                boolean bl = true;
                return bl;
            }
            finally {
                if (libPath != null) {
                    libPath.$destroy();
                }
                if (sdkPath != null) {
                    sdkPath.$destroy();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getVisualStudioInstallDir(std.string path2) {
            std.string vsIDEInstallDir = null;
            std.string vsExpressIDEInstallDir = null;
            try {
                char.ptr vcinstalldir = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"VCINSTALLDIR")));
                if (vcinstalldir != null) {
                    path2.$assign(vcinstalldir);
                    path2.$assign(path2.substr(0, path2.find(NativePointer.$((String)"\\VC"))));
                    boolean bl = true;
                    return bl;
                }
                vsIDEInstallDir = new std.string();
                vsExpressIDEInstallDir = new std.string();
                boolean hasVCDir = MSVCToolChainStatics.getSystemRegistryString(NativePointer.$((String)"SOFTWARE\\Microsoft\\VisualStudio\\$VERSION"), NativePointer.$((String)"InstallDir"), vsIDEInstallDir, null);
                if (hasVCDir && !vsIDEInstallDir.empty()) {
                    path2.$assign(vsIDEInstallDir.substr(0, vsIDEInstallDir.find(NativePointer.$((String)"\\Common7\\IDE"))));
                    boolean bl = true;
                    return bl;
                }
                boolean hasVCExpressDir = MSVCToolChainStatics.getSystemRegistryString(NativePointer.$((String)"SOFTWARE\\Microsoft\\VCExpress\\$VERSION"), NativePointer.$((String)"InstallDir"), vsExpressIDEInstallDir, null);
                if (hasVCExpressDir && !vsExpressIDEInstallDir.empty()) {
                    path2.$assign(vsExpressIDEInstallDir.substr(0, vsIDEInstallDir.find(NativePointer.$((String)"\\Common7\\IDE"))));
                    boolean bl = true;
                    return bl;
                }
                char.ptr vs120comntools = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"VS120COMNTOOLS")));
                char.ptr vs100comntools = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"VS100COMNTOOLS")));
                char.ptr vs90comntools = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"VS90COMNTOOLS")));
                char.ptr vs80comntools = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"VS80COMNTOOLS")));
                char.ptr vscomntools = null;
                if (vs120comntools != null) {
                    vscomntools = Native.$tryClone((char.ptr)vs120comntools);
                } else if (vs100comntools != null) {
                    vscomntools = Native.$tryClone((char.ptr)vs100comntools);
                } else if (vs90comntools != null) {
                    vscomntools = Native.$tryClone((char.ptr)vs90comntools);
                } else if (vs80comntools != null) {
                    vscomntools = Native.$tryClone((char.ptr)vs80comntools);
                }
                if (vscomntools != null && vscomntools.$star() != 0) {
                    char.ptr p = Native.$tryClone((char.ptr)std.strstr((char.ptr)vscomntools, (char.ptr)NativePointer.$((String)"\\Common7\\Tools")));
                    path2.$assign(p != null ? new std.string((char.iterator)vscomntools, (char.iterator)p) : new std.string(vscomntools));
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (vsExpressIDEInstallDir != null) {
                    vsExpressIDEInstallDir.$destroy();
                }
                if (vsIDEInstallDir != null) {
                    vsIDEInstallDir.$destroy();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean getVisualStudioBinariesFolder(char.ptr clangProgramPath, std.string path2) {
            SmallString BinDir = null;
            try {
                path2.clear();
                BinDir = new SmallString(128);
                Optional VcInstallDir = Process.GetEnv((StringRef)new StringRef(NativePointer.$((String)"VCINSTALLDIR")));
                if (VcInstallDir.hasValue()) {
                    BinDir.$assign((std.string)VcInstallDir.getValue());
                    path.append((SmallString)BinDir, (Twine)new Twine(NativePointer.$((String)"bin")));
                } else {
                    std.string installDir = null;
                    SmallString ClPath = null;
                    try {
                        Optional OptPath = Process.GetEnv((StringRef)new StringRef(NativePointer.$((String)"PATH")));
                        if (OptPath.hasValue()) {
                            SmallVector PathSegments = null;
                            try {
                                byte[] EnvPathSeparatorStr = NativePointer.new$char((int)2, (byte[])new byte[]{NativePointer.$((char)sys.EnvPathSeparator), NativePointer.$((char)'\u0000')});
                                PathSegments = new SmallVector(8, (Object)new StringRef());
                                llvm.SplitString((StringRef)new StringRef((std.string)OptPath.getValue()), (SmallVectorImpl)PathSegments, (StringRef)new StringRef((Object)EnvPathSeparatorStr));
                                for (StringRef PathSegment : PathSegments) {
                                    SmallString FilePath = null;
                                    try {
                                        if (PathSegment.empty()) continue;
                                        FilePath = new SmallString(new StringRef(PathSegment), 128);
                                        path.append((SmallString)FilePath, (Twine)new Twine(NativePointer.$((String)"cl.exe")));
                                        if (!fs.can_execute((Twine)new Twine(FilePath.c_str())) || fs.equivalent((Twine)new Twine(FilePath.c_str()), (Twine)new Twine(clangProgramPath))) continue;
                                        path2.$assign(PathSegment.$basic_string());
                                        boolean bl = true;
                                        return bl;
                                    }
                                    finally {
                                        if (FilePath == null) continue;
                                        FilePath.$destroy();
                                    }
                                }
                            }
                            finally {
                                if (PathSegments != null) {
                                    PathSegments.$destroy();
                                }
                            }
                        }
                        if (!this.getVisualStudioInstallDir(installDir = new std.string())) {
                            boolean bl = false;
                            return bl;
                        }
                        BinDir.$assign(installDir);
                        path.append((SmallString)BinDir, (Twine)new Twine(NativePointer.$((String)"VC")), (Twine)new Twine(NativePointer.$((String)"bin")));
                        ClPath = new SmallString(BinDir);
                        path.append((SmallString)ClPath, (Twine)new Twine(NativePointer.$((String)"cl.exe")));
                        if (!fs.can_execute((Twine)new Twine(ClPath.c_str()))) {
                            boolean bl = false;
                            return bl;
                        }
                    }
                    finally {
                        if (ClPath != null) {
                            ClPath.$destroy();
                        }
                        if (installDir != null) {
                            installDir.$destroy();
                        }
                    }
                }
                if (BinDir.empty()) {
                    boolean bl = false;
                    return bl;
                }
                switch (this.getArch()) {
                    case x86: {
                        break;
                    }
                    case x86_64: {
                        path.append((SmallString)BinDir, (Twine)new Twine(NativePointer.$((String)"amd64")));
                        break;
                    }
                    case arm: {
                        path.append((SmallString)BinDir, (Twine)new Twine(NativePointer.$((String)"arm")));
                        break;
                    }
                    default: {
                        boolean bl = false;
                        return bl;
                    }
                }
                path2.$assign(BinDir.str().$basic_string());
                boolean bl = true;
                return bl;
            }
            finally {
                if (BinDir != null) {
                    BinDir.$destroy();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void AddSystemIncludeWithSubfolder(ArgList DriverArgs, ArgStringList CC1Args, std.string folder, char.ptr subfolder) {
            SmallString path2 = null;
            try {
                path2 = new SmallString(new StringRef(folder), 128);
                path.append((SmallString)path2, (Twine)new Twine(subfolder));
                MSVCToolChain.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(path2.str()));
            }
            finally {
                if (path2 != null) {
                    path2.$destroy();
                }
            }
        }

        @Override
        protected Tool buildLinker() {
            return new visualstudio.Link(this);
        }

        @Override
        protected Tool buildAssembler() {
            if (this.getTriple().isOSBinFormatMachO()) {
                return new darwin.Assemble(this);
            }
            this.getDriver().Diag(359L).$destroy();
            return null;
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        public String toString() {
            return "" + super.toString();
        }
    }

    public static class TCEToolChain
    extends ToolChain
    implements Destructors.ClassWithDestructor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TCEToolChain(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
            std.string Path = null;
            try {
                Path = new std.string(this.getDriver().Dir);
                Path.$addassign(NativePointer.$((String)"/../libexec"));
                this.getProgramPaths().push_back((Object)Path);
            }
            finally {
                if (Path != null) {
                    Path.$destroy();
                }
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public boolean IsMathErrnoDefault() {
            return true;
        }

        @Override
        public boolean isPICDefault() {
            return false;
        }

        @Override
        public boolean isPIEDefault() {
            return false;
        }

        @Override
        public boolean isPICDefaultForced() {
            return false;
        }

        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Hexagon_TC
    extends Linux
    implements Destructors.ClassWithDestructor {
        protected Generic_GCC.GCCVersion GCCLibAndIncVersion = new Generic_GCC.GCCVersion();

        @Override
        protected Tool buildAssembler() {
            return new hexagon.Assemble(this);
        }

        @Override
        protected Tool buildLinker() {
            return new hexagon.Link(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Hexagon_TC(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
            std.string InstalledDir = null;
            std.string BinDir = null;
            std.string HexagonDir = null;
            try {
                InstalledDir = new std.string(this.getDriver().getInstalledDir());
                std.string GnuDir = Hexagon_TC.GetGnuDir(InstalledDir, Args);
                BinDir = std.$plus_str_T((std.string)GnuDir, (char.iterator)NativePointer.$((String)"/bin"));
                if (fs.exists((Twine)new Twine(BinDir))) {
                    this.getProgramPaths().push_back((Object)BinDir);
                }
                HexagonDir = std.$plus_str_T((std.string)GnuDir, (char.iterator)NativePointer.$((String)"/lib/gcc/hexagon"));
                std_errors.error_code ec = new std_errors.error_code();
                Generic_GCC.GCCVersion MaxVersion = Generic_GCC.GCCVersion.Parse(new StringRef(NativePointer.$((String)"0.0.0")));
                fs.directory_iterator di = null;
                fs.directory_iterator de = null;
                try {
                    di = new fs.directory_iterator(new Twine(HexagonDir), ec);
                    de = new fs.directory_iterator();
                    while (!ec.$boolean() && di.$noteq(de)) {
                        Generic_GCC.GCCVersion cv = Generic_GCC.GCCVersion.Parse(path.filename((StringRef)new StringRef(di.$arrow().path())));
                        if (MaxVersion.$less(cv)) {
                            MaxVersion.$assign(cv);
                        }
                        di.$assign(di.increment(ec));
                    }
                }
                finally {
                    if (de != null) {
                        de.$destroy();
                    }
                    if (di != null) {
                        di.$destroy();
                    }
                }
                this.GCCLibAndIncVersion.$assign(MaxVersion);
                SmallVector<std.string> LibPaths = this.getFilePaths();
                LibPaths.clear();
                ToolChainsStatics.GetHexagonLibraryPaths(Args, this.GetGCCLibAndIncVersion().$basic_string(), Hexagon_TC.GetTargetCPU(Args).$basic_string(), InstalledDir, LibPaths);
            }
            finally {
                if (HexagonDir != null) {
                    HexagonDir.$destroy();
                }
                if (BinDir != null) {
                    BinDir.$destroy();
                }
                if (InstalledDir != null) {
                    InstalledDir.$destroy();
                }
            }
        }

        @Override
        public void $destroy() {
            this.GCCLibAndIncVersion.$destroy();
            super.$destroy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void AddClangSystemIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
            std.string Ver = null;
            std.string HexagonDir = null;
            try {
                Driver D = this.getDriver();
                if (DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdinc.getValue())) || DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlibinc.getValue()))) {
                    return;
                }
                Ver = this.GetGCCLibAndIncVersion().$basic_string();
                std.string GnuDir = Hexagon_TC.GetGnuDir(D.InstalledDir, DriverArgs);
                HexagonDir = std.$plus_str((std.string)std.$plus_str_T((std.string)GnuDir, (char.iterator)NativePointer.$((String)"/lib/gcc/hexagon/")), (std.string)Ver);
                Hexagon_TC.addExternCSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)HexagonDir, (char.iterator)NativePointer.$((String)"/include"))));
                Hexagon_TC.addExternCSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)HexagonDir, (char.iterator)NativePointer.$((String)"/include-fixed"))));
                Hexagon_TC.addExternCSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)GnuDir, (char.iterator)NativePointer.$((String)"/hexagon/include"))));
            }
            finally {
                if (HexagonDir != null) {
                    HexagonDir.$destroy();
                }
                if (Ver != null) {
                    Ver.$destroy();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
            std.string Ver = null;
            SmallString IncludeDir = null;
            try {
                if (DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlibinc.getValue())) || DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdincxx.getValue()))) {
                    return;
                }
                Driver D = this.getDriver();
                Ver = this.GetGCCLibAndIncVersion().$basic_string();
                IncludeDir = new SmallString(new StringRef(Hexagon_TC.GetGnuDir(D.InstalledDir, DriverArgs)), 128);
                path.append((SmallString)IncludeDir, (Twine)new Twine(NativePointer.$((String)"hexagon/include/c++/")));
                path.append((SmallString)IncludeDir, (Twine)new Twine(Ver));
                Hexagon_TC.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(IncludeDir.str()));
            }
            finally {
                if (IncludeDir != null) {
                    IncludeDir.$destroy();
                }
                if (Ver != null) {
                    Ver.$destroy();
                }
            }
        }

        @Override
        public ToolChain.CXXStdlibType GetCXXStdlibType(ArgList Args) {
            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_stdlib_EQ.getValue()));
            if (A == null) {
                return ToolChain.CXXStdlibType.CST_Libstdcxx;
            }
            StringRef Value = new StringRef(A.getValue());
            if (llvm.$noteq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"libstdc++")))) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(329L), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
            }
            return ToolChain.CXXStdlibType.CST_Libstdcxx;
        }

        public StringRef GetGCCLibAndIncVersion() {
            return new StringRef(this.GCCLibAndIncVersion.Text);
        }

        public static std.string GetGnuDir(std.string InstalledDir, ArgList Args) {
            std.string GccToolchain = ToolChainsStatics.getGCCToolchainDir(Args).$basic_string();
            if (!GccToolchain.empty()) {
                return GccToolchain;
            }
            std.string InstallRelDir = std.$plus_str_T((std.string)InstalledDir, (char.iterator)NativePointer.$((String)"/../../gnu"));
            if (fs.exists((Twine)new Twine(InstallRelDir))) {
                return InstallRelDir;
            }
            std.string PrefixRelDir = std.$plus_str_T((std.string)new std.string(NativePointer.$((String)"/usr/local")), (char.iterator)NativePointer.$((String)"/../gnu"));
            if (fs.exists((Twine)new Twine(PrefixRelDir))) {
                return PrefixRelDir;
            }
            return InstallRelDir;
        }

        public static StringRef GetTargetCPU(ArgList Args) {
            int V = ToolChainsStatics.getHexagonVersion(Args);
            switch (V) {
                default: {
                    throw new llvm_unreachable((CharSequence)"Unexpected version");
                }
                case 5: {
                    return new StringRef(NativePointer.$((String)"v5"));
                }
                case 4: {
                    return new StringRef(NativePointer.$((String)"v4"));
                }
                case 3: {
                    return new StringRef(NativePointer.$((String)"v3"));
                }
                case 2: {
                    return new StringRef(NativePointer.$((String)"v2"));
                }
                case 1: 
            }
            return new StringRef(NativePointer.$((String)"v1"));
        }

        @Override
        public String toString() {
            return "GCCLibAndIncVersion=" + this.GCCLibAndIncVersion + super.toString();
        }
    }

    public static class Linux
    extends Generic_ELF
    implements Destructors.ClassWithDestructor {
        public std.string Linker;
        public std.vectorString ExtraOpts;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Linux(Driver D, Triple Triple2, ArgList Args) {
            std.string LibPath;
            Distro Distro2;
            std.string SysRoot;
            block35: {
                block33: {
                    block34: {
                        block29: {
                            block32: {
                                block31: {
                                    block30: {
                                        super(D, Triple2, Args);
                                        this.Linker = new std.string();
                                        this.ExtraOpts = new std.vectorString(std.string.EMPTY);
                                        this.GCCInstallation.init(D, Triple2, Args);
                                        this.Multilibs.$assign(this.GCCInstallation.getMultilibs());
                                        Triple.ArchType Arch = Triple2.getArch();
                                        SysRoot = this.computeSysRoot();
                                        SmallVector<std.string> PPaths = this.getProgramPaths();
                                        PPaths.push_back((Object)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_StringRef_char$ptr((StringRef)this.GCCInstallation.getParentLibPath(), (char.ptr)NativePointer.$((String)"/../")), (Twine)new Twine(this.GCCInstallation.getTriple().str())), (Twine)new Twine(NativePointer.$((String)"/bin"))).str());
                                        this.Linker.$assign(this.GetLinkerPath());
                                        Distro2 = ToolChainsStatics.DetectDistro(Arch);
                                        if (ToolChainsStatics.IsOpenSUSE(Distro2) || ToolChainsStatics.IsUbuntu(Distro2)) {
                                            this.ExtraOpts.push_back(new std.string(NativePointer.$((String)"-z")));
                                            this.ExtraOpts.push_back(new std.string(NativePointer.$((String)"relro")));
                                        }
                                        if (Arch == Triple.ArchType.arm || Arch == Triple.ArchType.thumb) {
                                            this.ExtraOpts.push_back(new std.string(NativePointer.$((String)"-X")));
                                        }
                                        boolean IsAndroid = Triple2.getEnvironment() == Triple.EnvironmentType.Android;
                                        boolean IsMips = ToolChainsStatics.isMipsArch(Arch);
                                        if (IsMips && !SysRoot.empty()) {
                                            this.ExtraOpts.push_back(std.$plus_T_str((Object)NativePointer.$((String)"--sysroot="), (std.string)SysRoot));
                                        }
                                        if (IsMips || IsAndroid) break block29;
                                        if (ToolChainsStatics.IsRedhat(Distro2) || ToolChainsStatics.IsOpenSUSE(Distro2)) break block30;
                                        if (!ToolChainsStatics.IsUbuntu(Distro2)) break block31;
                                        if (Distro2.getValue() < Distro.UbuntuMaverick.getValue()) break block31;
                                    }
                                    this.ExtraOpts.push_back(new std.string(NativePointer.$((String)"--hash-style=gnu")));
                                }
                                if (ToolChainsStatics.IsDebian(Distro2) || ToolChainsStatics.IsOpenSUSE(Distro2)) break block32;
                                if (Distro2 == Distro.UbuntuLucid) break block32;
                                if (Distro2 == Distro.UbuntuJaunty) break block32;
                                if (Distro2 != Distro.UbuntuKarmic) break block29;
                            }
                            this.ExtraOpts.push_back(new std.string(NativePointer.$((String)"--hash-style=both")));
                        }
                        if (ToolChainsStatics.IsRedhat(Distro2)) {
                            this.ExtraOpts.push_back(new std.string(NativePointer.$((String)"--no-add-needed")));
                        }
                        if (Distro2 == Distro.DebianSqueeze) break block33;
                        if (Distro2 == Distro.DebianWheezy) break block33;
                        if (Distro2 == Distro.DebianJessie || ToolChainsStatics.IsOpenSUSE(Distro2)) break block33;
                        if (!ToolChainsStatics.IsRedhat(Distro2)) break block34;
                        if (Distro2 == Distro.RHEL4) break block34;
                        if (Distro2 != Distro.RHEL5) break block33;
                    }
                    if (!ToolChainsStatics.IsUbuntu(Distro2)) break block35;
                    if (Distro2.getValue() < Distro.UbuntuKarmic.getValue()) break block35;
                }
                this.ExtraOpts.push_back(new std.string(NativePointer.$((String)"--build-id")));
            }
            if (ToolChainsStatics.IsOpenSUSE(Distro2)) {
                this.ExtraOpts.push_back(new std.string(NativePointer.$((String)"--enable-new-dtags")));
            }
            SmallVector<std.string> Paths = this.getFilePaths();
            std.string OSLibDir = ToolChainsStatics.getOSLibDir(Triple2, Args).$basic_string();
            std.string MultiarchTriple = ToolChainsStatics.getMultiarchTriple(Triple2, new StringRef(SysRoot));
            if (this.GCCInstallation.isValid()) {
                Triple GCCTriple = this.GCCInstallation.getTriple();
                LibPath = this.GCCInstallation.getParentLibPath().$basic_string();
                Multilib Multilib2 = this.GCCInstallation.getMultilib();
                ToolChainsStatics.addPathIfExists(llvm.$plus_Twine((Twine)new Twine(this.GCCInstallation.getInstallPath()), (Twine)new Twine(Multilib2.gccSuffix())), Paths);
                ToolChainsStatics.addPathIfExists(new Twine(std.$plus_str((std.string)std.$plus_str((std.string)std.$plus_str_T((std.string)std.$plus_str((std.string)std.$plus_str_T((std.string)LibPath, (char.iterator)NativePointer.$((String)"/../")), (std.string)GCCTriple.str()), (char.iterator)NativePointer.$((String)"/lib/../")), (std.string)OSLibDir), (std.string)Multilib2.osSuffix())), Paths);
                if (new StringRef(LibPath).startswith(SysRoot)) {
                    ToolChainsStatics.addPathIfExists(new Twine(std.$plus_str((std.string)std.$plus_str_T((std.string)LibPath, (char.iterator)NativePointer.$((String)"/")), (std.string)MultiarchTriple)), Paths);
                    ToolChainsStatics.addPathIfExists(new Twine(std.$plus_str((std.string)std.$plus_str_T((std.string)LibPath, (char.iterator)NativePointer.$((String)"/../")), (std.string)OSLibDir)), Paths);
                }
            }
            if (new StringRef(D.Dir).startswith(SysRoot)) {
                ToolChainsStatics.addPathIfExists(new Twine(std.$plus_str((std.string)std.$plus_str_T((std.string)D.Dir, (char.iterator)NativePointer.$((String)"/../lib/")), (std.string)MultiarchTriple)), Paths);
                ToolChainsStatics.addPathIfExists(new Twine(std.$plus_str((std.string)std.$plus_str_T((std.string)D.Dir, (char.iterator)NativePointer.$((String)"/../")), (std.string)OSLibDir)), Paths);
            }
            ToolChainsStatics.addPathIfExists(new Twine(std.$plus_str((std.string)std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/lib/")), (std.string)MultiarchTriple)), Paths);
            ToolChainsStatics.addPathIfExists(new Twine(std.$plus_str((std.string)std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/lib/../")), (std.string)OSLibDir)), Paths);
            ToolChainsStatics.addPathIfExists(new Twine(std.$plus_str((std.string)std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/usr/lib/")), (std.string)MultiarchTriple)), Paths);
            ToolChainsStatics.addPathIfExists(new Twine(std.$plus_str((std.string)std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/usr/lib/../")), (std.string)OSLibDir)), Paths);
            if (this.GCCInstallation.isValid()) {
                Multilib BiarchSibling = null;
                try {
                    ToolChainsStatics.addPathIfExists(new Twine(std.$plus_str((std.string)std.$plus_str_T((std.string)std.$plus_str((std.string)std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/usr/lib/")), (std.string)this.GCCInstallation.getTriple().str()), (char.iterator)NativePointer.$((String)"/../../")), (std.string)OSLibDir)), Paths);
                    BiarchSibling = new Multilib();
                    if (this.GCCInstallation.getBiarchSibling(BiarchSibling)) {
                        ToolChainsStatics.addPathIfExists(llvm.$plus_Twine((Twine)new Twine(this.GCCInstallation.getInstallPath()), (Twine)new Twine(BiarchSibling.gccSuffix())), Paths);
                    }
                    LibPath = this.GCCInstallation.getParentLibPath().$basic_string();
                    Triple GCCTriple = this.GCCInstallation.getTriple();
                    Multilib Multilib3 = this.GCCInstallation.getMultilib();
                    ToolChainsStatics.addPathIfExists(new Twine(std.$plus_str((std.string)std.$plus_str_T((std.string)std.$plus_str((std.string)std.$plus_str_T((std.string)LibPath, (char.iterator)NativePointer.$((String)"/../")), (std.string)GCCTriple.str()), (char.iterator)NativePointer.$((String)"/lib")), (std.string)Multilib3.osSuffix())), Paths);
                    if (new StringRef(LibPath).startswith(SysRoot)) {
                        ToolChainsStatics.addPathIfExists(new Twine(LibPath), Paths);
                    }
                }
                finally {
                    if (BiarchSibling != null) {
                        BiarchSibling.$destroy();
                    }
                }
            }
            if (new StringRef(D.Dir).startswith(SysRoot)) {
                ToolChainsStatics.addPathIfExists(new Twine(std.$plus_str_T((std.string)D.Dir, (char.iterator)NativePointer.$((String)"/../lib"))), Paths);
            }
            ToolChainsStatics.addPathIfExists(new Twine(std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/lib"))), Paths);
            ToolChainsStatics.addPathIfExists(new Twine(std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/usr/lib"))), Paths);
        }

        @Override
        public boolean HasNativeLLVMSupport() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void AddClangSystemIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
            NativeCallback.IncludeDirsFunc Callback;
            Driver D = this.getDriver();
            std.string SysRoot = this.computeSysRoot();
            if (DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdinc.getValue()))) {
                return;
            }
            if (!DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlibinc.getValue()))) {
                Linux.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/usr/local/include"))));
            }
            if (!DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nobuiltininc.getValue()))) {
                SmallString P = null;
                try {
                    P = new SmallString(new StringRef(D.ResourceDir), 128);
                    path.append((SmallString)P, (Twine)new Twine(NativePointer.$((String)"include")));
                    Linux.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(P.str()));
                }
                finally {
                    if (P != null) {
                        P.$destroy();
                    }
                }
            }
            if (DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlibinc.getValue()))) {
                return;
            }
            StringRef CIncludeDirs = StringRef.EMPTY;
            if (llvm.$noteq_StringRef((StringRef)new StringRef(CIncludeDirs), (StringRef)StringRef.EMPTY)) {
                SmallVector dirs = null;
                try {
                    dirs = new SmallVector(5, (Object)new StringRef());
                    CIncludeDirs.split((SmallVectorImpl)dirs, new StringRef(NativePointer.$((String)":")));
                    for (StringRef dir : dirs) {
                        StringRef Prefix = new StringRef(path.is_absolute((StringRef)dir) ? new std.string(SysRoot) : new std.string(NativePointer.$((String)"")));
                        Linux.addExternCSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, llvm.$plus_Twine((Twine)new Twine(Prefix), (Twine)new Twine(dir)));
                    }
                    return;
                }
                finally {
                    if (dirs != null) {
                        dirs.$destroy();
                    }
                }
            }
            if (this.GCCInstallation.isValid() && (Callback = this.Multilibs.includeDirsCallback()) != null) {
                std.vectorString IncludePaths = Callback.$call(this.GCCInstallation.getInstallPath(), new StringRef(this.GCCInstallation.getTriple().str()), this.GCCInstallation.getMultilib());
                for (std.string Path : IncludePaths) {
                    Linux.addExternCSystemIncludeIfExists(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(Path));
                }
            }
            Object[] X86_64MultiarchIncludeDirs = new StringRef[]{new StringRef((CharSequence)"/usr/include/x86_64-linux-gnu"), new StringRef((CharSequence)"/usr/include/i686-linux-gnu/64"), new StringRef((CharSequence)"/usr/include/i486-linux-gnu/64")};
            Object[] X86MultiarchIncludeDirs = new StringRef[]{new StringRef((CharSequence)"/usr/include/i386-linux-gnu"), new StringRef((CharSequence)"/usr/include/x86_64-linux-gnu/32"), new StringRef((CharSequence)"/usr/include/i686-linux-gnu"), new StringRef((CharSequence)"/usr/include/i486-linux-gnu")};
            Object[] AArch64MultiarchIncludeDirs = new StringRef[]{new StringRef((CharSequence)"/usr/include/aarch64-linux-gnu")};
            Object[] ARMMultiarchIncludeDirs = new StringRef[]{new StringRef((CharSequence)"/usr/include/arm-linux-gnueabi")};
            Object[] ARMHFMultiarchIncludeDirs = new StringRef[]{new StringRef((CharSequence)"/usr/include/arm-linux-gnueabihf")};
            Object[] MIPSMultiarchIncludeDirs = new StringRef[]{new StringRef((CharSequence)"/usr/include/mips-linux-gnu")};
            Object[] MIPSELMultiarchIncludeDirs = new StringRef[]{new StringRef((CharSequence)"/usr/include/mipsel-linux-gnu")};
            Object[] MIPS64MultiarchIncludeDirs = new StringRef[]{new StringRef((CharSequence)"/usr/include/mips64-linux-gnu"), new StringRef((CharSequence)"/usr/include/mips64-linux-gnuabi64")};
            Object[] MIPS64ELMultiarchIncludeDirs = new StringRef[]{new StringRef((CharSequence)"/usr/include/mips64el-linux-gnu"), new StringRef((CharSequence)"/usr/include/mips64el-linux-gnuabi64")};
            Object[] PPCMultiarchIncludeDirs = new StringRef[]{new StringRef((CharSequence)"/usr/include/powerpc-linux-gnu")};
            Object[] PPC64MultiarchIncludeDirs = new StringRef[]{new StringRef((CharSequence)"/usr/include/powerpc64-linux-gnu")};
            Object[] PPC64LEMultiarchIncludeDirs = new StringRef[]{new StringRef((CharSequence)"/usr/include/powerpc64le-linux-gnu")};
            ArrayRef MultiarchIncludeDirs = new ArrayRef();
            if (this.getTriple().getArch() == Triple.ArchType.x86_64) {
                MultiarchIncludeDirs.$assign(new ArrayRef(X86_64MultiarchIncludeDirs));
            } else if (this.getTriple().getArch() == Triple.ArchType.x86) {
                MultiarchIncludeDirs.$assign(new ArrayRef(X86MultiarchIncludeDirs));
            } else if (this.getTriple().getArch() == Triple.ArchType.aarch64 || this.getTriple().getArch() == Triple.ArchType.aarch64_be) {
                MultiarchIncludeDirs.$assign(new ArrayRef(AArch64MultiarchIncludeDirs));
            } else if (this.getTriple().getArch() == Triple.ArchType.arm) {
                if (this.getTriple().getEnvironment() == Triple.EnvironmentType.GNUEABIHF) {
                    MultiarchIncludeDirs.$assign(new ArrayRef(ARMHFMultiarchIncludeDirs));
                } else {
                    MultiarchIncludeDirs.$assign(new ArrayRef(ARMMultiarchIncludeDirs));
                }
            } else if (this.getTriple().getArch() == Triple.ArchType.mips) {
                MultiarchIncludeDirs.$assign(new ArrayRef(MIPSMultiarchIncludeDirs));
            } else if (this.getTriple().getArch() == Triple.ArchType.mipsel) {
                MultiarchIncludeDirs.$assign(new ArrayRef(MIPSELMultiarchIncludeDirs));
            } else if (this.getTriple().getArch() == Triple.ArchType.mips64) {
                MultiarchIncludeDirs.$assign(new ArrayRef(MIPS64MultiarchIncludeDirs));
            } else if (this.getTriple().getArch() == Triple.ArchType.mips64el) {
                MultiarchIncludeDirs.$assign(new ArrayRef(MIPS64ELMultiarchIncludeDirs));
            } else if (this.getTriple().getArch() == Triple.ArchType.ppc) {
                MultiarchIncludeDirs.$assign(new ArrayRef(PPCMultiarchIncludeDirs));
            } else if (this.getTriple().getArch() == Triple.ArchType.ppc64) {
                MultiarchIncludeDirs.$assign(new ArrayRef(PPC64MultiarchIncludeDirs));
            } else if (this.getTriple().getArch() == Triple.ArchType.ppc64le) {
                MultiarchIncludeDirs.$assign(new ArrayRef(PPC64LEMultiarchIncludeDirs));
            }
            for (StringRef Dir : MultiarchIncludeDirs) {
                if (!fs.exists((Twine)llvm.$plus_Twine((Twine)new Twine(SysRoot), (Twine)new Twine(Dir)))) continue;
                Linux.addExternCSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, llvm.$plus_Twine((Twine)new Twine(SysRoot), (Twine)new Twine(Dir)));
                break;
            }
            if (this.getTriple().getOS() == Triple.OSType.RTEMS) {
                return;
            }
            Linux.addExternCSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/include"))));
            Linux.addExternCSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)SysRoot, (char.iterator)NativePointer.$((String)"/usr/include"))));
        }

        @Override
        public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
            std.string[] LibStdCXXIncludePathCandidates;
            if (DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlibinc.getValue())) || DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdincxx.getValue()))) {
                return;
            }
            if (this.GetCXXStdlibType(DriverArgs) == ToolChain.CXXStdlibType.CST_Libcxx) {
                std.string[] LibCXXIncludePathCandidates;
                for (std.string IncludePath : LibCXXIncludePathCandidates = new std.string[]{std.$plus_str_T((std.string)this.getDriver().Dir, (char.iterator)NativePointer.$((String)"/../include/c++/v1")), std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/c++/v1"))}) {
                    if (!fs.exists((Twine)new Twine(IncludePath))) continue;
                    Linux.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(IncludePath));
                    break;
                }
                return;
            }
            if (!this.GCCInstallation.isValid()) {
                return;
            }
            StringRef LibDir = this.GCCInstallation.getParentLibPath();
            StringRef InstallDir = this.GCCInstallation.getInstallPath();
            StringRef TripleStr = new StringRef(this.GCCInstallation.getTriple().str());
            Multilib Multilib2 = this.GCCInstallation.getMultilib();
            std.string GCCMultiarchTriple = ToolChainsStatics.getMultiarchTriple(this.GCCInstallation.getTriple(), new StringRef(this.getDriver().SysRoot));
            std.string TargetMultiarchTriple = ToolChainsStatics.getMultiarchTriple(this.getTriple(), new StringRef(this.getDriver().SysRoot));
            Generic_GCC.GCCVersion Version = this.GCCInstallation.getVersion();
            if (Linux.addLibStdCXXIncludePaths(new Twine(std.$plus_str_T((std.string)LibDir.str(), (char.iterator)NativePointer.$((String)"/../include"))), new Twine(std.$plus_T_str((Object)NativePointer.$((String)"/c++/"), (std.string)Version.Text)), new StringRef(TripleStr), new StringRef(GCCMultiarchTriple), new StringRef(TargetMultiarchTriple), new Twine(Multilib2.includeSuffix()), DriverArgs, CC1Args)) {
                return;
            }
            for (std.string IncludePath : LibStdCXXIncludePathCandidates = new std.string[]{std.$plus_str((std.string)std.$plus_str_T((std.string)std.$plus_str((std.string)std.$plus_str_T((std.string)InstallDir.str(), (char.iterator)NativePointer.$((String)"/include/g++-v")), (std.string)Version.MajorStr), (char.iterator)NativePointer.$((String)".")), (std.string)Version.MinorStr), std.$plus_str((std.string)std.$plus_str_T((std.string)InstallDir.str(), (char.iterator)NativePointer.$((String)"/include/g++-v")), (std.string)Version.MajorStr), std.$plus_str((std.string)std.$plus_str_T((std.string)std.$plus_str((std.string)std.$plus_str_T((std.string)LibDir.str(), (char.iterator)NativePointer.$((String)"/../")), (std.string)TripleStr.str()), (char.iterator)NativePointer.$((String)"/include/c++/")), (std.string)Version.Text), std.$plus_str_T((std.string)LibDir.str(), (char.iterator)NativePointer.$((String)"/../include/c++"))}) {
                if (Linux.addLibStdCXXIncludePaths(new Twine(IncludePath), new Twine(NativePointer.$((String)"")), new StringRef(TripleStr), StringRef.EMPTY, StringRef.EMPTY, new Twine(Multilib2.includeSuffix()), DriverArgs, CC1Args)) break;
            }
        }

        @Override
        public boolean isPIEDefault() {
            return this.getSanitizerArgs().requiresPIE();
        }

        @Override
        protected Tool buildAssembler() {
            return new gnutools.Assemble(this);
        }

        @Override
        protected Tool buildLinker() {
            return new gnutools.Link(this);
        }

        private static boolean addLibStdCXXIncludePaths(Twine Base, Twine Suffix, StringRef GCCTriple, StringRef GCCMultiarchTriple, StringRef TargetMultiarchTriple, Twine IncludeSuffix, ArgList DriverArgs, ArgStringList CC1Args) {
            if (!fs.exists((Twine)llvm.$plus_Twine((Twine)Base, (Twine)Suffix))) {
                return false;
            }
            Linux.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, llvm.$plus_Twine((Twine)Base, (Twine)Suffix));
            if (GCCMultiarchTriple.empty() && TargetMultiarchTriple.empty() || fs.exists((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)Base, (Twine)Suffix), (Twine)new Twine(NativePointer.$((String)"/"))), (Twine)new Twine(GCCTriple)), (Twine)IncludeSuffix))) {
                Linux.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)Base, (Twine)Suffix), (Twine)new Twine(NativePointer.$((String)"/"))), (Twine)new Twine(GCCTriple)), (Twine)IncludeSuffix));
            } else {
                Linux.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)Base, (Twine)new Twine(NativePointer.$((String)"/"))), (Twine)new Twine(GCCMultiarchTriple)), (Twine)Suffix), (Twine)IncludeSuffix));
                Linux.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)Base, (Twine)new Twine(NativePointer.$((String)"/"))), (Twine)new Twine(TargetMultiarchTriple)), (Twine)Suffix));
            }
            Linux.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)Base, (Twine)Suffix), (Twine)new Twine(NativePointer.$((String)"/backward"))));
            return true;
        }

        private std.string computeSysRoot() {
            if (!this.getDriver().SysRoot.empty()) {
                return new std.string(this.getDriver().SysRoot);
            }
            if (!this.GCCInstallation.isValid() || !ToolChainsStatics.isMipsArch(this.getTriple().getArch())) {
                return new std.string();
            }
            StringRef InstallDir = this.GCCInstallation.getInstallPath();
            StringRef TripleStr = new StringRef(this.GCCInstallation.getTriple().str());
            Multilib Multilib2 = this.GCCInstallation.getMultilib();
            std.string Path = llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_Twine((Twine)llvm.$plus_StringRef_char$ptr((StringRef)InstallDir, (char.ptr)NativePointer.$((String)"/../../../../")), (Twine)new Twine(TripleStr)), (Twine)new Twine(NativePointer.$((String)"/libc"))), (Twine)new Twine(Multilib2.osSuffix())).str();
            if (fs.exists((Twine)new Twine(Path))) {
                return Path;
            }
            Path.$assign(llvm.$plus_Twine((Twine)llvm.$plus_StringRef_char$ptr((StringRef)InstallDir, (char.ptr)NativePointer.$((String)"/../../../../sysroot")), (Twine)new Twine(Multilib2.osSuffix())).str());
            if (fs.exists((Twine)new Twine(Path))) {
                return Path;
            }
            return new std.string();
        }

        @Override
        public void $destroy() {
            this.ExtraOpts.$destroy();
            this.Linker.$destroy();
            super.$destroy();
        }

        @Override
        public String toString() {
            return "Linker=" + this.Linker + ", ExtraOpts=" + this.ExtraOpts + super.toString();
        }
    }

    public static class DragonFly
    extends Generic_ELF {
        public DragonFly(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
            this.getProgramPaths().push_back((Object)new std.string(this.getDriver().getInstalledDir()));
            if (std.$noteq_T_str((char.iterator)this.getDriver().getInstalledDir(), (std.string)this.getDriver().Dir)) {
                this.getProgramPaths().push_back((Object)this.getDriver().Dir);
            }
            this.getFilePaths().push_back((Object)std.$plus_str_T((std.string)this.getDriver().Dir, (char.iterator)NativePointer.$((String)"/../lib")));
            this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"/usr/lib")));
            if (fs.exists((Twine)new Twine(NativePointer.$((String)"/usr/lib/gcc47")))) {
                this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"/usr/lib/gcc47")));
            } else {
                this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"/usr/lib/gcc44")));
            }
        }

        @Override
        public boolean IsMathErrnoDefault() {
            return false;
        }

        @Override
        protected Tool buildAssembler() {
            return new dragonfly.Assemble(this);
        }

        @Override
        protected Tool buildLinker() {
            return new dragonfly.Link(this);
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Minix
    extends Generic_ELF {
        public Minix(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
            this.getFilePaths().push_back((Object)std.$plus_str_T((std.string)this.getDriver().Dir, (char.iterator)NativePointer.$((String)"/../lib")));
            this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"/usr/lib")));
        }

        @Override
        protected Tool buildAssembler() {
            return new minix.Assemble(this);
        }

        @Override
        protected Tool buildLinker() {
            return new minix.Link(this);
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class NetBSD
    extends Generic_ELF {
        public NetBSD(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
            if (this.getDriver().UseStdLib) {
                block0 : switch (Triple2.getArch()) {
                    case x86: {
                        this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"=/usr/lib/i386")));
                        break;
                    }
                    case arm: 
                    case thumb: 
                    case armeb: 
                    case thumbeb: {
                        switch (Triple2.getEnvironment()) {
                            case GNUEABI: 
                            case EABI: {
                                this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"=/usr/lib/eabi")));
                                break block0;
                            }
                            case GNUEABIHF: 
                            case EABIHF: {
                                this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"=/usr/lib/eabihf")));
                                break block0;
                            }
                        }
                        this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"=/usr/lib/oabi")));
                        break;
                    }
                    case mips64: 
                    case mips64el: {
                        if (mips.hasMipsAbiArg(Args, NativePointer.$((String)"o32"))) {
                            this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"=/usr/lib/o32")));
                            break;
                        }
                        if (!mips.hasMipsAbiArg(Args, NativePointer.$((String)"64"))) break;
                        this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"=/usr/lib/64")));
                        break;
                    }
                    case ppc: {
                        this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"=/usr/lib/powerpc")));
                        break;
                    }
                    case sparc: {
                        this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"=/usr/lib/sparc")));
                        break;
                    }
                }
                this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"=/usr/lib")));
            }
        }

        @Override
        public boolean IsMathErrnoDefault() {
            return false;
        }

        @Override
        public boolean IsObjCNonFragileABIDefault() {
            return true;
        }

        @Override
        public ToolChain.CXXStdlibType GetCXXStdlibType(ArgList Args) {
            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_stdlib_EQ.getValue()));
            if (A != null) {
                StringRef Value = new StringRef(A.getValue());
                if (llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"libstdc++")))) {
                    return ToolChain.CXXStdlibType.CST_Libstdcxx;
                }
                if (llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"libc++")))) {
                    return ToolChain.CXXStdlibType.CST_Libcxx;
                }
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(329L), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
            }
            uint.ref Major = NativePointer.create_uint$ref();
            uint.ref Minor = NativePointer.create_uint$ref();
            uint.ref Micro = NativePointer.create_uint$ref();
            this.getTriple().getOSVersion(Major, Minor, Micro);
            if (Major.$deref() >= 7L || Major.$deref() == 6L && Minor.$deref() == 99L && Micro.$deref() >= 49L || Major.$deref() == 0L) {
                switch (this.getArch()) {
                    case aarch64: 
                    case arm: 
                    case thumb: 
                    case armeb: 
                    case thumbeb: 
                    case x86_64: 
                    case x86: 
                    case ppc: 
                    case ppc64: 
                    case ppc64le: {
                        return ToolChain.CXXStdlibType.CST_Libcxx;
                    }
                }
            }
            return ToolChain.CXXStdlibType.CST_Libstdcxx;
        }

        @Override
        public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
            if (DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlibinc.getValue())) || DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdincxx.getValue()))) {
                return;
            }
            switch (this.GetCXXStdlibType(DriverArgs)) {
                case CST_Libcxx: {
                    NetBSD.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/c++/"))));
                    break;
                }
                case CST_Libstdcxx: {
                    NetBSD.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/g++"))));
                    NetBSD.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/g++/backward"))));
                }
            }
        }

        @Override
        public boolean IsUnwindTablesDefault() {
            return true;
        }

        @Override
        protected Tool buildAssembler() {
            return new netbsd.Assemble(this);
        }

        @Override
        protected Tool buildLinker() {
            return new netbsd.Link(this);
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class FreeBSD
    extends Generic_ELF {
        public FreeBSD(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
            if ((Triple2.getArch() == Triple.ArchType.x86 || Triple2.getArch() == Triple.ArchType.ppc) && fs.exists((Twine)new Twine(std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/lib32/crt1.o"))))) {
                this.getFilePaths().push_back((Object)std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/lib32")));
            } else {
                this.getFilePaths().push_back((Object)std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/lib")));
            }
        }

        @Override
        public boolean HasNativeLLVMSupport() {
            return true;
        }

        @Override
        public boolean IsMathErrnoDefault() {
            return false;
        }

        @Override
        public boolean IsObjCNonFragileABIDefault() {
            return true;
        }

        @Override
        public ToolChain.CXXStdlibType GetCXXStdlibType(ArgList Args) {
            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_stdlib_EQ.getValue()));
            if (A != null) {
                StringRef Value = new StringRef(A.getValue());
                if (llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"libstdc++")))) {
                    return ToolChain.CXXStdlibType.CST_Libstdcxx;
                }
                if (llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"libc++")))) {
                    return ToolChain.CXXStdlibType.CST_Libcxx;
                }
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(329L), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
            }
            if (this.getTriple().getOSMajorVersion() >= 10L) {
                return ToolChain.CXXStdlibType.CST_Libcxx;
            }
            return ToolChain.CXXStdlibType.CST_Libstdcxx;
        }

        @Override
        public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
            if (DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlibinc.getValue())) || DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdincxx.getValue()))) {
                return;
            }
            switch (this.GetCXXStdlibType(DriverArgs)) {
                case CST_Libcxx: {
                    FreeBSD.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/c++/v1"))));
                    break;
                }
                case CST_Libstdcxx: {
                    FreeBSD.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/c++/4.2"))));
                    FreeBSD.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/c++/4.2/backward"))));
                }
            }
        }

        @Override
        public boolean UseSjLjExceptions() {
            switch (this.getTriple().getEnvironment()) {
                case GNUEABIHF: 
                case GNUEABI: 
                case EABI: {
                    return false;
                }
            }
            return this.getTriple().getArch() == Triple.ArchType.arm || this.getTriple().getArch() == Triple.ArchType.thumb;
        }

        @Override
        public boolean isPIEDefault() {
            return this.getSanitizerArgs().requiresPIE();
        }

        @Override
        protected Tool buildAssembler() {
            return new freebsd.Assemble(this);
        }

        @Override
        protected Tool buildLinker() {
            return new freebsd.Link(this);
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Bitrig
    extends Generic_ELF {
        public Bitrig(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
            this.getFilePaths().push_back((Object)std.$plus_str_T((std.string)this.getDriver().Dir, (char.iterator)NativePointer.$((String)"/../lib")));
            this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"/usr/lib")));
        }

        @Override
        public boolean IsMathErrnoDefault() {
            return false;
        }

        @Override
        public boolean IsObjCNonFragileABIDefault() {
            return true;
        }

        @Override
        public ToolChain.CXXStdlibType GetCXXStdlibType(ArgList Args) {
            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_stdlib_EQ.getValue()));
            if (A != null) {
                StringRef Value = new StringRef(A.getValue());
                if (llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"libstdc++")))) {
                    return ToolChain.CXXStdlibType.CST_Libstdcxx;
                }
                if (llvm.$eq_StringRef((StringRef)new StringRef(Value), (StringRef)new StringRef(NativePointer.$((String)"libc++")))) {
                    return ToolChain.CXXStdlibType.CST_Libcxx;
                }
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(329L), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
            }
            return ToolChain.CXXStdlibType.CST_Libcxx;
        }

        @Override
        public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
            if (DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlibinc.getValue())) || DriverArgs.hasArg(new OptSpecifier((long)options.ID.OPT_nostdincxx.getValue()))) {
                return;
            }
            switch (this.GetCXXStdlibType(DriverArgs)) {
                case CST_Libcxx: {
                    Bitrig.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/c++/v1"))));
                    break;
                }
                case CST_Libstdcxx: {
                    Bitrig.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/c++/stdc++"))));
                    Bitrig.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, new Twine(std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/c++/stdc++/backward"))));
                    StringRef Triple2 = new StringRef(this.getTriple().str());
                    if (Triple2.startswith((CharSequence)"amd64")) {
                        Bitrig.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, llvm.$plus_Twine((Twine)new Twine(std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/c++/stdc++/x86_64"))), (Twine)new Twine(Triple2.substr(5))));
                        break;
                    }
                    Bitrig.addSystemInclude(DriverArgs, (SmallVector<char.ptr>)CC1Args, llvm.$plus_Twine((Twine)new Twine(std.$plus_str_T((std.string)this.getDriver().SysRoot, (char.iterator)NativePointer.$((String)"/usr/include/c++/stdc++/"))), (Twine)new Twine(Triple2)));
                }
            }
        }

        @Override
        public void AddCXXStdlibLibArgs(ArgList Args, ArgStringList CmdArgs) {
            switch (this.GetCXXStdlibType(Args)) {
                case CST_Libcxx: {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lc++"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lc++abi"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
                    break;
                }
                case CST_Libstdcxx: {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lstdc++"));
                }
            }
        }

        @Override
        public long GetDefaultStackProtectorLevel(boolean KernelOrKext) {
            return 1L;
        }

        @Override
        protected Tool buildAssembler() {
            return new bitrig.Assemble(this);
        }

        @Override
        protected Tool buildLinker() {
            return new bitrig.Link(this);
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class OpenBSD
    extends Generic_ELF {
        public OpenBSD(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
            this.getFilePaths().push_back((Object)std.$plus_str_T((std.string)this.getDriver().Dir, (char.iterator)NativePointer.$((String)"/../lib")));
            this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"/usr/lib")));
        }

        @Override
        public boolean IsMathErrnoDefault() {
            return false;
        }

        @Override
        public boolean IsObjCNonFragileABIDefault() {
            return true;
        }

        @Override
        public boolean isPIEDefault() {
            return true;
        }

        @Override
        public long GetDefaultStackProtectorLevel(boolean KernelOrKext) {
            return 2L;
        }

        @Override
        protected Tool buildAssembler() {
            return new openbsd.Assemble(this);
        }

        @Override
        protected Tool buildLinker() {
            return new openbsd.Link(this);
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Solaris
    extends Generic_GCC
    implements Destructors.ClassWithDestructor {
        public Solaris(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
            this.getProgramPaths().push_back((Object)new std.string(this.getDriver().getInstalledDir()));
            if (std.$noteq_T_str((char.iterator)this.getDriver().getInstalledDir(), (std.string)this.getDriver().Dir)) {
                this.getProgramPaths().push_back((Object)this.getDriver().Dir);
            }
            this.getFilePaths().push_back((Object)std.$plus_str_T((std.string)this.getDriver().Dir, (char.iterator)NativePointer.$((String)"/../lib")));
            this.getFilePaths().push_back((Object)new std.string(NativePointer.$((String)"/usr/lib")));
        }

        @Override
        public boolean IsIntegratedAssemblerDefault() {
            return true;
        }

        @Override
        protected Tool buildAssembler() {
            return new solaris.Assemble(this);
        }

        @Override
        protected Tool buildLinker() {
            return new solaris.Link(this);
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Generic_ELF
    extends Generic_GCC
    implements Destructors.ClassWithDestructor {
        protected void anchor() {
        }

        public Generic_ELF(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
        }

        @Override
        public void addClangTargetOptions(ArgList DriverArgs, ArgStringList CC1Args) {
            boolean UseInitArrayDefault;
            Generic_GCC.GCCVersion V = this.GCCInstallation.getVersion();
            boolean bl = UseInitArrayDefault = this.getTriple().getArch() == Triple.ArchType.aarch64 || this.getTriple().getArch() == Triple.ArchType.aarch64_be || this.getTriple().getOS() == Triple.OSType.Linux && (!V.isOlderThan(4, 7, 0) || this.getTriple().getEnvironment() == Triple.EnvironmentType.Android);
            if (DriverArgs.hasFlag(new OptSpecifier((long)options.ID.OPT_fuse_init_array.getValue()), new OptSpecifier((long)options.ID.OPT_fno_use_init_array.getValue()), UseInitArrayDefault)) {
                CC1Args.push_back((Object)NativePointer.$((String)"-fuse-init-array"));
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class DarwinClang
    extends Darwin
    implements Destructors.ClassWithDestructor {
        public DarwinClang(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
        }

        @Override
        public void AddLinkRuntimeLibArgs(ArgList Args, ArgStringList CmdArgs) {
            SanitizerArgs Sanitize;
            switch (this.GetRuntimeLibType(Args)) {
                case RLT_CompilerRT: {
                    break;
                }
                default: {
                    ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.getDriver().Diag(357L), (char.ptr)Args.getLastArg(new OptSpecifier((long)options.ID.OPT_rtlib_EQ.getValue())).getValue()), (char.ptr)NativePointer.$((String)"darwin")).$destroy();
                    return;
                }
            }
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fapple_kext.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_mkernel.getValue()))) {
                return;
            }
            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_static_libgcc.getValue()));
            if (A != null) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(354L), (StringRef)new StringRef(A.getAsString(Args))).$destroy();
                return;
            }
            if (Args.hasFlag(new OptSpecifier((long)options.ID.OPT_fprofile_arcs.getValue()), new OptSpecifier((long)options.ID.OPT_fno_profile_arcs.getValue()), false) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fprofile_generate.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fprofile_instr_generate.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_fcreate_profile.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_coverage.getValue()))) {
                if (this.isTargetIOSBased()) {
                    this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef(NativePointer.$((String)"libclang_rt.profile_ios.a")));
                } else {
                    this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef(NativePointer.$((String)"libclang_rt.profile_osx.a")));
                }
            }
            if ((Sanitize = this.getSanitizerArgs()).needsUbsanRt()) {
                if (this.isTargetIOSBased()) {
                    ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.getDriver().Diag(311L), (char.ptr)NativePointer.$((String)"-fsanitize=undefined")).$destroy();
                } else {
                    assert (this.isTargetMacOS()) : "unexpected non OS X target";
                    this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef(NativePointer.$((String)"libclang_rt.ubsan_osx.a")), true);
                    this.AddCXXStdlibLibArgs(Args, CmdArgs);
                }
            }
            if (Sanitize.needsAsanRt()) {
                if (this.isTargetIPhoneOS()) {
                    ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.getDriver().Diag(311L), (char.ptr)NativePointer.$((String)"-fsanitize=address")).$destroy();
                } else {
                    if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_dynamiclib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_bundle.getValue()))) {
                        this.AddCXXStdlibLibArgs(Args, CmdArgs);
                    }
                    if (this.isTargetMacOS()) {
                        this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef(NativePointer.$((String)"libclang_rt.asan_osx_dynamic.dylib")), true, false, true);
                    } else if (this.isTargetIOSSimulator()) {
                        this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef(NativePointer.$((String)"libclang_rt.asan_iossim_dynamic.dylib")), true, false, true);
                    }
                }
            }
            CmdArgs.push_back((Object)NativePointer.$((String)"-lSystem"));
            if (this.isTargetIOSBased()) {
                if (this.isIPhoneOSVersionLT(5L, 0L) && !this.isTargetIOSSimulator() && this.getTriple().getArch() != Triple.ArchType.aarch64) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s.1"));
                }
                this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef(NativePointer.$((String)"libclang_rt.ios.a")));
            } else {
                assert (this.isTargetMacOS()) : "unexpected non MacOS platform";
                if (this.isMacosxVersionLT(10L, 5L)) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s.10.4"));
                } else if (this.isMacosxVersionLT(10L, 6L)) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s.10.5"));
                }
                if (this.isMacosxVersionLT(10L, 5L)) {
                    this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef(NativePointer.$((String)"libclang_rt.10.4.a")));
                } else {
                    if (this.getTriple().getArch() == Triple.ArchType.x86) {
                        this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef(NativePointer.$((String)"libclang_rt.eprintf.a")));
                    }
                    this.AddLinkRuntimeLib(Args, CmdArgs, new StringRef(NativePointer.$((String)"libclang_rt.osx.a")));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void AddCXXStdlibLibArgs(ArgList Args, ArgStringList CmdArgs) {
            ToolChain.CXXStdlibType Type2 = this.GetCXXStdlibType(Args);
            switch (Type2) {
                case CST_Libcxx: {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lc++"));
                    break;
                }
                case CST_Libstdcxx: {
                    Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_isysroot.getValue()));
                    if (A != null) {
                        SmallString P = null;
                        try {
                            P = new SmallString(new StringRef(A.getValue()), 128);
                            path.append((SmallString)P, (Twine)new Twine(NativePointer.$((String)"usr")), (Twine)new Twine(NativePointer.$((String)"lib")), (Twine)new Twine(NativePointer.$((String)"libstdc++.dylib")));
                            if (!fs.exists((Twine)new Twine(P.str()))) {
                                path.remove_filename((SmallString)P);
                                path.append((SmallString)P, (Twine)new Twine(NativePointer.$((String)"libstdc++.6.dylib")));
                                if (fs.exists((Twine)new Twine(P.str()))) {
                                    CmdArgs.push_back((Object)Args.MakeArgString(P.str()));
                                    return;
                                }
                            }
                        }
                        finally {
                            if (P != null) {
                                P.$destroy();
                            }
                        }
                    }
                    if (!fs.exists((Twine)new Twine(NativePointer.$((String)"/usr/lib/libstdc++.dylib"))) && fs.exists((Twine)new Twine(NativePointer.$((String)"/usr/lib/libstdc++.6.dylib")))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"/usr/lib/libstdc++.6.dylib"));
                        return;
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lstdc++"));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void AddCCKextLibArgs(ArgList Args, ArgStringList CmdArgs) {
            SmallString P = null;
            try {
                P = new SmallString(new StringRef(this.getDriver().ResourceDir), 128);
                path.append((SmallString)P, (Twine)new Twine(NativePointer.$((String)"lib")), (Twine)new Twine(NativePointer.$((String)"darwin")));
                if (!this.isTargetIPhoneOS() || this.isTargetIOSSimulator() || this.getTriple().getArch() == Triple.ArchType.aarch64 || !this.isIPhoneOSVersionLT(6L, 0L)) {
                    path.append((SmallString)P, (Twine)new Twine(NativePointer.$((String)"libclang_rt.cc_kext.a")));
                } else {
                    path.append((SmallString)P, (Twine)new Twine(NativePointer.$((String)"libclang_rt.cc_kext_ios5.a")));
                }
                if (fs.exists((Twine)new Twine(P.str()))) {
                    CmdArgs.push_back((Object)Args.MakeArgString(P.str()));
                }
            }
            finally {
                if (P != null) {
                    P.$destroy();
                }
            }
        }

        @Override
        public void addClangWarningOptions(ArgStringList CC1Args) {
            if (!this.isTargetMacOS() && this.getTriple().isArch64Bit()) {
                CC1Args.push_back((Object)NativePointer.$((String)"-Wdeprecated-objc-isa-usage"));
                CC1Args.push_back((Object)NativePointer.$((String)"-Werror=deprecated-objc-isa-usage"));
                CC1Args.push_back((Object)NativePointer.$((String)"-Werror=implicit-function-declaration"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void AddLinkARCArgs(ArgList Args, ArgStringList CmdArgs) {
            SmallString P = null;
            try {
                if (this.isTargetMacOS() && this.getArch() == Triple.ArchType.x86) {
                    return;
                }
                ObjCRuntime runtime = this.getDefaultObjCRuntime(true);
                if ((runtime.hasNativeARC() || !ToolChainsStatics.isObjCAutoRefCount(Args)) && runtime.hasSubscripting()) {
                    return;
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-force_load"));
                P = new SmallString(new StringRef(this.getDriver().ClangExecutable), 128);
                path.remove_filename((SmallString)P);
                path.remove_filename((SmallString)P);
                path.append((SmallString)P, (Twine)new Twine(NativePointer.$((String)"lib")), (Twine)new Twine(NativePointer.$((String)"arc")), (Twine)new Twine(NativePointer.$((String)"libarclite_")));
                if (this.isTargetIOSSimulator()) {
                    P.$addassign(new StringRef(NativePointer.$((String)"iphonesimulator")));
                } else if (this.isTargetIPhoneOS()) {
                    P.$addassign(new StringRef(NativePointer.$((String)"iphoneos")));
                } else {
                    P.$addassign(new StringRef(NativePointer.$((String)"macosx")));
                }
                P.$addassign(new StringRef(NativePointer.$((String)".a")));
                CmdArgs.push_back((Object)Args.MakeArgString(P.$StringRef()));
            }
            finally {
                if (P != null) {
                    P.$destroy();
                }
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Darwin
    extends MachO
    implements Destructors.ClassWithDestructor {
        public long[] DarwinVersion = NativePointer.new$long((int)3, (int[])new int[0]);
        public boolean TargetInitialized = false;
        public DarwinPlatformKind TargetPlatform;
        public VersionTuple TargetVersion = new VersionTuple();
        private std.string MacosxVersionMin = new std.string();
        private std.string iOSVersionMin = new std.string();

        private void AddDeploymentTarget(DerivedArgList Args) {
            DarwinPlatformKind Platform;
            OptTable Opts = this.getDriver().getOpts();
            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_isysroot.getValue()));
            if (A != null) {
                if (!fs.exists((Twine)new Twine(A.getValue()))) {
                    ClangGlobals.$out_DiagnosticBuilder_char$ptr((DiagnosticBuilder)this.getDriver().Diag(382L), (char.ptr)A.getValue()).$destroy();
                }
            } else {
                char.ptr env = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"SDKROOT")));
                if (env != null && path.is_absolute((char.ptr)env) && fs.exists((Twine)new Twine(env)) && llvm.$noteq_StringRef((StringRef)new StringRef(env), (StringRef)StringRef.SLASH)) {
                    Args.append(Args.MakeSeparateArg(null, Opts.getOption(new OptSpecifier((long)options.ID.OPT_isysroot.getValue())), new StringRef(env)));
                }
            }
            Arg OSXVersion = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mmacosx_version_min_EQ.getValue()));
            Arg iOSVersion = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_miphoneos_version_min_EQ.getValue()));
            if (OSXVersion != null && iOSVersion != null) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(306L), (StringRef)new StringRef(OSXVersion.getAsString((ArgList)Args))), (StringRef)new StringRef(iOSVersion.getAsString((ArgList)Args))).$destroy();
                iOSVersion = null;
            } else if (OSXVersion == null && iOSVersion == null) {
                Option O;
                Arg A2;
                StringRef OSXTarget = new StringRef();
                StringRef iOSTarget = new StringRef();
                char.ptr env = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"MACOSX_DEPLOYMENT_TARGET")));
                if (env != null) {
                    OSXTarget.$assign(new StringRef(env));
                }
                if ((env = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"IPHONEOS_DEPLOYMENT_TARGET")))) != null) {
                    iOSTarget.$assign(new StringRef(env));
                }
                if (iOSTarget.empty() && (A2 = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_isysroot.getValue()))) != null) {
                    StringRef first = new StringRef();
                    StringRef second = new StringRef();
                    StringRef isysroot = new StringRef(A2.getValue());
                    std.tie((Object)first, (Object)second).$assign(isysroot.split(new StringRef(NativePointer.$((String)"SDKs/iPhoneOS"))));
                    if (llvm.$noteq_StringRef((StringRef)new StringRef(second), (StringRef)StringRef.EMPTY)) {
                        iOSTarget.$assign(second.substr(0, 3));
                    }
                }
                StringRef MachOArchName = this.getMachOArchName((ArgList)Args);
                if (OSXTarget.empty() && iOSTarget.empty() && (llvm.$eq_StringRef((StringRef)new StringRef(MachOArchName), (StringRef)new StringRef(NativePointer.$((String)"armv7"))) || llvm.$eq_StringRef((StringRef)new StringRef(MachOArchName), (StringRef)new StringRef(NativePointer.$((String)"armv7s"))) || llvm.$eq_StringRef((StringRef)new StringRef(MachOArchName), (StringRef)new StringRef(NativePointer.$((String)"arm64"))))) {
                    iOSTarget.$assign(new StringRef(this.iOSVersionMin));
                }
                if (!OSXTarget.empty() && !iOSTarget.empty()) {
                    if (this.getTriple().getArch() == Triple.ArchType.arm || this.getTriple().getArch() == Triple.ArchType.aarch64 || this.getTriple().getArch() == Triple.ArchType.thumb) {
                        OSXTarget.$assign(StringRef.EMPTY);
                    } else {
                        iOSTarget.$assign(StringRef.EMPTY);
                    }
                }
                if (!OSXTarget.empty()) {
                    O = Opts.getOption(new OptSpecifier((long)options.ID.OPT_mmacosx_version_min_EQ.getValue()));
                    OSXVersion = Args.MakeJoinedArg(null, new Option(O), new StringRef(OSXTarget));
                    Args.append(OSXVersion);
                } else if (!iOSTarget.empty()) {
                    O = Opts.getOption(new OptSpecifier((long)options.ID.OPT_miphoneos_version_min_EQ.getValue()));
                    iOSVersion = Args.MakeJoinedArg(null, new Option(O), new StringRef(iOSTarget));
                    Args.append(iOSVersion);
                } else if (llvm.$noteq_StringRef((StringRef)new StringRef(MachOArchName), (StringRef)new StringRef(NativePointer.$((String)"armv6m"))) && llvm.$noteq_StringRef((StringRef)new StringRef(MachOArchName), (StringRef)new StringRef(NativePointer.$((String)"armv7m"))) && llvm.$noteq_StringRef((StringRef)new StringRef(MachOArchName), (StringRef)new StringRef(NativePointer.$((String)"armv7em")))) {
                    O = Opts.getOption(new OptSpecifier((long)options.ID.OPT_mmacosx_version_min_EQ.getValue()));
                    OSXVersion = Args.MakeJoinedArg(null, new Option(O), new StringRef(this.MacosxVersionMin));
                    Args.append(OSXVersion);
                }
            }
            if (OSXVersion != null) {
                Platform = DarwinPlatformKind.MacOS;
            } else if (iOSVersion != null) {
                Platform = DarwinPlatformKind.IPhoneOS;
            } else {
                throw new llvm_unreachable((CharSequence)"Unable to infer Darwin variant");
            }
            uint.ref Major = NativePointer.create_uint$ref();
            uint.ref Minor = NativePointer.create_uint$ref();
            uint.ref Micro = NativePointer.create_uint$ref();
            bool.ref HadExtra = NativePointer.create_bool$ref();
            if (Platform == DarwinPlatformKind.MacOS) {
                assert (iOSVersion == null) : "Unknown target platform!";
                if (!Driver.GetReleaseVersion(OSXVersion.getValue(), Major, Minor, Micro, HadExtra) || HadExtra.$deref() || Major.$deref() != 10L || Minor.$deref() >= 100L || Micro.$deref() >= 100L) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(332L), (StringRef)new StringRef(OSXVersion.getAsString((ArgList)Args))).$destroy();
                }
            } else if (Platform == DarwinPlatformKind.IPhoneOS) {
                assert (iOSVersion != null) : "Unknown target platform!";
                if (!Driver.GetReleaseVersion(iOSVersion.getValue(), Major, Minor, Micro, HadExtra) || HadExtra.$deref() || Major.$deref() >= 10L || Minor.$deref() >= 100L || Micro.$deref() >= 100L) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(332L), (StringRef)new StringRef(iOSVersion.getAsString((ArgList)Args))).$destroy();
                }
            } else {
                throw new llvm_unreachable((CharSequence)"unknown kind of Darwin platform");
            }
            if (iOSVersion != null && (this.getTriple().getArch() == Triple.ArchType.x86 || this.getTriple().getArch() == Triple.ArchType.x86_64)) {
                Platform = DarwinPlatformKind.IPhoneOSSimulator;
            }
            this.setTarget(Platform, Major.$deref(), Minor.$deref(), Micro.$deref());
        }

        public Darwin(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
            uint.ref Major = NativePointer.create_uint$ref();
            uint.ref Minor = NativePointer.create_uint$ref();
            uint.ref Micro = NativePointer.create_uint$ref();
            if (!Triple2.getMacOSXVersion(Major, Minor, Micro)) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(320L), (StringRef)Triple2.getOSName()).$destroy();
            }
            new raw_string_ostream(this.MacosxVersionMin).$out_uint(Major.$deref()).$out_char(NativePointer.$((char)'.')).$out_uint(Minor.$deref()).$out_char(NativePointer.$((char)'.')).$out_uint(Micro.$deref());
            this.DarwinVersion[0] = Minor.$deref() + 4L;
            this.DarwinVersion[1] = Micro.$deref();
            this.DarwinVersion[2] = 0L;
            Triple2.getiOSVersion(Major, Minor, Micro);
            new raw_string_ostream(this.iOSVersionMin).$out_uint(Major.$deref()).$out_char(NativePointer.$((char)'.')).$out_uint(Minor.$deref()).$out_char(NativePointer.$((char)'.')).$out_uint(Micro.$deref());
        }

        @Override
        public void $destroy() {
            this.iOSVersionMin.$destroy();
            this.MacosxVersionMin.$destroy();
            super.$destroy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public std.string ComputeEffectiveClangTriple(ArgList Args, types.ID InputType) {
            Triple Triple2 = null;
            SmallString Str = null;
            try {
                Triple2 = new Triple(new Twine(this.ComputeLLVMTriple(Args, InputType)));
                if (!this.isTargetInitialized()) {
                    std.string string2 = new std.string(Triple2.getTriple());
                    return string2;
                }
                Str = new SmallString(16);
                Str.$addassign(new StringRef(this.isTargetIOSBased() ? NativePointer.$((String)"ios") : NativePointer.$((String)"macosx")));
                Str.$addassign(new StringRef(this.getTargetVersion().getAsString()));
                Triple2.setOSName(Str.$StringRef());
                std.string string3 = new std.string(Triple2.getTriple());
                return string3;
            }
            finally {
                if (Str != null) {
                    Str.$destroy();
                }
                if (Triple2 != null) {
                    Triple2.$destroy();
                }
            }
        }

        @Override
        public void addMinVersionArgs(ArgList Args, ArgStringList CmdArgs) {
            VersionTuple TargetVersion = this.getTargetVersion();
            if (this.isTargetIOSSimulator()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-ios_simulator_version_min"));
            } else if (this.isTargetIOSBased()) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-iphoneos_version_min"));
            } else {
                assert (this.isTargetMacOS()) : "unexpected target";
                CmdArgs.push_back((Object)NativePointer.$((String)"-macosx_version_min"));
            }
            CmdArgs.push_back((Object)Args.MakeArgString(TargetVersion.getAsString()));
        }

        @Override
        public void addStartObjectFileArgs(ArgList Args, ArgStringList CmdArgs) {
            if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_dynamiclib.getValue()))) {
                if (!this.isTargetIOSSimulator()) {
                    if (this.isTargetIPhoneOS()) {
                        if (this.isIPhoneOSVersionLT(3L, 1L)) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-ldylib1.o"));
                        }
                    } else if (this.isMacosxVersionLT(10L, 5L)) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-ldylib1.o"));
                    } else if (this.isMacosxVersionLT(10L, 6L)) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-ldylib1.10.5.o"));
                    }
                }
            } else if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_bundle.getValue()))) {
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue())) && !this.isTargetIOSSimulator()) {
                    if (this.isTargetIPhoneOS()) {
                        if (this.isIPhoneOSVersionLT(3L, 1L)) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lbundle1.o"));
                        }
                    } else if (this.isMacosxVersionLT(10L, 6L)) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lbundle1.o"));
                    }
                }
            } else if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pg.getValue())) && this.SupportsProfiling()) {
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_object.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_preload.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcrt0.o"));
                } else {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcrt1.o"));
                }
                if (this.isTargetMacOS() && !this.isMacosxVersionLT(10L, 8L)) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-no_new_main"));
                }
            } else if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_object.getValue())) || Args.hasArg(new OptSpecifier((long)options.ID.OPT_preload.getValue()))) {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lcrt0.o"));
            } else if (!this.isTargetIOSSimulator()) {
                if (this.isTargetIPhoneOS()) {
                    if (this.getArch() != Triple.ArchType.aarch64) {
                        if (this.isIPhoneOSVersionLT(3L, 1L)) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lcrt1.o"));
                        } else if (this.isIPhoneOSVersionLT(6L, 0L)) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lcrt1.3.1.o"));
                        }
                    }
                } else if (this.isMacosxVersionLT(10L, 5L)) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lcrt1.o"));
                } else if (this.isMacosxVersionLT(10L, 6L)) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lcrt1.10.5.o"));
                } else if (this.isMacosxVersionLT(10L, 8L)) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lcrt1.10.6.o"));
                }
            }
            if (!this.isTargetIPhoneOS() && Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared_libgcc.getValue())) && this.isMacosxVersionLT(10L, 5L)) {
                char.ptr Str = Native.$tryClone((char.ptr)Args.MakeArgString(this.GetFilePath(NativePointer.$((String)"crt3.o"))));
                CmdArgs.push_back((Object)Str);
            }
        }

        @Override
        public boolean isKernelStatic() {
            return !this.isTargetIPhoneOS() || this.isIPhoneOSVersionLT(6L, 0L) || this.getTriple().getArch() == Triple.ArchType.aarch64;
        }

        protected void setTarget(DarwinPlatformKind Platform, long Major, long Minor, long Micro) {
            if (this.TargetInitialized && this.TargetPlatform == Platform && ClangGlobals.$eq_VersionTuple((VersionTuple)this.TargetVersion, (VersionTuple)new VersionTuple(Major, Minor, Micro))) {
                return;
            }
            assert (!this.TargetInitialized) : "Target already initialized!";
            this.TargetInitialized = true;
            this.TargetPlatform = Platform;
            this.TargetVersion.$assign(new VersionTuple(Major, Minor, Micro));
        }

        protected boolean isTargetIPhoneOS() {
            assert (this.TargetInitialized) : "Target not initialized!";
            return this.TargetPlatform == DarwinPlatformKind.IPhoneOS;
        }

        protected boolean isTargetIOSSimulator() {
            assert (this.TargetInitialized) : "Target not initialized!";
            return this.TargetPlatform == DarwinPlatformKind.IPhoneOSSimulator;
        }

        @Override
        public boolean isTargetIOSBased() {
            assert (this.TargetInitialized) : "Target not initialized!";
            return this.isTargetIPhoneOS() || this.isTargetIOSSimulator();
        }

        protected boolean isTargetMacOS() {
            return this.TargetPlatform == DarwinPlatformKind.MacOS;
        }

        protected boolean isTargetInitialized() {
            return this.TargetInitialized;
        }

        protected VersionTuple getTargetVersion() {
            assert (this.TargetInitialized) : "Target not initialized!";
            return new VersionTuple(this.TargetVersion);
        }

        protected boolean isIPhoneOSVersionLT(long V0) {
            return this.isIPhoneOSVersionLT(V0, 0L, 0L);
        }

        protected boolean isIPhoneOSVersionLT(long V0, long V1) {
            return this.isIPhoneOSVersionLT(V0, V1, 0L);
        }

        protected boolean isIPhoneOSVersionLT(long V0, long V1, long V2) {
            assert (this.isTargetIOSBased()) : "Unexpected call for non iOS target!";
            return ClangGlobals.$less_VersionTuple((VersionTuple)this.TargetVersion, (VersionTuple)new VersionTuple(V0, V1, V2));
        }

        protected boolean isMacosxVersionLT(long V0) {
            return this.isMacosxVersionLT(V0, 0L, 0L);
        }

        protected boolean isMacosxVersionLT(long V0, long V1) {
            return this.isMacosxVersionLT(V0, V1, 0L);
        }

        protected boolean isMacosxVersionLT(long V0, long V1, long V2) {
            assert (this.isTargetMacOS()) : "Unexpected call for non OS X target!";
            return ClangGlobals.$less_VersionTuple((VersionTuple)this.TargetVersion, (VersionTuple)new VersionTuple(V0, V1, V2));
        }

        @Override
        public boolean isCrossCompiling() {
            return false;
        }

        @Override
        public DerivedArgList TranslateArgs(DerivedArgList Args, char.ptr BoundArch) {
            ToolChain.CXXStdlibType Type2;
            DerivedArgList DAL = super.TranslateArgs(Args, BoundArch);
            OptTable Opts = this.getDriver().getOpts();
            if (BoundArch == null) {
                return DAL;
            }
            this.AddDeploymentTarget(DAL);
            if (this.isTargetIOSBased() && !this.isIPhoneOSVersionLT(6L, 0L)) {
                SmallVectorImpl.iterator it = DAL.begin();
                SmallVectorImpl.iterator ie = DAL.end();
                while (it.$noteq((Object)ie)) {
                    Arg A = (Arg)it.$star();
                    it.$preInc();
                    if (A.getOption().getID() != (long)options.ID.OPT_mkernel.getValue() && A.getOption().getID() != (long)options.ID.OPT_fapple_kext.getValue()) continue;
                    assert (it.$noteq((Object)ie)) : "unexpected argument translation";
                    A = (Arg)it.$star();
                    assert (A.getOption().getID() == (long)options.ID.OPT_static.getValue()) : "missing expected -static argument";
                    it = DAL.getArgs().erase(it);
                }
            }
            if ((this.isTargetMacOS() && !this.isMacosxVersionLT(10L, 9L) || this.isTargetIOSBased() && !this.isIPhoneOSVersionLT(7L, 0L)) && Args.getLastArg(new OptSpecifier((long)options.ID.OPT_stdlib_EQ.getValue())) == null) {
                DAL.AddJoinedArg(null, Opts.getOption(new OptSpecifier((long)options.ID.OPT_stdlib_EQ.getValue())), new StringRef(NativePointer.$((String)"libc++")));
            }
            if ((Type2 = this.GetCXXStdlibType((ArgList)DAL)) == ToolChain.CXXStdlibType.CST_Libcxx) {
                StringRef where = new StringRef();
                if (this.isTargetIOSBased() && this.isIPhoneOSVersionLT(5L, 0L)) {
                    where.$assign(new StringRef(NativePointer.$((String)"iOS 5.0")));
                }
                if (llvm.$noteq_StringRef((StringRef)new StringRef(where), (StringRef)new StringRef())) {
                    ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(323L), (StringRef)new StringRef(where)).$destroy();
                }
            }
            return DAL;
        }

        @Override
        public ObjCRuntime getDefaultObjCRuntime(boolean isNonFragile) {
            if (this.isTargetIOSBased()) {
                return new ObjCRuntime(ObjCRuntime.Kind.iOS, this.TargetVersion);
            }
            if (isNonFragile) {
                return new ObjCRuntime(ObjCRuntime.Kind.MacOSX, this.TargetVersion);
            }
            return new ObjCRuntime(ObjCRuntime.Kind.FragileMacOSX, this.TargetVersion);
        }

        @Override
        public boolean hasBlocksRuntime() {
            if (this.isTargetIOSBased()) {
                return !this.isIPhoneOSVersionLT(3L, 2L);
            }
            assert (this.isTargetMacOS()) : "unexpected darwin target";
            return !this.isMacosxVersionLT(10L, 6L);
        }

        @Override
        public boolean UseObjCMixedDispatch() {
            return !this.isTargetMacOS() || !this.isMacosxVersionLT(10L, 6L);
        }

        @Override
        public long GetDefaultStackProtectorLevel(boolean KernelOrKext) {
            if (this.isTargetIOSBased()) {
                return 1L;
            }
            if (this.isTargetMacOS() && !this.isMacosxVersionLT(10L, 6L)) {
                return 1L;
            }
            if (this.isTargetMacOS() && !this.isMacosxVersionLT(10L, 5L) && !KernelOrKext) {
                return 1L;
            }
            return 0L;
        }

        @Override
        public boolean SupportsObjCGC() {
            return this.isTargetMacOS();
        }

        @Override
        public void CheckObjCARC() {
            if (this.isTargetIOSBased() || this.isTargetMacOS() && !this.isMacosxVersionLT(10L, 6L)) {
                return;
            }
            this.getDriver().Diag(304L).$destroy();
        }

        @Override
        public boolean UseSjLjExceptions() {
            return this.getTriple().getArch() == Triple.ArchType.arm || this.getTriple().getArch() == Triple.ArchType.thumb;
        }

        @Override
        public String toString() {
            return "DarwinVersion=" + this.DarwinVersion + ", TargetInitialized=" + this.TargetInitialized + ", TargetPlatform=" + (Object)((Object)this.TargetPlatform) + ", TargetVersion=" + this.TargetVersion + ", MacosxVersionMin=" + this.MacosxVersionMin + ", iOSVersionMin=" + this.iOSVersionMin + super.toString();
        }

        public static final class DarwinPlatformKind
        extends Enum<DarwinPlatformKind> {
            public static final /* enum */ DarwinPlatformKind MacOS = new DarwinPlatformKind(0L);
            public static final /* enum */ DarwinPlatformKind IPhoneOS = new DarwinPlatformKind(MacOS.getValue() + 1);
            public static final /* enum */ DarwinPlatformKind IPhoneOSSimulator = new DarwinPlatformKind(IPhoneOS.getValue() + 1);
            private final int value;
            private static final /* synthetic */ DarwinPlatformKind[] $VALUES;

            public static DarwinPlatformKind[] values() {
                return (DarwinPlatformKind[])$VALUES.clone();
            }

            public static DarwinPlatformKind valueOf(String name) {
                return Enum.valueOf(DarwinPlatformKind.class, name);
            }

            public static DarwinPlatformKind valueOf(int val) {
                DarwinPlatformKind out;
                DarwinPlatformKind darwinPlatformKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
                assert (out != null) : "no value for " + val;
                return out;
            }

            private DarwinPlatformKind(long val) {
                this.value = (int)val;
            }

            public int getValue() {
                return this.value;
            }

            static {
                $VALUES = new DarwinPlatformKind[]{MacOS, IPhoneOS, IPhoneOSSimulator};
            }

            private static final class Values {
                private static final DarwinPlatformKind[] VALUES;
                private static final DarwinPlatformKind[] _VALUES;

                private Values() {
                }

                static {
                    int max = 0;
                    int min = 0;
                    for (DarwinPlatformKind kind : DarwinPlatformKind.values()) {
                        if (kind.value > max) {
                            max = kind.value;
                        }
                        if (kind.value >= min) continue;
                        min = kind.value;
                    }
                    _VALUES = new DarwinPlatformKind[min < 0 ? 1 - min : 0];
                    VALUES = new DarwinPlatformKind[max >= 0 ? 1 + max : 0];
                    for (DarwinPlatformKind kind : DarwinPlatformKind.values()) {
                        if (kind.value < 0) {
                            Values._VALUES[-((DarwinPlatformKind)kind).value] = kind;
                            continue;
                        }
                        Values.VALUES[((DarwinPlatformKind)kind).value] = kind;
                    }
                }
            }
        }
    }

    public static class MachO
    extends ToolChain
    implements Destructors.ClassWithDestructor {
        private std_ptr.unique_ptr<darwin.Lipo> Lipo = new std_ptr.unique_ptr();
        private std_ptr.unique_ptr<darwin.Dsymutil> Dsymutil = new std_ptr.unique_ptr();
        private std_ptr.unique_ptr<darwin.VerifyDebug> VerifyDebug = new std_ptr.unique_ptr();

        @Override
        protected Tool buildAssembler() {
            return new darwin.Assemble(this);
        }

        @Override
        protected Tool buildLinker() {
            return new darwin.Link(this);
        }

        @Override
        protected Tool getTool(Action.ActionClass AC) {
            switch (AC) {
                case LipoJobClass: {
                    if (!this.Lipo.$boolean()) {
                        this.Lipo.reset((Object)new darwin.Lipo(this));
                    }
                    return (Tool)this.Lipo.get();
                }
                case DsymutilJobClass: {
                    if (!this.Dsymutil.$boolean()) {
                        this.Dsymutil.reset((Object)new darwin.Dsymutil(this));
                    }
                    return (Tool)this.Dsymutil.get();
                }
                case VerifyDebugInfoJobClass: {
                    if (!this.VerifyDebug.$boolean()) {
                        this.VerifyDebug.reset((Object)new darwin.VerifyDebug(this));
                    }
                    return (Tool)this.VerifyDebug.get();
                }
            }
            return super.getTool(AC);
        }

        public MachO(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
            this.getProgramPaths().push_back((Object)new std.string(this.getDriver().getInstalledDir()));
            if (std.$noteq_T_str((char.iterator)this.getDriver().getInstalledDir(), (std.string)this.getDriver().Dir)) {
                this.getProgramPaths().push_back((Object)this.getDriver().Dir);
            }
            this.getProgramPaths().push_back((Object)new std.string(this.getDriver().getInstalledDir()));
            if (std.$noteq_T_str((char.iterator)this.getDriver().getInstalledDir(), (std.string)this.getDriver().Dir)) {
                this.getProgramPaths().push_back((Object)this.getDriver().Dir);
            }
        }

        @Override
        public void $destroy() {
            this.VerifyDebug.$destroy();
            this.Dsymutil.$destroy();
            this.Lipo.$destroy();
            super.$destroy();
        }

        public StringRef getMachOArchName(ArgList Args) {
            char.ptr Arch;
            switch (this.getTriple().getArch()) {
                default: {
                    return this.getDefaultUniversalArchName();
                }
                case aarch64: {
                    return new StringRef(NativePointer.$((String)"arm64"));
                }
                case arm: 
                case thumb: 
            }
            Arg A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_march_EQ.getValue()));
            if (A != null && (Arch = Native.$tryClone((char.ptr)ToolChainsStatics.GetArmArchForMArch(new StringRef(A.getValue())))) != null) {
                return new StringRef(Arch);
            }
            A = Args.getLastArg(new OptSpecifier((long)options.ID.OPT_mcpu_EQ.getValue()));
            if (A != null && (Arch = Native.$tryClone((char.ptr)ToolChainsStatics.GetArmArchForMCpu(new StringRef(A.getValue())))) != null) {
                return new StringRef(Arch);
            }
            return new StringRef(NativePointer.$((String)"arm"));
        }

        public void AddLinkARCArgs(ArgList Args, ArgStringList CmdArgs) {
        }

        public void AddLinkRuntimeLibArgs(ArgList Args, ArgStringList CmdArgs) {
            SmallString CompilerRT = new SmallString(new StringRef(NativePointer.$((String)"libclang_rt.")), 32);
            CompilerRT.$addassign(new StringRef(llvm.$eq_StringRef((StringRef)arm.getARMFloatABI(this.getDriver(), Args, this.getTriple()), (StringRef)new StringRef(NativePointer.$((String)"hard"))) ? NativePointer.$((String)"hard") : NativePointer.$((String)"soft")));
            CompilerRT.$addassign(new StringRef(Args.hasArg(new OptSpecifier((long)options.ID.OPT_fPIC.getValue())) ? NativePointer.$((String)"_pic.a") : NativePointer.$((String)"_static.a")));
            this.AddLinkRuntimeLib(Args, CmdArgs, CompilerRT.$StringRef(), false, true);
        }

        public void addStartObjectFileArgs(ArgList Args, ArgStringList CmdArgs) {
        }

        public void addMinVersionArgs(ArgList Args, ArgStringList CmdArgs) {
        }

        public boolean isKernelStatic() {
            return false;
        }

        public boolean isTargetIOSBased() {
            return false;
        }

        public void AddLinkRuntimeLib(ArgList Args, ArgStringList CmdArgs, StringRef DarwinLibName) {
            this.AddLinkRuntimeLib(Args, CmdArgs, DarwinLibName, false, false, false);
        }

        public void AddLinkRuntimeLib(ArgList Args, ArgStringList CmdArgs, StringRef DarwinLibName, boolean AlwaysLink) {
            this.AddLinkRuntimeLib(Args, CmdArgs, DarwinLibName, AlwaysLink, false, false);
        }

        public void AddLinkRuntimeLib(ArgList Args, ArgStringList CmdArgs, StringRef DarwinLibName, boolean AlwaysLink, boolean IsEmbedded) {
            this.AddLinkRuntimeLib(Args, CmdArgs, DarwinLibName, AlwaysLink, IsEmbedded, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void AddLinkRuntimeLib(ArgList Args, ArgStringList CmdArgs, StringRef DarwinLibName, boolean AlwaysLink, boolean IsEmbedded, boolean AddRPath) {
            SmallString Dir = null;
            SmallString P = null;
            try {
                Dir = new SmallString(new StringRef(this.getDriver().ResourceDir), 128);
                path.append((SmallString)Dir, (Twine)new Twine(NativePointer.$((String)"lib")), (Twine)new Twine(IsEmbedded ? NativePointer.$((String)"macho_embedded") : NativePointer.$((String)"darwin")));
                P = new SmallString(Dir);
                path.append((SmallString)P, (Twine)new Twine(DarwinLibName));
                if (AlwaysLink || fs.exists((Twine)new Twine(P.str()))) {
                    CmdArgs.push_back((Object)Args.MakeArgString(P.str()));
                }
                if (AddRPath) {
                    assert (DarwinLibName.endswith((CharSequence)".dylib")) : "must be a dynamic library";
                    CmdArgs.push_back((Object)NativePointer.$((String)"-rpath"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"@executable_path"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-rpath"));
                    CmdArgs.push_back((Object)Args.MakeArgString(Dir.str()));
                }
            }
            finally {
                if (P != null) {
                    P.$destroy();
                }
                if (Dir != null) {
                    Dir.$destroy();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public std.string ComputeEffectiveClangTriple(ArgList Args, types.ID InputType) {
            Triple Triple2 = null;
            try {
                Triple2 = new Triple(new Twine(this.ComputeLLVMTriple(Args, InputType)));
                std.string string2 = new std.string(Triple2.getTriple());
                return string2;
            }
            finally {
                if (Triple2 != null) {
                    Triple2.$destroy();
                }
            }
        }

        @Override
        public types.ID LookupTypeForExtension(char.ptr Ext) {
            types.ID Ty = types.lookupTypeForExtension(Ext);
            if (Ty == types.ID.TY_PP_Asm) {
                return types.ID.TY_Asm;
            }
            return Ty;
        }

        @Override
        public boolean HasNativeLLVMSupport() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public DerivedArgList TranslateArgs(DerivedArgList Args, char.ptr BoundArch) {
            DerivedArgList DAL = new DerivedArgList(Args.getBaseArgs());
            OptTable Opts = this.getDriver().getOpts();
            block19: for (Arg A : Args) {
                if (A.getOption().matches(new OptSpecifier((long)options.ID.OPT_Xarch__.getValue()))) {
                    std_ptr.unique_ptr XarchArg = null;
                    try {
                        Triple.ArchType XarchArch = darwin.getArchTypeForMachOArchName(new StringRef(A.getValue(0L)));
                        if (XarchArch != this.getArch() && (BoundArch == null || XarchArch != darwin.getArchTypeForMachOArchName(new StringRef(BoundArch)))) continue;
                        Arg OriginalArg = A;
                        uint.ref Index = NativePointer.create_uint$ref((long)Args.getBaseArgs().MakeIndex(new StringRef(A.getValue(1L))));
                        long Prev = Index.$deref();
                        XarchArg = new std_ptr.unique_ptr((Object)Opts.ParseOneArg((ArgList)Args, Index));
                        if (!XarchArg.$boolean() || Index.$deref() > Prev + 1L) {
                            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(318L), (StringRef)new StringRef(A.getAsString((ArgList)Args))).$destroy();
                            continue;
                        }
                        if (((Arg)XarchArg.$arrow()).getOption().hasFlag(16L)) {
                            ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.getDriver().Diag(317L), (StringRef)new StringRef(A.getAsString((ArgList)Args))).$destroy();
                            continue;
                        }
                        ((Arg)XarchArg.$arrow()).setBaseArg(A);
                        A = (Arg)XarchArg.release();
                        DAL.AddSynthesizedArg(A);
                        if (A.getOption().hasFlag(32L)) {
                            long e = A.getNumValues();
                            for (long i = 0L; i != e; ++i) {
                                DAL.AddSeparateArg(OriginalArg, Opts.getOption(new OptSpecifier((long)options.ID.OPT_Zlinker_input.getValue())), new StringRef(A.getValue(i)));
                            }
                            continue;
                        }
                    }
                    finally {
                        if (XarchArg == null) continue;
                        XarchArg.$destroy();
                        continue;
                    }
                }
                switch (options.ID.valueOf(A.getOption().getID())) {
                    default: {
                        DAL.append(A);
                        continue block19;
                    }
                    case OPT_mkernel: 
                    case OPT_fapple_kext: {
                        DAL.append(A);
                        DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier((long)options.ID.OPT_static.getValue())));
                        continue block19;
                    }
                    case OPT_dependency_file: {
                        DAL.AddSeparateArg(A, Opts.getOption(new OptSpecifier((long)options.ID.OPT_MF.getValue())), new StringRef(A.getValue()));
                        continue block19;
                    }
                    case OPT_gfull: {
                        DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier((long)options.ID.OPT_g_Flag.getValue())));
                        DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier((long)options.ID.OPT_fno_eliminate_unused_debug_symbols.getValue())));
                        continue block19;
                    }
                    case OPT_gused: {
                        DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier((long)options.ID.OPT_g_Flag.getValue())));
                        DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier((long)options.ID.OPT_feliminate_unused_debug_symbols.getValue())));
                        continue block19;
                    }
                    case OPT_shared: {
                        DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier((long)options.ID.OPT_dynamiclib.getValue())));
                        continue block19;
                    }
                    case OPT_fconstant_cfstrings: {
                        DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier((long)options.ID.OPT_mconstant_cfstrings.getValue())));
                        continue block19;
                    }
                    case OPT_fno_constant_cfstrings: {
                        DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier((long)options.ID.OPT_mno_constant_cfstrings.getValue())));
                        continue block19;
                    }
                    case OPT_Wnonportable_cfstrings: {
                        DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier((long)options.ID.OPT_mwarn_nonportable_cfstrings.getValue())));
                        continue block19;
                    }
                    case OPT_Wno_nonportable_cfstrings: {
                        DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier((long)options.ID.OPT_mno_warn_nonportable_cfstrings.getValue())));
                        continue block19;
                    }
                    case OPT_fpascal_strings: {
                        DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier((long)options.ID.OPT_mpascal_strings.getValue())));
                        continue block19;
                    }
                    case OPT_fno_pascal_strings: 
                }
                DAL.AddFlagArg(A, Opts.getOption(new OptSpecifier((long)options.ID.OPT_mno_pascal_strings.getValue())));
            }
            if (!(this.getTriple().getArch() != Triple.ArchType.x86 && this.getTriple().getArch() != Triple.ArchType.x86_64 || Args.hasArgNoClaim(new OptSpecifier((long)options.ID.OPT_mtune_EQ.getValue())))) {
                DAL.AddJoinedArg(null, Opts.getOption(new OptSpecifier((long)options.ID.OPT_mtune_EQ.getValue())), new StringRef(NativePointer.$((String)"core2")));
            }
            if (BoundArch != null) {
                StringRef Name = new StringRef(BoundArch);
                Option MCpu = Opts.getOption(new OptSpecifier((long)options.ID.OPT_mcpu_EQ.getValue()));
                Option MArch = Opts.getOption(new OptSpecifier((long)options.ID.OPT_march_EQ.getValue()));
                if (!llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"ppc")))) {
                    if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"ppc601")))) {
                        DAL.AddJoinedArg(null, new Option(MCpu), new StringRef(NativePointer.$((String)"601")));
                    } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"ppc603")))) {
                        DAL.AddJoinedArg(null, new Option(MCpu), new StringRef(NativePointer.$((String)"603")));
                    } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"ppc604")))) {
                        DAL.AddJoinedArg(null, new Option(MCpu), new StringRef(NativePointer.$((String)"604")));
                    } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"ppc604e")))) {
                        DAL.AddJoinedArg(null, new Option(MCpu), new StringRef(NativePointer.$((String)"604e")));
                    } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"ppc750")))) {
                        DAL.AddJoinedArg(null, new Option(MCpu), new StringRef(NativePointer.$((String)"750")));
                    } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"ppc7400")))) {
                        DAL.AddJoinedArg(null, new Option(MCpu), new StringRef(NativePointer.$((String)"7400")));
                    } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"ppc7450")))) {
                        DAL.AddJoinedArg(null, new Option(MCpu), new StringRef(NativePointer.$((String)"7450")));
                    } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"ppc970")))) {
                        DAL.AddJoinedArg(null, new Option(MCpu), new StringRef(NativePointer.$((String)"970")));
                    } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"ppc64"))) || llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"ppc64le")))) {
                        DAL.AddFlagArg(null, Opts.getOption(new OptSpecifier((long)options.ID.OPT_m64.getValue())));
                    } else if (!llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"i386")))) {
                        if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"i486")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"i486")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"i586")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"i586")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"i686")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"i686")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"pentium")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"pentium")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"pentium2")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"pentium2")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"pentpro")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"pentiumpro")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"pentIIm3")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"pentium2")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"x86_64")))) {
                            DAL.AddFlagArg(null, Opts.getOption(new OptSpecifier((long)options.ID.OPT_m64.getValue())));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"x86_64h")))) {
                            DAL.AddFlagArg(null, Opts.getOption(new OptSpecifier((long)options.ID.OPT_m64.getValue())));
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"x86_64h")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"arm")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"armv4t")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"armv4t")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"armv4t")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"armv5")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"armv5tej")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"xscale")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"xscale")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"armv6")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"armv6k")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"armv6m")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"armv6m")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"armv7")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"armv7a")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"armv7em")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"armv7em")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"armv7k")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"armv7k")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"armv7m")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"armv7m")));
                        } else if (llvm.$eq_StringRef((StringRef)new StringRef(Name), (StringRef)new StringRef(NativePointer.$((String)"armv7s")))) {
                            DAL.AddJoinedArg(null, new Option(MArch), new StringRef(NativePointer.$((String)"armv7s")));
                        }
                    }
                }
            }
            return DAL;
        }

        @Override
        public boolean IsBlocksDefault() {
            return true;
        }

        @Override
        public boolean IsIntegratedAssemblerDefault() {
            return true;
        }

        @Override
        public boolean IsMathErrnoDefault() {
            return false;
        }

        @Override
        public boolean IsEncodeExtendedBlockSignatureDefault() {
            return true;
        }

        @Override
        public boolean IsObjCNonFragileABIDefault() {
            return this.getTriple().getArch() != Triple.ArchType.x86;
        }

        @Override
        public boolean UseObjCMixedDispatch() {
            return true;
        }

        @Override
        public boolean IsUnwindTablesDefault() {
            return this.getArch() == Triple.ArchType.x86_64;
        }

        @Override
        public ToolChain.RuntimeLibType GetDefaultRuntimeLibType() {
            return ToolChain.RuntimeLibType.RLT_CompilerRT;
        }

        @Override
        public boolean isPICDefault() {
            return true;
        }

        @Override
        public boolean isPIEDefault() {
            return false;
        }

        @Override
        public boolean isPICDefaultForced() {
            return this.getArch() == Triple.ArchType.x86_64 || this.getArch() == Triple.ArchType.aarch64;
        }

        @Override
        public boolean SupportsProfiling() {
            return this.getArch() == Triple.ArchType.x86 || this.getArch() == Triple.ArchType.x86_64;
        }

        @Override
        public boolean SupportsObjCGC() {
            return false;
        }

        @Override
        public boolean UseDwarfDebugFlags() {
            char.ptr S = Native.$tryClone((char.ptr)std.getenv((char.ptr)NativePointer.$((String)"RC_DEBUG_OPTIONS")));
            if (S != null) {
                return S.$at(0) != NativePointer.$((char)'\u0000');
            }
            return false;
        }

        @Override
        public boolean UseSjLjExceptions() {
            return false;
        }

        public String toString() {
            return "Lipo=" + this.Lipo + ", Dsymutil=" + this.Dsymutil + ", VerifyDebug=" + this.VerifyDebug + super.toString();
        }
    }

    public static class Generic_GCC
    extends ToolChain
    implements Destructors.ClassWithDestructor {
        protected GCCInstallationDetector GCCInstallation = new GCCInstallationDetector();
        private std_ptr.unique_ptr<gcc.Preprocess> Preprocess = new std_ptr.unique_ptr();
        private std_ptr.unique_ptr<gcc.Compile> Compile = new std_ptr.unique_ptr();

        public Generic_GCC(Driver D, Triple Triple2, ArgList Args) {
            super(D, Triple2, Args);
            this.getProgramPaths().push_back((Object)new std.string(this.getDriver().getInstalledDir()));
            if (std.$noteq_T_str((char.iterator)this.getDriver().getInstalledDir(), (std.string)this.getDriver().Dir)) {
                this.getProgramPaths().push_back((Object)this.getDriver().Dir);
            }
        }

        @Override
        public void $destroy() {
            this.Compile.$destroy();
            this.Preprocess.$destroy();
            this.GCCInstallation.$destroy();
            super.$destroy();
        }

        @Override
        public void printVerboseInfo(raw_ostream OS) {
            this.GCCInstallation.print(OS);
        }

        @Override
        public boolean IsUnwindTablesDefault() {
            return this.getArch() == Triple.ArchType.x86_64;
        }

        @Override
        public boolean isPICDefault() {
            return false;
        }

        @Override
        public boolean isPIEDefault() {
            return false;
        }

        @Override
        public boolean isPICDefaultForced() {
            return false;
        }

        @Override
        public boolean IsIntegratedAssemblerDefault() {
            return this.getTriple().getArch() == Triple.ArchType.x86 || this.getTriple().getArch() == Triple.ArchType.x86_64 || this.getTriple().getArch() == Triple.ArchType.aarch64 || this.getTriple().getArch() == Triple.ArchType.aarch64_be || this.getTriple().getArch() == Triple.ArchType.arm || this.getTriple().getArch() == Triple.ArchType.armeb || this.getTriple().getArch() == Triple.ArchType.thumb || this.getTriple().getArch() == Triple.ArchType.thumbeb || this.getTriple().getArch() == Triple.ArchType.ppc || this.getTriple().getArch() == Triple.ArchType.ppc64 || this.getTriple().getArch() == Triple.ArchType.ppc64le || this.getTriple().getArch() == Triple.ArchType.sparc || this.getTriple().getArch() == Triple.ArchType.sparcv9 || this.getTriple().getArch() == Triple.ArchType.systemz;
        }

        @Override
        protected Tool getTool(Action.ActionClass AC) {
            switch (AC) {
                case PreprocessJobClass: {
                    if (!this.Preprocess.$boolean()) {
                        this.Preprocess.reset((Object)new gcc.Preprocess(this));
                    }
                    return (Tool)this.Preprocess.get();
                }
                case CompileJobClass: {
                    if (!this.Compile.$boolean()) {
                        this.Compile.reset((Object)new gcc.Compile(this));
                    }
                    return (Tool)this.Compile.get();
                }
            }
            return super.getTool(AC);
        }

        @Override
        protected Tool buildAssembler() {
            return new gnutools.Assemble(this);
        }

        @Override
        protected Tool buildLinker() {
            return new gcc.Link(this);
        }

        protected boolean isTarget64Bit() {
            return this.getTriple().isArch64Bit();
        }

        protected boolean isTarget32Bit() {
            return this.getTriple().isArch32Bit();
        }

        public String toString() {
            return "GCCInstallation=" + this.GCCInstallation + ", Preprocess=" + this.Preprocess + ", Compile=" + this.Compile + super.toString();
        }

        protected static class GCCInstallationDetector
        implements Destructors.ClassWithDestructor {
            private boolean IsValid = false;
            private Triple GCCTriple = new Triple();
            private std.string GCCInstallPath = new std.string();
            private std.string GCCParentLibPath = new std.string();
            private Multilib SelectedMultilib = new Multilib();
            private Optional<Multilib> BiarchSibling = new Optional();
            private GCCVersion Version = new GCCVersion();
            private std.set<std.string> CandidateGCCInstallPaths = new std.set();
            private MultilibSet Multilibs = new MultilibSet();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void init(Driver D, Triple TargetTriple, ArgList Args) {
                SmallVector CandidateLibDirs = null;
                SmallVector CandidateBiarchLibDirs = null;
                SmallVector CandidateTripleAliases = null;
                SmallVector CandidateBiarchTripleAliases = null;
                SmallVector Prefixes = null;
                try {
                    Triple BiarchVariantTriple = TargetTriple.isArch32Bit() ? TargetTriple.get64BitArchVariant() : TargetTriple.get32BitArchVariant();
                    CandidateLibDirs = new SmallVector(4, (Object)new StringRef());
                    CandidateBiarchLibDirs = new SmallVector(4, (Object)new StringRef());
                    CandidateTripleAliases = new SmallVector(16, (Object)new StringRef());
                    CandidateBiarchTripleAliases = new SmallVector(16, (Object)new StringRef());
                    GCCInstallationDetector.CollectLibDirsAndTriples(TargetTriple, BiarchVariantTriple, (SmallVectorImpl<StringRef>)CandidateLibDirs, (SmallVectorImpl<StringRef>)CandidateTripleAliases, (SmallVectorImpl<StringRef>)CandidateBiarchLibDirs, (SmallVectorImpl<StringRef>)CandidateBiarchTripleAliases);
                    Prefixes = new SmallVector(8, (type.iterator)D.PrefixDirs.begin(), (type.iterator)D.PrefixDirs.end(), (Object)new std.string());
                    StringRef GCCToolchainDir = ToolChainsStatics.getGCCToolchainDir(Args);
                    if (llvm.$noteq_StringRef((StringRef)new StringRef(GCCToolchainDir), (StringRef)StringRef.EMPTY)) {
                        if (GCCToolchainDir.back() == NativePointer.$((char)'/')) {
                            GCCToolchainDir.$assign$drop_back();
                        }
                        Prefixes.push_back((Object)GCCToolchainDir.$basic_string());
                    } else {
                        if (!D.SysRoot.empty()) {
                            Prefixes.push_back((Object)D.SysRoot);
                            Prefixes.push_back((Object)std.$plus_str_T((std.string)D.SysRoot, (char.iterator)NativePointer.$((String)"/usr")));
                        }
                        Prefixes.push_back((Object)std.$plus_str_T((std.string)D.InstalledDir, (char.iterator)NativePointer.$((String)"/..")));
                        if (D.SysRoot.empty()) {
                            Prefixes.push_back((Object)new std.string(NativePointer.$((String)"/usr")));
                        }
                    }
                    this.Version.$assign(GCCVersion.Parse(new StringRef(NativePointer.$((String)"0.0.0"))));
                    long ie = Prefixes.size();
                    for (long i = 0L; i < ie; ++i) {
                        long k;
                        long ke;
                        std.string LibDir;
                        long j;
                        if (!fs.exists((Twine)new Twine((std.string)Prefixes.$at(i)))) continue;
                        long je = CandidateLibDirs.size();
                        for (j = 0L; j < je; ++j) {
                            LibDir = std.$plus_str((std.string)((std.string)Prefixes.$at(i)), (std.string)((StringRef)CandidateLibDirs.$at(j)).str());
                            if (!fs.exists((Twine)new Twine(LibDir))) continue;
                            ke = CandidateTripleAliases.size();
                            for (k = 0L; k < ke; ++k) {
                                this.ScanLibDirForGCCTriple(TargetTriple, Args, LibDir, new StringRef((StringRef)CandidateTripleAliases.$at(k)));
                            }
                        }
                        je = CandidateBiarchLibDirs.size();
                        for (j = 0L; j < je; ++j) {
                            LibDir = std.$plus_str((std.string)((std.string)Prefixes.$at(i)), (std.string)((StringRef)CandidateBiarchLibDirs.$at(j)).str());
                            if (!fs.exists((Twine)new Twine(LibDir))) continue;
                            ke = CandidateBiarchTripleAliases.size();
                            for (k = 0L; k < ke; ++k) {
                                this.ScanLibDirForGCCTriple(TargetTriple, Args, LibDir, new StringRef((StringRef)CandidateBiarchTripleAliases.$at(k)), true);
                            }
                        }
                    }
                }
                finally {
                    if (Prefixes != null) {
                        Prefixes.$destroy();
                    }
                    if (CandidateBiarchTripleAliases != null) {
                        CandidateBiarchTripleAliases.$destroy();
                    }
                    if (CandidateTripleAliases != null) {
                        CandidateTripleAliases.$destroy();
                    }
                    if (CandidateBiarchLibDirs != null) {
                        CandidateBiarchLibDirs.$destroy();
                    }
                    if (CandidateLibDirs != null) {
                        CandidateLibDirs.$destroy();
                    }
                }
            }

            public boolean isValid() {
                return this.IsValid;
            }

            public Triple getTriple() {
                return this.GCCTriple;
            }

            public StringRef getInstallPath() {
                return new StringRef(this.GCCInstallPath);
            }

            public StringRef getParentLibPath() {
                return new StringRef(this.GCCParentLibPath);
            }

            public Multilib getMultilib() {
                return this.SelectedMultilib;
            }

            public MultilibSet getMultilibs() {
                return this.Multilibs;
            }

            public boolean getBiarchSibling(Multilib M) {
                if (this.BiarchSibling.hasValue()) {
                    M.$assign((Multilib)this.BiarchSibling.getValue());
                    return true;
                }
                return false;
            }

            public GCCVersion getVersion() {
                return this.Version;
            }

            public void print(raw_ostream OS) {
                for (std.string InstallPath : this.CandidateGCCInstallPaths) {
                    OS.$out(NativePointer.$((String)"Found candidate GCC installation: ")).$out(InstallPath).$out(NativePointer.$((String)"\n"));
                }
                if (!this.GCCInstallPath.empty()) {
                    OS.$out(NativePointer.$((String)"Selected GCC installation: ")).$out(this.GCCInstallPath).$out(NativePointer.$((String)"\n"));
                }
                for (Multilib Multilib2 : this.Multilibs) {
                    DriverGlobals.$out_raw_ostream_Multilib(OS.$out(NativePointer.$((String)"Candidate multilib: ")), Multilib2).$out(NativePointer.$((String)"\n"));
                }
                if (this.Multilibs.size() != 0L || !this.SelectedMultilib.isDefault()) {
                    DriverGlobals.$out_raw_ostream_Multilib(OS.$out(NativePointer.$((String)"Selected multilib: ")), this.SelectedMultilib).$out(NativePointer.$((String)"\n"));
                }
            }

            private static type.iterator<?, StringRef> begin(char.ptr[] strings) {
                return new convert_iterator((type.iterator)NativePointer.create_type$ptr((Object[])strings), (CollectionUtils.Converter)CharPtrToStringRefConverter.INSTANCE);
            }

            private static type.iterator<?, StringRef> end(char.ptr[] strings) {
                return new convert_iterator((type.iterator)NativePointer.create_type$ptr((Object[])strings, (long)strings.length), (CollectionUtils.Converter)CharPtrToStringRefConverter.INSTANCE);
            }

            private static void CollectLibDirsAndTriples(Triple TargetTriple, Triple BiarchTriple, SmallVectorImpl<StringRef> LibDirs, SmallVectorImpl<StringRef> TripleAliases, SmallVectorImpl<StringRef> BiarchLibDirs, SmallVectorImpl<StringRef> BiarchTripleAliases) {
                char.ptr[] AArch64LibDirs = new char.ptr[]{NativePointer.$((String)"/lib64"), NativePointer.$((String)"/lib")};
                char.ptr[] AArch64Triples = new char.ptr[]{NativePointer.$((String)"aarch64-none-linux-gnu"), NativePointer.$((String)"aarch64-linux-gnu"), NativePointer.$((String)"aarch64-linux-android"), NativePointer.$((String)"aarch64-redhat-linux")};
                char.ptr[] AArch64beLibDirs = new char.ptr[]{NativePointer.$((String)"/lib")};
                char.ptr[] AArch64beTriples = new char.ptr[]{NativePointer.$((String)"aarch64_be-none-linux-gnu"), NativePointer.$((String)"aarch64_be-linux-gnu")};
                char.ptr[] ARMLibDirs = new char.ptr[]{NativePointer.$((String)"/lib")};
                char.ptr[] ARMTriples = new char.ptr[]{NativePointer.$((String)"arm-linux-gnueabi"), NativePointer.$((String)"arm-linux-androideabi")};
                char.ptr[] ARMHFTriples = new char.ptr[]{NativePointer.$((String)"arm-linux-gnueabihf"), NativePointer.$((String)"armv7hl-redhat-linux-gnueabi")};
                char.ptr[] ARMebLibDirs = new char.ptr[]{NativePointer.$((String)"/lib")};
                char.ptr[] ARMebTriples = new char.ptr[]{NativePointer.$((String)"armeb-linux-gnueabi"), NativePointer.$((String)"armeb-linux-androideabi")};
                char.ptr[] ARMebHFTriples = new char.ptr[]{NativePointer.$((String)"armeb-linux-gnueabihf"), NativePointer.$((String)"armebv7hl-redhat-linux-gnueabi")};
                char.ptr[] X86_64LibDirs = new char.ptr[]{NativePointer.$((String)"/lib64"), NativePointer.$((String)"/lib")};
                char.ptr[] X86_64Triples = new char.ptr[]{NativePointer.$((String)"x86_64-linux-gnu"), NativePointer.$((String)"x86_64-unknown-linux-gnu"), NativePointer.$((String)"x86_64-pc-linux-gnu"), NativePointer.$((String)"x86_64-redhat-linux6E"), NativePointer.$((String)"x86_64-redhat-linux"), NativePointer.$((String)"x86_64-suse-linux"), NativePointer.$((String)"x86_64-manbo-linux-gnu"), NativePointer.$((String)"x86_64-linux-gnu"), NativePointer.$((String)"x86_64-slackware-linux"), NativePointer.$((String)"x86_64-linux-android"), NativePointer.$((String)"x86_64-unknown-linux")};
                char.ptr[] X32LibDirs = new char.ptr[]{NativePointer.$((String)"/libx32")};
                char.ptr[] X86LibDirs = new char.ptr[]{NativePointer.$((String)"/lib32"), NativePointer.$((String)"/lib")};
                char.ptr[] X86Triples = new char.ptr[]{NativePointer.$((String)"i686-linux-gnu"), NativePointer.$((String)"i686-pc-linux-gnu"), NativePointer.$((String)"i486-linux-gnu"), NativePointer.$((String)"i386-linux-gnu"), NativePointer.$((String)"i386-redhat-linux6E"), NativePointer.$((String)"i686-redhat-linux"), NativePointer.$((String)"i586-redhat-linux"), NativePointer.$((String)"i386-redhat-linux"), NativePointer.$((String)"i586-suse-linux"), NativePointer.$((String)"i486-slackware-linux"), NativePointer.$((String)"i686-montavista-linux"), NativePointer.$((String)"i686-linux-android"), NativePointer.$((String)"i586-linux-gnu")};
                char.ptr[] MIPSLibDirs = new char.ptr[]{NativePointer.$((String)"/lib")};
                char.ptr[] MIPSTriples = new char.ptr[]{NativePointer.$((String)"mips-linux-gnu"), NativePointer.$((String)"mips-mti-linux-gnu"), NativePointer.$((String)"mips-img-linux-gnu")};
                char.ptr[] MIPSELLibDirs = new char.ptr[]{NativePointer.$((String)"/lib")};
                char.ptr[] MIPSELTriples = new char.ptr[]{NativePointer.$((String)"mipsel-linux-gnu"), NativePointer.$((String)"mipsel-linux-android"), NativePointer.$((String)"mips-img-linux-gnu")};
                char.ptr[] MIPS64LibDirs = new char.ptr[]{NativePointer.$((String)"/lib64"), NativePointer.$((String)"/lib")};
                char.ptr[] MIPS64Triples = new char.ptr[]{NativePointer.$((String)"mips64-linux-gnu"), NativePointer.$((String)"mips-mti-linux-gnu"), NativePointer.$((String)"mips-img-linux-gnu"), NativePointer.$((String)"mips64-linux-gnuabi64")};
                char.ptr[] MIPS64ELLibDirs = new char.ptr[]{NativePointer.$((String)"/lib64"), NativePointer.$((String)"/lib")};
                char.ptr[] MIPS64ELTriples = new char.ptr[]{NativePointer.$((String)"mips64el-linux-gnu"), NativePointer.$((String)"mips-mti-linux-gnu"), NativePointer.$((String)"mips-img-linux-gnu"), NativePointer.$((String)"mips64el-linux-android"), NativePointer.$((String)"mips64el-linux-gnuabi64")};
                char.ptr[] PPCLibDirs = new char.ptr[]{NativePointer.$((String)"/lib32"), NativePointer.$((String)"/lib")};
                char.ptr[] PPCTriples = new char.ptr[]{NativePointer.$((String)"powerpc-linux-gnu"), NativePointer.$((String)"powerpc-unknown-linux-gnu"), NativePointer.$((String)"powerpc-linux-gnuspe"), NativePointer.$((String)"powerpc-suse-linux"), NativePointer.$((String)"powerpc-montavista-linuxspe")};
                char.ptr[] PPC64LibDirs = new char.ptr[]{NativePointer.$((String)"/lib64"), NativePointer.$((String)"/lib")};
                char.ptr[] PPC64Triples = new char.ptr[]{NativePointer.$((String)"powerpc64-linux-gnu"), NativePointer.$((String)"powerpc64-unknown-linux-gnu"), NativePointer.$((String)"powerpc64-suse-linux"), NativePointer.$((String)"ppc64-redhat-linux")};
                char.ptr[] PPC64LELibDirs = new char.ptr[]{NativePointer.$((String)"/lib64"), NativePointer.$((String)"/lib")};
                char.ptr[] PPC64LETriples = new char.ptr[]{NativePointer.$((String)"powerpc64le-linux-gnu"), NativePointer.$((String)"powerpc64le-unknown-linux-gnu"), NativePointer.$((String)"powerpc64le-suse-linux"), NativePointer.$((String)"ppc64le-redhat-linux")};
                char.ptr[] SPARCv8LibDirs = new char.ptr[]{NativePointer.$((String)"/lib32"), NativePointer.$((String)"/lib")};
                char.ptr[] SPARCv8Triples = new char.ptr[]{NativePointer.$((String)"sparc-linux-gnu"), NativePointer.$((String)"sparcv8-linux-gnu")};
                char.ptr[] SPARCv9LibDirs = new char.ptr[]{NativePointer.$((String)"/lib64"), NativePointer.$((String)"/lib")};
                char.ptr[] SPARCv9Triples = new char.ptr[]{NativePointer.$((String)"sparc64-linux-gnu"), NativePointer.$((String)"sparcv9-linux-gnu")};
                char.ptr[] SystemZLibDirs = new char.ptr[]{NativePointer.$((String)"/lib64"), NativePointer.$((String)"/lib")};
                char.ptr[] SystemZTriples = new char.ptr[]{NativePointer.$((String)"s390x-linux-gnu"), NativePointer.$((String)"s390x-unknown-linux-gnu"), NativePointer.$((String)"s390x-ibm-linux-gnu"), NativePointer.$((String)"s390x-suse-linux"), NativePointer.$((String)"s390x-redhat-linux")};
                switch (TargetTriple.getArch()) {
                    case aarch64: {
                        LibDirs.append(GCCInstallationDetector.begin(AArch64LibDirs), GCCInstallationDetector.end(AArch64LibDirs));
                        TripleAliases.append(GCCInstallationDetector.begin(AArch64Triples), GCCInstallationDetector.end(AArch64Triples));
                        BiarchLibDirs.append(GCCInstallationDetector.begin(AArch64LibDirs), GCCInstallationDetector.end(AArch64LibDirs));
                        BiarchTripleAliases.append(GCCInstallationDetector.begin(AArch64Triples), GCCInstallationDetector.end(AArch64Triples));
                        break;
                    }
                    case aarch64_be: {
                        LibDirs.append(GCCInstallationDetector.begin(AArch64beLibDirs), GCCInstallationDetector.end(AArch64beLibDirs));
                        TripleAliases.append(GCCInstallationDetector.begin(AArch64beTriples), GCCInstallationDetector.end(AArch64beTriples));
                        BiarchLibDirs.append(GCCInstallationDetector.begin(AArch64beLibDirs), GCCInstallationDetector.end(AArch64beLibDirs));
                        BiarchTripleAliases.append(GCCInstallationDetector.begin(AArch64beTriples), GCCInstallationDetector.end(AArch64beTriples));
                        break;
                    }
                    case arm: 
                    case thumb: {
                        LibDirs.append(GCCInstallationDetector.begin(ARMLibDirs), GCCInstallationDetector.end(ARMLibDirs));
                        if (TargetTriple.getEnvironment() == Triple.EnvironmentType.GNUEABIHF) {
                            TripleAliases.append(GCCInstallationDetector.begin(ARMHFTriples), GCCInstallationDetector.end(ARMHFTriples));
                            break;
                        }
                        TripleAliases.append(GCCInstallationDetector.begin(ARMTriples), GCCInstallationDetector.end(ARMTriples));
                        break;
                    }
                    case armeb: 
                    case thumbeb: {
                        LibDirs.append(GCCInstallationDetector.begin(ARMebLibDirs), GCCInstallationDetector.end(ARMebLibDirs));
                        if (TargetTriple.getEnvironment() == Triple.EnvironmentType.GNUEABIHF) {
                            TripleAliases.append(GCCInstallationDetector.begin(ARMebHFTriples), GCCInstallationDetector.end(ARMebHFTriples));
                            break;
                        }
                        TripleAliases.append(GCCInstallationDetector.begin(ARMebTriples), GCCInstallationDetector.end(ARMebTriples));
                        break;
                    }
                    case x86_64: {
                        LibDirs.append(GCCInstallationDetector.begin(X86_64LibDirs), GCCInstallationDetector.end(X86_64LibDirs));
                        TripleAliases.append(GCCInstallationDetector.begin(X86_64Triples), GCCInstallationDetector.end(X86_64Triples));
                        if (TargetTriple.getEnvironment() == Triple.EnvironmentType.GNUX32) {
                            BiarchLibDirs.append(GCCInstallationDetector.begin(X32LibDirs), GCCInstallationDetector.end(X32LibDirs));
                            BiarchTripleAliases.append(GCCInstallationDetector.begin(X86_64Triples), GCCInstallationDetector.end(X86_64Triples));
                            break;
                        }
                        BiarchLibDirs.append(GCCInstallationDetector.begin(X86LibDirs), GCCInstallationDetector.end(X86LibDirs));
                        BiarchTripleAliases.append(GCCInstallationDetector.begin(X86Triples), GCCInstallationDetector.end(X86Triples));
                        break;
                    }
                    case x86: {
                        LibDirs.append(GCCInstallationDetector.begin(X86LibDirs), GCCInstallationDetector.end(X86LibDirs));
                        TripleAliases.append(GCCInstallationDetector.begin(X86Triples), GCCInstallationDetector.end(X86Triples));
                        BiarchLibDirs.append(GCCInstallationDetector.begin(X86_64LibDirs), GCCInstallationDetector.end(X86_64LibDirs));
                        BiarchTripleAliases.append(GCCInstallationDetector.begin(X86_64Triples), GCCInstallationDetector.end(X86_64Triples));
                        break;
                    }
                    case mips: {
                        LibDirs.append(GCCInstallationDetector.begin(MIPSLibDirs), GCCInstallationDetector.end(MIPSLibDirs));
                        TripleAliases.append(GCCInstallationDetector.begin(MIPSTriples), GCCInstallationDetector.end(MIPSTriples));
                        BiarchLibDirs.append(GCCInstallationDetector.begin(MIPS64LibDirs), GCCInstallationDetector.end(MIPS64LibDirs));
                        BiarchTripleAliases.append(GCCInstallationDetector.begin(MIPS64Triples), GCCInstallationDetector.end(MIPS64Triples));
                        break;
                    }
                    case mipsel: {
                        LibDirs.append(GCCInstallationDetector.begin(MIPSELLibDirs), GCCInstallationDetector.end(MIPSELLibDirs));
                        TripleAliases.append(GCCInstallationDetector.begin(MIPSELTriples), GCCInstallationDetector.end(MIPSELTriples));
                        TripleAliases.append(GCCInstallationDetector.begin(MIPSTriples), GCCInstallationDetector.end(MIPSTriples));
                        BiarchLibDirs.append(GCCInstallationDetector.begin(MIPS64ELLibDirs), GCCInstallationDetector.end(MIPS64ELLibDirs));
                        BiarchTripleAliases.append(GCCInstallationDetector.begin(MIPS64ELTriples), GCCInstallationDetector.end(MIPS64ELTriples));
                        break;
                    }
                    case mips64: {
                        LibDirs.append(GCCInstallationDetector.begin(MIPS64LibDirs), GCCInstallationDetector.end(MIPS64LibDirs));
                        TripleAliases.append(GCCInstallationDetector.begin(MIPS64Triples), GCCInstallationDetector.end(MIPS64Triples));
                        BiarchLibDirs.append(GCCInstallationDetector.begin(MIPSLibDirs), GCCInstallationDetector.end(MIPSLibDirs));
                        BiarchTripleAliases.append(GCCInstallationDetector.begin(MIPSTriples), GCCInstallationDetector.end(MIPSTriples));
                        break;
                    }
                    case mips64el: {
                        LibDirs.append(GCCInstallationDetector.begin(MIPS64ELLibDirs), GCCInstallationDetector.end(MIPS64ELLibDirs));
                        TripleAliases.append(GCCInstallationDetector.begin(MIPS64ELTriples), GCCInstallationDetector.end(MIPS64ELTriples));
                        BiarchLibDirs.append(GCCInstallationDetector.begin(MIPSELLibDirs), GCCInstallationDetector.end(MIPSELLibDirs));
                        BiarchTripleAliases.append(GCCInstallationDetector.begin(MIPSELTriples), GCCInstallationDetector.end(MIPSELTriples));
                        BiarchTripleAliases.append(GCCInstallationDetector.begin(MIPSTriples), GCCInstallationDetector.end(MIPSTriples));
                        break;
                    }
                    case ppc: {
                        LibDirs.append(GCCInstallationDetector.begin(PPCLibDirs), GCCInstallationDetector.end(PPCLibDirs));
                        TripleAliases.append(GCCInstallationDetector.begin(PPCTriples), GCCInstallationDetector.end(PPCTriples));
                        BiarchLibDirs.append(GCCInstallationDetector.begin(PPC64LibDirs), GCCInstallationDetector.end(PPC64LibDirs));
                        BiarchTripleAliases.append(GCCInstallationDetector.begin(PPC64Triples), GCCInstallationDetector.end(PPC64Triples));
                        break;
                    }
                    case ppc64: {
                        LibDirs.append(GCCInstallationDetector.begin(PPC64LibDirs), GCCInstallationDetector.end(PPC64LibDirs));
                        TripleAliases.append(GCCInstallationDetector.begin(PPC64Triples), GCCInstallationDetector.end(PPC64Triples));
                        BiarchLibDirs.append(GCCInstallationDetector.begin(PPCLibDirs), GCCInstallationDetector.end(PPCLibDirs));
                        BiarchTripleAliases.append(GCCInstallationDetector.begin(PPCTriples), GCCInstallationDetector.end(PPCTriples));
                        break;
                    }
                    case ppc64le: {
                        LibDirs.append(GCCInstallationDetector.begin(PPC64LELibDirs), GCCInstallationDetector.end(PPC64LELibDirs));
                        TripleAliases.append(GCCInstallationDetector.begin(PPC64LETriples), GCCInstallationDetector.end(PPC64LETriples));
                        break;
                    }
                    case sparc: {
                        LibDirs.append(GCCInstallationDetector.begin(SPARCv8LibDirs), GCCInstallationDetector.end(SPARCv8LibDirs));
                        TripleAliases.append(GCCInstallationDetector.begin(SPARCv8Triples), GCCInstallationDetector.end(SPARCv8Triples));
                        BiarchLibDirs.append(GCCInstallationDetector.begin(SPARCv9LibDirs), GCCInstallationDetector.end(SPARCv9LibDirs));
                        BiarchTripleAliases.append(GCCInstallationDetector.begin(SPARCv9Triples), GCCInstallationDetector.end(SPARCv9Triples));
                        break;
                    }
                    case sparcv9: {
                        LibDirs.append(GCCInstallationDetector.begin(SPARCv9LibDirs), GCCInstallationDetector.end(SPARCv9LibDirs));
                        TripleAliases.append(GCCInstallationDetector.begin(SPARCv9Triples), GCCInstallationDetector.end(SPARCv9Triples));
                        BiarchLibDirs.append(GCCInstallationDetector.begin(SPARCv8LibDirs), GCCInstallationDetector.end(SPARCv8LibDirs));
                        BiarchTripleAliases.append(GCCInstallationDetector.begin(SPARCv8Triples), GCCInstallationDetector.end(SPARCv8Triples));
                        break;
                    }
                    case systemz: {
                        LibDirs.append(GCCInstallationDetector.begin(SystemZLibDirs), GCCInstallationDetector.end(SystemZLibDirs));
                        TripleAliases.append(GCCInstallationDetector.begin(SystemZTriples), GCCInstallationDetector.end(SystemZTriples));
                        break;
                    }
                }
                TripleAliases.push_back((Object)new StringRef(TargetTriple.str()));
                if (std.$noteq_str((std.string)TargetTriple.str(), (std.string)BiarchTriple.str())) {
                    BiarchTripleAliases.push_back((Object)new StringRef(BiarchTriple.str()));
                }
            }

            private void ScanLibDirForGCCTriple(Triple TargetTriple, ArgList Args, std.string LibDir, StringRef CandidateTriple) {
                this.ScanLibDirForGCCTriple(TargetTriple, Args, LibDir, CandidateTriple, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void ScanLibDirForGCCTriple(Triple TargetTriple, ArgList Args, std.string LibDir, StringRef CandidateTriple, boolean NeedsBiarchSuffix) {
                Triple.ArchType TargetArch = TargetTriple.getArch();
                Object[] LibSuffixes = new std.string[]{std.$plus_T_str((Object)NativePointer.$((String)"/gcc/"), (std.string)CandidateTriple.str()), std.$plus_T_str((Object)NativePointer.$((String)"/gcc-cross/"), (std.string)CandidateTriple.str()), std.$plus_str((std.string)std.$plus_str_T((std.string)std.$plus_T_str((Object)NativePointer.$((String)"/"), (std.string)CandidateTriple.str()), (char.iterator)NativePointer.$((String)"/gcc/")), (std.string)CandidateTriple.str()), std.$plus_T_str((Object)NativePointer.$((String)"/"), (std.string)CandidateTriple.str()), std.$plus_T_str((Object)NativePointer.$((String)"/i386-linux-gnu/gcc/"), (std.string)CandidateTriple.str())};
                std.string[] InstallSuffixes = new std.string[]{new std.string((CharSequence)"/../../.."), new std.string((CharSequence)"/../../.."), new std.string((CharSequence)"/../../../.."), new std.string((CharSequence)"/../.."), new std.string((CharSequence)"/../../../..")};
                long NumLibSuffixes = llvm.array_lengthof((Object[])LibSuffixes) - (TargetArch != Triple.ArchType.x86 ? 1 : 0);
                for (long i = 0L; i < NumLibSuffixes; ++i) {
                    StringRef LibSuffix = new StringRef((std.string)LibSuffixes[(int)i]);
                    std_errors.error_code EC = new std_errors.error_code();
                    fs.directory_iterator LI = null;
                    fs.directory_iterator LE = null;
                    try {
                        LI = new fs.directory_iterator(llvm.$plus_Twine((Twine)new Twine(LibDir), (Twine)new Twine(LibSuffix)), EC);
                        LE = new fs.directory_iterator();
                        while (!EC.$boolean() && LI.$noteq(LE)) {
                            DetectedMultilibs Detected = null;
                            try {
                                StringRef VersionText = path.filename((StringRef)new StringRef(LI.$arrow().path()));
                                GCCVersion CandidateVersion = GCCVersion.Parse(new StringRef(VersionText));
                                if (!(CandidateVersion.Major != -1 && !this.CandidateGCCInstallPaths.insert((Object)LI.$arrow().path()).second || CandidateVersion.isOlderThan(4, 1, 1) || CandidateVersion.$lesseq(this.Version))) {
                                    Detected = new DetectedMultilibs();
                                    if (!(ToolChainsStatics.isMipsArch(TargetArch) ? !ToolChainsStatics.findMIPSMultilibs(TargetTriple, new StringRef(LI.$arrow().path()), Args, Detected) : !ToolChainsStatics.findBiarchMultilibs(TargetTriple, new StringRef(LI.$arrow().path()), Args, NeedsBiarchSuffix, Detected))) {
                                        this.Multilibs.$assign(Detected.Multilibs);
                                        this.SelectedMultilib.$assign(Detected.SelectedMultilib);
                                        this.BiarchSibling.$assign(Detected.BiarchSibling);
                                        this.Version.$assign(CandidateVersion);
                                        this.GCCTriple.setTriple(new Twine(CandidateTriple));
                                        this.GCCInstallPath.$assign(std.$plus_str((std.string)std.$plus_str_T((std.string)std.$plus_str((std.string)LibDir, (std.string)LibSuffixes[(int)i]), (char.iterator)NativePointer.$((String)"/")), (std.string)VersionText.str()));
                                        this.GCCParentLibPath.$assign(std.$plus_str((std.string)this.GCCInstallPath, (std.string)InstallSuffixes[(int)i]));
                                        this.IsValid = true;
                                    }
                                }
                            }
                            finally {
                                if (Detected != null) {
                                    Detected.$destroy();
                                }
                            }
                            LI.$assign(LI.increment(EC));
                        }
                        continue;
                    }
                    finally {
                        if (LE != null) {
                            LE.$destroy();
                        }
                        if (LI != null) {
                            LI.$destroy();
                        }
                    }
                }
            }

            public void $destroy() {
                this.Multilibs.$destroy();
                this.CandidateGCCInstallPaths.$destroy();
                this.Version.$destroy();
                this.BiarchSibling.$destroy();
                this.SelectedMultilib.$destroy();
                this.GCCParentLibPath.$destroy();
                this.GCCInstallPath.$destroy();
                this.GCCTriple.$destroy();
            }

            public String toString() {
                return "IsValid=" + this.IsValid + ", GCCTriple=" + this.GCCTriple + ", GCCInstallPath=" + this.GCCInstallPath + ", GCCParentLibPath=" + this.GCCParentLibPath + ", SelectedMultilib=" + this.SelectedMultilib + ", BiarchSibling=" + this.BiarchSibling + ", Version=" + this.Version + ", CandidateGCCInstallPaths=" + this.CandidateGCCInstallPaths + ", Multilibs=" + this.Multilibs;
            }

            private static final class CharPtrToStringRefConverter
            implements CollectionUtils.Converter<char.ptr, StringRef> {
                static final CharPtrToStringRefConverter INSTANCE = new CharPtrToStringRefConverter();

                private CharPtrToStringRefConverter() {
                }

                public Class<StringRef> getToClass() {
                    return StringRef.class;
                }

                public StringRef convert(char.ptr from) {
                    return new StringRef(from);
                }
            }
        }

        protected static class GCCVersion
        implements Destructors.ClassWithDestructor {
            public std.string Text;
            public int Major;
            public int Minor;
            public int Patch;
            public final int.ref MajorRef = new int.ref(){

                public int $deref() {
                    return GCCVersion.this.Major;
                }

                public int $set(int value) {
                    GCCVersion.this.Major = value;
                    return GCCVersion.this.Major;
                }

                public int.ptr deref$ptr() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
            public final int.ref MinorRef = new int.ref(){

                public int $deref() {
                    return GCCVersion.this.Minor;
                }

                public int $set(int value) {
                    GCCVersion.this.Minor = value;
                    return GCCVersion.this.Minor;
                }

                public int.ptr deref$ptr() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
            public final int.ref PatchRef = new int.ref(){

                public int $deref() {
                    return GCCVersion.this.Patch;
                }

                public int $set(int value) {
                    GCCVersion.this.Patch = value;
                    return GCCVersion.this.Patch;
                }

                public int.ptr deref$ptr() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
            };
            public std.string MajorStr;
            public std.string MinorStr;
            public std.string PatchSuffix;

            public GCCVersion(std.string Text, int Major, int Minor, int Patch, CharSequence MajorStr, CharSequence MinorStr, CharSequence PatchSuffix) {
                this.Text = Text;
                this.Major = Major;
                this.Minor = Minor;
                this.Patch = Patch;
                this.MajorStr = new std.string(MajorStr);
                this.MinorStr = new std.string(MinorStr);
                this.PatchSuffix = new std.string(PatchSuffix);
            }

            public GCCVersion(std.string Text, int Major, int Minor, int Patch, char.ptr MajorStr, char.ptr MinorStr, char.ptr PatchSuffix) {
                this.Text = Text;
                this.Major = Major;
                this.Minor = Minor;
                this.Patch = Patch;
                this.MajorStr = new std.string(MajorStr);
                this.MinorStr = new std.string(MinorStr);
                this.PatchSuffix = new std.string(PatchSuffix);
            }

            public static GCCVersion Parse(StringRef VersionText) {
                int EndNumber;
                GCCVersion BadVersion = new GCCVersion(VersionText.str(), -1, -1, -1, NativePointer.$((String)""), NativePointer.$((String)""), NativePointer.$((String)""));
                std.pair First = VersionText.split(NativePointer.$((char)'.'));
                std.pair Second = ((StringRef)First.second).split(NativePointer.$((char)'.'));
                GCCVersion GoodVersion = new GCCVersion(VersionText.str(), -1, -1, -1, NativePointer.$((String)""), NativePointer.$((String)""), NativePointer.$((String)""));
                if (((StringRef)First.first).getAsInteger(10, GoodVersion.MajorRef) || GoodVersion.Major < 0) {
                    return BadVersion;
                }
                GoodVersion.MajorStr.$assign(((StringRef)First.first).str());
                if (((StringRef)Second.first).getAsInteger(10, GoodVersion.MinorRef) || GoodVersion.Minor < 0) {
                    return BadVersion;
                }
                GoodVersion.MinorStr.$assign(((StringRef)Second.first).str());
                StringRef PatchText = new StringRef(GoodVersion.PatchSuffix.$assign(((StringRef)Second.second).str()));
                if (!PatchText.empty() && (EndNumber = PatchText.find_first_not_of(new StringRef(NativePointer.$((String)"0123456789")))) != 0) {
                    if (PatchText.slice(0, EndNumber).getAsInteger(10, GoodVersion.PatchRef) || GoodVersion.Patch < 0) {
                        return BadVersion;
                    }
                    GoodVersion.PatchSuffix.$assign(PatchText.substr(EndNumber).$basic_string());
                }
                return GoodVersion;
            }

            public boolean isOlderThan(int RHSMajor, int RHSMinor, int RHSPatch) {
                return this.isOlderThan(RHSMajor, RHSMinor, RHSPatch, new StringRef());
            }

            public boolean isOlderThan(int RHSMajor, int RHSMinor, int RHSPatch, StringRef RHSPatchSuffix) {
                if (this.Major != RHSMajor) {
                    return this.Major < RHSMajor;
                }
                if (this.Minor != RHSMinor) {
                    return this.Minor < RHSMinor;
                }
                if (this.Patch != RHSPatch) {
                    if (RHSPatch == -1) {
                        return true;
                    }
                    if (this.Patch == -1) {
                        return false;
                    }
                    return this.Patch < RHSPatch;
                }
                if (llvm.$noteq_StringRef((StringRef)new StringRef(this.PatchSuffix), (StringRef)new StringRef(RHSPatchSuffix))) {
                    if (RHSPatchSuffix.empty()) {
                        return true;
                    }
                    if (this.PatchSuffix.empty()) {
                        return false;
                    }
                    return llvm.$less_StringRef((StringRef)new StringRef(this.PatchSuffix), (StringRef)new StringRef(RHSPatchSuffix));
                }
                return false;
            }

            public boolean $less(GCCVersion RHS) {
                return this.isOlderThan(RHS.Major, RHS.Minor, RHS.Patch, new StringRef(RHS.PatchSuffix));
            }

            public boolean $greater(GCCVersion RHS) {
                return RHS.$less(this);
            }

            public boolean $lesseq(GCCVersion RHS) {
                return !this.$greater(RHS);
            }

            public boolean $greatereq(GCCVersion RHS) {
                return !this.$less(RHS);
            }

            public GCCVersion(GCCVersion $Prm0) {
                this.Text = new std.string($Prm0.Text);
                this.Major = $Prm0.Major;
                this.Minor = $Prm0.Minor;
                this.Patch = $Prm0.Patch;
                this.MajorStr = new std.string($Prm0.MajorStr);
                this.MinorStr = new std.string($Prm0.MinorStr);
                this.PatchSuffix = new std.string($Prm0.PatchSuffix);
            }

            public GCCVersion $assign(GCCVersion $Prm0) {
                this.Text.$assign($Prm0.Text);
                this.Major = $Prm0.Major;
                this.Minor = $Prm0.Minor;
                this.Patch = $Prm0.Patch;
                this.MajorStr.$assign($Prm0.MajorStr);
                this.MinorStr.$assign($Prm0.MinorStr);
                this.PatchSuffix.$assign($Prm0.PatchSuffix);
                return this;
            }

            public void $destroy() {
                this.PatchSuffix.$destroy();
                this.MinorStr.$destroy();
                this.MajorStr.$destroy();
                this.Text.$destroy();
            }

            public GCCVersion() {
                this.Text = new std.string();
                this.MajorStr = new std.string();
                this.MinorStr = new std.string();
                this.PatchSuffix = new std.string();
            }

            public String toString() {
                return "Text=" + this.Text + ", Major=" + this.Major + ", Minor=" + this.Minor + ", Patch=" + this.Patch + ", MajorStr=" + this.MajorStr + ", MinorStr=" + this.MinorStr + ", PatchSuffix=" + this.PatchSuffix;
            }
        }
    }
}

