/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.options;
import org.clang.driver.tools.impl.GnuTool;
import org.clang.driver.tools.impl.arm;
import org.clang.driver.tools.impl.mips;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;

public final class netbsd {

    public static class Link
    extends GnuTool {
        public Link(ToolChain TC) {
            super(NativePointer.$((String)"netbsd::Link"), NativePointer.$((String)"linker"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isLinkJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            ArgStringList CmdArgs = null;
            try {
                Driver D = this.getToolChain().getDriver();
                CmdArgs = new ArgStringList();
                if (!D.SysRoot.empty()) {
                    CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"--sysroot="), (std.string)D.SysRoot)));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"--eh-frame-hdr"));
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
                } else {
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_rdynamic.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bshareable"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-dynamic-linker"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"/libexec/ld.elf_so"));
                    }
                }
                block1 : switch (this.getToolChain().getArch()) {
                    case x86: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"elf_i386"));
                        break;
                    }
                    case arm: 
                    case thumb: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        switch (this.getToolChain().getTriple().getEnvironment()) {
                            case EABI: 
                            case GNUEABI: {
                                CmdArgs.push_back((Object)NativePointer.$((String)"armelf_nbsd_eabi"));
                                break block1;
                            }
                            case EABIHF: 
                            case GNUEABIHF: {
                                CmdArgs.push_back((Object)NativePointer.$((String)"armelf_nbsd_eabihf"));
                                break block1;
                            }
                        }
                        CmdArgs.push_back((Object)NativePointer.$((String)"armelf_nbsd"));
                        break;
                    }
                    case armeb: 
                    case thumbeb: {
                        arm.appendEBLinkFlags(Args, CmdArgs, this.getToolChain().getTriple());
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        switch (this.getToolChain().getTriple().getEnvironment()) {
                            case EABI: 
                            case GNUEABI: {
                                CmdArgs.push_back((Object)NativePointer.$((String)"armelfb_nbsd_eabi"));
                                break block1;
                            }
                            case EABIHF: 
                            case GNUEABIHF: {
                                CmdArgs.push_back((Object)NativePointer.$((String)"armelfb_nbsd_eabihf"));
                                break block1;
                            }
                        }
                        CmdArgs.push_back((Object)NativePointer.$((String)"armelfb_nbsd"));
                        break;
                    }
                    case mips64: 
                    case mips64el: {
                        if (mips.hasMipsAbiArg(Args, NativePointer.$((String)"32"))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                            if (this.getToolChain().getArch() == Triple.ArchType.mips64) {
                                CmdArgs.push_back((Object)NativePointer.$((String)"elf32btsmip"));
                                break;
                            }
                            CmdArgs.push_back((Object)NativePointer.$((String)"elf32ltsmip"));
                            break;
                        }
                        if (!mips.hasMipsAbiArg(Args, NativePointer.$((String)"64"))) break;
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        if (this.getToolChain().getArch() == Triple.ArchType.mips64) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"elf64btsmip"));
                            break;
                        }
                        CmdArgs.push_back((Object)NativePointer.$((String)"elf64ltsmip"));
                        break;
                    }
                    case ppc: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"elf32ppc_nbsd"));
                        break;
                    }
                    case ppc64: 
                    case ppc64le: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"elf64ppc"));
                        break;
                    }
                    case sparc: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"elf32_sparc"));
                        break;
                    }
                    case sparcv9: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"elf64_sparc"));
                        break;
                    }
                }
                if (Output.isFilename()) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                    CmdArgs.push_back((Object)Output.getFilename());
                } else assert (Output.isNothing()) : "Invalid output.";
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostartfiles.getValue()))) {
                    if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().GetFilePath(NativePointer.$((String)"crt0.o"))));
                        CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().GetFilePath(NativePointer.$((String)"crti.o"))));
                        CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().GetFilePath(NativePointer.$((String)"crtbegin.o"))));
                    } else {
                        CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().GetFilePath(NativePointer.$((String)"crti.o"))));
                        CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().GetFilePath(NativePointer.$((String)"crtbeginS.o"))));
                    }
                }
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_L.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_T_Group.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_e.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_s.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_t.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Z_Flag.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_r.getValue()));
                ToolsStatics.AddLinkerInputs(this.getToolChain(), Inputs, Args, CmdArgs);
                uint.ref MajorRef = NativePointer.create_uint$ref();
                uint.ref MinorRef = NativePointer.create_uint$ref();
                uint.ref MicroRef = NativePointer.create_uint$ref();
                this.getToolChain().getTriple().getOSVersion(MajorRef, MinorRef, MicroRef);
                long Major = MajorRef.$deref();
                long Minor = MinorRef.$deref();
                long Micro = MicroRef.$deref();
                boolean useLibgcc = true;
                if (Major >= 7L || Major == 6L && Minor == 99L && Micro >= 49L || Major == 0L) {
                    switch (this.getToolChain().getArch()) {
                        case x86: 
                        case arm: 
                        case armeb: 
                        case thumb: 
                        case thumbeb: 
                        case ppc: 
                        case ppc64: 
                        case ppc64le: 
                        case aarch64: 
                        case x86_64: {
                            useLibgcc = false;
                            break;
                        }
                    }
                }
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nodefaultlibs.getValue()))) {
                    if (D.CCCIsCXX()) {
                        this.getToolChain().AddCXXStdlibLibArgs(Args, CmdArgs);
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lm"));
                    }
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pthread.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                    if (useLibgcc) {
                        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_eh"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"--as-needed"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc_s"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"--no-as-needed"));
                        }
                    }
                }
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostartfiles.getValue()))) {
                    if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().GetFilePath(NativePointer.$((String)"crtend.o"))));
                    } else {
                        CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().GetFilePath(NativePointer.$((String)"crtendS.o"))));
                    }
                    CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().GetFilePath(NativePointer.$((String)"crtn.o"))));
                }
                ToolsStatics.addProfileRT(this.getToolChain(), Args, CmdArgs);
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(this.getToolChain().GetLinkerPath()));
                C.addCommand((std_ptr.unique_ptr<Command>)llvm.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
            }
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Assemble
    extends GnuTool {
        public Assemble(ToolChain TC) {
            super(NativePointer.$((String)"netbsd::Assemble"), NativePointer.$((String)"assembler"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            ArgStringList CmdArgs = null;
            try {
                ToolsStatics.claimNoWarnArgs(Args);
                CmdArgs = new ArgStringList();
                switch (this.getToolChain().getArch()) {
                    case x86: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--32"));
                        break;
                    }
                    case arm: 
                    case armeb: 
                    case thumb: 
                    case thumbeb: {
                        std.string MArch = null;
                        try {
                            MArch = arm.getARMTargetCPU(Args, this.getToolChain().getTriple()).$basic_string();
                            CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_T_str((Object)NativePointer.$((String)"-mcpu="), (std.string)MArch)));
                            if (MArch == null) break;
                        }
                        catch (Throwable throwable) {
                            if (MArch != null) {
                                MArch.$destroy();
                            }
                            throw throwable;
                        }
                        MArch.$destroy();
                        break;
                    }
                    case mips: 
                    case mipsel: 
                    case mips64: 
                    case mips64el: {
                        StringRef CPUName = new StringRef();
                        StringRef ABIName = new StringRef();
                        mips.getMipsCPUAndABI(Args, this.getToolChain().getTriple(), CPUName, ABIName);
                        CmdArgs.push_back((Object)NativePointer.$((String)"-march"));
                        CmdArgs.push_back((Object)CPUName.data());
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mabi"));
                        CmdArgs.push_back((Object)ToolsStatics.getGnuCompatibleMipsABIName(new StringRef(ABIName)).data());
                        if (this.getToolChain().getArch() == Triple.ArchType.mips || this.getToolChain().getArch() == Triple.ArchType.mips64) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-EB"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-EL"));
                        }
                        ToolsStatics.addAssemblerKPIC(Args, CmdArgs);
                        break;
                    }
                    case sparc: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-32"));
                        ToolsStatics.addAssemblerKPIC(Args, CmdArgs);
                        break;
                    }
                    case sparcv9: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-64"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Av9"));
                        ToolsStatics.addAssemblerKPIC(Args, CmdArgs);
                        break;
                    }
                }
                Args.AddAllArgValues((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier((long)options.ID.OPT_Xassembler.getValue()));
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                for (InputInfo II : Inputs) {
                    CmdArgs.push_back((Object)II.getFilename());
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(this.getToolChain().GetProgramPath(NativePointer.$((String)"as"))));
                C.addCommand((std_ptr.unique_ptr<Command>)llvm.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
            }
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

