/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.options;
import org.clang.driver.tools.impl.GnuTool;
import org.clang.driver.tools.impl.mips;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;

public final class openbsd {

    public static class Link
    extends GnuTool {
        public Link(ToolChain TC) {
            super(NativePointer.$((String)"openbsd::Link"), NativePointer.$((String)"linker"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isLinkJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            ArgStringList CmdArgs = null;
            try {
                std.string Triple2;
                Driver D = this.getToolChain().getDriver();
                CmdArgs = new ArgStringList();
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_g_Group.getValue()));
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_emit_llvm.getValue()));
                Args.ClaimAllArgs(new OptSpecifier((long)options.ID.OPT_w.getValue()));
                if (this.getToolChain().getArch() == Triple.ArchType.mips64) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-EB"));
                } else if (this.getToolChain().getArch() == Triple.ArchType.mips64el) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-EL"));
                }
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-e"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"__start"));
                }
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_static.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
                } else {
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_rdynamic.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"--eh-frame-hdr"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Bdynamic"));
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-shared"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-dynamic-linker"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"/usr/libexec/ld.so"));
                    }
                }
                if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_nopie.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-nopie"));
                }
                if (Output.isFilename()) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                    CmdArgs.push_back((Object)Output.getFilename());
                } else assert (Output.isNothing()) : "Invalid output.";
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostartfiles.getValue()))) {
                    if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pg.getValue()))) {
                            CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().GetFilePath(NativePointer.$((String)"gcrt0.o"))));
                        } else {
                            CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().GetFilePath(NativePointer.$((String)"crt0.o"))));
                        }
                        CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().GetFilePath(NativePointer.$((String)"crtbegin.o"))));
                    } else {
                        CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().GetFilePath(NativePointer.$((String)"crtbeginS.o"))));
                    }
                }
                if (std.$eq_str_T((std.string)(Triple2 = this.getToolChain().getTripleString()).substr(0, 6), (char.iterator)NativePointer.$((String)"x86_64"))) {
                    Triple2.replace(0, 6, NativePointer.$((String)"amd64"));
                }
                CmdArgs.push_back((Object)Args.MakeArgString(std.$plus_str_T((std.string)std.$plus_T_str((Object)NativePointer.$((String)"-L/usr/lib/gcc-lib/"), (std.string)Triple2), (char.iterator)NativePointer.$((String)"/4.2.1"))));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_L.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_T_Group.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_e.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_s.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_t.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Z_Flag.getValue()));
                Args.AddAllArgs((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_r.getValue()));
                ToolsStatics.AddLinkerInputs(this.getToolChain(), Inputs, Args, CmdArgs);
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nodefaultlibs.getValue()))) {
                    if (D.CCCIsCXX()) {
                        this.getToolChain().AddCXXStdlibLibArgs(Args, CmdArgs);
                        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pg.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lm_p"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lm"));
                        }
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                    if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pthread.getValue()))) {
                        if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue())) && Args.hasArg(new OptSpecifier((long)options.ID.OPT_pg.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread_p"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
                        }
                    }
                    if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                        if (Args.hasArg(new OptSpecifier((long)options.ID.OPT_pg.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lc_p"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                        }
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgcc"));
                }
                if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier((long)options.ID.OPT_nostartfiles.getValue()))) {
                    if (!Args.hasArg(new OptSpecifier((long)options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().GetFilePath(NativePointer.$((String)"crtend.o"))));
                    } else {
                        CmdArgs.push_back((Object)Args.MakeArgString(this.getToolChain().GetFilePath(NativePointer.$((String)"crtendS.o"))));
                    }
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(this.getToolChain().GetLinkerPath()));
                C.addCommand((std_ptr.unique_ptr<Command>)llvm.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
            }
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Assemble
    extends GnuTool {
        public Assemble(ToolChain TC) {
            super(NativePointer.$((String)"openbsd::Assemble"), NativePointer.$((String)"assembler"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            ArgStringList CmdArgs = null;
            try {
                ToolsStatics.claimNoWarnArgs(Args);
                CmdArgs = new ArgStringList();
                boolean NeedsKPIC = false;
                switch (this.getToolChain().getArch()) {
                    case x86: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--32"));
                        break;
                    }
                    case ppc: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mppc"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-many"));
                        break;
                    }
                    case sparc: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-32"));
                        NeedsKPIC = true;
                        break;
                    }
                    case sparcv9: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-64"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Av9a"));
                        NeedsKPIC = true;
                        break;
                    }
                    case mips64: 
                    case mips64el: {
                        StringRef CPUName = new StringRef();
                        StringRef ABIName = new StringRef();
                        mips.getMipsCPUAndABI(Args, this.getToolChain().getTriple(), CPUName, ABIName);
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mabi"));
                        CmdArgs.push_back((Object)ToolsStatics.getGnuCompatibleMipsABIName(new StringRef(ABIName)).data());
                        if (this.getToolChain().getArch() == Triple.ArchType.mips64) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-EB"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-EL"));
                        }
                        NeedsKPIC = true;
                        break;
                    }
                }
                if (NeedsKPIC) {
                    ToolsStatics.addAssemblerKPIC(Args, CmdArgs);
                }
                Args.AddAllArgValues((SmallVector)CmdArgs, new OptSpecifier((long)options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier((long)options.ID.OPT_Xassembler.getValue()));
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                for (InputInfo II : Inputs) {
                    CmdArgs.push_back((Object)II.getFilename());
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(this.getToolChain().GetProgramPath(NativePointer.$((String)"as"))));
                C.addCommand((std_ptr.unique_ptr<Command>)llvm.make_unique((Object)new Command(JA, this, Exec, CmdArgs)));
            }
            finally {
                if (CmdArgs != null) {
                    CmdArgs.$destroy();
                }
            }
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

