/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.api.executable.InvalidPhpExecutableException;
import org.netbeans.modules.php.api.executable.PhpInterpreter;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.Bundle;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.api.PhpLanguageProperties;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.netbeans.modules.php.project.ui.BrowseTestSources;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.web.browser.api.BrowserUISupport;
import org.netbeans.modules.web.browser.api.WebBrowser;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public final class ProjectPropertiesSupport {
    private ProjectPropertiesSupport() {
    }

    public static String relativizeFile(File dir, File file) {
        String relativePath = PropertyUtils.relativizeFile((File)dir, (File)file);
        if (relativePath == null) {
            relativePath = file.getAbsolutePath();
        }
        return relativePath;
    }

    public static PropertyEvaluator getPropertyEvaluator(PhpProject project) {
        return project.getEvaluator();
    }

    public static void addWeakPropertyEvaluatorListener(PhpProject project, PropertyChangeListener listener) {
        project.addWeakPropertyEvaluatorListener(listener);
    }

    public static void addWeakIgnoredFilesListener(PhpProject project, ChangeListener listener) {
        project.addWeakIgnoredFilesListener(listener);
    }

    public static boolean addWeakProjectPropertyChangeListener(PhpProject project, PropertyChangeListener listener) {
        return project.addWeakPropertyChangeListener(listener);
    }

    public static void addProjectPropertyChangeListener(PhpProject project, PropertyChangeListener listener) {
        project.addPropertyChangeListener(listener);
    }

    public static void removeProjectPropertyChangeListener(PhpProject project, PropertyChangeListener listener) {
        project.removePropertyChangeListener(listener);
    }

    public static FileObject getProjectDirectory(PhpProject project) {
        return project.getProjectDirectory();
    }

    @CheckForNull
    public static FileObject getSourcesDirectory(PhpProject project) {
        return project.getSourcesDirectory();
    }

    public static List<FileObject> getTestDirectories(final PhpProject project, boolean showFileChooser) {
        List<FileObject> testDirs = ProjectPropertiesSupport.filterValid(project.getTestsDirectories());
        if (!testDirs.isEmpty()) {
            return testDirs;
        }
        if (!showFileChooser) {
            return Collections.emptyList();
        }
        BrowseTestSources panel = (BrowseTestSources)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<BrowseTestSources>(){

            public BrowseTestSources run() {
                return new BrowseTestSources(project, Bundle.ProjectPropertiesSupport_browse_tests(), Bundle.ProjectPropertiesSupport_browse_tests_info());
            }
        });
        if (!panel.open()) {
            return Collections.emptyList();
        }
        File tests = new File(panel.getTestSources());
        assert (tests.isDirectory());
        FileObject testsDirectory = FileUtil.toFileObject((File)tests);
        ProjectPropertiesSupport.saveTestSources(project, "test.src.dir", tests);
        return Collections.singletonList(testsDirectory);
    }

    @CheckForNull
    public static FileObject getTestDirectory(PhpProject project, FileObject file, boolean showFileChooser) {
        List<FileObject> testDirectories = ProjectPropertiesSupport.getTestDirectories(project, showFileChooser);
        if (testDirectories.isEmpty()) {
            return null;
        }
        FileObject testsDirectory = ProjectPropertiesSupport.findClosestDir(testDirectories, file);
        assert (testsDirectory != null && testsDirectory.isValid()) : testsDirectory;
        return testsDirectory;
    }

    public static List<FileObject> getSeleniumDirectories(final PhpProject project, boolean showFileChooser) {
        List<FileObject> testDirs = ProjectPropertiesSupport.filterValid(project.getSeleniumDirectories());
        if (!testDirs.isEmpty()) {
            return testDirs;
        }
        if (!showFileChooser) {
            return Collections.emptyList();
        }
        BrowseTestSources panel = (BrowseTestSources)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<BrowseTestSources>(){

            public BrowseTestSources run() {
                return new BrowseTestSources(project, Bundle.ProjectPropertiesSupport_browse_selenium_test(), Bundle.ProjectPropertiesSupport_browse_tests_info());
            }
        });
        if (!panel.open()) {
            return Collections.emptyList();
        }
        File tests = new File(panel.getTestSources());
        assert (tests.isDirectory());
        FileObject testsDirectory = FileUtil.toFileObject((File)tests);
        ProjectPropertiesSupport.saveTestSources(project, "selenium.src.dir", tests);
        return Collections.singletonList(testsDirectory);
    }

    public static FileObject getSeleniumDirectory(final PhpProject project, boolean showFileChooser) {
        BrowseTestSources panel;
        FileObject seleniumDirectory = project.getSeleniumDirectory();
        if (seleniumDirectory != null && seleniumDirectory.isValid()) {
            return seleniumDirectory;
        }
        if (showFileChooser && (panel = (BrowseTestSources)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<BrowseTestSources>(){

            public BrowseTestSources run() {
                return new BrowseTestSources(project, NbBundle.getMessage(ProjectPropertiesSupport.class, (String)"LBL_BrowseSelenium"));
            }
        })).open()) {
            File selenium = new File(panel.getTestSources());
            assert (selenium.isDirectory());
            seleniumDirectory = FileUtil.toFileObject((File)selenium);
            ProjectPropertiesSupport.saveTestSources(project, "selenium.src.dir", selenium);
        }
        return seleniumDirectory;
    }

    @CheckForNull
    public static WebBrowser getWebBrowser(PhpProject project) {
        String browserId = project.getEvaluator().getProperty("browser.id");
        if (browserId == null) {
            return null;
        }
        return BrowserUISupport.getBrowser((String)browserId);
    }

    public static boolean getBrowserReloadOnSave(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "browser.reload.on.save", true);
    }

    public static String getWebRoot(PhpProject project) {
        return project.getEvaluator().getProperty("web.root");
    }

    public static FileObject getWebRootDirectory(PhpProject project) {
        return project.getWebRootDirectory();
    }

    public static File getSourceSubdirectory(PhpProject project, String subdirectoryPath) {
        return ProjectPropertiesSupport.getSubdirectory(project, project.getSourcesDirectory(), subdirectoryPath);
    }

    public static File getSubdirectory(PhpProject project, FileObject rootDirectory, String subdirectoryPath) {
        File rootDir = FileUtil.toFile((FileObject)rootDirectory);
        if (!StringUtils.hasText((String)subdirectoryPath)) {
            return rootDir;
        }
        FileObject fo = rootDirectory.getFileObject(subdirectoryPath);
        if (fo != null) {
            return FileUtil.toFile((FileObject)fo);
        }
        return PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)rootDirectory), (String)subdirectoryPath);
    }

    public static PhpInterpreter getValidPhpInterpreter(PhpProject project) throws InvalidPhpExecutableException {
        String interpreter = project.getEvaluator().getProperty("interpreter");
        if (StringUtils.hasText((String)interpreter)) {
            return PhpInterpreter.getCustom((String)interpreter);
        }
        return PhpInterpreter.getDefault();
    }

    public static String getPhpInterpreter(PhpProject project) {
        String interpreter = project.getEvaluator().getProperty("interpreter");
        if (StringUtils.hasText((String)interpreter)) {
            return interpreter;
        }
        return PhpOptions.getInstance().getPhpInterpreter();
    }

    public static boolean isCopySourcesEnabled(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "copy.src.files", false);
    }

    public static boolean isCopySourcesOnOpen(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "copy.src.on.open", false);
    }

    public static File getCopySourcesTarget(PhpProject project) {
        String targetString = project.getEvaluator().getProperty("copy.src.target");
        if (targetString != null && targetString.trim().length() > 0) {
            return FileUtil.normalizeFile((File)new File(targetString));
        }
        return null;
    }

    public static String getEncoding(PhpProject project) {
        return project.getEvaluator().getProperty("source.encoding");
    }

    public static boolean areShortTagsEnabled(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "tags.short", false);
    }

    public static boolean areAspTagsEnabled(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "tags.asp", PhpLanguageProperties.ASP_TAGS_ENABLED);
    }

    public static PhpVersion getPhpVersion(PhpProject project) {
        return ProjectPropertiesSupport.getPhpVersion(project.getEvaluator().getProperty("php.version"));
    }

    public static PhpVersion getPhpVersion(String value) {
        if (value != null) {
            try {
                return PhpVersion.valueOf((String)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return PhpVersion.getDefault();
    }

    public static PhpProjectProperties.RunAsType getRunAs(PhpProject project) {
        PhpProjectProperties.RunAsType runAsType = null;
        String runAs = project.getEvaluator().getProperty("run.as");
        if (runAs != null) {
            try {
                runAsType = PhpProjectProperties.RunAsType.valueOf(runAs);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return runAsType != null ? runAsType : PhpProjectProperties.RunAsType.LOCAL;
    }

    public static String getUrl(PhpProject project) {
        return project.getEvaluator().getProperty("url");
    }

    public static String getIndexFile(PhpProject project) {
        return project.getEvaluator().getProperty("index.file");
    }

    public static String getArguments(PhpProject project) {
        return project.getEvaluator().getProperty("script.arguments");
    }

    public static String getPhpArguments(PhpProject project) {
        return project.getEvaluator().getProperty("php.arguments");
    }

    public static String getWorkDir(PhpProject project) {
        return project.getEvaluator().getProperty("work.dir");
    }

    public static String getRemoteConnection(PhpProject project) {
        return project.getEvaluator().getProperty("remote.connection");
    }

    public static String getRemoteDirectory(PhpProject project) {
        return project.getEvaluator().getProperty("remote.directory");
    }

    public static boolean areRemotePermissionsPreserved(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "remote.permissions", false);
    }

    public static boolean isRemoteUploadDirectly(PhpProject project) {
        return ProjectPropertiesSupport.getBoolean(project, "remote.upload.directly", false);
    }

    public static PhpProjectProperties.UploadFiles getRemoteUpload(PhpProject project) {
        PhpProjectProperties.UploadFiles uploadFiles = null;
        String remoteUpload = project.getEvaluator().getProperty("remote.upload");
        assert (remoteUpload != null);
        try {
            uploadFiles = PhpProjectProperties.UploadFiles.valueOf(remoteUpload);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uploadFiles;
    }

    public static PhpProjectProperties.DebugUrl getDebugUrl(PhpProject project) {
        String debugUrl = project.getEvaluator().getProperty("debug.url");
        if (debugUrl == null) {
            return PhpProjectProperties.DebugUrl.DEFAULT_URL;
        }
        return PhpProjectProperties.DebugUrl.valueOf(debugUrl);
    }

    public static List<Pair<String, String>> getDebugPathMapping(PhpProject project) {
        List remotes = StringUtils.explode((String)ProjectPropertiesSupport.getString(project, "debug.path.mapping.remote", null), (String)"||NB||");
        List locals = StringUtils.explode((String)ProjectPropertiesSupport.getString(project, "debug.path.mapping.local", null), (String)"||NB||");
        int remotesSize = remotes.size();
        int localsSize = locals.size();
        ArrayList<Pair<String, String>> paths = new ArrayList<Pair<String, String>>(remotesSize);
        for (int i = 0; i < remotesSize; ++i) {
            String remotePath = (String)remotes.get(i);
            if (!StringUtils.hasText((String)remotePath)) continue;
            String l = "";
            if (i < localsSize) {
                l = (String)locals.get(i);
            }
            String localPath = null;
            File local = new File(l);
            if (local.isAbsolute()) {
                if (local.isDirectory()) {
                    localPath = local.getAbsolutePath();
                }
            } else {
                File subDir = ProjectPropertiesSupport.getSourceSubdirectory(project, l);
                if (subDir.exists()) {
                    localPath = subDir.getAbsolutePath();
                }
            }
            if (localPath == null) continue;
            paths.add((Pair<String, String>)Pair.of((Object)remotePath, (Object)localPath));
        }
        Pair<String, String> copySupportPair = ProjectPropertiesSupport.getCopySupportPair(project);
        if (copySupportPair != null) {
            paths.add(copySupportPair);
        }
        return paths;
    }

    public static Pair<String, Integer> getDebugProxy(PhpProject project) {
        String host = ProjectPropertiesSupport.getString(project, "debug.proxy.host", null);
        if (!StringUtils.hasText((String)host)) {
            return null;
        }
        return Pair.of((Object)host, (Object)ProjectPropertiesSupport.getInt(project, "debug.proxy.port", 9001));
    }

    public static String getHostname(PhpProject project) {
        return ProjectPropertiesSupport.getString(project, "hostname", null);
    }

    public static String getPort(PhpProject project) {
        return ProjectPropertiesSupport.getString(project, "port", null);
    }

    public static String getInternalRouter(PhpProject project) {
        return ProjectPropertiesSupport.getString(project, "router", null);
    }

    private static Pair<String, String> getCopySupportPair(PhpProject project) {
        File copySource;
        FileObject copySourceFo;
        File copyTarget;
        Pair copySupportPair = null;
        if (ProjectPropertiesSupport.isCopySourcesEnabled(project) && (copyTarget = ProjectPropertiesSupport.getCopySourcesTarget(project)) != null && copyTarget.exists() && (copySourceFo = ProjectPropertiesSupport.getSourcesDirectory(project)) != null && (copySource = FileUtil.toFile((FileObject)copySourceFo)) != null && copySource.exists()) {
            copySupportPair = Pair.of((Object)copyTarget.getAbsolutePath(), (Object)copySource.getAbsolutePath());
        }
        return copySupportPair;
    }

    private static boolean getBoolean(PhpProject project, String property, boolean defaultValue) {
        String boolValue = project.getEvaluator().getProperty(property);
        if (StringUtils.hasText((String)boolValue)) {
            return Boolean.parseBoolean(boolValue);
        }
        return defaultValue;
    }

    private static String getString(PhpProject project, String property, String defaultValue) {
        String stringValue = project.getEvaluator().getProperty(property);
        if (stringValue == null) {
            return defaultValue;
        }
        return stringValue;
    }

    private static int getInt(PhpProject project, String property, int defaultValue) {
        String stringValue = project.getEvaluator().getProperty(property);
        if (stringValue != null) {
            try {
                return Integer.valueOf(stringValue);
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    private static void saveTestSources(final PhpProject project, final String propertyName, final File testDir) {
        BaseProgressUtils.showProgressDialogAndRun((Runnable)new Runnable(){

            @Override
            public void run() {
                File projectDirectory = FileUtil.toFile((FileObject)project.getProjectDirectory());
                String testPath = PropertyUtils.relativizeFile((File)projectDirectory, (File)testDir);
                if (testPath == null) {
                    testPath = testDir.getAbsolutePath();
                }
                PhpProjectProperties.save(project, Collections.singletonMap(propertyName, testPath), Collections.emptyMap());
            }
        }, (String)Bundle.ProjectPropertiesSupport_project_metadata_saving());
    }

    private static List<FileObject> filterValid(FileObject[] files) {
        ArrayList<FileObject> validFiles = new ArrayList<FileObject>(files.length);
        for (FileObject file : files) {
            if (!file.isValid()) continue;
            validFiles.add(file);
        }
        return validFiles;
    }

    static FileObject findClosestDir(List<FileObject> directories, FileObject fo) {
        assert (!directories.isEmpty());
        if (fo == null) {
            return directories.get(0);
        }
        File file = FileUtil.toFile((FileObject)fo);
        int idx = 0;
        String bestRelPath = null;
        for (int i = 0; i < directories.size(); ++i) {
            int bestRelPathLength;
            File dir = FileUtil.toFile((FileObject)directories.get(i));
            String relPath = PropertyUtils.relativizeFile((File)dir, (File)file);
            if (relPath == null) continue;
            if (bestRelPath == null) {
                bestRelPath = relPath;
                idx = i;
                continue;
            }
            assert (bestRelPath != null);
            if (".".equals(relPath)) {
                idx = i;
                break;
            }
            if (!relPath.startsWith("../") && bestRelPath.startsWith("../")) {
                bestRelPath = relPath;
                idx = i;
                continue;
            }
            int relPathLength = relPath.length() - relPath.replace("../", "").length();
            if (relPathLength < (bestRelPathLength = bestRelPath.length() - bestRelPath.replace("../", "").length())) {
                bestRelPath = relPath;
                idx = i;
                continue;
            }
            if (relPathLength != bestRelPathLength || relPath.length() >= bestRelPath.length()) continue;
            bestRelPath = relPath;
            idx = i;
        }
        return directories.get(idx);
    }
}

