/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.testing.PhpTesting;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.customizer.PhpProjectProperties;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;

public final class TestingProviders
implements PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(TestingProviders.class.getName());
    private final PhpProject project;
    private final List<PhpTestingProvider> testingProviders = new CopyOnWriteArrayList<PhpTestingProvider>();
    private volatile boolean providersDirty = true;

    private TestingProviders(PhpProject project) {
        this.project = project;
    }

    public static TestingProviders create(PhpProject project) {
        TestingProviders providers = new TestingProviders(project);
        ProjectPropertiesSupport.addWeakPropertyEvaluatorListener(project, providers);
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PhpTestingProvider> getTestingProviders() {
        List<PhpTestingProvider> list = this.testingProviders;
        synchronized (list) {
            if (this.providersDirty) {
                this.providersDirty = false;
                HashSet<String> storedTestingProviders = new HashSet<String>(new PhpProjectProperties(this.project).getTestingProviders());
                ArrayList<PhpTestingProvider> projectProviders = new ArrayList<PhpTestingProvider>(storedTestingProviders.size());
                for (PhpTestingProvider provider : PhpTesting.getTestingProviders()) {
                    if (!storedTestingProviders.contains(provider.getIdentifier())) continue;
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Adding testing provider %s for project %s", provider.getIdentifier(), this.project.getName()));
                    }
                    projectProviders.add(provider);
                }
                this.testingProviders.clear();
                this.testingProviders.addAll(projectProviders);
            }
        }
        return new ArrayList<PhpTestingProvider>(this.testingProviders);
    }

    void resetTestingProviders() {
        this.providersDirty = true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName == null || "testing.providers".equals(propertyName)) {
            this.resetTestingProviders();
        }
    }
}

