/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.testrunner;

import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.php.project.ui.testrunner.TestCaseImpl;
import org.netbeans.modules.php.project.ui.testrunner.TestSessionImpl;
import org.netbeans.modules.php.spi.testing.run.TestCase;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public class TestSuiteImpl
implements org.netbeans.modules.php.spi.testing.run.TestSuite {
    private final TestSessionImpl testSession;
    private final TestSuite testSuite;
    private final FileObject location;
    private volatile boolean finished = false;

    TestSuiteImpl(TestSessionImpl testSession, TestSuite testSuite, FileObject location) {
        assert (testSession != null);
        assert (testSuite != null);
        this.testSession = testSession;
        this.testSuite = testSuite;
        this.location = location;
    }

    public TestCase addTestCase(String name, String type) {
        this.checkFrozen();
        this.checkFinished();
        Parameters.notWhitespace((CharSequence)"name", (CharSequence)name);
        Parameters.notWhitespace((CharSequence)"type", (CharSequence)type);
        TestSession session = this.testSession.getTestSession();
        Testcase testCase = new Testcase(name, type, session);
        if (this.location != null) {
            testCase.setLocation(FileUtil.toFile((FileObject)this.location).getAbsolutePath());
        }
        session.addTestCase(testCase);
        return new TestCaseImpl(this, testCase);
    }

    public void finish(long time) {
        this.checkFrozen();
        this.checkFinished();
        this.finished = true;
        TestSession session = this.testSession.getTestSession();
        this.testSession.getManager().displayReport(session, session.getReport(time));
    }

    public TestSessionImpl getTestSession() {
        return this.testSession;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    public FileObject getLocation() {
        return this.location;
    }

    void checkFrozen() {
        this.testSession.checkFrozen();
    }

    private void checkFinished() {
        if (this.finished) {
            throw new IllegalStateException("Test suite " + this.testSuite.getName() + " is already finished");
        }
    }
}

