/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.wizards;

import java.awt.Component;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.php.project.connections.RemoteClient;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.common.RemoteUtils;
import org.netbeans.modules.php.project.connections.spi.RemoteConfiguration;
import org.netbeans.modules.php.project.connections.transfer.TransferFile;
import org.netbeans.modules.php.project.connections.ui.transfer.TransferFilesChooser;
import org.netbeans.modules.php.project.ui.actions.RemoteCommand;
import org.netbeans.modules.php.project.ui.wizards.CancelablePanel;
import org.netbeans.modules.php.project.ui.wizards.NewPhpProjectWizardIterator;
import org.netbeans.modules.php.project.ui.wizards.RemoteConfirmationPanelVisual;
import org.openide.WizardDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public class RemoteConfirmationPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
WizardDescriptor.FinishablePanel<WizardDescriptor>,
CancelablePanel,
ChangeListener {
    static final String REMOTE_FILES = "remoteFiles";
    static final String REMOTE_CLIENT = "remoteClient";
    private static final RequestProcessor RP = new RequestProcessor("Fetching remote files", 2);
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final String[] steps;
    private RemoteConfirmationPanelVisual confirmationPanel = null;
    private WizardDescriptor descriptor = null;
    private volatile boolean canceled;
    private volatile RemoteClient remoteClient;

    public RemoteConfirmationPanel(String[] steps) {
        this.steps = (String[])steps.clone();
    }

    String[] getSteps() {
        return this.steps;
    }

    public Component getComponent() {
        if (this.confirmationPanel == null) {
            this.confirmationPanel = new RemoteConfirmationPanelVisual(this, this.descriptor);
            this.confirmationPanel.addRemoteConfirmationListener(this);
        }
        return this.confirmationPanel;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public void readSettings(WizardDescriptor settings) {
        this.descriptor = settings;
        this.getComponent();
        this.canceled = false;
        this.fetchRemoteFiles();
    }

    public void storeSettings(WizardDescriptor settings) {
        this.descriptor = settings;
        this.getComponent();
        if (this.remoteClient != null) {
            settings.putProperty(REMOTE_CLIENT, (Object)this.remoteClient);
        }
        this.cancel();
        settings.putProperty(REMOTE_FILES, this.confirmationPanel.getRemoteFiles());
    }

    public boolean isValid() {
        switch (this.confirmationPanel.getState()) {
            case FETCHING: {
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
                this.descriptor.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(RemoteConfirmationPanel.class, (String)"LBL_FetchingRemoteFiles"));
                return false;
            }
            case NO_FILES: {
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(RemoteConfirmationPanel.class, (String)"MSG_NoFilesAvailable"));
                return false;
            }
            case FILES: {
                if (!this.confirmationPanel.getRemoteFiles().isEmpty()) break;
                this.descriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(RemoteConfirmationPanel.class, (String)"MSG_NoFilesSelected"));
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + (Object)((Object)this.confirmationPanel.getState()));
            }
        }
        this.descriptor.putProperty("WizardPanel_errorMessage", (Object)" ");
        return true;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public boolean isFinishPanel() {
        return true;
    }

    @Override
    public void cancel() {
        this.canceled = true;
        if (this.remoteClient != null) {
            this.remoteClient.cancel();
            this.disconnectRemoteClient();
        }
    }

    void fetchRemoteFiles() {
        this.getComponent();
        this.confirmationPanel.setFetchingFiles();
        RP.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(RemoteConfirmationPanel.class, (String)"LBL_FetchingRemoteFilesProgress"));
                try {
                    handle.start();
                    Set remoteFiles = Collections.emptySet();
                    String reason = "";
                    try {
                        remoteFiles = RemoteConfirmationPanel.this.getRemoteFiles();
                    }
                    catch (RemoteException ex) {
                        Logger.getLogger(RemoteConfirmationPanel.class.getName()).log(Level.INFO, "Cannot fetch files", ex);
                        reason = ex.getMessage();
                    }
                    final boolean hasAnyTransferableFiles = TransferFilesChooser.forDownload(remoteFiles).hasAnyTransferableFiles();
                    final Set rmt = Collections.synchronizedSet(remoteFiles);
                    final String rsn = reason;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (RemoteConfirmationPanel.this.canceled) {
                                return;
                            }
                            if (hasAnyTransferableFiles) {
                                RemoteConfirmationPanel.this.confirmationPanel.setRemoteFiles(rmt);
                            } else {
                                RemoteConfirmationPanel.this.confirmationPanel.setNoFiles(rsn);
                            }
                            RemoteConfirmationPanel.this.changeSupport.fireChange();
                        }
                    });
                }
                finally {
                    handle.finish();
                }
            }
        });
    }

    private Set<TransferFile> getRemoteFiles() throws RemoteException {
        assert (this.descriptor != null);
        File sources = NewPhpProjectWizardIterator.getSources(this.descriptor);
        RemoteConfiguration remoteConfiguration = (RemoteConfiguration)this.descriptor.getProperty("remoteConnection");
        InputOutput remoteLog = RemoteCommand.getRemoteLog(remoteConfiguration.getDisplayName());
        String remoteDirectory = (String)this.descriptor.getProperty("remoteDirectory");
        this.disconnectRemoteClient();
        this.remoteClient = new RemoteClient(remoteConfiguration, new RemoteClient.AdvancedProperties().setInputOutput(remoteLog).setAdditionalInitialSubdirectory(remoteDirectory).setPreservePermissions(false));
        return this.remoteClient.prepareDownload(sources, sources);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.changeSupport.fireChange();
    }

    private void disconnectRemoteClient() {
        if (this.remoteClient != null) {
            final RemoteClient remoteClientCopy = this.remoteClient;
            this.remoteClient = null;
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        remoteClientCopy.disconnect(true);
                    }
                    catch (RemoteException ex) {
                        RemoteUtils.processRemoteException(ex);
                    }
                }
            });
        }
    }
}

