/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.execute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.dataview.api.DataView;
import org.netbeans.modules.db.sql.execute.SQLExecutionLogger;
import org.netbeans.modules.db.sql.execute.SQLExecutionResult;
import org.netbeans.modules.db.sql.execute.SQLExecutionResults;
import org.netbeans.modules.db.sql.execute.StatementInfo;
import org.netbeans.modules.db.sql.history.SQLHistoryEntry;
import org.netbeans.modules.db.sql.history.SQLHistoryManager;

public final class SQLExecuteHelper {
    private static final Logger LOGGER = Logger.getLogger(SQLExecuteHelper.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);

    public static SQLExecutionResults execute(String sqlScript, int startOffset, int endOffset, DatabaseConnection conn, SQLExecutionLogger executionLogger) {
        return SQLExecuteHelper.execute(sqlScript, startOffset, endOffset, conn, executionLogger, 20);
    }

    public static SQLExecutionResults execute(String sqlScript, int startOffset, int endOffset, DatabaseConnection conn, SQLExecutionLogger executionLogger, int pageSize) {
        boolean cancelled = false;
        List<StatementInfo> statements = SQLExecuteHelper.getStatements(sqlScript, startOffset, endOffset, conn.getDriverClass().contains("mysql"));
        ArrayList<SQLExecutionResult> results = new ArrayList<SQLExecutionResult>();
        long totalExecutionTime = 0L;
        String url = conn.getDatabaseURL();
        for (StatementInfo info : statements) {
            cancelled = Thread.currentThread().isInterrupted();
            if (cancelled) break;
            String sql = info.getSQL();
            if (LOG) {
                LOGGER.log(Level.FINE, "Executing: " + sql);
            }
            DataView view = DataView.create((DatabaseConnection)conn, (String)sql, (int)pageSize);
            SQLHistoryManager.getInstance().saveSQL(new SQLHistoryEntry(url, sql, new Date()));
            SQLExecutionResult result = new SQLExecutionResult(info, view);
            boolean isIllegal = false;
            for (Throwable th : view.getExceptions()) {
                if (!(th instanceof IllegalStateException)) continue;
                LOGGER.log(Level.INFO, th.getLocalizedMessage(), th);
                isIllegal = true;
                break;
            }
            if (isIllegal) break;
            executionLogger.log(result);
            totalExecutionTime += result.getExecutionTime();
            results.add(result);
        }
        if (!cancelled) {
            executionLogger.finish(totalExecutionTime);
        } else {
            if (LOG) {
                LOGGER.log(Level.FINE, "Execution cancelled");
            }
            executionLogger.cancel();
        }
        SQLHistoryManager.getInstance().save();
        if (!cancelled) {
            return new SQLExecutionResults(results);
        }
        return null;
    }

    private static List<StatementInfo> getStatements(String script, int startOffset, int endOffset, boolean useHashComments) {
        if (startOffset == 0 && endOffset == script.length() || startOffset == endOffset) {
            List<StatementInfo> allStatements = SQLExecuteHelper.split(script, useHashComments);
            if (startOffset == 0 && endOffset == script.length()) {
                return allStatements;
            }
            StatementInfo foundStatement = SQLExecuteHelper.findStatementAtOffset(allStatements, startOffset, script);
            return foundStatement == null ? Collections.emptyList() : Collections.singletonList(foundStatement);
        }
        return SQLExecuteHelper.split(script.substring(startOffset, endOffset), useHashComments);
    }

    static StatementInfo findStatementAtOffset(List<StatementInfo> statements, int offset, String script) {
        StatementInfo prev = null;
        for (StatementInfo stmt : statements) {
            if (offset <= stmt.getRawEndOffset()) {
                if (offset >= stmt.getStartOffset()) {
                    return stmt;
                }
                if (offset >= stmt.getRawStartOffset()) {
                    if (prev == null) {
                        return stmt;
                    }
                    String between = script.substring(prev.getRawEndOffset(), offset);
                    return between.contains("\n") ? stmt : prev;
                }
            }
            prev = stmt;
        }
        return prev;
    }

    public static List<StatementInfo> split(String script) {
        return SQLExecuteHelper.split(script, true);
    }

    static List<StatementInfo> split(String script, boolean useHashComments) {
        return new SQLSplitter(script, useHashComments).getStatements();
    }

    private static final class SQLSplitter {
        private static final int STATE_MEANINGFUL_TEXT = 0;
        private static final int STATE_MAYBE_LINE_COMMENT = 1;
        private static final int STATE_LINE_COMMENT = 2;
        private static final int STATE_MAYBE_BLOCK_COMMENT = 3;
        private static final int STATE_BLOCK_COMMENT = 4;
        private static final int STATE_MAYBE_END_BLOCK_COMMENT = 5;
        private static final int STATE_QUOTED = 6;
        private final String sql;
        private final int sqlLength;
        private final boolean useHashComments;
        private final StringBuilder statement = new StringBuilder();
        private final List<StatementInfo> statements = new ArrayList<StatementInfo>();
        private int pos = 0;
        private int line = -1;
        private int column;
        private boolean wasEOL = true;
        private int rawStartOffset;
        private int startOffset;
        private int startLine;
        private int startColumn;
        private int endOffset;
        private int rawEndOffset;
        private int state = 0;
        private String delimiter = ";";
        private static final String DELIMITER_TOKEN = "delimiter";

        public SQLSplitter(String sql, boolean useHashComments) {
            assert (sql != null);
            this.sql = sql;
            this.sqlLength = sql.length();
            this.useHashComments = useHashComments;
            this.parse();
        }

        private void parse() {
            this.checkDelimiterStatement();
            int startQuote = -1;
            int commentStart = 0;
            block9: while (this.pos < this.sqlLength) {
                char ch = this.sql.charAt(this.pos);
                if (ch == '\r') {
                    if (!LOG) continue;
                    LOGGER.log(Level.FINE, "The SQL string contained non-supported \r characters.");
                    continue;
                }
                this.nextColumn();
                switch (this.state) {
                    case 0: {
                        if (this.isDelimiter()) {
                            this.rawEndOffset = this.pos;
                            this.addStatement();
                            this.statement.setLength(0);
                            this.rawStartOffset = this.pos + this.delimiter.length();
                            this.pos += this.delimiter.length();
                            continue block9;
                        }
                        if (ch == '-') {
                            this.state = 1;
                            break;
                        }
                        if (ch == '/') {
                            this.state = 3;
                            break;
                        }
                        if (ch == '#' && this.useHashComments) {
                            if (this.statement.length() != 0 && Character.isLetterOrDigit(this.statement.charAt(this.statement.length() - 1))) break;
                            this.state = 2;
                            break;
                        }
                        if (!SQLSplitter.isStartQuote(ch)) break;
                        startQuote = ch;
                        this.state = 6;
                        break;
                    }
                    case 1: {
                        if (ch == '-') {
                            commentStart = this.pos + 1;
                            this.state = 2;
                            break;
                        }
                        this.state = 0;
                        this.statement.append('-');
                        this.endOffset = this.pos;
                        break;
                    }
                    case 2: {
                        if (ch != '\n') break;
                        this.checkForDelimiterStmt(commentStart, this.pos - 1);
                        this.state = 0;
                        break;
                    }
                    case 3: {
                        if (ch == '*') {
                            commentStart = this.pos + 1;
                            this.state = 4;
                            break;
                        }
                        this.statement.append('/');
                        this.endOffset = this.pos;
                        if (ch == '/') break;
                        this.state = 0;
                        break;
                    }
                    case 4: {
                        if (ch != '*') break;
                        this.state = 5;
                        break;
                    }
                    case 5: {
                        if (ch == '/') {
                            this.checkForDelimiterStmt(commentStart, this.pos - 2);
                            this.state = 0;
                            ++this.pos;
                            continue block9;
                        }
                        if (ch == '*') break;
                        this.state = 4;
                        break;
                    }
                    case 6: {
                        int lookAhead = -1;
                        if (this.pos + 1 < this.sqlLength) {
                            lookAhead = this.sql.charAt(this.pos + 1);
                        }
                        if (!SQLSplitter.isEndQuote(startQuote, ch)) break;
                        if (lookAhead >= 0 && SQLSplitter.isEndQuote(startQuote, lookAhead)) {
                            this.statement.append(ch);
                            this.statement.append((char)lookAhead);
                            this.pos += 2;
                            if (this.state != 6 && Character.isWhitespace(ch)) continue block9;
                            this.endOffset = this.pos + 1;
                            continue block9;
                        }
                        this.state = 0;
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                if (!(this.state != 0 && this.state != 6 || this.statement.length() <= 0 && Character.isWhitespace(ch))) {
                    if (this.statement.length() == 0) {
                        if (this.checkDelimiterStatement()) continue;
                        this.startOffset = this.pos;
                        this.endOffset = this.pos;
                        this.startLine = this.line;
                        this.startColumn = this.column;
                    }
                    this.statement.append(ch);
                    if (this.state == 6 || !Character.isWhitespace(ch)) {
                        this.endOffset = this.pos + 1;
                    }
                }
                ++this.pos;
            }
            this.rawEndOffset = this.pos;
            this.addStatement();
        }

        private static boolean isStartQuote(int start) {
            return SQLSplitter.isStartStringQuoteChar(start) || SQLSplitter.isStartIdentifierQuoteChar(start);
        }

        private static boolean isEndQuote(int start, int end) {
            return SQLSplitter.isEndIdentifierQuoteChar(start, end) || SQLSplitter.isEndStringQuoteChar(start, end);
        }

        private static boolean isStartStringQuoteChar(int start) {
            return start == 39;
        }

        private static boolean isStartIdentifierQuoteChar(int start) {
            return start == 34 || start == 96 || start == 91;
        }

        private static int getMatchingQuote(int start) {
            switch (start) {
                case 91: {
                    return 93;
                }
            }
            return start;
        }

        private static boolean isEndIdentifierQuoteChar(int start, int end) {
            return SQLSplitter.isStartIdentifierQuoteChar(start) && end == SQLSplitter.getMatchingQuote(start);
        }

        private static boolean isEndStringQuoteChar(int start, int end) {
            return SQLSplitter.isStartStringQuoteChar(start) && end == SQLSplitter.getMatchingQuote(start);
        }

        private boolean checkDelimiterStatement() {
            int endPos;
            this.skipWhitespace();
            if (this.pos == this.sqlLength) {
                return false;
            }
            if (!this.isToken(DELIMITER_TOKEN)) {
                return false;
            }
            int tokenLength = DELIMITER_TOKEN.length();
            this.pos += tokenLength;
            this.skipWhitespace();
            for (endPos = this.pos; endPos < this.sqlLength && !Character.isWhitespace(this.sql.charAt(endPos)); ++endPos) {
            }
            if (this.pos == endPos) {
                return false;
            }
            this.delimiter = this.sql.substring(this.pos, endPos);
            this.pos = endPos;
            this.statement.setLength(0);
            this.rawStartOffset = this.pos;
            return true;
        }

        private void checkForDelimiterStmt(int initialOffset, int end) {
            int start;
            for (start = initialOffset; Character.isWhitespace(this.sql.charAt(start)) && start < end; ++start) {
            }
            if (start >= end && end - start + 1 <= DELIMITER_TOKEN.length()) {
                return;
            }
            boolean delimiterMatched = true;
            for (int i = 0; i < DELIMITER_TOKEN.length(); ++i) {
                if (Character.toUpperCase(this.sql.charAt(start)) != Character.toUpperCase(DELIMITER_TOKEN.charAt(i))) {
                    delimiterMatched = false;
                    break;
                }
                ++start;
            }
            if (!delimiterMatched) {
                return;
            }
            while (Character.isWhitespace(this.sql.charAt(start)) && start < end) {
                ++start;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = start; i <= end && !Character.isWhitespace(this.sql.charAt(i)); ++i) {
                sb.append(this.sql.charAt(i));
            }
            if (sb.length() > 0) {
                this.delimiter = sb.toString();
            }
        }

        private void skipWhitespace() {
            while (this.pos < this.sqlLength && Character.isWhitespace(this.sql.charAt(this.pos))) {
                this.nextColumn();
                ++this.pos;
            }
        }

        private boolean isDelimiter() {
            int length = this.delimiter.length();
            if (this.pos + length > this.sqlLength) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                if (this.delimiter.charAt(i) != this.sql.charAt(this.pos + i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void nextColumn() {
            if (this.wasEOL) {
                ++this.line;
                this.column = 0;
                this.wasEOL = false;
            } else {
                ++this.column;
            }
            if (this.sql.charAt(this.pos) == '\n') {
                this.wasEOL = true;
            }
        }

        private boolean isToken(String token) {
            String substr;
            char ch = this.sql.charAt(this.pos);
            if (Character.toUpperCase(ch) != Character.toUpperCase(token.charAt(0))) {
                return false;
            }
            if (this.pos > 0 && !Character.isWhitespace(this.sql.charAt(this.pos - 1))) {
                return false;
            }
            if (this.sql.length() > this.pos + token.length() && Character.isLetterOrDigit(this.sql.charAt(this.pos + token.length()))) {
                return false;
            }
            try {
                substr = this.sql.substring(this.pos, this.pos + token.length());
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            return substr.toUpperCase().equals(token.toUpperCase());
        }

        private void addStatement() {
            String sqlTrimmed = this.statement.toString().trim();
            if (sqlTrimmed.length() <= 0) {
                return;
            }
            StatementInfo info = new StatementInfo(sqlTrimmed, this.rawStartOffset, this.startOffset, this.startLine, this.startColumn, this.endOffset, this.rawEndOffset);
            this.statements.add(info);
        }

        public List<StatementInfo> getStatements() {
            return Collections.unmodifiableList(this.statements);
        }
    }
}

