/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.history;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;

@XmlType(name="sql")
public class SQLHistoryEntry {
    private String url;
    private String sql;
    private Date date;

    protected SQLHistoryEntry() {
    }

    public SQLHistoryEntry(String url, String sql, Date date) {
        this.url = url;
        this.sql = sql;
        this.date = date;
    }

    @XmlTransient
    public Date getDate() {
        return this.date;
    }

    protected void setDate(Date date) {
        this.date = date;
    }

    @XmlValue
    public String getSql() {
        return this.sql;
    }

    protected void setSql(String sql) {
        this.sql = sql != null ? sql.trim() : sql;
    }

    @XmlAttribute
    public String getUrl() {
        return this.url;
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    @XmlAttribute(name="date")
    protected String getDateXMLVariant() {
        if (this.date == null) {
            return null;
        }
        return Long.toString(this.date.getTime());
    }

    protected void setDateXMLVariant(String value) {
        try {
            this.date = new Date(Long.parseLong(value));
        }
        catch (NumberFormatException nfe) {
            try {
                this.date = DateFormat.getDateTimeInstance(3, 3).parse(value);
            }
            catch (ParseException pe) {
                this.date = new Date();
            }
        }
    }

    public String toString() {
        return "SQLHistoryEntry{url=" + this.url + ", sql=" + this.sql + ", date=" + this.date + '}';
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLHistoryEntry other = (SQLHistoryEntry)obj;
        if (this.url == null ? other.url != null : !this.url.toLowerCase().equals(other.url.toLowerCase())) {
            return false;
        }
        return !(this.sql == null ? other.sql != null : !this.sql.toLowerCase().equals(other.sql.toLowerCase()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + (this.sql != null ? this.sql.toLowerCase().hashCode() : 0);
        return hash;
    }
}

