/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Annotator;
import org.netbeans.modules.subversion.remote.FileInformation;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.FileStatusProvider;
import org.netbeans.modules.subversion.remote.FilesystemHandler;
import org.netbeans.modules.subversion.remote.HistoryProvider;
import org.netbeans.modules.subversion.remote.OutputLogger;
import org.netbeans.modules.subversion.remote.SubversionVCS;
import org.netbeans.modules.subversion.remote.SubversionVisibilityQuery;
import org.netbeans.modules.subversion.remote.VersionsCache;
import org.netbeans.modules.subversion.remote.WorkingCopyAttributesCache;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnClientFactory;
import org.netbeans.modules.subversion.remote.client.SvnClientRefreshHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.config.SvnConfigFiles;
import org.netbeans.modules.subversion.remote.ui.ignore.IgnoreAction;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.subversion.remote.versioning.util.VCSHyperlinkProvider;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.DelayScanRegistry;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class Subversion {
    public static final String PROP_ANNOTATIONS_CHANGED = "annotationsChanged";
    static final String PROP_VERSIONED_FILES_CHANGED = "versionedFilesChanged";
    static final String PROP_BASE_FILE_CHANGED = "baseFileChanged";
    static final String INVALID_METADATA_MARKER = "invalid-metadata";
    private static final int STATUS_DIFFABLE = 83192;
    private static Subversion instance;
    private FileStatusCache fileStatusCache;
    private FilesystemHandler filesystemHandler;
    private FileStatusProvider fileStatusProvider;
    private SvnClientRefreshHandler refreshHandler;
    private Annotator annotator;
    private HashMap<String, RequestProcessor> processorsToUrl;
    private List<ISVNNotifyListener> svnNotifyListeners;
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    public static final Logger LOG;
    private Lookup.Result<? extends VCSHyperlinkProvider> hpResult;
    private static final List<String> allowableFolders;
    private RequestProcessor parallelRP;
    private HistoryProvider historyProvider;
    private RequestProcessor.Task cleanupTask;
    private final Set<VCSFileProxy> unversionedParents = Collections.synchronizedSet(new HashSet(20));
    private final ConcurrentMap<VCSFileProxy, GlobalInfo> topmostInfo = new ConcurrentHashMap<VCSFileProxy, GlobalInfo>();

    public static synchronized Subversion getInstance() {
        if (instance == null) {
            instance = new Subversion();
            instance.init();
        }
        return instance;
    }

    private Subversion() {
    }

    private void init() {
        this.fileStatusCache = new FileStatusCache();
        this.annotator = new Annotator(this);
        this.fileStatusCache.setAnnotator(this.annotator);
        this.fileStatusProvider = new FileStatusProvider();
        this.filesystemHandler = new FilesystemHandler(this);
        this.refreshHandler = new SvnClientRefreshHandler();
        this.prepareCache();
    }

    public void attachListeners(SubversionVCS svcs) {
        this.fileStatusCache.addVersioningListener(svcs);
        this.addPropertyChangeListener(svcs);
    }

    private void prepareCache() {
        this.cleanupTask = this.getRequestProcessor().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!Subversion.this.fileStatusCache.ready()) {
                    Subversion.this.fileStatusCache.computeIndex();
                }
                if (DelayScanRegistry.getInstance().isDelayed(Subversion.this.cleanupTask, LOG, "Subversion.cleanupTask")) {
                    return;
                }
                try {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Cleaning up cache");
                    }
                    Subversion.this.fileStatusCache.cleanUp();
                }
                finally {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("END Cleaning up cache");
                    }
                    Subversion.this.cleanupTask = null;
                }
            }
        });
        this.cleanupTask.schedule(500);
    }

    public void shutdown() {
        this.fileStatusProvider.shutdown();
    }

    public FileStatusCache getStatusCache() {
        return this.fileStatusCache;
    }

    public Annotator getAnnotator() {
        return this.annotator;
    }

    public HistoryProvider getHistoryProvider() {
        if (this.historyProvider == null) {
            this.historyProvider = new HistoryProvider();
        }
        return this.historyProvider;
    }

    public SvnClientRefreshHandler getRefreshHandler() {
        return this.refreshHandler;
    }

    public boolean checkClientAvailable(Context context) {
        FileSystem fileSystem = context.getFileSystem();
        if (fileSystem == null || !VCSFileProxySupport.isConnectedFileSystem((FileSystem)fileSystem)) {
            return false;
        }
        try {
            SvnClientFactory.checkClientAvailable(context);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(context, ex, true, true);
            return false;
        }
        return true;
    }

    public SvnClient getClient(Context context, SVNUrl repositoryUrl, String username, char[] password, int handledExceptions) throws SVNClientException {
        SvnClient client = SvnClientFactory.getInstance(context).createSvnClient(context, repositoryUrl, null, username, password, handledExceptions);
        this.attachListeners(context.getFileSystem(), client);
        return client;
    }

    public SvnClient getClient(Context context, SVNUrl repositoryUrl, SvnProgressSupport progressSupport) throws SVNClientException {
        Parameters.notNull((CharSequence)"repositoryUrl", (Object)repositoryUrl);
        String username = "";
        char[] password = null;
        return this.getClient(context, repositoryUrl, username, password, progressSupport);
    }

    public SvnClient getClient(Context context, SVNUrl repositoryUrl, String username, char[] password, SvnProgressSupport support) throws SVNClientException {
        SvnClient client = SvnClientFactory.getInstance(context).createSvnClient(context, repositoryUrl, support, username, password, 196652);
        this.attachListeners(context.getFileSystem(), client);
        return client;
    }

    public SvnClient getClient(VCSFileProxy file) throws SVNClientException {
        return this.getClient(file, null);
    }

    @SuppressWarnings(value={"RCN"})
    public SvnClient getClient(VCSFileProxy file, SvnProgressSupport support) throws SVNClientException {
        SVNUrl repositoryUrl = SvnUtils.getRepositoryRootUrl(file);
        assert (repositoryUrl != null) : "Unable to get repository: " + file.getPath() + " is probably unmanaged.";
        return repositoryUrl == null ? null : this.getClient(new Context(file), repositoryUrl, support);
    }

    public SvnClient getClient(Context ctx, SvnProgressSupport support) throws SVNClientException {
        VCSFileProxy[] roots = ctx.getRootFiles();
        SVNUrl repositoryUrl = null;
        for (VCSFileProxy root : roots) {
            if (!SvnUtils.isManaged(root)) {
                LOG.log(Level.WARNING, "getClient: unmanaged file in context: {0}", root.getPath());
            }
            if ((repositoryUrl = SvnUtils.getRepositoryRootUrl(root)) != null) break;
            LOG.log(Level.WARNING, "Could not retrieve repository root for context file {0}", new Object[]{root});
        }
        if (repositoryUrl == null) {
            StringBuilder sb = new StringBuilder("Cannot determine repositoryRootUrl for selected context:");
            for (VCSFileProxy root : roots) {
                sb.append("\n").append(root.getPath());
            }
            throw new SVNClientException(sb.toString());
        }
        return this.getClient(ctx, repositoryUrl, support);
    }

    public SvnClient getClient(Context context, SVNUrl repositoryUrl) throws SVNClientException {
        return this.getClient(context, repositoryUrl, null);
    }

    public SvnClient getClient(boolean attachListeners, Context context) throws SVNClientException {
        this.cleanupFilesystem();
        SvnClient client = SvnClientFactory.getInstance(context).createSvnClient(context);
        if (attachListeners) {
            this.attachListeners(context.getFileSystem(), client);
        }
        return client;
    }

    public void versionedFilesChanged() {
        this.topmostInfo.clear();
        this.unversionedParents.clear();
        this.support.firePropertyChange(PROP_VERSIONED_FILES_CHANGED, null, null);
    }

    public void cleanupFilesystem() {
        this.filesystemHandler.removeInvalidMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachListeners(FileSystem fileSystem, SvnClient client) {
        client.addNotifyListener(this.getLogger(fileSystem, client.getSvnUrl()));
        client.addNotifyListener(this.refreshHandler);
        List<ISVNNotifyListener> l = this.getSVNNotifyListeners();
        ISVNNotifyListener[] listeners = null;
        List<ISVNNotifyListener> list = l;
        synchronized (list) {
            listeners = l.toArray(new ISVNNotifyListener[l.size()]);
        }
        for (ISVNNotifyListener listener : listeners) {
            client.addNotifyListener(listener);
        }
    }

    public OutputLogger getLogger(FileSystem fileSystem, SVNUrl repositoryRoot) {
        return OutputLogger.getLogger(fileSystem, repositoryRoot);
    }

    boolean isIgnored(VCSFileProxy file) {
        VCSFileProxy parent;
        String name;
        block11: {
            name = file.getName();
            parent = (file = file.normalizeFile()).getParentFile();
            if (parent != null) {
                int pstatus = this.fileStatusCache.getStatus(parent).getStatus();
                Context context = new Context(parent);
                if ((pstatus & 0x15DF8) != 0) {
                    try {
                        SvnClient client = this.getClient(false, context);
                        List<String> gignores = SvnConfigFiles.getInstance(context.getFileSystem()).getGlobalIgnores();
                        if (gignores != null && SvnUtils.getMatchinIgnoreParterns(gignores, name, true).size() > 0) {
                            return true;
                        }
                        List<String> patterns = client.getIgnoredPatterns(parent);
                        if (patterns != null && SvnUtils.getMatchinIgnoreParterns(patterns, name, true).size() > 0) {
                            return true;
                        }
                    }
                    catch (SVNClientException ex) {
                        if (SvnClientExceptionHandler.isUnversionedResource(ex.getMessage()) || SvnClientExceptionHandler.isCancelledAction(ex.getMessage()) || WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) break block11;
                        SvnClientExceptionHandler.notifyException(context, ex, false, false);
                    }
                }
            }
        }
        if (SharabilityQuery.getSharability((URI)VCSFileProxySupport.toURI((VCSFileProxy)file)) == SharabilityQuery.Sharability.NOT_SHARABLE) {
            block12: {
                try {
                    FileInformation info = this.fileStatusCache.getCachedStatus(file);
                    if (SubversionVisibilityQuery.isHiddenFolder(info, file)) {
                        return false;
                    }
                    if (SharabilityQuery.getSharability((URI)VCSFileProxySupport.toURI((VCSFileProxy)parent)) != SharabilityQuery.Sharability.NOT_SHARABLE && (this.fileStatusCache.getStatus(parent).getStatus() & 0x15DF8) != 0) {
                        IgnoreAction.ignore(file);
                    }
                }
                catch (SVNClientException ex) {
                    if (WorkingCopyAttributesCache.getInstance().isSuppressed(ex)) break block12;
                    SvnClientExceptionHandler.notifyException(new Context(file), ex, false, false);
                }
            }
            return true;
        }
        return ".nbintdb".equals(name);
    }

    public RequestProcessor getRequestProcessor() {
        return this.getRequestProcessor(null);
    }

    public RequestProcessor getParallelRequestProcessor() {
        if (this.parallelRP == null) {
            this.parallelRP = new RequestProcessor("Subversion.ParallelTasks", 5, true);
        }
        return this.parallelRP;
    }

    public RequestProcessor getRequestProcessor(SVNUrl url) {
        String key;
        RequestProcessor rp;
        if (this.processorsToUrl == null) {
            this.processorsToUrl = new HashMap();
        }
        if ((rp = this.processorsToUrl.get(key = url != null ? url.toString() : "ANY_URL")) == null) {
            rp = new RequestProcessor("Subversion - " + key, 1, true);
            this.processorsToUrl.put(key, rp);
        }
        return rp;
    }

    public boolean isConnected(VCSFileProxy file) {
        if (file.toFile() != null) {
            return false;
        }
        if (!this.isAllowable(file)) {
            return false;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "looking for managed parent for {0}", new Object[]{file});
        }
        return VCSFileProxySupport.isConnectedFileSystem((FileSystem)VCSFileProxySupport.getFileSystem((VCSFileProxy)file));
    }

    public VCSFileProxy getTopmostManagedAncestor(VCSFileProxy file) {
        if (!this.isConnected(file)) {
            return null;
        }
        if (this.unversionedParents.contains(file)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(" cached as unversioned");
            }
            return null;
        }
        VCSFileProxy metadataRoot = null;
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(" part of metaddata");
            }
            while (file != null) {
                if (SvnUtils.isAdministrative(file)) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, " will use parent {0}", new Object[]{file});
                    }
                    metadataRoot = file;
                    file = file.getParentFile();
                    break;
                }
                file = file.getParentFile();
            }
        }
        VCSFileProxy topmost = null;
        HashSet<VCSFileProxy> done = new HashSet<VCSFileProxy>();
        while (file != null) {
            if (this.unversionedParents.contains(file)) {
                if (!LOG.isLoggable(Level.FINE)) break;
                LOG.log(Level.FINE, " already known as unversioned {0}", new Object[]{file});
                break;
            }
            if (VersioningSupport.isExcluded((VCSFileProxy)file)) break;
            boolean forbiddenFolder = org.netbeans.modules.versioning.core.util.Utils.isForbiddenFolder((VCSFileProxy)file);
            if (!forbiddenFolder && SvnUtils.hasMetadata(file)) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " found managed parent {0}", new Object[]{file});
                }
                topmost = file;
                done.clear();
            } else {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " found unversioned {0}", new Object[]{file});
                }
                if (file.exists()) {
                    done.add(file);
                }
            }
            file = file.getParentFile();
        }
        if (done.size() > 0) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, " storing unversioned");
            }
            this.unversionedParents.addAll(done);
        }
        if (topmost == null && metadataRoot != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "setting metadata root as managed parent {0}", new Object[]{metadataRoot});
            }
            topmost = metadataRoot;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "returning managed parent {0}", new Object[]{topmost});
        }
        this.cacheIfNeededAllForTopmost(topmost);
        return topmost;
    }

    FileStatusProvider getVCSAnnotator() {
        return this.fileStatusProvider;
    }

    VCSInterceptor getInterceptor() {
        return this.filesystemHandler;
    }

    private List<ISVNNotifyListener> getSVNNotifyListeners() {
        if (this.svnNotifyListeners == null) {
            this.svnNotifyListeners = new ArrayList<ISVNNotifyListener>();
        }
        return this.svnNotifyListeners;
    }

    public void refreshAllAnnotations() {
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, null);
    }

    public void refreshAnnotations(VCSFileProxy ... files) {
        HashSet<VCSFileProxy> s = new HashSet<VCSFileProxy>(Arrays.asList(files));
        this.support.firePropertyChange(PROP_ANNOTATIONS_CHANGED, null, s);
    }

    public void refreshAnnotationsAndSidebars(VCSFileProxy ... files) {
        HashSet<VCSFileProxy> s = files == null ? null : new HashSet<VCSFileProxy>(Arrays.asList(files));
        this.support.firePropertyChange(PROP_BASE_FILE_CHANGED, null, s);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSVNNotifyListener(ISVNNotifyListener listener) {
        List<ISVNNotifyListener> listeners;
        List<ISVNNotifyListener> list = listeners = this.getSVNNotifyListeners();
        synchronized (list) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSVNNotifyListener(ISVNNotifyListener listener) {
        List<ISVNNotifyListener> listeners;
        List<ISVNNotifyListener> list = listeners = this.getSVNNotifyListeners();
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    void getOriginalFile(VCSFileProxy workingCopy, VCSFileProxy originalFile) {
        block5: {
            FileInformation info = this.fileStatusCache.getStatus(workingCopy);
            if ((info.getStatus() & 0x144F8) == 0) {
                return;
            }
            VCSFileProxy original = null;
            try {
                Context context = new Context(workingCopy);
                SvnClientFactory.checkClientAvailable(context);
                original = VersionsCache.getInstance(context.getFileSystem()).getBaseRevisionFile(workingCopy);
                if (original == null) {
                    throw new IOException("Unable to get BASE revision of " + workingCopy);
                }
                Utils.copyStreamsCloseAll((OutputStream)VCSFileProxySupport.getOutputStream((VCSFileProxy)originalFile), (InputStream)original.getInputStream(false));
            }
            catch (IOException e) {
                LOG.log(Level.INFO, "Unable to get original file", e);
            }
            catch (SVNClientException ex) {
                LOG.log(Level.INFO, "Subversion.getOriginalFile: file is managed but svn client is unavailable (file {0})", workingCopy.getPath());
                if (!LOG.isLoggable(Level.FINE)) break block5;
                LOG.log(Level.FINE, null, ex);
            }
        }
    }

    public List<VCSHyperlinkProvider> getHyperlinkProviders() {
        if (this.hpResult == null) {
            this.hpResult = Lookup.getDefault().lookupResult(VCSHyperlinkProvider.class);
        }
        if (this.hpResult == null) {
            return Collections.emptyList();
        }
        Collection providersCol = this.hpResult.allInstances();
        ArrayList providersList = new ArrayList(providersCol.size());
        providersList.addAll(providersCol);
        return Collections.unmodifiableList(providersList);
    }

    private boolean isAllowable(VCSFileProxy file) {
        String path = file.getPath() + "/";
        for (String s : allowableFolders) {
            if (!(s.endsWith("/") ? path.startsWith(s) : path.startsWith(s + "/"))) continue;
            return true;
        }
        return false;
    }

    public SVNUrl getTopmostRepositoryUrl(VCSFileProxy file) throws SVNClientException {
        VCSFileProxy topmost = this.getTopmostManagedAncestor(file);
        if (topmost == null) {
            return null;
        }
        GlobalInfo out = (GlobalInfo)this.topmostInfo.get(topmost);
        assert (out != null);
        return out.getTopmostRepositoryUrl();
    }

    public void refreshTopmostRepositoryUrl(VCSFileProxy file) {
        VCSFileProxy topmost = this.getTopmostManagedAncestor(file);
        if (topmost == null) {
            return;
        }
        GlobalInfo out = (GlobalInfo)this.topmostInfo.get(topmost);
        out.refresh();
    }

    private void cacheIfNeededAllForTopmost(VCSFileProxy topmost) {
        if (topmost != null) {
            try {
                GlobalInfo info = (GlobalInfo)this.topmostInfo.get(topmost);
                if (info == null) {
                    this.topmostInfo.putIfAbsent(topmost, new GlobalInfo(topmost));
                    info = (GlobalInfo)this.topmostInfo.get(topmost);
                    info.getTopmostRepositoryUrl();
                }
            }
            catch (SVNClientException ex) {
                LOG.log(Level.INFO, "Cannot get repository URL for " + topmost.getPath(), ex);
            }
        }
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.subversion.remote");
        ArrayList<String> files = new ArrayList<String>();
        try {
            String allowable = System.getProperty("versioning.svn.allowableFolders", "/");
            files.addAll(Arrays.asList(allowable.split("\\;")));
            files.remove("");
        }
        catch (Exception e) {
            LOG.log(Level.INFO, e.getMessage(), e);
        }
        allowableFolders = files;
    }

    private final class GlobalInfo
    implements Runnable {
        private boolean inited = false;
        private SVNUrl result;
        private final VCSFileProxy topmost;
        private SVNClientException ex;
        RequestProcessor.Task runner;

        private GlobalInfo(VCSFileProxy topmost) {
            this.topmost = topmost;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SVNUrl getTopmostRepositoryUrl() throws SVNClientException {
            GlobalInfo globalInfo = this;
            synchronized (globalInfo) {
                if (!this.inited) {
                    if (this.runner == null) {
                        this.runner = Subversion.this.getParallelRequestProcessor().create((Runnable)this);
                        this.runner.run();
                    }
                    this.runner.waitFinished();
                }
                if (this.ex != null) {
                    throw this.ex;
                }
                return this.result;
            }
        }

        @Override
        public void run() {
            try {
                this.result = SvnUtils.getRepositoryRootUrl(this.topmost, true);
            }
            catch (SVNClientException ex) {
                this.ex = ex;
            }
            this.inited = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refresh() {
            GlobalInfo globalInfo = this;
            synchronized (globalInfo) {
                this.inited = false;
                this.ex = null;
                this.runner = null;
                this.result = null;
            }
            try {
                this.getTopmostRepositoryUrl();
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
        }
    }
}

