/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote;

import java.awt.EventQueue;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.ui.wcadmin.UpgradeAction;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.actions.SystemAction;

public final class WorkingCopyAttributesCache {
    private static WorkingCopyAttributesCache instance;
    private final HashSet<String> unsupportedWorkingCopies = new HashSet(5);
    private final HashSet<String> tooOldClientForWorkingCopies = new HashSet(5);
    private final HashSet<String> tooOldWorkingCopies = new HashSet(5);
    private final HashSet<String> askedToUpgradeWorkingCopies = new HashSet(5);

    public static synchronized WorkingCopyAttributesCache getInstance() {
        if (instance == null) {
            instance = new WorkingCopyAttributesCache();
            instance.init();
        }
        return instance;
    }

    private WorkingCopyAttributesCache() {
    }

    private void init() {
    }

    public void logSuppressed(SVNClientException ex, VCSFileProxy file) throws SVNClientException {
        if (SvnClientExceptionHandler.isTooOldClientForWC(ex.getMessage())) {
            this.logUnsupportedWC(ex, file);
        } else if (SvnClientExceptionHandler.isPartOfNewerWC(ex.getMessage())) {
            this.logTooOldClient(ex, file);
        } else if (SvnClientExceptionHandler.isTooOldWorkingCopy(ex.getMessage())) {
            this.logTooOldWC(ex, file);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public boolean isSuppressed(SVNClientException ex) {
        boolean retval = false;
        if (SvnClientExceptionHandler.isTooOldClientForWC(ex.getMessage())) {
            retval = true;
        } else if (SvnClientExceptionHandler.isPartOfNewerWC(ex.getMessage())) {
            retval = true;
        } else if (SvnClientExceptionHandler.isTooOldWorkingCopy(ex.getMessage())) {
            retval = true;
        }
        return retval;
    }

    private void logUnsupportedWC(SVNClientException ex, VCSFileProxy file) throws SVNClientException {
        this.logWC(ex, file, this.unsupportedWorkingCopies);
    }

    private void logTooOldClient(SVNClientException ex, VCSFileProxy file) throws SVNClientException {
        this.logWC(ex, file, this.tooOldClientForWorkingCopies);
    }

    private void logTooOldWC(SVNClientException ex, VCSFileProxy file) throws SVNClientException {
        this.logWC(ex, file, this.tooOldWorkingCopies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLogged(String fileName, HashSet<String> loggedWCs) {
        HashSet<String> hashSet = loggedWCs;
        synchronized (hashSet) {
            for (String unsupported : loggedWCs) {
                if (!fileName.startsWith(unsupported)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logWC(final SVNClientException ex, final VCSFileProxy file, HashSet<String> loggedWCs) throws SVNClientException {
        String fileName = file.getPath();
        if (!this.isLogged(fileName, loggedWCs)) {
            final VCSFileProxy topManaged = Subversion.getInstance().getTopmostManagedAncestor(file);
            HashSet<String> hashSet = loggedWCs;
            synchronized (hashSet) {
                loggedWCs.add(topManaged.getPath());
            }
            Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        OpenProjects.getDefault().openProjects().get();
                    }
                    catch (InterruptedException ex2) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String msg = ex.getMessage().toLowerCase(Locale.ENGLISH);
                            if (SvnClientExceptionHandler.isTooOldWorkingCopy(msg) && (msg.contains("svn upgrade") || msg.contains("working copy format of ") && msg.contains("is too old") || msg.contains("needs to be upgraded"))) {
                                SvnClientExceptionHandler.notifyException(new Context(file), ex, false, false);
                                ((UpgradeAction)SystemAction.get(UpgradeAction.class)).upgrade(topManaged);
                            } else {
                                SvnClientExceptionHandler.notifyException(new Context(file), ex, true, true);
                            }
                        }
                    });
                }
            });
        }
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean logAskedToUpgrade(VCSFileProxy file) {
        if (!this.isLogged(file.getPath(), this.askedToUpgradeWorkingCopies)) {
            VCSFileProxy topManaged = Subversion.getInstance().getTopmostManagedAncestor(file);
            HashSet<String> hashSet = this.askedToUpgradeWorkingCopies;
            synchronized (hashSet) {
                this.askedToUpgradeWorkingCopies.add(topManaged.getPath());
            }
            return true;
        }
        return false;
    }
}

