/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.status;

import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.ui.actions.AbstractAllAction;
import org.netbeans.modules.subversion.remote.ui.status.SvnVersioningTopComponent;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.openide.util.NbBundle;

public class ShowAllChangesAction
extends AbstractAllAction {
    public String getName() {
        return NbBundle.getMessage(ShowAllChangesAction.class, (String)"CTL_MenuItem_ShowAllChanges_Label");
    }

    public void actionPerformed(ActionEvent e) {
        Subversion.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                ShowAllChangesAction.this.async();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void async() {
        try {
            String title;
            this.setEnabled(false);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SvnVersioningTopComponent stc = SvnVersioningTopComponent.getInstance();
                    stc.setContext(null);
                    stc.open();
                }
            });
            Project[] projects = OpenProjects.getDefault().getOpenProjects();
            final Context ctx = SvnUtils.getProjectsContext(projects);
            if (projects.length == 1) {
                Project project = projects[0];
                ProjectInformation pinfo = ProjectUtils.getInformation((Project)project);
                title = pinfo.getDisplayName();
            } else {
                title = NbBundle.getMessage(ShowAllChangesAction.class, (String)"CTL_ShowAllChanges_WindowTitle", (Object)Integer.toString(projects.length));
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SvnVersioningTopComponent stc = SvnVersioningTopComponent.getInstance();
                    stc.setContentTitle(title);
                    stc.setContext(ctx);
                    stc.open();
                    stc.requestActive();
                    if (ShowAllChangesAction.this.shouldPostRefresh()) {
                        stc.performRefreshAction();
                    }
                }
            });
        }
        finally {
            this.setEnabled(true);
        }
    }

    protected boolean shouldPostRefresh() {
        return true;
    }
}

