/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.update;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.FileInformation;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.RepositoryFile;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNInfo;
import org.netbeans.modules.subversion.remote.api.ISVNStatus;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.update.RevertModifications;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public class RevertModificationsAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/subversion/remote/resources/icons/get_clean.png";

    public RevertModificationsAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_MenuItem_Revert";
    }

    @Override
    protected int getFileEnabledStatus() {
        return 89592;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return 89592;
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        SVNUrl url;
        SVNUrl rootUrl;
        final Context ctx = this.getContext(nodes);
        if (!Subversion.getInstance().checkClientAvailable(ctx)) {
            return;
        }
        VCSFileProxy[] roots = ctx.getRootFiles();
        ArrayList<VCSFileProxy> l = new ArrayList<VCSFileProxy>();
        for (VCSFileProxy file : roots) {
            if (!SvnUtils.isManaged(file)) continue;
            l.add(file);
        }
        roots = l.toArray(new VCSFileProxy[l.size()]);
        if (roots == null || roots.length == 0) {
            return;
        }
        VCSFileProxy interestingFile = roots.length == 1 ? roots[0] : SvnUtils.getPrimaryFile(roots[0]);
        try {
            rootUrl = ContextAction.getSvnUrl(ctx);
            url = SvnUtils.getRepositoryUrl(interestingFile);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
            return;
        }
        RepositoryFile repositoryFile = new RepositoryFile(ctx.getFileSystem(), rootUrl, url, SVNRevision.HEAD);
        final RevertModifications revertModifications = new RevertModifications(repositoryFile);
        if (!revertModifications.showDialog()) {
            return;
        }
        ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes, ctx){

            @Override
            public void perform() {
                RevertModificationsAction.performRevert(revertModifications.getRevisionInterval(), revertModifications.revertNewFiles(), !revertModifications.revertRecursively(), ctx, this);
            }
        };
        support.start(this.createRequestProcessor(ctx));
    }

    public static void performRevert(final RevertModifications.RevisionInterval revisions, boolean revertNewFiles, final boolean onlySelectedFiles, final Context ctx, final SvnProgressSupport support) {
        SvnClient client;
        try {
            client = Subversion.getInstance().getClient(ctx, support);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
            return;
        }
        VCSFileProxy[] files = ctx.getFiles();
        final VCSFileProxy[][] split = onlySelectedFiles ? new VCSFileProxy[2][0] : VCSFileProxySupport.splitFlatOthers((VCSFileProxy[])files);
        try {
            SvnUtils.runWithoutIndexing(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    for (int c = 0; c < split.length; ++c) {
                        boolean recursive;
                        if (support.isCanceled()) {
                            return null;
                        }
                        VCSFileProxy[] files = split[c];
                        boolean bl = recursive = c == 1;
                        if (!recursive && revisions == null) {
                            files = onlySelectedFiles ? ctx.getFiles() : SvnUtils.flatten(files, 88528);
                        }
                        try {
                            if (revisions != null) {
                                for (int i = 0; i < files.length; ++i) {
                                    if (support.isCanceled()) {
                                        return null;
                                    }
                                    SVNUrl url = SvnUtils.getRepositoryUrl(files[i]);
                                    RevertModifications.RevisionInterval targetInterval = RevertModificationsAction.recountStartRevision(ctx, client, url, revisions);
                                    if (files[i].exists()) {
                                        client.merge(url, targetInterval.endRevision, url, targetInterval.startRevision, files[i], false, recursive);
                                        continue;
                                    }
                                    assert (targetInterval.startRevision instanceof SVNRevision.Number) : "The revision has to be a Number when trying to undelete file!";
                                    client.copy(url, files[i], targetInterval.startRevision);
                                }
                                continue;
                            }
                            if (support.isCanceled()) {
                                return null;
                            }
                            if (files.length <= 0) continue;
                            HashSet deletedFiles = new HashSet();
                            for (VCSFileProxy file : files) {
                                deletedFiles.addAll(RevertModificationsAction.getDeletedParents(file));
                            }
                            this.handleCopiedFiles(client, files, recursive);
                            for (VCSFileProxy file : files) {
                                client.revert(file, recursive);
                            }
                            if (deletedFiles.size() <= 0) continue;
                            for (VCSFileProxy file : deletedFiles) {
                                client.revert(file, false);
                            }
                            continue;
                        }
                        catch (SVNClientException ex) {
                            support.annotate(ex);
                        }
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                private void handleCopiedFiles(SvnClient client2, VCSFileProxy[] files, boolean recursively) {
                    FileStatusCache cache = Subversion.getInstance().getStatusCache();
                    if (recursively) {
                        files = cache.listFiles(files, 4096);
                    }
                    for (VCSFileProxy f : files) {
                        VCSFileProxy temporary;
                        block24: {
                            ISVNStatus entry;
                            FileInformation fi = cache.getStatus(f);
                            if (fi.getStatus() != 4096 || !(entry = fi.getEntry(f)).isCopied()) continue;
                            temporary = VCSFileProxySupport.generateTemporaryFile((VCSFileProxy)f.getParentFile(), (String)f.getName());
                            if (VCSFileProxySupport.renameTo((VCSFileProxy)f, (VCSFileProxy)temporary)) {
                                client2.remove(new VCSFileProxy[]{f}, true);
                                break block24;
                            }
                            Subversion.LOG.log(Level.WARNING, "RevertModifications.handleCopiedFiles: cannot rename {0} to {1}", new Object[]{f, temporary});
                        }
                        if (!temporary.exists()) continue;
                        try {
                            if (VCSFileProxySupport.renameTo((VCSFileProxy)temporary, (VCSFileProxy)f)) continue;
                            VCSFileProxySupport.copyFile((VCSFileProxy)temporary, (VCSFileProxy)f);
                            continue;
                        }
                        catch (IOException ex) {
                            Subversion.LOG.log(Level.INFO, "RevertModifications.handleCopiedFiles: cannot copy {0} back to {1}", new Object[]{temporary, f});
                            continue;
                        }
                        finally {
                            VCSFileProxySupport.delete((VCSFileProxy)temporary);
                        }
                        catch (SVNClientException ex) {
                            try {
                                Subversion.LOG.log(Level.INFO, null, ex);
                            }
                            catch (Throwable throwable) {
                                if (temporary.exists()) {
                                    try {
                                        if (!VCSFileProxySupport.renameTo((VCSFileProxy)temporary, (VCSFileProxy)f)) {
                                            VCSFileProxySupport.copyFile((VCSFileProxy)temporary, (VCSFileProxy)f);
                                        }
                                    }
                                    catch (IOException ex2) {
                                        Subversion.LOG.log(Level.INFO, "RevertModifications.handleCopiedFiles: cannot copy {0} back to {1}", new Object[]{temporary, f});
                                    }
                                    finally {
                                        VCSFileProxySupport.delete((VCSFileProxy)temporary);
                                    }
                                }
                                throw throwable;
                            }
                            if (!temporary.exists()) continue;
                            try {
                                if (VCSFileProxySupport.renameTo((VCSFileProxy)temporary, (VCSFileProxy)f)) continue;
                                VCSFileProxySupport.copyFile((VCSFileProxy)temporary, (VCSFileProxy)f);
                            }
                            catch (IOException ex3) {
                                Subversion.LOG.log(Level.INFO, "RevertModifications.handleCopiedFiles: cannot copy {0} back to {1}", new Object[]{temporary, f});
                            }
                            finally {
                                VCSFileProxySupport.delete((VCSFileProxy)temporary);
                            }
                        }
                    }
                }
            }, files);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(ctx, ex, true, false);
        }
        if (support.isCanceled()) {
            return;
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        for (VCSFileProxy file : cache.listFiles(ctx, 6400)) {
            FileInformation fi;
            if (!file.isDirectory() && ((fi = cache.getCachedStatus(file)) == null || (fi.getStatus() & 0x1000) == 0)) continue;
            cache.refresh(file, null);
        }
        if (support.isCanceled()) {
            return;
        }
        if (revertNewFiles) {
            VCSFileProxy[] newfiles;
            for (VCSFileProxy file : newfiles = Subversion.getInstance().getStatusCache().listFiles(ctx.getRootFiles(), 4100)) {
                if (onlySelectedFiles && !ctx.getRoots().contains(file)) continue;
                FileObject fo = file.toFileObject();
                try {
                    if (fo == null) continue;
                    fo.delete();
                }
                catch (IOException ex) {
                    Subversion.LOG.log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    private static List<VCSFileProxy> getDeletedParents(VCSFileProxy file) {
        ArrayList<VCSFileProxy> ret = new ArrayList<VCSFileProxy>();
        for (VCSFileProxy parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            FileInformation info = Subversion.getInstance().getStatusCache().getStatus(parent);
            if ((info.getStatus() & 0x100) == 0 && (info.getStatus() & 0x800) == 0) {
                return ret;
            }
            ret.add(parent);
        }
        return ret;
    }

    private static RevertModifications.RevisionInterval recountStartRevision(Context context, SvnClient client, SVNUrl repository, RevertModifications.RevisionInterval ret) throws SVNClientException {
        long currStartRevNum;
        SVNRevision currStartRevision = ret.startRevision;
        SVNRevision currEndRevision = ret.endRevision;
        if (currStartRevision.equals(SVNRevision.HEAD)) {
            ISVNInfo info = client.getInfo(context, repository);
            currStartRevision = info.getRevision();
        }
        long newStartRevNum = (currStartRevNum = Long.parseLong(currStartRevision.toString())) > 0L ? currStartRevNum - 1L : currStartRevNum;
        return new RevertModifications.RevisionInterval(new SVNRevision.Number(newStartRevNum), currEndRevision);
    }
}

