/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.search;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.search.SearchParams;

public final class MatchingFileData {
    private final SearchParams params;
    private final String path;
    private final String fname;
    private List<Entry> entries = null;
    private Integer size = -1;

    public MatchingFileData(SearchParams params, String path) {
        this.params = params;
        this.path = path;
        this.fname = path.substring(1 + path.lastIndexOf(47));
    }

    public String getPath() {
        return this.path;
    }

    public String getFileName() {
        return this.fname;
    }

    public void setFileSize(Integer size) {
        this.size = size;
    }

    public Integer getSize() {
        return this.size;
    }

    public List<Entry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public SearchParams getSearchParams() {
        return this.params;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    public boolean hasEntries() {
        return this.entries != null && !this.entries.isEmpty();
    }

    public static class Entry {
        private final int line;
        private final String context;

        public Entry(int line, String context) {
            this.line = line;
            this.context = context;
        }

        public int getLineNumber() {
            return this.line;
        }

        public String getContext() {
            return this.context;
        }
    }
}

