/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.search.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.modules.cnd.search.MatchingFileData;
import org.netbeans.modules.cnd.search.SearchParams;
import org.netbeans.modules.cnd.search.Searcher;

public final class UnixFindBasedSearcher
implements Searcher {
    private static final Pattern grepOutPattern = Pattern.compile("^([0-9]+):(.*)");
    private final SearchParams params;
    private final SearchRoot root;
    private String rootPath;
    private List<MatchingFileData.Entry> entries;

    public UnixFindBasedSearcher(SearchRoot root, SearchParams params) {
        this.params = params;
        this.root = root;
    }

    @Override
    public String getCommand() {
        return "find";
    }

    @Override
    public String[] getCommandArguments() {
        SearchPattern sp;
        String searchText;
        ArrayList<String> args = new ArrayList<String>();
        this.rootPath = this.root.getFileObject().getPath();
        args.add(this.rootPath);
        args.add("-type");
        args.add("f");
        String fileNamePattern = this.params.getFileNamePattern();
        if (fileNamePattern != null && !fileNamePattern.isEmpty()) {
            args.add("-name");
            args.add(fileNamePattern);
        }
        if ((searchText = (sp = this.params.getSearchPattern()).getSearchExpression()) != null && !searchText.isEmpty()) {
            args.add("-exec");
            args.add("grep");
            if (!sp.isMatchCase()) {
                args.add("-i");
            }
            if (sp.isWholeWords()) {
                args.add("-w");
            }
            args.add("-n");
            args.add(searchText);
            args.add("{}");
            args.add(";");
        }
        args.add("-ls");
        return args.toArray(new String[args.size()]);
    }

    @Override
    public MatchingFileData processOutputLine(String line) {
        Matcher m = grepOutPattern.matcher(line);
        if (m.matches()) {
            Integer lineNo = Integer.parseInt(m.group(1));
            String context = m.group(2);
            if (this.entries == null) {
                this.entries = new ArrayList<MatchingFileData.Entry>(10);
            }
            this.entries.add(new MatchingFileData.Entry(lineNo, context));
            return null;
        }
        String[] data = line.split("[ \t]+", 11);
        if (data.length != 11) {
            return null;
        }
        String fname = data[10];
        if (fname.contains(" -> ")) {
            fname = fname.substring(0, fname.indexOf(" -> "));
        }
        MatchingFileData result = new MatchingFileData(this.params, fname);
        int fileSize = -1;
        try {
            fileSize = Integer.parseInt(data[6]);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        result.setFileSize(fileSize);
        result.setEntries(this.entries);
        this.entries = null;
        return result;
    }
}

