/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class FsSkewNotifier {
    private static final FsSkewNotifier INSTANCE = new FsSkewNotifier();
    private final Set<ExecutionEnvironment> alreadyNotified = new HashSet<ExecutionEnvironment>();
    private final Object lock = new Object();

    private FsSkewNotifier() {
    }

    public static FsSkewNotifier getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(final ExecutionEnvironment env, final long fsSkew) {
        Object object = this.lock;
        synchronized (object) {
            if (this.alreadyNotified.contains(env)) {
                return;
            }
            this.alreadyNotified.add(env);
        }
        Runnable edtRunner = new Runnable(){

            @Override
            public void run() {
                String envString = env.getDisplayName();
                Object text = null;
                String title = NbBundle.getMessage(FsSkewNotifier.class, (String)"FS_Skew_Title", (Object)envString);
                ImageIcon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/remote/sync/exclamation.gif", (boolean)false);
                CharSequence skewString = FsSkewNotifier.secondsToString(fsSkew);
                skewString = fsSkew > 0L ? NbBundle.getMessage(FsSkewNotifier.class, (String)"FS_Skew_Faster", (Object)skewString) : NbBundle.getMessage(FsSkewNotifier.class, (String)"FS_Skew_Slower", (Object)skewString);
                String details = NbBundle.getMessage(FsSkewNotifier.class, (String)"FS_Skew_Details", (Object)envString, (Object)skewString);
                JComponent baloonComponent = FsSkewNotifier.this.createDetails(details);
                JComponent popupComponent = FsSkewNotifier.this.createDetails(details);
                Notification n = NotificationDisplayer.getDefault().notify(title, (Icon)icon, baloonComponent, popupComponent, NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.WARNING);
            }
        };
        SwingUtilities.invokeLater(edtRunner);
    }

    private JComponent createDetails(String explanationText) {
        JPanel res = new JPanel(new BorderLayout());
        JLabel text = new JLabel(explanationText);
        text.setBorder(BorderFactory.createEmptyBorder(0, 0, 6, 0));
        res.add((Component)text, "Center");
        res.setOpaque(false);
        return res;
    }

    private static CharSequence secondsToString(long skew) {
        long seconds = skew % 60L;
        long minutes = skew / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        StringBuilder sb = new StringBuilder();
        String[] unitNamesSingle = new String[]{NbBundle.getMessage(FsSkewNotifier.class, (String)"FS_Skew_Day"), NbBundle.getMessage(FsSkewNotifier.class, (String)"FS_Skew_Hour"), NbBundle.getMessage(FsSkewNotifier.class, (String)"FS_Skew_Minute"), NbBundle.getMessage(FsSkewNotifier.class, (String)"FS_Skew_Second")};
        String[] unitNamesPlural = new String[]{NbBundle.getMessage(FsSkewNotifier.class, (String)"FS_Skew_Days"), NbBundle.getMessage(FsSkewNotifier.class, (String)"FS_Skew_Hours"), NbBundle.getMessage(FsSkewNotifier.class, (String)"FS_Skew_Minutes"), NbBundle.getMessage(FsSkewNotifier.class, (String)"FS_Skew_Seconds")};
        long[] unitVlues = new long[]{days, hours %= 24L, minutes %= 60L, seconds};
        assert (unitNamesSingle.length == unitVlues.length);
        String comma = NbBundle.getMessage(FsSkewNotifier.class, (String)"FS_Skew_Comma");
        String and = NbBundle.getMessage(FsSkewNotifier.class, (String)"FS_Skew_And");
        for (int i = 0; i < unitVlues.length; ++i) {
            if (unitVlues[i] <= 0L) continue;
            if (sb.length() > 0) {
                if (i == unitVlues.length - 1) {
                    sb.append(' ');
                    sb.append(and);
                } else {
                    sb.append(comma);
                }
                sb.append(' ');
            }
            String unitName = unitVlues[i] > 1L ? unitNamesPlural[i] : unitNamesSingle[i];
            sb.append(unitVlues[i]).append(' ').append(unitName);
        }
        return sb;
    }
}

