/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.remote.sync.SyncUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileSystem;

class SharedSyncWorker
implements RemoteSyncWorker {
    private final File[] files;
    private final FSPath[] fsPaths;
    private final FileSystem fileSystem;
    private final String workingDir;
    private final ExecutionEnvironment executionEnvironment;

    public SharedSyncWorker(ExecutionEnvironment executionEnvironment, PrintWriter out, PrintWriter err, String workingDir, List<FSPath> paths, List<FSPath> buildResults) {
        this.fileSystem = SyncUtils.getSingleFileSystem(paths);
        this.fsPaths = paths.toArray(new FSPath[paths.size()]);
        this.files = SyncUtils.toFiles(this.fsPaths);
        this.executionEnvironment = executionEnvironment;
        this.workingDir = workingDir;
    }

    public boolean startup(Map<String, String> env2add) {
        if (SyncUtils.isDoubleRemote(this.executionEnvironment, this.fileSystem)) {
            SyncUtils.warnDoubleRemote(this.executionEnvironment, this.fileSystem);
            return false;
        }
        PathMap mapper = HostInfoProvider.getMapper((ExecutionEnvironment)this.executionEnvironment);
        if (this.files != null && this.files.length > 0) {
            File[] filesToCheck;
            if (this.workingDir == null || !new File(this.workingDir).exists()) {
                filesToCheck = this.files;
            } else {
                filesToCheck = new File[this.files.length + 1];
                System.arraycopy(this.files, 0, filesToCheck, 0, this.files.length);
                filesToCheck[this.files.length] = new File(this.workingDir);
            }
            return mapper.checkRemotePaths(SharedSyncWorker.filterInexistent(filesToCheck), true);
        }
        return true;
    }

    private static File[] filterInexistent(File[] files) {
        boolean inexistentFound = false;
        for (File file : files) {
            if (file.exists()) continue;
            inexistentFound = true;
            break;
        }
        if (inexistentFound) {
            ArrayList<File> l = new ArrayList<File>();
            for (File file : files) {
                if (!file.exists()) continue;
                l.add(file);
            }
            return l.toArray(new File[l.size()]);
        }
        return files;
    }

    public void shutdown() {
    }

    public boolean cancel() {
        return false;
    }
}

