/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync.download;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

class HostUpdatesPersistence {
    private final Properties data = new Properties();
    private final FileObject dataFile;
    private static final String VERSION = "1.0";
    private static final String VERSION_KEY = "____VERSION";

    public HostUpdatesPersistence(FileObject privProjectStorageDir, ExecutionEnvironment executionEnvironment) throws IOException {
        String dataFileName = "downloads-" + executionEnvironment.getHost() + '-' + executionEnvironment.getUser() + '-' + executionEnvironment.getSSHPort();
        this.dataFile = FileUtil.createData((FileObject)privProjectStorageDir, (String)dataFileName);
        try {
            this.load();
            if (!VERSION.equals(this.data.get(VERSION_KEY))) {
                this.data.clear();
            }
        }
        catch (IOException ex) {
            this.data.clear();
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() throws IOException {
        if (this.dataFile.isValid()) {
            InputStream is = this.dataFile.getInputStream();
            try (BufferedInputStream bs = new BufferedInputStream(is);){
                this.data.load(bs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"RV"})
    public void store() {
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(this.dataFile.getOutputStream());
            this.data.setProperty(VERSION_KEY, VERSION);
            this.data.store(os, null);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            try {
                this.dataFile.delete();
            }
            catch (IOException ex2) {
                System.err.printf("Error deleting file %s%n", this.dataFile.getPath());
            }
        }
        finally {
            if (os != null) {
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean getFileSelected(File file, boolean defaultValue) {
        return this.getBoolean(file.getAbsolutePath(), defaultValue);
    }

    public void setFileSelected(File file, boolean selected) {
        this.setBoolean(file.getAbsolutePath(), selected);
    }

    public boolean getRememberChoice() {
        return this.getBoolean("", false);
    }

    public void setRememberChoice(boolean value) {
        this.setBoolean("", value);
    }

    private boolean getBoolean(String key, boolean defaultValue) {
        Object value = this.data.get(key);
        if ("1".equals(value)) {
            return true;
        }
        if ("0".equals(value)) {
            return false;
        }
        return defaultValue;
    }

    private void setBoolean(String key, boolean value) {
        this.data.put(key, value ? "1" : "0");
    }
}

