/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui.wizard;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsCacheManager;
import org.netbeans.modules.cnd.remote.server.RemoteServerList;
import org.netbeans.modules.cnd.remote.server.RemoteServerRecord;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.ui.setup.StopWatch;
import org.netbeans.modules.cnd.spi.remote.setup.HostValidator;
import org.netbeans.modules.cnd.spi.remote.setup.RemoteSyncFactoryDefaultProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class HostValidatorImpl
implements HostValidator {
    private final ToolsCacheManager cacheManager;
    private volatile Runnable runOnFinish;
    private volatile Thread compilerSearchThread;
    private volatile boolean compilerSearchCancelled;
    private volatile CompilerSetManager csm;

    public HostValidatorImpl(ToolsCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public Runnable getRunOnFinish() {
        return this.runOnFinish;
    }

    public ToolsCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public void cancelToolSearch() {
        Thread th;
        this.compilerSearchCancelled = true;
        CompilerSetManager csmCopy = this.csm;
        if (csmCopy != null) {
            csmCopy.cancel();
        }
        if ((th = this.compilerSearchThread) != null) {
            th.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validate(ExecutionEnvironment env, boolean searchForTools, PrintWriter writer) {
        this.compilerSearchThread = null;
        this.compilerSearchCancelled = false;
        RemoteServerRecord record = (RemoteServerRecord)ServerList.get((ExecutionEnvironment)env);
        record.setNeedsValidationOnConnect(false);
        try {
            boolean bl = this.validateImpl(record, searchForTools, writer);
            return bl;
        }
        finally {
            record.setNeedsValidationOnConnect(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateImpl(RemoteServerRecord record, boolean searchForTools, final PrintWriter writer) {
        StopWatch sw;
        ExecutionEnvironment env = record.getExecutionEnvironment();
        boolean result = false;
        boolean alreadyOnline = record.isOnline();
        if (alreadyOnline) {
            String message = NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel2.MsgAlreadyConnected1");
            message = String.format(message, env.toString());
            writer.printf("%s", message);
        } else {
            record.resetOfflineState();
        }
        if (!alreadyOnline) {
            writer.print(NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel2.MsgConnectingTo", (Object)env.getHost()));
        }
        try {
            sw = StopWatch.createAndStart(RemoteServerList.TRACE_SETUP, "#HostSetup", env, "connecting", new Object[0]);
            ConnectionManager.getInstance().connectTo(env);
            sw.stop();
        }
        catch (InterruptedIOException | ConnectionManager.CancellationException ex) {
            return false;
        }
        catch (IOException ex) {
            writer.print("\n" + RemoteUtil.getMessage(ex));
            return false;
        }
        if (!alreadyOnline) {
            writer.print(NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel2.MsgDone") + '\n');
            writer.print(NbBundle.getMessage(this.getClass(), (String)"CSM_ConfHost") + '\n');
            sw = StopWatch.createAndStart(RemoteServerList.TRACE_SETUP, "#HostSetup", env, "record.init", new Object[0]);
            record.init(null);
            sw.stop();
        }
        if (record.isOnline()) {
            Writer reporter = new Writer(){

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    String value = new String(cbuf, off, len);
                    writer.print(value);
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            };
            if (searchForTools && !this.compilerSearchCancelled) {
                this.compilerSearchThread = Thread.currentThread();
                try {
                    this.csm = this.cacheManager.getCompilerSetManagerCopy(env, false);
                    StopWatch sw2 = StopWatch.createAndStart(RemoteServerList.TRACE_SETUP, "#HostSetup", env, "CompilerSetManager.initialize", new Object[0]);
                    this.csm.initialize(false, false, reporter);
                    sw2.stop();
                    if (record.hasProblems()) {
                        try {
                            reporter.append(record.getProblems());
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    final CompilerSetManager csmCopy = this.csm;
                    this.runOnFinish = new Runnable(){

                        @Override
                        public void run() {
                            if (!HostValidatorImpl.this.compilerSearchCancelled) {
                                csmCopy.finishInitialization();
                            }
                        }
                    };
                }
                finally {
                    this.csm = null;
                    this.compilerSearchThread = null;
                }
                result = true;
            } else {
                writer.write(NbBundle.getMessage(this.getClass(), (String)"HostValidator.Toolchain.Search.Skipped") + '\n');
                result = true;
            }
        } else {
            writer.write(NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel2.ErrConn") + '\n' + record.getReason());
        }
        if (alreadyOnline) {
            writer.write('\n' + NbBundle.getMessage(this.getClass(), (String)"CreateHostVisualPanel2.MsgAlreadyConnected2"));
        } else {
            RemoteSyncFactoryDefaultProvider rsfdp = (RemoteSyncFactoryDefaultProvider)Lookup.getDefault().lookup(RemoteSyncFactoryDefaultProvider.class);
            if (rsfdp != null) {
                record.setSyncFactory(rsfdp.getDefaultFactory(env));
            }
        }
        return result;
    }
}

