/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.grammar;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.api.MavenConfiguration;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.grammar.POMDataObject;
import org.netbeans.modules.maven.grammar.ShowEffPomDiffPanel;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

class ShowEffPomDiffAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ShowEffPomDiffAction.class.getName());
    private static final String ICON = "org/netbeans/modules/maven/grammar/diffSettingsIcon.gif";
    private final Lookup lookup;

    ShowEffPomDiffAction(Lookup lookup) {
        this.putValue("Name", "Show diff");
        this.putValue("SmallIcon", ImageUtilities.loadImage((String)ICON));
        this.putValue("ShortDescription", "Show diff between the current effective pom and alternate ones");
        this.lookup = lookup;
    }

    void calculateEnabledState() {
        FileObject pom = (FileObject)this.lookup.lookup(FileObject.class);
        if (pom != null) {
            Project p = null;
            try {
                NbMavenProject nbmp;
                p = ProjectManager.getDefault().findProject(pom.getParent());
                if (p != null && ((nbmp = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class)) == null || nbmp.isUnloadable())) {
                    p = null;
                }
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, ex.getMessage(), ex);
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.FINE, ex.getMessage(), ex);
            }
            this.setEnabled(p != null);
        } else {
            this.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileObject pom = (FileObject)this.lookup.lookup(FileObject.class);
        if (pom != null) {
            Project p = null;
            try {
                p = ProjectManager.getDefault().findProject(pom.getParent());
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, ex.getMessage(), ex);
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.FINE, ex.getMessage(), ex);
            }
            if (p != null) {
                final ProjectConfigurationProvider conf = (ProjectConfigurationProvider)p.getLookup().lookup(ProjectConfigurationProvider.class);
                ShowEffPomDiffPanel pnl = new ShowEffPomDiffPanel((ProjectConfigurationProvider<MavenConfiguration>)conf);
                DialogDescriptor dd = new DialogDescriptor((Object)pnl, "Select configurations/profiles to diff");
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
                    Model model2;
                    Model model;
                    NbMavenProject nbmp = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class);
                    final MavenConfiguration sel = pnl.isConfigurationSelected() ? pnl.getSelectedConfig() : null;
                    List<String> profiles = sel != null ? sel.getActivatedProfiles() : pnl.getSelectedProfiles();
                    Properties props = new Properties();
                    if (sel != null) {
                        props.putAll((Map<?, ?>)sel.getProperties());
                    } else {
                        props.putAll(pnl.getSelectedProperties());
                    }
                    if (nbmp != null) {
                        model = nbmp.getMavenProject().getModel();
                        if (model == null || nbmp.isUnloadable()) {
                            // empty if block
                        }
                        model2 = nbmp.loadAlternateMavenProject(EmbedderFactory.getProjectEmbedder(), profiles, props).getModel();
                    } else {
                        model = null;
                        model2 = null;
                    }
                    StreamSource ss = new StreamSource(){

                        public String getName() {
                            return "Current";
                        }

                        public String getTitle() {
                            return "Current Project Effective POM (configuration: " + ((MavenConfiguration)conf.getActiveConfiguration()).getDisplayName() + ")";
                        }

                        public String getMIMEType() {
                            return "text/x-maven-pom+xml";
                        }

                        public Reader createReader() throws IOException {
                            StringWriter sw = new StringWriter();
                            new MavenXpp3Writer().write((Writer)sw, model);
                            return new StringReader(sw.toString());
                        }

                        public Writer createWriter(Difference[] conflicts) throws IOException {
                            return null;
                        }
                    };
                    StreamSource ss2 = new StreamSource(){

                        public String getName() {
                            return "Alternate";
                        }

                        public String getTitle() {
                            return "Alternate Effective POM (configuration: " + (sel != null ? sel.getDisplayName() : "<custom>") + ")";
                        }

                        public String getMIMEType() {
                            return "text/x-maven-pom+xml";
                        }

                        public Reader createReader() throws IOException {
                            StringWriter sw = new StringWriter();
                            new MavenXpp3Writer().write((Writer)sw, model2);
                            return new StringReader(sw.toString());
                        }

                        public Writer createWriter(Difference[] conflicts) throws IOException {
                            return null;
                        }
                    };
                    if (model != null && model2 != null) {
                        ShowEffPomDiffAction.showDiff(ss, ss2, "Effective Diff - " + pom.getNameExt() + POMDataObject.annotateWithProjectName(pom));
                    }
                }
            }
        }
    }

    public static void showDiff(final StreamSource before, final StreamSource after, final String tcName) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DiffView view = Diff.getDefault().createDiff(before, after);
                    DiffTopComponent tc = new DiffTopComponent(view);
                    tc.setName(tcName);
                    tc.setDisplayName(tcName);
                    tc.open();
                    tc.requestActive();
                }
                catch (IOException x) {
                    LOG.log(Level.INFO, null, x);
                }
            }
        });
    }

    private static class DiffTopComponent
    extends TopComponent {
        DiffTopComponent(DiffView view) {
            this.setLayout(new BorderLayout());
            this.add(view.getComponent(), "Center");
        }

        public int getPersistenceType() {
            return 2;
        }

        protected String preferredID() {
            return "DiffTopComponent";
        }
    }
}

