/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.remote;

import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.debugger.common2.debugger.Log;
import org.netbeans.modules.cnd.debugger.common2.debugger.remote.CustomizableHost;
import org.netbeans.modules.cnd.debugger.common2.utils.masterdetail.RecordList;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionSetXMLCodec;
import org.xml.sax.Attributes;

class HostListXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private RecordList<CustomizableHost> model;
    private OptionSetXMLCodec optionsXMLCodec;
    private CustomizableHost currentHost;
    private static final String TAG_REMOTEHOST = "host";
    private static final String TAG_REMOTEHOSTS = "hosts";
    private static final String ATTR_ID = "id";

    HostListXMLCodec(RecordList<CustomizableHost> model) {
        this.model = model;
    }

    private static int version() {
        return 1;
    }

    protected String tag() {
        return TAG_REMOTEHOSTS;
    }

    public void start(Attributes atts) throws VersionException {
    }

    public void end() {
    }

    public void startElement(String element, Attributes atts) {
        String id = atts.getValue(ATTR_ID);
        if (Log.XML.debug) {
            System.out.println(" HostListXMLCodec startElement: element " + element);
            System.out.println(" HostListXMLCodec startElement: id" + id);
        }
        if (element.equals(TAG_REMOTEHOST)) {
            this.currentHost = new CustomizableHost();
            this.optionsXMLCodec = new OptionSetXMLCodec(this.currentHost.getOptions());
            this.model.appendRecord(this.currentHost);
        }
        this.optionsXMLCodec.startElement(element, atts);
    }

    public void endElement(String element, String currentText) {
        if (Log.XML.debug) {
            System.out.println(" HostListXMLCodec endElement: element " + element);
            System.out.println(" HostListXMLCodec endElement: currentText " + currentText);
        }
        this.optionsXMLCodec.endElement(element, currentText);
    }

    public void encode(XMLEncoderStream xes) {
        xes.elementOpen(TAG_REMOTEHOSTS, HostListXMLCodec.version());
        for (CustomizableHost host : this.model) {
            String hostName = host.getHostName();
            if (hostName.equals("localhost")) continue;
            AttrValuePair[] id_attr = new AttrValuePair[]{new AttrValuePair(ATTR_ID, hostName)};
            xes.elementOpen(TAG_REMOTEHOST, id_attr);
            this.optionsXMLCodec = new OptionSetXMLCodec(host.getOptions());
            this.optionsXMLCodec.encode(xes);
            xes.elementClose(TAG_REMOTEHOST);
        }
        xes.elementClose(TAG_REMOTEHOSTS);
    }
}

