/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils;

import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.util.Utilities;

public abstract class FileMapper {
    public static FileMapper getDefault() {
        if (Utilities.isWindows()) {
            return CygwinFileMapper.INSTANCE;
        }
        return NullFileMapper.INSTANCE;
    }

    public static FileMapper getByType(Type kind) {
        switch (kind) {
            case NULL: {
                return NullFileMapper.INSTANCE;
            }
            case CYGWIN: {
                return CygwinFileMapper.INSTANCE;
            }
            case MSYS: {
                return MSysFileMapper.INSTANCE;
            }
        }
        return NullFileMapper.INSTANCE;
    }

    public abstract String worldToEngine(String var1);

    public abstract String engineToWorld(String var1);

    private FileMapper() {
    }

    private static class MSysFileMapper
    extends FileMapper {
        private static MSysFileMapper INSTANCE = new MSysFileMapper();

        private MSysFileMapper() {
        }

        @Override
        public String engineToWorld(String path) {
            if (path == null) {
                return null;
            }
            String res = WindowsSupport.getInstance().convertFromMSysPath(path);
            if (res != null) {
                return res;
            }
            return path;
        }

        @Override
        public String worldToEngine(String path) {
            return path;
        }
    }

    private static class CygwinFileMapper_old
    extends FileMapper {
        private static final String prefix = "/cygdrive/";
        private static final int prefixLen = "/cygdrive/".length();

        private CygwinFileMapper_old() {
        }

        @Override
        public String worldToEngine(String path) {
            String newPath = path;
            if (path.charAt(1) == ':') {
                char disk = path.charAt(0);
                String rest = path.substring(2);
                newPath = prefix + disk + CygwinFileMapper_old.separatorToUnix(rest);
            }
            System.out.println("CygwinFileMapper.worldToEngine():\n\tFrom: " + path + "\n" + "\t  To: " + newPath + "\n");
            return newPath;
        }

        @Override
        public String engineToWorld(String path) {
            String newPath = path;
            if (path.startsWith(prefix)) {
                char disk = path.charAt(10);
                newPath = "" + disk + ":" + path.substring(prefixLen + 1);
                newPath = CygwinFileMapper_old.separatorToWindows(newPath);
            }
            System.out.println("CygwinFileMapper.engineToWorld():\n\tFrom: " + path + "\n" + "\t  To: " + newPath + "\n");
            return newPath;
        }

        private static String separatorToWindows(String s) {
            StringBuilder sb = new StringBuilder();
            block3: for (int sx = 0; sx < s.length(); ++sx) {
                char c = s.charAt(sx);
                switch (c) {
                    case '/': {
                        sb.append('\\');
                        continue block3;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }

        private static String separatorToUnix(String s) {
            StringBuilder sb = new StringBuilder();
            block3: for (int sx = 0; sx < s.length(); ++sx) {
                char c = s.charAt(sx);
                switch (c) {
                    case '\\': {
                        sb.append('/');
                        continue block3;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }
    }

    private static class CygwinFileMapper
    extends FileMapper {
        private static CygwinFileMapper INSTANCE = new CygwinFileMapper();

        private CygwinFileMapper() {
        }

        @Override
        public String engineToWorld(String path) {
            if (path == null) {
                return null;
            }
            String res = WindowsSupport.getInstance().convertFromCygwinPath(path);
            if (res != null) {
                return res;
            }
            return path;
        }

        @Override
        public String worldToEngine(String path) {
            if (path == null) {
                return null;
            }
            String res = WindowsSupport.getInstance().convertToCygwinPath(path);
            if (res != null) {
                return res;
            }
            return path;
        }
    }

    private static class NullFileMapper
    extends FileMapper {
        private static NullFileMapper INSTANCE = new NullFileMapper();

        private NullFileMapper() {
        }

        @Override
        public String worldToEngine(String path) {
            return path;
        }

        @Override
        public String engineToWorld(String path) {
            return path;
        }
    }

    public static enum Type {
        NULL,
        CYGWIN,
        MSYS;

    }
}

