/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.utils.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.debugger.common2.utils.options.OptionPropertySupport;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileSystem;

class OptionDirectoryEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private OptionPropertySupport ops;
    private final String baseDir;
    private final FileSystem fileSystem;
    private PropertyEnv env;
    private int dirOrFile;

    public OptionDirectoryEditor(OptionPropertySupport ops, String baseDir, int dirOrFile) {
        this(ops, baseDir, dirOrFile, FileSystemProvider.getFileSystem((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()));
    }

    public OptionDirectoryEditor(OptionPropertySupport ops, String baseDir, int dirOrFile, FileSystem fileSystem) {
        this.ops = ops;
        this.baseDir = baseDir;
        this.dirOrFile = dirOrFile;
        this.fileSystem = fileSystem;
    }

    @Override
    public void setAsText(String text) {
        this.setValue(text);
    }

    @Override
    public String getAsText() {
        return (String)this.getValue();
    }

    @Override
    public void setValue(Object v) {
        this.ops.setValue(v);
    }

    @Override
    public Object getValue() {
        Object o = this.ops.getValue();
        return o;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return new DirectoryChooser(this, this.env, this.dirOrFile, this.baseDir, (String)this.ops.getValue(), this.fileSystem);
    }

    public void attachEnv(PropertyEnv env) {
        this.env = env;
    }

    private static class DirectoryChooser
    extends JPanel
    implements PropertyChangeListener {
        private final PropertyEditorSupport editor;
        private final String baseDir;
        private final JFileChooser fileChooser;

        private static String fullPath(String baseDir, String path) {
            if (baseDir == null) {
                return CndPathUtilities.isPathAbsolute((CharSequence)path) ? path : null;
            }
            String seed = path;
            if (seed.length() == 0) {
                seed = ".";
            }
            if (!CndPathUtilities.isPathAbsolute((CharSequence)seed)) {
                seed = baseDir + File.separatorChar + seed;
            }
            return seed;
        }

        public DirectoryChooser(PropertyEditorSupport editor, PropertyEnv env, int dirOrFile, String baseDir, String path, FileSystem fileSystem) {
            this.fileChooser = RemoteFileUtil.isRemote((FileSystem)fileSystem) ? RemoteFileUtil.createFileChooser((FileSystem)fileSystem, (String)"Experiment Directory", (String)"Select", (int)dirOrFile, null, (String)DirectoryChooser.fullPath(baseDir, path), (boolean)true) : new FileChooser("Experiment Directory", "Select", dirOrFile, null, DirectoryChooser.fullPath(baseDir, path), true);
            this.editor = editor;
            this.baseDir = baseDir;
            this.fileChooser.setControlButtonsAreShown(false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.fileChooser, "Center");
            env.setState(PropertyEnv.STATE_NEEDS_VALIDATION);
            env.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            File file;
            if ("state".equals(evt.getPropertyName()) && evt.getNewValue() == PropertyEnv.STATE_VALID && (file = this.fileChooser.getSelectedFile()) != null) {
                String path = file.getAbsolutePath();
                this.editor.setValue(path);
            }
        }
    }
}

