/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglib;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.netbeans.modules.web.taglib.TLDEditorSupport;
import org.netbeans.modules.web.taglib.TLDNode;
import org.netbeans.modules.web.taglib.model.Taglib;
import org.netbeans.modules.xml.api.XmlFileEncodingQueryImpl;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.xml.sax.InputSource;

public final class TLDDataObject
extends MultiDataObject
implements CookieSet.Factory {
    private static final boolean debug = false;
    private volatile transient TLDEditorSupport editorSupport;
    private static final long serialVersionUID = -7581377241494497816L;

    public static MultiViewEditorElement createMultiViewEditorElement(Lookup context) {
        return new MultiViewEditorElement(context);
    }

    public TLDDataObject() throws DataObjectExistsException, IOException {
        super(null, null);
    }

    public TLDDataObject(FileObject obj, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(obj, loader);
        this.getCookieSet().add(TLDEditorSupport.class, (CookieSet.Factory)this);
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkCookie = new CheckXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)checkCookie);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)validateCookie);
        this.getCookieSet().assign(FileEncodingQueryImplementation.class, (Object[])new FileEncodingQueryImplementation[]{XmlFileEncodingQueryImpl.singleton()});
    }

    protected synchronized Node createNodeDelegate() {
        return new TLDNode(this);
    }

    protected int associateLookup() {
        return 1;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Taglib getTaglib() throws IOException {
        Taglib taglib;
        InputStream is = this.getPrimaryFile().getInputStream();
        try {
            taglib = Taglib.createGraph(is);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (RuntimeException ex) {
                throw new IOException(ex.getMessage());
            }
        }
        is.close();
        return taglib;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Taglib taglib) throws IOException {
        File file = FileUtil.toFile((FileObject)this.getPrimaryFile());
        FileObject tldFO = this.getPrimaryFile();
        try {
            FileLock lock = tldFO.lock();
            try (OutputStream os = tldFO.getOutputStream(lock);){
                String version = taglib.getAttributeValue("version");
                if (version == null) {
                    taglib.changeDocType("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", "http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd");
                    taglib.setAttributeValue("xmlns", null);
                }
                taglib.write(os);
            }
            finally {
                lock.releaseLock();
            }
        }
        catch (FileAlreadyLockedException ex) {
            // empty catch block
        }
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(TLDEditorSupport.class)) {
            return this.getEditorSupport();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TLDEditorSupport getEditorSupport() {
        if (this.editorSupport == null) {
            TLDDataObject tLDDataObject = this;
            synchronized (tLDDataObject) {
                if (this.editorSupport == null) {
                    this.editorSupport = new TLDEditorSupport(this);
                }
            }
        }
        return this.editorSupport;
    }
}

