/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging.api.console;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ConsoleMessage {
    private final JSONObject msg;
    private List<StackFrame> stackTrace;
    private boolean stackTraceLoaded;

    ConsoleMessage(JSONObject msg) {
        this.msg = msg;
    }

    public String getSource() {
        if (this.msg != null) {
            return (String)this.msg.get((Object)"source");
        }
        return "";
    }

    public String getLevel() {
        if (this.msg != null) {
            return (String)this.msg.get((Object)"level");
        }
        return "";
    }

    public String getType() {
        if (this.msg != null) {
            return (String)this.msg.get((Object)"type");
        }
        return "";
    }

    public String getText() {
        if (this.msg != null) {
            return (String)this.msg.get((Object)"text");
        }
        return "";
    }

    public String getURLString() {
        if (this.msg != null) {
            return (String)this.msg.get((Object)"url");
        }
        return "";
    }

    public int getLine() {
        Number n;
        if (this.msg != null && (n = (Number)this.msg.get((Object)"line")) != null) {
            return n.intValue();
        }
        return -1;
    }

    public List<StackFrame> getStackTrace() {
        if (this.msg == null) {
            return Collections.EMPTY_LIST;
        }
        if (!this.stackTraceLoaded) {
            JSONArray stack = (JSONArray)this.msg.get((Object)"stackTrace");
            if (stack != null && stack.size() > 0) {
                this.stackTrace = new ArrayList<StackFrame>();
                for (Object o : stack) {
                    JSONObject json = (JSONObject)o;
                    this.stackTrace.add(new StackFrame(json));
                }
            }
            this.stackTraceLoaded = true;
        }
        return this.stackTrace;
    }

    public List<ConsoleMessage> getSubMessages() {
        return Collections.EMPTY_LIST;
    }

    public static final class StackFrame {
        private JSONObject stack;

        public StackFrame(JSONObject stack) {
            this.stack = stack;
        }

        public String getFunctionName() {
            String s = (String)this.stack.get((Object)"functionName");
            if (s == null || s.isEmpty()) {
                s = "(anonymous function)";
            }
            return s;
        }

        public String getURLString() {
            return (String)this.stack.get((Object)"url");
        }

        public int getLine() {
            Number n = (Number)this.stack.get((Object)"lineNumber");
            if (n != null) {
                return n.intValue();
            }
            return -1;
        }

        public int getColumn() {
            Number n = (Number)this.stack.get((Object)"columnNumber");
            if (n != null) {
                return n.intValue();
            }
            return -1;
        }
    }
}

