/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.repository.api.RepositoryExceptions;
import org.netbeans.modules.cnd.repository.disk.FileStorage;
import org.netbeans.modules.cnd.repository.disk.IndexedStorageFile;
import org.netbeans.modules.cnd.repository.disk.index.ChunkInfo;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.LayerKey;
import org.netbeans.modules.cnd.repository.impl.spi.LayeringSupport;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.repository.testbench.WriteStatistics;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class DoubleFileStorage
implements FileStorage {
    private static final int MAINTENANCE_PERIOD = 10000;
    private long NextMaintainanceSize = 0x20000000L;
    private static final long SIZE_INCREASE_STEP = 0x10000000L;
    private final AtomicLong lastDefragmentationTime = new AtomicLong(0L);
    private final File baseDir;
    private final LayeringSupport layeringSupport;
    private final LayerDescriptor layerDescriptor;
    private IndexedStorageFile cache_0_dataFile;
    private IndexedStorageFile cache_1_dataFile;
    private final AtomicBoolean cache_1_dataFileIsActive = new AtomicBoolean();
    private boolean defragmenting = false;
    private boolean openedForWriting = false;
    private boolean opened = false;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    DoubleFileStorage(File baseDir, LayerDescriptor layerDescriptor, LayeringSupport layeringSupport) {
        this.baseDir = baseDir;
        this.layeringSupport = layeringSupport;
        this.layerDescriptor = layerDescriptor;
    }

    boolean isOpened() {
        return this.opened;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean open(boolean openForWriting) {
        if (this.cache_0_dataFile == null || openForWriting && !this.openedForWriting) {
            try {
                this.close();
            }
            catch (IOException ex) {
                RepositoryExceptions.throwException((Object)this, (Throwable)ex);
            }
            boolean writable = openForWriting;
            if (writable && !this.baseDir.isDirectory()) {
                this.baseDir.mkdirs();
            }
            IndexedStorageFile cache0 = null;
            IndexedStorageFile cache1 = null;
            try {
                boolean cache1IsEmpty;
                cache0 = new IndexedStorageFile(this.layeringSupport, this.layerDescriptor, this.baseDir, "cache-0", writable);
                cache1 = new IndexedStorageFile(this.layeringSupport, this.layerDescriptor, this.baseDir, "cache-1", writable);
                boolean cache0IsEmpty = cache0.getDataFileUsedSize() == 0L;
                boolean bl = cache1IsEmpty = cache1.getDataFileUsedSize() == 0L;
                if (cache0IsEmpty && !cache1IsEmpty) {
                    this.cache_1_dataFileIsActive.set(true);
                } else if (!cache0IsEmpty && !cache1IsEmpty) {
                    this.cache_1_dataFileIsActive.set(cache0.getFragmentationPercentage() > cache1.getFragmentationPercentage());
                } else {
                    this.cache_1_dataFileIsActive.set(false);
                }
            }
            catch (FileNotFoundException ex) {
                cache0 = null;
                boolean bl = false;
                return bl;
            }
            catch (IOException ex) {
                RepositoryExceptions.throwException((Object)this, (Throwable)ex);
            }
            finally {
                this.cache_0_dataFile = cache0;
                this.cache_1_dataFile = cache1;
            }
            if (this.cache_0_dataFile == null || this.cache_1_dataFile == null) {
                throw new InternalError("Unhandled situation - failed to create cache_N_dataFile for DoubleFileStorage");
            }
            if (openForWriting) {
                this.openedForWriting = true;
            }
        }
        this.opened = true;
        return true;
    }

    private boolean getFlag() {
        return this.cache_1_dataFileIsActive.get();
    }

    private IndexedStorageFile getFileByFlag(boolean flag) {
        return flag ? this.cache_1_dataFile : this.cache_0_dataFile;
    }

    private IndexedStorageFile getActive() {
        return this.cache_1_dataFileIsActive.get() ? this.cache_1_dataFile : this.cache_0_dataFile;
    }

    private IndexedStorageFile getPassive() {
        return this.cache_1_dataFileIsActive.get() ? this.cache_0_dataFile : this.cache_1_dataFile;
    }

    @Override
    public void close() throws IOException {
        if (this.cache_0_dataFile != null) {
            this.cache_0_dataFile.close();
        }
        if (this.cache_1_dataFile != null) {
            this.cache_1_dataFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasKey(LayerKey key) throws IOException {
        this.lock.readLock().lock();
        try {
            boolean activeFlag = this.getFlag();
            boolean hasKey = this.getFileByFlag(activeFlag).hasKey(key);
            if (hasKey) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.getFileByFlag(!activeFlag).hasKey(key);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer read(LayerKey key) throws IOException {
        this.lock.readLock().lock();
        try {
            boolean activeFlag = this.getFlag();
            ByteBuffer buffer = this.getFileByFlag(activeFlag).read(key);
            if (buffer == null) {
                buffer = this.getFileByFlag(!activeFlag).read(key);
            }
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private void maintainIfNeeded() {
        try {
            boolean activeFlag = this.getFlag();
            IndexedStorageFile activeFile = this.getFileByFlag(activeFlag);
            long activeFileSize = activeFile.getSize();
            long passiveFileSize = this.getFileByFlag(!activeFlag).getSize();
            int activeFileFragmentationPercentage = activeFile.getFragmentationPercentage();
            if ((activeFileSize >= this.NextMaintainanceSize || passiveFileSize >= this.NextMaintainanceSize) && System.currentTimeMillis() - this.lastDefragmentationTime.get() >= 10000L) {
                this.defragment(true, Stats.maintenanceInterval);
                if (activeFileSize >= this.NextMaintainanceSize && activeFileFragmentationPercentage < 40) {
                    if (Stats.traceDefragmentation) {
                        System.out.printf(">>> Active file size %d  total fragmentation %d%%\n", activeFileSize, activeFileFragmentationPercentage);
                        System.out.printf("\tWill increase file size maintanance trashold on 256Mb\n", new Object[0]);
                    }
                    this.NextMaintainanceSize += 0x10000000L;
                }
            }
        }
        catch (IOException ex) {
            RepositoryExceptions.throwException((Object)this, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(LayerKey key, ByteBuffer data) throws IOException {
        if (Stats.writeStatistics) {
            WriteStatistics.instance().update(1);
        }
        this.lock.writeLock().lock();
        try {
            this.maintainIfNeeded();
            boolean activeFlag = this.getFlag();
            this.getFileByFlag(activeFlag).write(key, data);
            this.getFileByFlag(!activeFlag).remove(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(LayerKey key) throws IOException {
        this.lock.writeLock().lock();
        try {
            boolean activeFlag = this.getFlag();
            this.getFileByFlag(activeFlag).remove(key);
            this.getFileByFlag(!activeFlag).remove(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean defragment(boolean doIt, long timeout) throws IOException {
        boolean needMoreTime = false;
        if (Stats.writeStatistics) {
            WriteStatistics.instance().update(0);
        }
        if (Stats.traceDefragmentation) {
            System.out.printf(">>> Defragmenting %s; timeout %d ms total fragmentation %d%%\n", this.baseDir.getAbsolutePath(), timeout, this.getFragmentationPercentage());
            System.out.printf("\tActive:  %s\n", this.getActive().getTraceString());
            System.out.printf("\tPassive: %s\n", this.getPassive().getTraceString());
        }
        if (timeout > 0L && !this.defragmenting && !doIt && this.getFragmentationPercentage() < Stats.defragmentationThreashold) {
            if (Stats.traceDefragmentation) {
                System.out.printf("\tFragmentation is too low\n", new Object[0]);
            }
            this.lastDefragmentationTime.set(System.currentTimeMillis());
            return needMoreTime;
        }
        if (!this.defragmenting) {
            this.defragmenting = true;
            this.cache_1_dataFileIsActive.set(!this.cache_1_dataFileIsActive.get());
        }
        long startTime = System.currentTimeMillis();
        needMoreTime = this._defragment(timeout);
        if (this.getPassive().getObjectsCount() == 0) {
            this.defragmenting = false;
        }
        if (Stats.traceDefragmentation) {
            System.out.printf("<<< Defragmenting %s; timeout %d ms total fragmentation %d%%\n", this.baseDir.getAbsolutePath(), System.currentTimeMillis() - startTime, this.getFragmentationPercentage());
            System.out.printf("\tActive:  %s\n", this.getActive().getTraceString());
            System.out.printf("\tPassive: %s\n", this.getPassive().getTraceString());
        }
        this.lastDefragmentationTime.set(System.currentTimeMillis());
        return needMoreTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void move(IndexedStorageFile from, IndexedStorageFile to, LayerKey key) throws IOException {
        this.lock.writeLock().lock();
        try {
            ChunkInfo chunk = from.getChunkInfo(key);
            to.moveDataFromOtherFile(from, chunk.getOffset(), chunk.getSize(), key);
            from.remove(key);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private boolean _defragment(long timeout) throws IOException {
        boolean needMoreTime = false;
        long time = timeout > 0L || Stats.traceDefragmentation ? System.currentTimeMillis() : 0L;
        int cnt = 0;
        boolean activeFlag = this.getFlag();
        IndexedStorageFile passiveFile = this.getFileByFlag(!activeFlag);
        IndexedStorageFile activeFile = this.getFileByFlag(activeFlag);
        Iterator<LayerKey> it = passiveFile.getKeySetIterator();
        while (it.hasNext()) {
            LayerKey key = it.next();
            ChunkInfo chunk = passiveFile.getChunkInfo(key);
            CndUtils.assertNotNull((Object)chunk, (String)("Null chunk when defragmenting " + passiveFile.getTraceString()));
            if (chunk == null) continue;
            this.move(passiveFile, activeFile, key);
            ++cnt;
        }
        if (Stats.traceDefragmentation) {
            String text = it.hasNext() ? " finished by timeout" : " completed";
            System.out.printf("\t # defragmentinging %s %s; moved: %d remaining: %d \n", this.getFileByFlag(!activeFlag).getDataFileName(), text, cnt, this.getFileByFlag(!activeFlag).getObjectsCount());
        }
        return needMoreTime;
    }

    @Override
    public void dump(PrintStream ps) throws IOException {
        ps.printf("\nDumping DoubleFileStorage; baseFile %s\n", this.baseDir.getAbsolutePath());
        ps.printf("\nActive file:\n", new Object[0]);
        boolean activeFlag = this.getFlag();
        this.getFileByFlag(activeFlag).dump(ps);
        ps.printf("\nPassive file:\n", new Object[0]);
        this.getFileByFlag(!activeFlag).dump(ps);
        ps.printf("\n", new Object[0]);
    }

    @Override
    public void dumpSummary(PrintStream ps) throws IOException {
        ps.printf("\nDumping DoubleFileStorage; baseFile %s\n", this.baseDir.getAbsolutePath());
        ps.printf("\nActive file:\n", new Object[0]);
        boolean activeFlag = this.getFlag();
        this.getFileByFlag(activeFlag).dumpSummary(ps);
        ps.printf("\nPassive file:\n", new Object[0]);
        this.getFileByFlag(!activeFlag).dumpSummary(ps);
        ps.printf("\n", new Object[0]);
    }

    public int getFragmentationPercentage() throws IOException {
        boolean activeFlag = this.getFlag();
        long fileSize = this.getFileByFlag(activeFlag).getSize() + this.getFileByFlag(!activeFlag).getSize();
        float delta = fileSize - (this.getFileByFlag(activeFlag).getDataFileUsedSize() + this.getFileByFlag(!activeFlag).getDataFileUsedSize());
        float percentage = delta * 100.0f / (float)fileSize;
        return Math.round(percentage);
    }

    public long getSize() throws IOException {
        boolean activeFlag = this.getFlag();
        return this.getFileByFlag(activeFlag).getSize() + this.getFileByFlag(!activeFlag).getSize();
    }

    @Override
    public int getObjectsCount() {
        boolean activeFlag = this.getFlag();
        return this.getFileByFlag(activeFlag).getObjectsCount() + this.getFileByFlag(!activeFlag).getObjectsCount();
    }

    @Override
    public void debugDump(LayerKey key) {
    }

    @Override
    public boolean maintenance(long timeout) throws IOException {
        if (this.cache_0_dataFile == null || this.cache_1_dataFile == null) {
            return true;
        }
        return this.defragment(false, timeout);
    }

    public String toString() {
        return "DblFileStorage: " + this.baseDir;
    }
}

