/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.repository.impl.spi.LayerKey;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public final class KeysListFile
implements SelfPersistent {
    private final List<LayerKey> list = new ArrayList<LayerKey>();

    public KeysListFile() {
    }

    public KeysListFile(RepositoryDataInput input) throws IOException {
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            this.list.add(LayerKey.read((RepositoryDataInput)input));
        }
    }

    public void put(LayerKey key) {
        this.list.add(key);
    }

    public void remove(LayerKey key) {
        this.list.remove(key);
    }

    public int size() {
        return this.list.size();
    }

    public Collection<LayerKey> keySet() {
        return Collections.unmodifiableList(this.list);
    }

    public Iterator<LayerKey> getKeySetIterator() {
        return Collections.unmodifiableCollection(this.list).iterator();
    }

    public void write(RepositoryDataOutput output) throws IOException {
        output.writeInt(this.size());
        Iterator<LayerKey> keySetIterator = this.getKeySetIterator();
        while (keySetIterator.hasNext()) {
            LayerKey.write((LayerKey)keySetIterator.next(), (RepositoryDataOutput)output);
        }
    }
}

