/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.storage.data;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.netbeans.modules.cnd.repository.impl.spi.LayerConvertersProvider;
import org.netbeans.modules.cnd.repository.impl.spi.LayerKey;
import org.netbeans.modules.cnd.repository.impl.spi.WriteLayerCapability;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.storage.data.UTF;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.filesystems.FileSystem;

public final class RepositoryDataOutputStream
extends DataOutputStream
implements RepositoryDataOutput {
    private final LayerConvertersProvider layersConverterProvider;
    private final WriteLayerCapability wc;
    private final LayerKey layerKey;
    private static final OutputStreamEx outputStream = new OutputStreamEx();

    private RepositoryDataOutputStream(OutputStream outputStream, LayerKey layerKey, WriteLayerCapability wc, LayerConvertersProvider layersConverterProvider) {
        super(outputStream);
        this.layersConverterProvider = layersConverterProvider;
        this.wc = wc;
        this.layerKey = layerKey;
    }

    public RepositoryDataOutputStream(LayerKey layerKey, WriteLayerCapability wc, LayerConvertersProvider layersConverterProvider) {
        this(outputStream.reset(), layerKey, wc, layersConverterProvider);
    }

    public RepositoryDataOutputStream(OutputStream outputStream, LayerConvertersProvider layersConverterProvider) {
        this(outputStream, null, null, layersConverterProvider);
    }

    public void writeCharSequenceUTF(CharSequence s) throws IOException {
        UTF.writeUTF(s, this);
    }

    public void writeUnitId(int unitId) throws IOException {
        int unitID = this.layersConverterProvider.getWriteUnitsConverter().clientToLayer(unitId);
        CndUtils.assertTrue((unitID > -1 ? 1 : 0) != 0, (String)"Impossible on disk unit id: ", (Object)unitID);
        this.writeInt(unitID);
    }

    public void writeFileSystem(FileSystem fileSystem) throws IOException {
        this.writeInt(this.layersConverterProvider.getWriteFSConverter().clientToLayer(fileSystem));
    }

    public void writeFilePath(CharSequence filePath) throws IOException {
        this.writeInt(this.layersConverterProvider.getWriteFilePathConverter().clientToLayer(filePath));
    }

    public void writeFilePathForFileSystem(FileSystem fileSystem, CharSequence filePath) throws IOException {
        this.writeFilePath(filePath);
    }

    public void commit() {
        if (this.wc != null && this.layerKey != null) {
            this.wc.write(this.layerKey, outputStream.getBuffer());
        }
    }

    private static class OutputStreamEx
    extends OutputStream {
        private ByteBuffer buffer = ByteBuffer.allocateDirect(1024);

        public OutputStreamEx reset() {
            this.buffer.clear();
            return this;
        }

        public ByteBuffer getBuffer() {
            ByteBuffer result = this.buffer;
            if (this.buffer.capacity() > 4096) {
                this.buffer = ByteBuffer.allocateDirect(1024);
            }
            result.flip();
            return result;
        }

        @Override
        public void write(int b) throws IOException {
            int newposition = this.buffer.position() + 1;
            if (newposition > this.buffer.capacity()) {
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(Math.max(this.buffer.capacity() << 1, newposition));
                this.buffer.flip();
                newBuffer.put(this.buffer);
                this.buffer = newBuffer;
            }
            this.buffer.put((byte)b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            assert (off == 0);
            int newposition = this.buffer.position() + len;
            if (newposition > this.buffer.capacity()) {
                ByteBuffer newBuffer = ByteBuffer.allocateDirect(Math.max(this.buffer.capacity() << 1, newposition));
                this.buffer.flip();
                newBuffer.put(this.buffer);
                this.buffer = newBuffer;
            }
            this.buffer.put(b, off, len);
        }
    }
}

