/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexer;
import org.netbeans.modules.parsing.spi.indexing.CustomIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.index.JsfIndexSupport;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.modules.web.jsfapi.api.JsfSupport;
import org.netbeans.modules.web.jsfapi.spi.JsfSupportProvider;
import org.netbeans.modules.web.jsfapi.spi.LibraryUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class JsfCustomIndexer
extends CustomIndexer {
    static final String INDEXER_NAME = "jsfCustomIndexer";
    static final int INDEXER_VERSION = 7;
    public static final Logger LOGGER = Logger.getLogger(JsfCustomIndexer.class.getName());

    protected void index(Iterable<? extends Indexable> files, Context context) {
        LOGGER.log(Level.FINE, "JsfCustomIndexer: indexing {0}", context.getRoot());
        if (context.getRoot() == null) {
            return;
        }
        ArrayList<URL> toRescan = new ArrayList<URL>();
        for (Indexable indexable : files) {
            FileObject file;
            URL indexableURL = indexable.getURL();
            if (indexableURL == null || (file = URLMapper.findFileObject((URL)indexableURL)) == null) continue;
            if (JsfIndexSupport.isFaceletsLibraryDescriptor(file)) {
                this.processFaceletsLibraryDescriptors(file, context);
                continue;
            }
            if (JsfIndexSupport.isTagLibraryDescriptor(file)) {
                this.processTlds(file, context);
                continue;
            }
            if (!"text/xhtml".equals(file.getMIMEType())) continue;
            this.processFaceletsCompositeLibraries(file, context, toRescan);
        }
        if (!toRescan.isEmpty() && !context.isSupplementaryFilesIndexing()) {
            context.addSupplementaryFiles(context.getRootURI(), toRescan);
        }
    }

    private void processTlds(FileObject file, Context context) {
        LOGGER.log(Level.FINE, "indexing {0}", file);
        try (InputStream is = file.getInputStream();){
            String namespace = FaceletsLibraryDescriptor.parseNamespace(is);
            if (namespace != null) {
                JsfIndexSupport.indexTagLibraryDescriptor(context, file, namespace);
                LOGGER.log(Level.FINE, "The file {0} indexed as a Tag Library Descriptor", file);
            }
        }
        catch (IOException ex) {
            LOGGER.info(String.format("Error parsing %s file: %s", file.getPath(), ex.getMessage()));
        }
    }

    private void processFaceletsLibraryDescriptors(FileObject file, Context context) {
        LOGGER.log(Level.FINE, "indexing {0}", file);
        try (InputStream is = file.getInputStream();){
            String namespace = FaceletsLibraryDescriptor.parseNamespace(is);
            if (namespace != null) {
                JsfIndexSupport.indexFaceletsLibraryDescriptor(context, file, namespace);
                LOGGER.log(Level.FINE, "The file {0} indexed as a Facelets Library Descriptor", file);
            }
        }
        catch (IOException ex) {
            LOGGER.info(String.format("Error parsing %s file: %s", file.getPath(), ex.getMessage()));
        }
    }

    private void processFaceletsCompositeLibraries(final FileObject file, final Context context, final List<URL> toRescan) {
        try {
            Source source = Source.create((FileObject)file);
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator ri) throws Exception {
                    for (Embedding e : ri.getEmbeddings()) {
                        if (!e.getMimeType().equals("text/html")) continue;
                        HtmlParserResult parserResult = (HtmlParserResult)ri.getResultIterator(e).getParserResult();
                        FileObject fo = parserResult.getSnapshot().getSource().getFileObject();
                        LinkedList<IndexDocument> documents = new LinkedList<IndexDocument>();
                        IndexingSupport support = IndexingSupport.getInstance((Context)context);
                        if (JsfCustomIndexer.containsNonStandardNamespaces(parserResult.getNamespaces())) {
                            toRescan.add(fo.toURL());
                        }
                        Collection<JsfPageModel> models = JsfPageModelFactory.getModels(parserResult);
                        for (JsfPageModel model : models) {
                            IndexDocument document = support.createDocument(file);
                            model.storeToIndex(document);
                            documents.add(document);
                        }
                        LOGGER.log(Level.FINE, "indexing {0}, found {1} document.", new Object[]{fo.getPath(), documents.size()});
                        for (IndexDocument d : documents) {
                            support.addDocument(d);
                        }
                    }
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static boolean containsNonStandardNamespaces(Map<String, String> namespaces) {
        for (String ns : namespaces.keySet()) {
            if (DefaultLibraryInfo.forNamespace((String)ns) != null || "http://www.w3.org/1999/xhtml".equals(ns)) continue;
            return true;
        }
        return false;
    }

    public static class Factory
    extends CustomIndexerFactory {
        public CustomIndexer createIndexer() {
            return new JsfCustomIndexer();
        }

        public boolean supportsEmbeddedIndexers() {
            return false;
        }

        public boolean scanStarted(Context context) {
            try {
                return IndexingSupport.getInstance((Context)context).isValid();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }

        public void scanFinished(Context context) {
            super.scanFinished(context);
            if (context.getRoot() != null) {
                for (Project p : LibraryUtils.getOpenedJSFProjects()) {
                    JsfSupport support = JsfSupportProvider.get((Project)p);
                    if (support == null) continue;
                    JsfSupportImpl jsfSupportImpl = (JsfSupportImpl)support;
                    jsfSupportImpl.indexedContentPossiblyChanged();
                    jsfSupportImpl.getIndex().notifyChange();
                }
            }
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return JsfCustomIndexer.INDEXER_NAME;
        }

        public int getIndexVersion() {
            return 7;
        }
    }
}

